/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.common.BgAttributeColumn;
import com.kingdee.eas.ma.mbg.common.BgCalcuteColumn;
import com.kingdee.eas.ma.mbg.common.BgDescriptionColumn;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IDimensionColumn;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgSheetParseHelper;
import com.kingdee.eas.ma.mbg.utils.ExtendColIndexComparator;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class SetLayoutHelper {
    public static final String ROW_DIMENSION_PRE = "ROW_DIMENSION";
    public static final String CLOUMN_DIMENSION_PRE = "CLOUMN_DIMENSION";
    public static final String PROPERTY_PRE = "PROPERTY";
    public static final String CALCULATE_PRE = "CALCULATE";
    public static final String DES_PRE = "DES";
    public static final String SEPERATE = "|";

    public static void loadTblColumnEdit(KDTable tblColumnEdit, IBgDimensionManager bgDimensionManager) throws BOSException, EASBizException {
        List<BgDimensionInfo> rowDimensions = SetLayoutHelper.getRowDimensions(bgDimensionManager);
        List<BgDimensionInfo> colDimensions = SetLayoutHelper.getColumnDimensions(bgDimensionManager);
        SetLayoutHelper.loadTblColumnEdit(tblColumnEdit, bgDimensionManager, rowDimensions, colDimensions);
    }

    public static void loadTblColumnEdit(KDTable tblColumnEdit, IBgDimensionManager bgDimensionManager, List<BgDimensionInfo> rowDimensions, List<BgDimensionInfo> colDimensions) throws BOSException, EASBizException {
        int startColIndex;
        int rowIndex;
        if (tblColumnEdit == null || bgDimensionManager == null || colDimensions == null || rowDimensions == null) {
            return;
        }
        int size = colDimensions.size();
        tblColumnEdit.removeColumns();
        tblColumnEdit.addHeadRows(size);
        tblColumnEdit.addRows(4 - size + 1 <= 0 ? 1 : 4 - size + 1);
        ArrayList<BgAttributeColumn> leaveAttrCol = new ArrayList<BgAttributeColumn>();
        ArrayList<BgCalcuteColumn> leaveCalCol = new ArrayList<BgCalcuteColumn>();
        ArrayList<BgDescriptionColumn> leaveDesCol = new ArrayList<BgDescriptionColumn>();
        BgDimensionInfo curDimension = null;
        for (int i = 0; i < rowDimensions.size(); ++i) {
            curDimension = rowDimensions.get(i);
            if (!curDimension.isShow()) continue;
            IColumn col1 = tblColumnEdit.addColumn();
            col1.setUserObject((Object)("ROW_DIMENSION|" + curDimension.getNumber()));
            for (int rowIndex2 = 0; rowIndex2 < size; ++rowIndex2) {
                tblColumnEdit.getHeadRow(rowIndex2).getCell(col1.getColumnIndex()).setValue((Object)curDimension.getName());
            }
            tblColumnEdit.getHeadMergeManager().mergeBlock(0, col1.getColumnIndex(), size - 1, col1.getColumnIndex());
            List<BgAttributeColumn> properties = MBgTemplateHelper.getPropertiesForDim(bgDimensionManager, curDimension);
            BgAttributeColumn curProperty = null;
            for (int j = 0; j < properties.size(); ++j) {
                curProperty = properties.get(j);
                if (curProperty.getIndex() >= 0) {
                    leaveAttrCol.add(curProperty);
                    continue;
                }
                IColumn col2 = tblColumnEdit.addColumn();
                col2.setUserObject((Object)("PROPERTY|" + curProperty.getDimensionInfo().getNumber() + SEPERATE + curProperty.getRefColumn()));
                for (rowIndex = 0; rowIndex < size; ++rowIndex) {
                    if (curProperty.getAlias() != null && !"".equals(curProperty.getAlias().trim())) {
                        if (StringUtils.isEmpty((String)curProperty.getColumnName())) {
                            tblColumnEdit.getHeadRow(rowIndex).getCell(col2.getColumnIndex()).setValue((Object)curProperty.getAlias());
                            continue;
                        }
                        tblColumnEdit.getHeadRow(rowIndex).getCell(col2.getColumnIndex()).setValue((Object)curProperty.getColumnName());
                        continue;
                    }
                    tblColumnEdit.getHeadRow(rowIndex).getCell(col2.getColumnIndex()).setValue((Object)curProperty.getAlias());
                }
                tblColumnEdit.getHeadMergeManager().mergeBlock(0, col2.getColumnIndex(), size - 1, col2.getColumnIndex());
            }
        }
        List<BgCalcuteColumn> calculateCols = bgDimensionManager.getCalcuteCol();
        BgCalcuteColumn curCal = null;
        for (int i = 0; i < calculateCols.size(); ++i) {
            curCal = calculateCols.get(i);
            if (curCal.getIndex() >= 0) {
                leaveCalCol.add(curCal);
                continue;
            }
            IColumn col = tblColumnEdit.addColumn();
            col.setUserObject((Object)("CALCULATE|" + curCal.getAlias() + SEPERATE + curCal.getFormula()));
            for (int rowIndex3 = 0; rowIndex3 < size; ++rowIndex3) {
                tblColumnEdit.getHeadRow(rowIndex3).getCell(col.getColumnIndex()).setValue((Object)curCal.getAlias());
            }
            tblColumnEdit.getHeadMergeManager().mergeBlock(0, col.getColumnIndex(), size - 1, col.getColumnIndex());
        }
        List<BgDescriptionColumn> descriptionCols = bgDimensionManager.getDescriptionCol();
        BgDescriptionColumn curDes = null;
        for (int i = 0; i < descriptionCols.size(); ++i) {
            curDes = descriptionCols.get(i);
            if (curDes.getIndex() >= 0) {
                leaveDesCol.add(curDes);
                continue;
            }
            IColumn col = tblColumnEdit.addColumn();
            col.setUserObject((Object)("DES|" + descriptionCols.get(i).getAlias()));
            for (rowIndex = 0; rowIndex < size; ++rowIndex) {
                tblColumnEdit.getHeadRow(rowIndex).getCell(col.getColumnIndex()).setValue((Object)descriptionCols.get(i).getAlias());
            }
            tblColumnEdit.getHeadMergeManager().mergeBlock(0, col.getColumnIndex(), size - 1, col.getColumnIndex());
        }
        int copyStartColIndex = startColIndex = tblColumnEdit.getColumnCount();
        int count = 0;
        int eachRepeat = 0;
        for (int dimensionIndex = 0; dimensionIndex < colDimensions.size(); ++dimensionIndex) {
            int i;
            int j;
            copyStartColIndex = startColIndex;
            count = 1;
            for (j = 0; j < dimensionIndex; ++j) {
                if (SetLayoutHelper.isNeedShowMember(colDimensions.get(j))) {
                    if (colDimensions.get(j).getMember() == null || colDimensions.get(j).getMember().size() == 0) {
                        count *= 1;
                        continue;
                    }
                    count *= colDimensions.get(j).getMember().size();
                    continue;
                }
                count *= 1;
            }
            eachRepeat = 1;
            for (j = dimensionIndex + 1; j < colDimensions.size(); ++j) {
                if (SetLayoutHelper.isNeedShowMember(colDimensions.get(j))) {
                    if (colDimensions.get(j).getMember() == null || colDimensions.get(j).getMember().size() == 0) {
                        eachRepeat *= 1;
                        continue;
                    }
                    eachRepeat *= colDimensions.get(j).getMember().size();
                    continue;
                }
                eachRepeat *= 1;
            }
            if (!SetLayoutHelper.isNeedShowMember(colDimensions.get(dimensionIndex)) || colDimensions.get(dimensionIndex).getMember() == null || colDimensions.get(dimensionIndex).getMember().size() == 0) {
                for (i = 0; i < count; ++i) {
                    for (int j2 = 0; j2 < eachRepeat; ++j2) {
                        if (tblColumnEdit.getColumn(copyStartColIndex) == null) {
                            tblColumnEdit.addColumn(copyStartColIndex);
                        }
                        tblColumnEdit.getColumn(copyStartColIndex).setUserObject((Object)(CLOUMN_DIMENSION_PRE + colDimensions.get(dimensionIndex).getNumber()));
                        MbgSheetParseHelper.addDimensionInfo(tblColumnEdit.getColumn(copyStartColIndex), new BgDimensionMember(null, null, null, null));
                        tblColumnEdit.getHeadRow(dimensionIndex).getCell(copyStartColIndex, true).setValue((Object)colDimensions.get(dimensionIndex).getName());
                        ++copyStartColIndex;
                    }
                }
                continue;
            }
            for (i = 0; i < count; ++i) {
                for (int k = 0; k < colDimensions.get(dimensionIndex).getMember().size(); ++k) {
                    for (int j3 = 0; j3 < eachRepeat; ++j3) {
                        if (tblColumnEdit.getColumn(copyStartColIndex) == null) {
                            tblColumnEdit.addColumn(copyStartColIndex);
                        }
                        tblColumnEdit.getColumn(copyStartColIndex).setUserObject((Object)(CLOUMN_DIMENSION_PRE + colDimensions.get(dimensionIndex).getNumber()));
                        MbgSheetParseHelper.addDimensionInfo(tblColumnEdit.getColumn(copyStartColIndex), (BgDimensionMember)colDimensions.get(dimensionIndex).getMember().get(k));
                        tblColumnEdit.getHeadRow(dimensionIndex).getCell(copyStartColIndex, true).setValue((Object)((BgDimensionMember)colDimensions.get(dimensionIndex).getMember().get(k)).getName());
                        ++copyStartColIndex;
                    }
                }
            }
        }
        ArrayList<IDimensionColumn> leaveCol = new ArrayList<IDimensionColumn>();
        leaveCol.addAll(leaveAttrCol);
        leaveCol.addAll(leaveCalCol);
        leaveCol.addAll(leaveDesCol);
        if (leaveCol.size() > 0) {
            Collections.sort(leaveCol, (Comparator)new ExtendColIndexComparator());
            Object curObj = null;
            for (int i = 0; i < leaveCol.size(); ++i) {
                IColumn col;
                curObj = leaveCol.get(i);
                if (curObj instanceof BgAttributeColumn) {
                    BgAttributeColumn curProperty = curObj;
                    IColumn col2 = tblColumnEdit.addColumn(curProperty.getIndex() > tblColumnEdit.getColumnCount() ? tblColumnEdit.getColumnCount() : curProperty.getIndex());
                    col2.setUserObject((Object)("PROPERTY|" + curProperty.getDimensionInfo().getNumber() + SEPERATE + curProperty.getRefColumn()));
                    for (int rowIndex4 = 0; rowIndex4 < size; ++rowIndex4) {
                        tblColumnEdit.getHeadRow(rowIndex4).getCell(col2.getColumnIndex()).setValue((Object)(StringUtils.isEmpty((String)curProperty.getColumnName()) ? curProperty.getAlias() : curProperty.getColumnName()));
                    }
                    tblColumnEdit.getHeadMergeManager().mergeBlock(0, col2.getColumnIndex(), size - 1, col2.getColumnIndex());
                    continue;
                }
                if (curObj instanceof BgCalcuteColumn) {
                    curCal = curObj;
                    col = tblColumnEdit.addColumn(curCal.getIndex() > tblColumnEdit.getColumnCount() ? tblColumnEdit.getColumnCount() : curCal.getIndex());
                    col.setUserObject((Object)("CALCULATE|" + curCal.getAlias() + SEPERATE + curCal.getFormula()));
                    for (int rowIndex5 = 0; rowIndex5 < size; ++rowIndex5) {
                        tblColumnEdit.getHeadRow(rowIndex5).getCell(col.getColumnIndex()).setValue((Object)curCal.getAlias());
                    }
                    tblColumnEdit.getHeadMergeManager().mergeBlock(0, col.getColumnIndex(), size - 1, col.getColumnIndex());
                    continue;
                }
                if (!(curObj instanceof BgDescriptionColumn)) continue;
                curDes = curObj;
                col = tblColumnEdit.addColumn(curDes.getIndex() > tblColumnEdit.getColumnCount() ? tblColumnEdit.getColumnCount() : curDes.getIndex());
                col.setUserObject((Object)("DES|" + curDes.getAlias()));
                for (int rowIndex6 = 0; rowIndex6 < size; ++rowIndex6) {
                    tblColumnEdit.getHeadRow(rowIndex6).getCell(col.getColumnIndex()).setValue((Object)curDes.getAlias());
                }
                tblColumnEdit.getHeadMergeManager().mergeBlock(0, col.getColumnIndex(), size - 1, col.getColumnIndex());
            }
        }
    }

    public static void storeTblColumn(KDTable tblColumnEdit, IBgDimensionManager bgDimensionManager) {
        if (tblColumnEdit == null || bgDimensionManager == null) {
            return;
        }
        List<BgAttributeColumn> attrCol = bgDimensionManager.getAttributeCol();
        HashMap<String, BgAttributeColumn> attrMap = new HashMap<String, BgAttributeColumn>();
        for (int i = 0; i < attrCol.size(); ++i) {
            attrMap.put("PROPERTY|" + attrCol.get(i).getDimensionInfo().getNumber() + SEPERATE + attrCol.get(i).getRefColumn(), attrCol.get(i));
        }
        List<BgCalcuteColumn> calCol = bgDimensionManager.getCalcuteCol();
        HashMap<String, BgCalcuteColumn> calMap = new HashMap<String, BgCalcuteColumn>();
        for (int i = 0; i < calCol.size(); ++i) {
            calMap.put("CALCULATE|" + calCol.get(i).getAlias() + SEPERATE + calCol.get(i).getFormula(), calCol.get(i));
        }
        List<BgDescriptionColumn> desCol = bgDimensionManager.getDescriptionCol();
        HashMap<String, BgDescriptionColumn> desMap = new HashMap<String, BgDescriptionColumn>();
        for (int i = 0; i < desCol.size(); ++i) {
            desMap.put("DES|" + desCol.get(i).getAlias(), desCol.get(i));
        }
        IColumn column = null;
        Object userObj = null;
        for (int i = 0; i < tblColumnEdit.getColumnCount(); ++i) {
            column = tblColumnEdit.getColumn(i);
            userObj = column.getUserObject();
            if (!(userObj instanceof String)) continue;
            if (((String)userObj).startsWith(PROPERTY_PRE)) {
                if (!attrMap.containsKey(userObj)) continue;
                ((BgAttributeColumn)attrMap.get(userObj)).setIndex(column.getColumnIndex());
                continue;
            }
            if (((String)userObj).startsWith(CALCULATE_PRE)) {
                if (!calMap.containsKey(userObj)) continue;
                ((BgCalcuteColumn)calMap.get(userObj)).setIndex(column.getColumnIndex());
                continue;
            }
            if (!((String)userObj).startsWith(DES_PRE) || !desMap.containsKey(userObj)) continue;
            ((BgDescriptionColumn)desMap.get(userObj)).setIndex(column.getColumnIndex());
        }
    }

    private static List<BgDimensionInfo> getRowDimensions(IBgDimensionManager bgDimensionManager) {
        return bgDimensionManager.getRowDisplayDimension();
    }

    private static List<BgDimensionInfo> getColumnDimensions(IBgDimensionManager bgDimensionManager) {
        return bgDimensionManager.getColDisplayDimension();
    }

    private static boolean isNeedShowMember(BgDimensionInfo dimensionInfo) {
        if (dimensionInfo == null) {
            return false;
        }
        if (MBGLayoutConstants.BG_PERIOD.equals(dimensionInfo.getNumber())) {
            return true;
        }
        return MBGLayoutConstants.BG_ELEMENT.equals(dimensionInfo.getNumber());
    }

    private boolean isColColumn(IColumn column) {
        if (column == null) {
            return false;
        }
        return column.getUserObject() instanceof String && ((String)column.getUserObject()).startsWith(CLOUMN_DIMENSION_PRE);
    }
}

