/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.CellTextEditor;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.utils.BgElementHelper;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.IViewListNumberCellDisplayHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Map;
import java.util.WeakHashMap;

public class ViewListNumberCellTextEditor
extends CellTextEditor {
    private IViewListNumberCellDisplayHelper helper = null;
    protected Map formulaMap = new WeakHashMap();
    protected boolean isLockAll = false;
    private Map<String, BgElementInfo> elementObjMap = null;

    public void setLockAll(boolean isLockAll) {
        this.isLockAll = isLockAll;
    }

    public ViewListNumberCellTextEditor() {
    }

    public ViewListNumberCellTextEditor(IViewListNumberCellDisplayHelper helper) {
        this.helper = helper;
        if (helper != null && helper.getFormulaMap() != null) {
            this.formulaMap = helper.getFormulaMap();
        }
    }

    protected IViewListNumberCellDisplayHelper getHelper() {
        return this.helper;
    }

    public Map<String, BgElementInfo> getElementObjMap() {
        if (this.elementObjMap == null) {
            try {
                this.elementObjMap = BgElementHelper.getElementoObjMap();
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        return this.elementObjMap;
    }

    protected boolean allowEditCell() {
        if (this.isLockAll || this.getHelper() instanceof CoreUIObject && OprtState.VIEW.equals(((CoreUIObject)this.getHelper()).getOprtState())) {
            this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText((String)"KEY_ERROR_EDIT_ON_PROTECTED_OBJECT"), 0);
            return false;
        }
        boolean isAllowEditCell = super.allowEditCell();
        if (isAllowEditCell && !(isAllowEditCell = ViewListNumberCellTextEditor.isAllowEditCellFormViewList(this._sheet, this._rowIndex, this._colIndex))) {
            this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText((String)"KEY_ERROR_EDIT_ON_PROTECTED_OBJECT"), 0);
        }
        return isAllowEditCell;
    }

    public static boolean isAllowEditCellFormViewList(Sheet sheet, int rowIndex, int colIndex) {
        boolean isAllowEditCell = true;
        if (sheet != null) {
            if (sheet.getMaxColIndex() < colIndex || sheet.getMaxRowIndex() < rowIndex) {
                isAllowEditCell = false;
            } else if (!(BgNFSHelper.checkHasFormulaOfCell(sheet.getCell(rowIndex, colIndex, false)) || ViewListHelper.checkIsEditNoteCell(sheet.getCell(rowIndex, colIndex, false)) || ViewListHelper.getDimension(sheet.getColumn(colIndex, false)) != null && ViewListHelper.getDimension(sheet.getRow(rowIndex, false)) != null)) {
                isAllowEditCell = false;
            }
        }
        return isAllowEditCell;
    }

    public String getText() {
        String _text = super.getText();
        if (!StringUtils.isEmpty((String)_text) && !BgNFSHelper.checkIsExpression(_text)) {
            Cell _cell = this._sheet.getCell(this._rowIndex, this._colIndex, false);
            if (_cell != null) {
                if (!BgNFSHelper.checkHasPercentage(_cell) && !BgNFSHelper.checkHasTextOfCell(_cell)) {
                    if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                        _text = this.updateMeasureUnitValue(_text);
                    } else if (BgNFSHelper.checkHasNumbericOfCell(_cell)) {
                        _text = this.updateMeasureUnitValue(_text);
                    }
                }
            } else {
                _text = this.updateMeasureUnitValue(_text);
            }
        }
        return _text;
    }

    protected String updateMeasureUnitValue(String _text) {
        BigDecimal _value = null;
        if (!this.getHelper().getMeasureUnitMap().isEmpty()) {
            _value = this.updateBgMeasureUnitValue(_text);
        }
        if (_value != null) {
            _text = CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)_value);
        }
        return _text;
    }

    protected BigDecimal updateBgMeasureUnitValue(String _text) {
        Cell _cell;
        String _bgAccountNumber = null;
        String _tmpStr = null;
        BigDecimal _value = null;
        BigDecimal _coefficient = null;
        _tmpStr = _text.trim().replaceAll(",", "");
        try {
            _value = new BigDecimal(_tmpStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_value != null && (_cell = this._sheet.getCell(this._rowIndex, this._colIndex, false)) != null && _cell.getUserObject("BGACCOUNT_NUMBER") != null && _cell.getUserObject("BGACCOUNT_NUMBER").getValue() != null && (_coefficient = this.getCoef(_bgAccountNumber = String.valueOf(_cell.getUserObject("BGACCOUNT_NUMBER").getValue()), _coefficient, _cell)) != null) {
            _value = _value.multiply(_coefficient);
        }
        return _value;
    }

    protected BigDecimal getCoef(String _bgAccountNumber, BigDecimal defaultValue, Cell cell) {
        if (this.getHelper() == null || this.getHelper().getMeasureUnitMap() == null || this.getHelper().getAccountDataTypeMap() == null || !this.getHelper().getAccountDataTypeMap().containsKey(_bgAccountNumber)) {
            return defaultValue;
        }
        if (this.getHelper().getTemplateStyle() == null || this.getHelper().getTemplateStyle() != null && this.getHelper().getTemplateStyle().isDataTYpe()) {
            if (MBGViewListFormClientHelper.checkElementRateOrPrice(cell, this.getElementObjMap(), this.formulaMap)) {
                return defaultValue;
            }
            if (this.getHelper().getAccountDataTypeMap().get(_bgAccountNumber) != null && this.getHelper().getAccountDataTypeMap().get(_bgAccountNumber) instanceof Integer) {
                if (10 == (Integer)this.getHelper().getAccountDataTypeMap().get(_bgAccountNumber)) {
                    return new BigDecimal((Integer)this.getHelper().getMeasureUnitMap().get("currency"));
                }
                if (20 == (Integer)this.getHelper().getAccountDataTypeMap().get(_bgAccountNumber)) {
                    return new BigDecimal((Integer)this.getHelper().getMeasureUnitMap().get("noCurrency"));
                }
                if (30 == (Integer)this.getHelper().getAccountDataTypeMap().get(_bgAccountNumber)) {
                    return new BigDecimal((Integer)this.getHelper().getMeasureUnitMap().get("rate"));
                }
            }
        } else {
            String eleNumber;
            if (MBGViewListFormClientHelper.checkRateElement(cell, this.getElementObjMap(), this.formulaMap)) {
                return defaultValue;
            }
            if (this.getHelper().getTemplateStyle() != null && !this.getHelper().getTemplateStyle().isDataTYpe() && (eleNumber = MBGViewListFormClientHelper.getCellElement(cell, this.getElementObjMap(), this.formulaMap)) != null && this.getHelper().getTemplateStyle().getEleMap().containsKey(eleNumber)) {
                Object[] object = this.getHelper().getTemplateStyle().getEleMap().get(eleNumber);
                if ((Integer)object[3] == 0) {
                    return this.getHelper().getTemplateStyle().getCof();
                }
                return new BigDecimal(MBGViewListFormCommonHelper.transMeasureUnit((Integer)object[3] - 1));
            }
        }
        return defaultValue;
    }

    public String getCellText(Cell cell) {
        String _text = super.getCellText(cell);
        if (!StringUtils.isEmpty((String)_text) && !BgNFSHelper.checkIsExpression(_text)) {
            Cell _cell = this._sheet.getCell(this._rowIndex, this._colIndex, false);
            if (_cell != null) {
                if (!BgNFSHelper.checkHasPercentage(_cell) && !BgNFSHelper.checkHasTextOfCell(_cell)) {
                    if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                        _text = this.getMeasureUnitDisplayValue(_text);
                    } else if (BgNFSHelper.checkHasNumbericOfCell(_cell)) {
                        _text = this.getMeasureUnitDisplayValue(_text);
                    }
                }
            } else {
                _text = this.getMeasureUnitDisplayValue(_text);
            }
        }
        return _text;
    }

    protected String getMeasureUnitDisplayValue(String _text) {
        BigDecimal _value = null;
        if (!this.getHelper().getMeasureUnitMap().isEmpty()) {
            _value = this.getBgMeasureUnitDisplayValue(_text);
        }
        if (_value != null) {
            _value = _value.stripTrailingZeros();
            _text = CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)_value);
        }
        return _text;
    }

    protected BigDecimal getBgMeasureUnitDisplayValue(String _text) {
        Cell _cell;
        String _bgAccountNumber = null;
        BigDecimal _value = null;
        BigDecimal _coefficient = null;
        try {
            _value = new BigDecimal(_text.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_value != null && (_cell = this._sheet.getCell(this._rowIndex, this._colIndex, false)) != null && _cell.getUserObject("BGACCOUNT_NUMBER") != null && (_coefficient = this.getCoef(_bgAccountNumber = String.valueOf(_cell.getUserObject("BGACCOUNT_NUMBER").getValue()), _coefficient, _cell)) != null) {
            _value = _value.divide(_coefficient, 16, 4);
        }
        return _value;
    }
}

