/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.viewListForm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgPropertyHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.bgcsl.provider.BgCslViewListFormProvider;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.IMBGViewListFormFacade;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellInfo;
import com.kingdee.eas.ma.mbg.ViewListFacadeFactory;
import com.kingdee.eas.ma.mbg.client.action.actions.viewListForm.ActionInsertRow;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgDimensionParseCommonHelper;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MBGRowData;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListAtribute;
import com.kingdee.eas.ma.mbg.common.MbgViewListDescription;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.ViewListSheetParseHelper;
import com.kingdee.eas.ma.mbg.designer.ICheckCanSave;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.IViewListCombinRender;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormAdjustProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormBaseProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MbgViewListFormRollProvider;
import com.kingdee.eas.ma.mbg.utils.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.IAdjust;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgAdjustHelper;
import com.kingdee.eas.ma.mbg.utils.MbgBudgetDataQueryHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ViewListCombinRender
implements IRenderProvider,
IBasicRender {
    private static final Logger logger = Logger.getLogger((String)ViewListCombinRender.class.getName());
    public static final String RES_CLIENT = "com.kingdee.eas.ma.mbg.client.MBGViewListFormResource";
    private BookContextManager context;
    private boolean isShowCombin = true;
    private Map<Integer, Map<String, Set<String>>> initMembers = new HashMap<Integer, Map<String, Set<String>>>();
    private MbgViewListDimensionInfo dimension = null;
    private final Map<String, MbgViewlistCombinBizPromptBox> kdBizPromptBoxs = new HashMap<String, MbgViewlistCombinBizPromptBox>();
    private boolean isSingleSelectMember = false;
    private Map<String, Map<String, Map<String, MbgViewListDesCellInfo>>> desMap = null;
    IMBGViewListFormFacade viewlistFormFacade = null;
    private String isOrgOnRow = null;
    private String isOrgOnCol = null;
    private Map<String, BgPeriodDispInfo> bgPeriodDispCache = null;

    public void setShowCombin(boolean isShowCombin) {
        this.isShowCombin = isShowCombin;
    }

    public ViewListCombinRender(BookContextManager context) {
        this.context = context;
    }

    public IBasicRender getRender(Cell cell, int viewMode) {
        this.dimension = ViewListHelper.getCombinDimension(cell);
        MbgViewlistCombinBizPromptBox kdbox = null;
        if (!this.isShowCombin || cell == null || !this.checkState() || this.isAddActual()) {
            return null;
        }
        SpreadView sv = this.getSpreadView(cell);
        if (sv == null) {
            return null;
        }
        if (this.dimension == null && this.kdBizPromptBoxs.containsKey(this.getCellName(cell)) || this.dimension != null && DimensionConstants.DEF_ORGUNIT_NUMBER.equals(this.dimension.getNumber()) || cell.getSheet().getActiveCell() == null || !cell.getSheet().getActiveCell().equals(cell) || !this.checkCanEditOtherAddedBgForm(cell) && !this.kdBizPromptBoxs.isEmpty() && this.kdBizPromptBoxs.get(this.getCellName(cell)) != null) {
            kdbox = this.kdBizPromptBoxs.get(this.getCellName(cell));
            if (kdbox == null) {
                return null;
            }
            kdbox.setVisible(false);
            sv.remove((Component)((Object)kdbox));
            return null;
        }
        kdbox = this.getBizPromptBoxByCell(cell);
        this.setCellRender(cell, kdbox);
        return null;
    }

    public void setCellRender(Cell cell, MbgViewlistCombinBizPromptBox kdbox) {
        if (kdbox == null) {
            return;
        }
        if (kdbox.isVisible() && this.checkBounds(cell, kdbox)) {
            return;
        }
        this.setDialogFilter(this.getFilterMap(cell), cell, kdbox);
        ViewlistCombinHelper.removeDataChengeListeners(kdbox);
        this.addListeners_KDBizPromptBox(kdbox, cell);
        SpreadView sv = this.getSpreadView(cell);
        if (sv == null) {
            return;
        }
        sv.remove((Component)((Object)kdbox));
        Rectangle rect = SheetBaseMath.getActualCellRect((Sheet)cell.getSheet(), (int)cell.getRow(), (int)cell.getCol(), (boolean)true);
        kdbox.setBounds(rect.x + rect.width - 16, rect.y + rect.height - 16, 16, 16);
        sv.add((Component)((Object)kdbox));
        kdbox.setVisible(true);
        sv.updateUI();
        kdbox.setUpdate(true);
        kdbox.setCanChangeMember(true);
    }

    protected boolean checkBounds(Cell cell, MbgViewlistCombinBizPromptBox kdbox) {
        boolean isFix = true;
        Rectangle rect = SheetBaseMath.getActualCellRect((Sheet)cell.getSheet(), (int)cell.getRow(), (int)cell.getCol(), (boolean)true);
        if (kdbox.getBounds().x != rect.x + rect.width - 16 || kdbox.getBounds().y != rect.y + rect.height - 16) {
            isFix = false;
        }
        return isFix;
    }

    private boolean checkState() {
        return OprtState.EDIT.equals(this.context.getOwnerUI().getOprtState()) || OprtState.ADDNEW.equals(this.context.getOwnerUI().getOprtState());
    }

    private boolean isAddActual() {
        return this.getProvider().getEditValue() != null && this.getProvider().getEditValue() instanceof BgActualRecordInfo;
    }

    protected boolean isCsl() {
        return false;
    }

    public MbgViewlistCombinBizPromptBox getBizPromptBoxByCell(Cell cell) {
        String orgId;
        MbgViewlistCombinBizPromptBox kdbox = null;
        Object selector = null;
        this.dimension = ViewListHelper.getCombinDimension(cell);
        if (this.dimension == null || cell == null) {
            return null;
        }
        String string = orgId = this.getRowColOrgId(cell) != null ? this.getRowColOrgId(cell) : this.getOrgUnitId();
        if (this.getBoxKey(cell) != null && this.kdBizPromptBoxs.containsKey(this.getBoxKey(cell))) {
            kdbox = this.kdBizPromptBoxs.get(this.getBoxKey(cell));
            selector = kdbox.getSelector();
            if (selector instanceof NewDimensionMemberSelectDialog) {
                ((NewDimensionMemberSelectDialog)selector).setOrgId(orgId);
            }
        } else {
            Object dialog;
            kdbox = new MbgViewlistCombinBizPromptBox(cell);
            if (DimensionConstants.DEF_PERIOD_NUMBER.equals(this.dimension.getNumber())) {
                dialog = new BgPeriodDialog((CoreUIObject)this.getOwnerUI(), this.isMuisMultiSelect().booleanValue());
                dialog.setBgSchemeID(this.getProvider().getBgSchemeId());
                dialog.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
                dialog.setBgPeriodBeginDate(this.getProvider().getBgSchemeInfo().getDateFrom());
                dialog.setBgPeriodEndDate(this.getProvider().getBgSchemeInfo().getDateTo());
                selector = dialog;
            } else {
                dialog = new NewDimensionMemberSelectDialog((Component)this.getOwnerUI(), this.dimension, orgId, (boolean)this.isMuisMultiSelect(), false);
                ((NewDimensionMemberSelectDialog)dialog).setShowFilterRadioBtn(true);
                if (this.isCsl()) {
                    ((NewDimensionMemberSelectDialog)dialog).setFilterRollVersion(true);
                    ((NewDimensionMemberSelectDialog)dialog).setCanntFilterOrg(true);
                }
                selector = dialog;
            }
            kdbox.setSelector((KDPromptSelector)selector);
            this.kdBizPromptBoxs.put(this.getBoxKey(cell), kdbox);
            kdbox.setVisible(false);
            kdbox.setDataNoNotify(" ");
        }
        if (!this.getCellName(cell).equals(this.getCellName(kdbox.getCell()))) {
            kdbox.setCell(cell);
            kdbox.setVisible(false);
        }
        SpreadView sv = null;
        for (MbgViewlistCombinBizPromptBox tmpBox : this.kdBizPromptBoxs.values()) {
            if (this.getCellName(tmpBox.getCell()).equals(this.getCellName(cell)) || tmpBox == null || !tmpBox.isVisible()) continue;
            tmpBox.setVisible(false);
            sv = this.getSpreadView(tmpBox.getCell());
            if (sv == null) continue;
            sv.updateUI();
        }
        return kdbox;
    }

    protected String getBoxKey(Cell cell) {
        String boxKey = null;
        MbgViewListDimensionInfo dimension = null;
        MbgViewListRowCol rowObject = null;
        Row row = null;
        if (cell != null && ViewlistCombinHelper.checkRowIsCombin(cell).booleanValue() && ViewListHelper.getCombinDimension(cell) != null && ViewListHelper.getDimension(row = cell.getRowObject()) instanceof MbgViewListRowCol) {
            rowObject = (MbgViewListRowCol)ViewListHelper.getDimension(row);
            dimension = ViewListHelper.getCombinDimension(cell);
            boxKey = rowObject.getIndex() + BgBaseConstants.SEP_FOUR_STR + dimension.getNumber();
        }
        return boxKey;
    }

    public boolean isSingleSelectMember() {
        return this.isSingleSelectMember;
    }

    public void setSingleSelectMember(boolean isSingleSelectMember) {
        this.isSingleSelectMember = isSingleSelectMember;
    }

    private void addListeners_KDBizPromptBox(MbgViewlistCombinBizPromptBox kdbox, final Cell cell) {
        kdbox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                MbgViewlistCombinBizPromptBox tmpBox = null;
                BgNFSHelper.disableCal(cell.getSheet().getBook());
                if (eventObj.getSource() instanceof MbgViewlistCombinBizPromptBox) {
                    tmpBox = (MbgViewlistCombinBizPromptBox)((Object)eventObj.getSource());
                    if (!tmpBox.isDoChangeEvent) {
                        return;
                    }
                }
                boolean batch = false;
                if (eventObj.getNewValue() != null) {
                    List<BgDimensionMember> datalist = new ArrayList();
                    if (eventObj.getNewValue() instanceof List) {
                        datalist = (List)eventObj.getNewValue();
                    } else if (eventObj.getNewValue() instanceof Object[]) {
                        Object[] objects = (Object[])eventObj.getNewValue();
                        for (int i = 0; i < objects.length; ++i) {
                            datalist.add(DimensionFormulaHelper.convertToMember(objects[i]));
                        }
                    }
                    if (datalist.size() > 1) {
                        batch = true;
                        ViewListCombinRender.this.dealInsertRow(cell, datalist);
                    } else {
                        ViewListCombinRender.this.action_DataChange(eventObj, cell);
                    }
                }
                boolean isFillMember = false;
                if (eventObj.getSource() instanceof MbgViewlistCombinBizPromptBox && (tmpBox = (MbgViewlistCombinBizPromptBox)((Object)eventObj.getSource())).getCell() != null) {
                    String boxCellName = ViewListCombinRender.this.getCellName(tmpBox.getCell());
                    if (ViewListCombinRender.this.getCellName(cell).equals(boxCellName)) {
                        isFillMember = true;
                    }
                }
                if (tmpBox != null && tmpBox.isDoChangeEvent && isFillMember) {
                    ViewListCombinRender.this.setSingleSelectMember(true);
                    if (batch) {
                        MbgViewListRowCol rowCol = (MbgViewListRowCol)cell.getRowObject().getUserObject("dimension.object").getValue();
                        ViewListCombinRender.this.afterFillMembers(cell.getSheet(), rowCol.getStartIndex(), rowCol.getEndIndex(), true);
                    } else {
                        ViewListCombinRender.this.afterFillMembers(cell.getSheet(), cell.getRow(), cell.getRow(), true);
                    }
                }
                if (tmpBox != null) {
                    tmpBox.setDoChangeEvent(false);
                }
                BgNFSHelper.enableCal(cell.getSheet().getBook());
            }
        });
        kdbox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ViewListCombinRender.this.action_WillShow(e);
            }
        });
    }

    private void action_DataChange(DataChangeEvent eventObj, Cell cell) {
        MbgViewlistCombinBizPromptBox box = (MbgViewlistCombinBizPromptBox)((Object)eventObj.getSource());
        if (!box.isDoChangeEvent) {
            return;
        }
        BgDimensionMember member = null;
        if (eventObj.getNewValue() != null && eventObj.getNewValue() instanceof List) {
            List lst = (List)eventObj.getNewValue();
            if (lst.get(0) instanceof BgDimensionMember) {
                member = (BgDimensionMember)lst.get(0);
            }
        } else if (eventObj.getNewValue() != null) {
            BgPeriodInfo[] newValue = (BgPeriodInfo[])eventObj.getNewValue();
            member = DimensionFormulaHelper.convertToMember(newValue[0]);
        }
        if (!this.getCellName(cell).equals(this.getCellName(box.getCell()))) {
            return;
        }
        ArrayList<ItemFormula> deletedFormulas = new ArrayList<ItemFormula>();
        if (!(this.getProvider() instanceof MBGViewListFormAdjustProvider) && this.getProvider() instanceof MBGViewListFormProvider) {
            this.resetBgDataInfo(cell.getRowObject());
        }
        this.getDeletedFormulas(cell, deletedFormulas);
        this.setDeletedFormulasToSheetUserObject(cell, deletedFormulas);
        if (member != null) {
            boolean checkDumpRow = this.checkDumpRow(cell, member);
            if (checkDumpRow) {
                MsgBox.showWarning((String)BgCommCHelper.getMessageStr((String)RES_CLIENT, (String)"existSameDimensionMember"));
                SysUtil.abort();
            }
            ViewlistCombinHelper.setCombinCellMember(this.getProvider(), cell, member);
        } else {
            Row row = cell.getSheet().getRow(cell.getRow(), false);
            if (ViewlistCombinHelper.isRowHasData(row, cell.getSheet()).booleanValue()) {
                MsgBox.showWarning((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)"combinRow_hasSavedData"));
                box.setDataNoNotify(" ");
                SysUtil.abort();
            }
            ViewListHelper.setHeadCell(cell, null, null);
        }
        ViewlistCombinHelper.setSelectedCell(cell);
        if (this.getProvider() instanceof IAdjust) {
            ((IAdjust)((Object)this.getProvider())).setAdjustSave(false);
        }
        box.setDataNoNotify(" ");
    }

    private void action_WillShow(SelectorEvent e) {
        Map<String, Map<String, BgNViewDataInfo>> bgDataMap = this.getBgDataMap();
        if (e.getSource() != null && e.getSource() instanceof MbgViewlistCombinBizPromptBox) {
            MbgViewlistCombinBizPromptBox box = (MbgViewlistCombinBizPromptBox)((Object)e.getSource());
            box.setDoChangeEvent(true);
            Cell cell = box.getCell();
            Boolean canChangeMember = box.isCanChangeMember();
            if (cell != null) {
                Sheet sheet = cell.getSheet();
                Row row = sheet.getRow(cell.getRow(), false);
                ItemFormula itemFormula = null;
                String formula = null;
                String version = null;
                Boolean isRowHasData = ViewlistCombinHelper.isRowHasData(row, sheet);
                if (!isRowHasData.booleanValue() || bgDataMap.isEmpty()) {
                    return;
                }
                String orgId = this.getRowColOrgId(cell) != null ? this.getRowColOrgId(cell) : this.getOrgUnitId();
                Map<String, BgNViewDataInfo> dataMap = bgDataMap.get(orgId);
                HashSet<String> formulas = new HashSet<String>();
                for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                    if (r == row.getRow()) continue;
                    for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                        Cell _cell = sheet.getCell(r, c, false);
                        if (!BgNFSHelper.checkHasItemFormula(_cell)) continue;
                        itemFormula = BgNFSHelper.getItemFormula(_cell);
                        version = itemFormula.getExt("Version");
                        formula = itemFormula.getFormula() + "_" + version;
                        formulas.add(formula);
                    }
                }
            }
        }
    }

    private String processBgItems(Cell cell) {
        if (cell == null || BgNFSHelper.checkIsEmptyValue(cell)) {
            return null;
        }
        if (!ViewlistCombinHelper.checkCombinRowFullofMembers(cell.getRowObject(), true)) {
            return null;
        }
        int sheetIndex = cell.getSheet().getSheetIndex();
        Row row = cell.getRowObject();
        ArrayList<BgDimensionMember> members = new ArrayList<BgDimensionMember>();
        HashMap<String, MBGRowData> rowDatas = new HashMap<String, MBGRowData>();
        Sheet sheet = cell.getSheet();
        int maxCol = sheet.getMaxColIndex();
        BgSheetRange lockRange = new BgSheetRange(sheet);
        BgSheetRange lockRangeNotPaintColor = new BgSheetRange(sheet);
        BgSheetRange unLockRange = new BgSheetRange(sheet);
        BgSheetRange unlockRangeNotPaintColor = new BgSheetRange(sheet);
        String orgId = null;
        for (int c = 0; c <= maxCol; ++c) {
            Cell _cell = row.getCell(c, false);
            Column col = sheet.getColumn(c, false);
            if (ViewListHelper.getCombinDimension(_cell) != null || col == null || !(ViewListHelper.getDimension(col) instanceof MbgViewListRowCol) && !(ViewListHelper.getDimension(col) instanceof MbgViewListDescription)) continue;
            Object[] colMembers = ViewListHelper.getDimensionMember(col);
            Object[] rowMembers = ViewListHelper.getDimensionMember(row);
            members.clear();
            ViewListHelper.add(members, rowMembers);
            ViewListHelper.add(members, colMembers);
            members.addAll(ViewlistCombinHelper.getPageMembers(this.getDimensionManager(), this.getProvider().getPageF7List(sheetIndex)));
            members.addAll(ViewlistCombinHelper.getViewMembers(this.getDimensionManager(), this.getProvider().getViewF7List(sheetIndex)));
            this.setAccountNumber(_cell, members);
            if (ViewListHelper.getDimension(col) instanceof MbgViewListRowCol) {
                BgDimensionParseCommonHelper.builderBgFormula(_cell, members, true, null, rowDatas, null, DimensionCommonHelper.getItemFields(this.context.getProvider().getBgDimensionManager().getSheet()));
            } else if (ViewListHelper.getDimension(col) instanceof MbgViewListDescription) {
                MbgViewListDescriptionHelper.buildDescriptionFormula(this.context.getOrgUnitId(), _cell, null, members, (MbgViewListSheetManager)this.context.getProvider().getBgDimensionManager().getSheet(), row, col, true);
            }
            if (this.isCanEditCell(_cell, BgNFSHelper.getItemFormula(_cell))) {
                if (BgNFSHelper.getBackGroup(_cell) != null && BgNFSHelper.getBackGroup(_cell).equals(BgNConstants.LOCK_COLOR)) {
                    unLockRange.addCell(row.getRow(), c);
                } else {
                    unlockRangeNotPaintColor.addCell(row.getRow(), c);
                }
            } else if (BgNFSHelper.getBackGroup(_cell) == null || BgNFSHelper.getBackGroup(_cell).equals(BgNConstants.BASE_COLOR)) {
                lockRange.addCell(row.getRow(), c);
            } else {
                lockRangeNotPaintColor.addCell(row.getRow(), c);
            }
            if (orgId != null || BgNFSHelper.getItemFormula(_cell) == null) continue;
            orgId = BgNFSHelper.getItemFormula(_cell).getExt("ORGUNITID");
        }
        BgViewHelper.setLocked(true, lockRange.getRange(), true);
        BgViewHelper.setLocked(true, lockRangeNotPaintColor.getRange(), false);
        BgViewHelper.setLocked(false, unLockRange.getRange(), true);
        BgViewHelper.setLocked(false, unlockRangeNotPaintColor.getRange(), false);
        if (this.context != null && this.context.getProvider() instanceof IViewListCombinRender) {
            try {
                ((IViewListCombinRender)((Object)this.context.getProvider())).dealCalculateColFormula(sheet, sheet.getRowRange(row.getRow(), row.getRow()));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                this.context.getOwnerUI().handUIExceptionAndAbort(e);
            }
        }
        return orgId;
    }

    private void fillDimData(Cell cell, String orgId) {
        if (cell == null || orgId == null || !cell.getSheet().getActiveCell().equals(cell)) {
            return;
        }
        Row row = cell.getRowObject();
        MbgViewListRowCol rowObject = (MbgViewListRowCol)ViewListHelper.getDimension(row);
        HashMap<String, List<IBgDimensionManagerBase>> dimensionManagers = new HashMap<String, List<IBgDimensionManagerBase>>();
        MbgViewListDimensionManager dimensionManager = this.getDimensionManager().deepclone();
        dimensionManager.getRows().clear();
        dimensionManager.getRows().add(rowObject);
        dimensionManagers.put(orgId, new ArrayList());
        ((List)dimensionManagers.get(orgId)).add(dimensionManager);
        try {
            Map<String, Map<String, BgNViewDataInfo>> dataMap = this.queryDimData(dimensionManagers);
            this.fillBgDataValue(row, dataMap, null, true);
            if (this.getProvider() instanceof MBGViewListFormAdjustProvider) {
                this.fillAdjustData(row);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private boolean isCanEditCell(Cell cell, ItemFormula formula) {
        if (cell != null && ViewListHelper.getDimension(cell.getSheet().getColumn(cell.getCol(), false)) instanceof MbgViewListDescription && cell.getStyle().isLocked()) {
            return false;
        }
        if (cell == null || formula == null) {
            return true;
        }
        MbgViewListManager viewManager = (MbgViewListManager)this.getProvider().getBgViewManagerForMulOrg().get(formula.getExt("ORGUNIT"));
        if (viewManager == null) {
            boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(((MbgViewListSheetManager)((MbgViewListManager)this.getProvider().getCurMbgViewManager()).getSheetManagers().get(cell.getSheet().getSheetIndex())).getDimensionManager());
            HashSet<String> orgNums = new HashSet<String>();
            String curOrgNumForDimensionData = this.getOrgNumsForCurSheet(cell.getSheet().getSheetIndex(), orgNums);
            if (!isorgOnPageOrView && curOrgNumForDimensionData != null) {
                viewManager = (MbgViewListManager)this.getProvider().getBgViewManagerForMulOrg().get(curOrgNumForDimensionData);
            }
        }
        try {
            return this.isCanEditBgData(cell, formula, viewManager) && !MBGViewListFormCommonHelper.isCellReadonly(cell, viewManager, this.getBgFormInfo());
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return false;
    }

    protected boolean isCanEditBgData(Cell cell, ItemFormula formula, MbgViewListManager viewManager) throws EASBizException, BOSException {
        if (cell == null || formula == null || !(this.getBgFormInfo() instanceof IDimDataQuery)) {
            return false;
        }
        IDimDataQuery queryInfo = (IDimDataQuery)this.getBgFormInfo();
        String cellOrgId = formula.getExt("ORGUNITID");
        String version = formula.getExt("Version");
        if (version == null || this.getBgFormInfo() == null || queryInfo.getBizVersion() == null || !version.equals(queryInfo.getBizVersion().getNumber())) {
            return false;
        }
        if (this.getProvider() instanceof ICheckCanSave) {
            if (this.getProvider().getMultiOrgFormulasMap() != null) {
                if (!this.getProvider().getMultiOrgFormulasMap().containsKey(cellOrgId)) {
                    this.getProvider().getMultiOrgFormulasMap().put(cellOrgId, new HashSet());
                }
                this.getProvider().getMultiOrgFormulasMap().get(cellOrgId).add(formula.getFormula());
            }
            return ((ICheckCanSave)((Object)this.getProvider())).isCanEditBgData(cell, formula.getFormula(), null, cellOrgId, viewManager, cell.getSheet().getSheetIndex(), version);
        }
        DimensionMemberCheckHelper helper = this.getDimensionMembercheckHeler(cellOrgId, viewManager);
        return helper.canSave(formula.getFormula(), helper.getEditScen(viewManager, cell.getSheet().getSheetIndex(), this.getEditScenType()), version);
    }

    protected boolean isLockByWorkPaperCell(ItemFormula itemFormula) {
        if (!this.context.isLockByWorkPaperCell()) {
            return false;
        }
        boolean re = false;
        if (itemFormula == null) {
            return re;
        }
        String formula = itemFormula.getFormula();
        if (formula != null && (formula.indexOf(BgCslDimConstants.csl03) > 0 || formula.indexOf(BgCslDimConstants.csl04) > 0 || formula.indexOf(BgCslDimConstants.csl08) > 0)) {
            re = true;
        }
        return re;
    }

    protected DimensionMemberCheckHelper getDimensionMembercheckHeler(String orgId, MbgViewListManager viewManager) throws EASBizException, BOSException {
        if (this.isFromWorkPaper() && this.getBgFormInfo() instanceof IDimDataQuery) {
            String schemeOrgId;
            orgId = schemeOrgId = ((IDimDataQuery)this.getBgFormInfo()).getBizBgScheme().getOrgUnit().getId().toString();
        }
        DimensionMemberCheckFactory factory = this.getProvider().getCheckFactory();
        DimensionMemberCheckHelper helper = factory.getHelper(orgId, viewManager);
        return helper;
    }

    private SpreadView getSpreadView(Cell cell) {
        KDSpread spread = this.context.getSpreadContext().getSpread();
        int fhC = spread.getFixHorizonCount();
        int fvC = spread.getFixVerticalCount();
        int hC = spread.getHorizonCount();
        int vC = spread.getVerticalCount();
        for (int i = fvC; i < vC; ++i) {
            for (int j = fhC; j < hC; ++j) {
                SpreadView sv = (SpreadView)spread.getView(i, j);
                if (sv.getFirstRow() > cell.getRow() || sv.getEndRow() < cell.getRow() || sv.getFirstCol() > cell.getCol() || sv.getEndCol() < cell.getCol()) continue;
                return sv;
            }
        }
        return null;
    }

    private String getCellName(Cell cell) {
        return cell.getName(true, false);
    }

    private CoreUI getOwnerUI() {
        return this.context.getOwnerUI();
    }

    private String getOrgUnitId() {
        return this.context.getOrgUnitId();
    }

    protected ViewListProvider getProvider() {
        return (ViewListProvider)this.context.getProvider();
    }

    private MbgViewListDimensionManager getDimensionManager() {
        return this.getProvider().getBgDimensionManager();
    }

    private IObjectValue getBgFormInfo() {
        return this.getProvider().getEditValue();
    }

    protected BgScenarioType getEditScenType() {
        return BgScenarioType.BudgetData;
    }

    private BgSchemeDimensionHelper getSchemeHelper() {
        try {
            return this.getProvider().getSchemeHelper();
        }
        catch (EASBizException e) {
            logger.error((Object)"ViewListCombinRender getSchemeHelper error : ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"ViewListCombinRender getSchemeHelper error : ", (Throwable)e);
        }
        return null;
    }

    private Boolean isMuisMultiSelect() {
        return true;
    }

    private void repaintCell(Cell cell) {
        if (cell == null) {
            return;
        }
        this.context.getSpreadContext().repaint(new Rectangle(SheetBaseMath.getActualCellRect((Sheet)cell.getSheet(), (int)cell.getRow(), (int)cell.getCol(), (boolean)true)));
    }

    public void clearCombinMembers() {
        this.initMembers.clear();
    }

    public void initCombinMembers() {
        this.initCombinMembers(null);
    }

    public void initCombinMembers(MbgViewListDimensionManager dimensionManager) {
        if (!this.initMembers.isEmpty()) {
            return;
        }
        List<IMbgViewListObject> rowCols = null;
        rowCols = dimensionManager == null ? this.getDimensionManager().getRowCols() : dimensionManager.getRowCols();
        for (int i = 0; i < rowCols.size(); ++i) {
            MbgViewListRowCol rowCol;
            if (!(rowCols.get(i) instanceof MbgViewListRowCol) || !(rowCol = (MbgViewListRowCol)rowCols.get(i)).isCombin()) continue;
            int index = rowCol.getIndex();
            List<MbgViewListDimensionInfo> dims = rowCol.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                MbgViewListDimensionInfo dim = dims.get(j);
                String dimNumber = dim.getNumber();
                if (dim.getCanAddMember().isEmpty() && dim.getOrignCanAddMember().isEmpty()) continue;
                if (!this.initMembers.containsKey(index)) {
                    this.initMembers.put(index, new HashMap());
                }
                if (!this.initMembers.get(index).containsKey(dimNumber)) {
                    this.initMembers.get(index).put(dimNumber, new HashSet());
                }
                for (int m = 0; m < dim.getCanAddMember().size(); ++m) {
                    this.initMembers.get(index).get(dimNumber).add(((BgDimensionMember)dim.getCanAddMember().get(m)).getNumber());
                }
            }
        }
    }

    private Map<String, Set<String>> getFilterMap(Cell cell) {
        if (cell == null) {
            return null;
        }
        HashMap<String, Set<String>> filterMap = new HashMap<String, Set<String>>();
        Row row = cell.getRowObject();
        IMbgViewListObject rowObject = ViewListHelper.getDimension(row);
        MbgViewListDimensionInfo dimensionInfo = null;
        if (ViewListHelper.getCombinDimension(cell) != null) {
            dimensionInfo = ViewListHelper.getCombinDimension(cell);
            if (ViewlistCombinHelper.checkRowIsCombin(cell).booleanValue()) {
                if (!this.initMembers.isEmpty()) {
                    this.reParseCanAddMembers();
                    int rowInd = rowObject.getIndex();
                    if (this.initMembers.containsKey(rowInd)) {
                        if ((this.initMembers.get(rowInd).get(dimensionInfo.getNumber()) == null || this.initMembers.get(rowInd).get(dimensionInfo.getNumber()).isEmpty()) && dimensionInfo.getOrignCanAddMember() != null && !dimensionInfo.getOrignCanAddMember().isEmpty()) {
                            filterMap.put(this.getSchemeHelper().getSrcNumber(dimensionInfo.getNumber()) + "_" + "IS_NULL_ROW", null);
                        }
                        filterMap.put(this.getSchemeHelper().getSrcNumber(dimensionInfo.getNumber()), this.initMembers.get(rowInd).get(dimensionInfo.getNumber()));
                    }
                    if ((filterMap.isEmpty() || !filterMap.containsKey(DimensionConstants.DEF_CSL_SRCNUMBER)) && DimensionConstants.DEF_CSL_NUMBER.equals(dimensionInfo.getNumber())) {
                        filterMap.put(DimensionConstants.DEF_CSL_SRCNUMBER, BgCslDimConstants.canEditCslAjdNumberSet);
                    }
                } else if (DimensionConstants.DEF_CSL_NUMBER.equals(dimensionInfo.getNumber())) {
                    filterMap.put(DimensionConstants.DEF_CSL_SRCNUMBER, BgCslDimConstants.canEditCslAjdNumberSet);
                }
            }
        }
        return filterMap;
    }

    protected void reParseCanAddMembers() {
        if (this.getProvider() instanceof MBGViewListFormBaseProvider) {
            MbgViewListSheetManager sheetManager = (MbgViewListSheetManager)((MBGViewListFormBaseProvider)this.getProvider()).getCurMbgSheetManager();
            MbgViewListSheetManager cloneSheet = DimensionCommonHelper.cloneSheetManager(sheetManager);
            try {
                MbgViewListSheetManager mbgSheetManager = MBGViewListFormFacadeFactory.getRemoteInstance().reParseCanAddMembers(cloneSheet, this.getSchemeHelper().getBgSchemeId(), (BgFormInfo)this.getBgFormInfo(), false);
                mbgSheetManager.getDimensionManager().getRowCols();
                this.clearCombinMembers();
                this.initCombinMembers(mbgSheetManager.getDimensionManager());
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public void removeAllKdBoxs() {
        SpreadView sv = null;
        if (!this.kdBizPromptBoxs.isEmpty()) {
            for (String cellName : this.kdBizPromptBoxs.keySet()) {
                MbgViewlistCombinBizPromptBox box = this.kdBizPromptBoxs.get(cellName);
                Cell cell = box.getCell();
                sv = this.getSpreadView(cell);
                if (sv == null) continue;
                sv.remove((Component)((Object)box));
            }
            this.kdBizPromptBoxs.clear();
        }
    }

    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
    }

    public Map<String, Map<String, BgNViewDataInfo>> queryDimData(Map<String, List<IBgDimensionManagerBase>> dimensionManagers) throws BOSException, EASBizException {
        this.getQueryDataHelper().setQueryState(0);
        return ((IViewListCombinRender)((Object)this.getProvider())).queryData(dimensionManagers);
    }

    protected MbgBudgetDataQueryHelper getQueryDataHelper() {
        return ((IViewListCombinRender)((Object)this.getProvider())).getQueryDataHelper();
    }

    private BOSUuid getBgOrgViewId() {
        String bgOrgViewId = this.getSchemeHelper().getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId();
        return bgOrgViewId != null ? BOSUuid.read((String)bgOrgViewId) : null;
    }

    protected int getDataType() {
        return 1;
    }

    public void fillBgDataValue(Row row, Map<String, Map<String, BgNViewDataInfo>> dataMap, Map<String, Map<String, BgNViewDataInfo>> tmpDataMap, boolean repaintCell) throws Exception {
        if (row == null) {
            return;
        }
        int rowIndex = row.getRow();
        Sheet sheet = row.getSheet();
        Cell cell = null;
        ItemFormula formula = null;
        String cellOrgId = null;
        BgNViewDataInfo dataValue = null;
        BgNViewDataInfo tmpDataValue = null;
        BgSheetRange lockRange = new BgSheetRange(sheet);
        BgNFSHelper.disableUndo(sheet.getBook());
        BgNFSHelper.disableCal(sheet.getBook());
        DimensionCacheHelper cachehelper = this.getProvider().getCheckFactory().getCacheHelper();
        for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
            cell = sheet.getCell(rowIndex, colIndex, false);
            formula = BgNFSHelper.getItemFormula(cell);
            if (formula != null) {
                String version = formula.getExt("Version");
                cellOrgId = formula.getExt("ORGUNITID");
                tmpDataValue = MBGViewListFormCommonHelper.getData(tmpDataMap, cellOrgId, formula.getFormula(), version, false);
                dataValue = MBGViewListFormCommonHelper.getData(dataMap, cellOrgId, formula.getFormula(), version, false);
                if (tmpDataValue != null) {
                    if (dataValue != null) {
                        tmpDataValue.setState(dataValue.getState());
                    }
                    dataValue = tmpDataValue;
                }
                if (dataValue != null) {
                    MBGViewListFormCommonHelper.setDataValueToCell(cell, dataValue, cachehelper, this.getDataType());
                    if (this.getProvider() instanceof MBGViewListFormAdjustProvider) {
                        if (!((MBGViewListFormAdjustProvider)this.getProvider()).isCanEditByState(dataValue) && (BgNFSHelper.getBackGroup(cell) == null || BgNFSHelper.getBackGroup(cell).equals(BgNConstants.BASE_COLOR))) {
                            lockRange.addCell(row.getRow(), colIndex);
                        }
                    } else if (dataValue.getState() != 1 && dataValue.getState() != 0 && (BgNFSHelper.getBackGroup(cell) == null || BgNFSHelper.getBackGroup(cell).equals(BgNConstants.BASE_COLOR))) {
                        lockRange.addCell(row.getRow(), colIndex);
                    }
                    if (repaintCell) {
                        this.repaintCell(cell);
                    }
                } else {
                    if (!this.isCanEditCell(cell, formula)) {
                        MBGViewListFormCommonHelper.setDataValueToCell(cell, null, cachehelper, this.getDataType());
                    }
                    if (repaintCell) {
                        this.repaintCell(cell);
                    }
                }
            }
            this.fillDescriptions(cell);
        }
        BgViewHelper.setLocked(true, lockRange.getRange(), true);
        BgNFSHelper.enableUndo(sheet.getBook());
    }

    public void fillAdjustData(Row row) throws BOSException, EASBizException {
        if (!(this.getBgFormInfo() instanceof BgFormInfo)) {
            return;
        }
        Cell cell = null;
        Sheet sheet = row.getSheet();
        int rowIndex = row.getRow();
        String orgid = null;
        HashSet<String> orgIdSet = new HashSet<String>();
        for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
            cell = sheet.getCell(rowIndex, colIndex, false);
            if (cell == null) continue;
            if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                orgid = ((ItemFormula)cell.getUserObjectValue("ITEM")).getExt("ORGUNITID");
            }
            if (StringUtils.isEmpty(orgid)) continue;
            orgIdSet.add(orgid);
        }
        Set bgScenarioNums = BgScenarioHelper.getBgScenNums(null);
        Map adjustData = BgAdjustFacadaFactory.getRemoteInstance().getAdjustData(((BgFormInfo)this.getBgFormInfo()).getAdjust().getId().toString(), orgIdSet);
        String dimKey = null;
        String bgFormVersionNumber = ((BgFormInfo)this.getBgFormInfo()).getBgVersion().getNumber();
        for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
            BgNDataInfo dataInfo;
            cell = sheet.getCell(rowIndex, colIndex, false);
            if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
            String formula = BgNFSHelper.getFormulaOfCell(cell);
            dimKey = DimUtils.getDimDataKey(formula, bgFormVersionNumber);
            String scenarioNum = BgNFSHelper.parseFormulaPara(formula)[3];
            orgid = ((ItemFormula)cell.getUserObjectValue("ITEM")).getExt("ORGUNITID");
            if (!bgFormVersionNumber.equals(BgNFSHelper.getItemFormula(cell).getExt("Version")) || StringUtils.isEmpty((String)orgid) || !adjustData.containsKey(orgid)) continue;
            if (((Map)adjustData.get(orgid)).containsKey(formula)) {
                dataInfo = (BgNDataInfo)((Map)adjustData.get(orgid)).get(formula);
                BigDecimal oldValue = dataInfo.getBudgetValueNoDef() instanceof BigDecimal ? dataInfo.getBudgetValueNoDef() : (BgNFSHelper.getValue(cell) instanceof BigDecimal ? (BigDecimal)BgNFSHelper.getValue(cell) : null);
                BigDecimal newValue = dataInfo.getAdjustValue();
                if (this.getAdjustMap().get(orgid) != null && ((Map)this.getAdjustMap().get(orgid)).containsKey(formula)) {
                    this.updateDivInfo(cell, formula, newValue, oldValue);
                } else {
                    this.createDivInfo(cell, formula, newValue, oldValue);
                }
                if (oldValue != null && (newValue == null || newValue.compareTo(oldValue) == 0)) continue;
                this.setCellAdjustValue(cell, formula, newValue);
                continue;
            }
            if (this.getBgDataMap().containsKey(orgid) && this.getBgDataMap().get(orgid).containsKey(dimKey)) {
                dataInfo = this.getBgDataMap().get(orgid).get(dimKey);
                if (dataInfo != null && dataInfo.getState() != 0) {
                    if (dataInfo.getOldValue() == null || dataInfo.getOldValue().compareTo(dataInfo.getBudgetValue()) == 0) continue;
                    if (this.getAdjustMap().get(orgid) != null && ((Map)this.getAdjustMap().get(orgid)).containsKey(formula)) {
                        this.updateDivInfo(cell, formula, dataInfo.getBudgetValue(), dataInfo.getOldValue());
                    } else {
                        this.createDivInfo(cell, formula, dataInfo.getBudgetValue(), dataInfo.getOldValue());
                    }
                    this.setCellAdjustValue(cell, formula, dataInfo.getBudgetValue());
                    continue;
                }
                this.setNormalBackGroup(cell);
                continue;
            }
            try {
                if (cell.getValue() != null && cell.getValue() != Variant.nullVariant && cell.getValue().toBigDecimal() != null && bgScenarioNums.contains(scenarioNum) && this.getProvider() instanceof MbgViewListFormRollProvider) {
                    this.createDivInfo(cell, formula, cell.getValue().toBigDecimal(), null);
                    continue;
                }
                this.setNormalBackGroup(cell);
                continue;
            }
            catch (SyntaxErrorException e) {
                logger.info((Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private Map getAdjustMap() {
        if (this.getProvider() instanceof MBGViewListFormAdjustProvider) {
            return ((MBGViewListFormAdjustProvider)this.getProvider()).getAdjustMap();
        }
        return new HashMap();
    }

    protected Map<String, Map<String, BgNViewDataInfo>> getBgDataMap() {
        return ((IViewListCombinRender)((Object)this.getProvider())).getBgDataMap();
    }

    private void setCellAdjustValue(Cell cell, String formula, BigDecimal value) {
        BgNFSHelper.setValue(cell, value);
    }

    private MbgAdjustHelper getAdjustHelper() {
        if (this.getProvider() instanceof MBGViewListFormAdjustProvider) {
            return ((MBGViewListFormAdjustProvider)this.getProvider()).getAdjustHelper();
        }
        return null;
    }

    public void updateDivInfo(Cell cell, String formulaStr, BigDecimal newValue, BigDecimal oldValue) {
        if (this.getAdjustHelper() != null) {
            this.getAdjustHelper().updateDivInfo(cell, formulaStr, newValue, oldValue);
        }
    }

    public void createDivInfo(Cell cell, String formulaStr, BigDecimal newValue, BigDecimal oldValue) {
        if (this.getAdjustHelper() != null) {
            this.getAdjustHelper().createDivInfo(cell, formulaStr, newValue, oldValue);
        }
    }

    protected void setNormalBackGroup(Cell cell) {
        if (cell != null && !cell.getSheet().getRange(cell).isCellLocked()) {
            BgNFSHelper.setBackGroup(cell, BgNConstants.BASE_COLOR);
        }
    }

    protected void setAccountNumber(Cell cell, List<BgDimensionMember> members) {
        if (members != null && !members.isEmpty()) {
            Map<String, Integer> accountMap = ((IViewListCombinRender)((Object)this.getProvider())).getAccountDataTypeMap();
            int size = members.size();
            for (int m = 0; m < size; ++m) {
                BgDimensionMember mem = members.get(m);
                if (accountMap == null || !DimensionConstants.DEF_ACCOUNT_NUMBER.equals(mem.getType()) || mem.getNumber() == null) continue;
                BgNFSHelper.setUserObject(cell, "BGACCOUNT_NUMBER", mem.getNumber());
            }
        }
    }

    protected Map<String, Map<String, Map<String, MbgViewListDesCellInfo>>> getDesMap(Sheet sheet) throws Exception {
        if (this.desMap == null && this.getProvider() instanceof IViewListCombinRender) {
            this.desMap = ((IViewListCombinRender)((Object)this.getProvider())).queryDescMap(sheet);
        }
        return this.desMap;
    }

    protected void fillDescriptions(Cell cell) throws Exception {
        if (this.getProvider() instanceof IViewListCombinRender && cell != null) {
            ((IViewListCombinRender)((Object)this.getProvider())).fillDescriptions(cell, this.getDesMap(cell.getSheet()));
        }
    }

    protected void dealPageMembers(List<KDPromptBox> viewF7List, List<KDPromptBox> pageF7List, IBgDimensionManagerBase dimensionManager, IBgDimensionManagerBase dimensionManagerForStyle, String currOrgNumber) {
        if (this.getProvider() instanceof IViewListCombinRender) {
            ((IViewListCombinRender)((Object)this.getProvider())).dealPageMembers(viewF7List, pageF7List, dimensionManager, dimensionManagerForStyle, currOrgNumber);
        }
    }

    protected IMBGViewListFormFacade getViewListFormFacade() throws BOSException {
        if (this.viewlistFormFacade == null) {
            this.viewlistFormFacade = MBGViewListFormFacadeFactory.getRemoteInstance();
        }
        return this.viewlistFormFacade;
    }

    public void afterFillMembers(Sheet sheet, int startRowIndex, int endRowIndex) {
        this.afterFillMembers(sheet, startRowIndex, endRowIndex, false);
    }

    public void afterFillMembers(Sheet sheet, int startRowIndex, int endRowIndex, boolean isSingleSelectMember) {
        if (sheet == null || startRowIndex <= 0 || startRowIndex > endRowIndex) {
            return;
        }
        try {
            if (!isSingleSelectMember) {
                this.getProvider().store(sheet);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.context.getOwnerUI().handUIExceptionAndAbort(e);
        }
        HashMap<String, Map<String, Set<String>>> orgMembersMap = new HashMap<String, Map<String, Set<String>>>();
        HashMap membersMap = null;
        HashMap<String, Set<String>> memberMapForProp = new HashMap<String, Set<String>>();
        String orgId = null;
        String orgNumber = null;
        HashMap<String, List<MbgViewListRowCol>> orgRowsMap = new HashMap<String, List<MbgViewListRowCol>>();
        HashMap<String, String> orgIdAndNum = new HashMap<String, String>();
        boolean isQueryViewData = false;
        int sheetIndex = sheet.getSheetIndex();
        int maxCol = sheet.getMaxColIndex();
        HashMap<String, MBGRowData> rowDatas = new HashMap<String, MBGRowData>();
        Set<Integer> fullRowIndexs = ViewlistCombinHelper.checkCombinRowsFullofMembers(sheet, startRowIndex, endRowIndex, true, isSingleSelectMember);
        for (int rIndex = startRowIndex; rIndex <= endRowIndex; ++rIndex) {
            Row row = sheet.getRow(rIndex, false);
            for (int cIndex = 0; cIndex <= maxCol; ++cIndex) {
                Column col = sheet.getColumn(cIndex, false);
                Cell _cell = row.getCell(cIndex, false);
                if (_cell == null) continue;
                this.recordMemberForProp(_cell, memberMapForProp);
                if (!fullRowIndexs.contains(rIndex)) continue;
                isQueryViewData = true;
                if (_cell == null || ViewListHelper.getCombinDimension(_cell) != null || col == null || !(ViewListHelper.getDimension(col) instanceof MbgViewListRowCol) && !(ViewListHelper.getDimension(col) instanceof MbgViewListDescription)) continue;
                ArrayList<BgDimensionMember> members = new ArrayList<BgDimensionMember>();
                Object[] colMembers = ViewListHelper.getDimensionMember(col);
                Object[] rowMembers = ViewListHelper.getDimensionMember(row);
                members.clear();
                ViewListHelper.add(members, rowMembers);
                ViewListHelper.add(members, colMembers);
                members.addAll(ViewlistCombinHelper.getPageMembers(this.getDimensionManager(), this.getProvider().getPageF7List(sheetIndex)));
                members.addAll(ViewlistCombinHelper.getViewMembers(this.getDimensionManager(), this.getProvider().getViewF7List(sheetIndex)));
                this.setAccountNumber(_cell, members);
                if (ViewListHelper.getDimension(col) instanceof MbgViewListRowCol) {
                    BgDimensionParseCommonHelper.builderBgFormula(_cell, members, true, null, rowDatas, null, DimensionCommonHelper.getItemFields(this.context.getProvider().getBgDimensionManager().getSheet()));
                } else if (ViewListHelper.getDimension(col) instanceof MbgViewListDescription) {
                    MbgViewListDescriptionHelper.buildDescriptionFormula(this.context.getOrgUnitId(), _cell, null, members, (MbgViewListSheetManager)this.context.getProvider().getBgDimensionManager().getSheet(), row, col, true);
                    ((ViewListProvider)this.context.getProvider()).fillDescriptions(_cell, null);
                }
                if (BgNFSHelper.getItemFormula(_cell) == null) continue;
                orgId = BgNFSHelper.getItemFormula(_cell).getExt("ORGUNITID");
                if (DimensionConstants.DEF_ORGUNIT_FIELD.equals(orgId) && this.isOrgOnRow() && this.getBgFormInfo() instanceof BgFormInfo) {
                    orgId = ((BgFormInfo)this.getBgFormInfo()).getOrgUnit().getId().toString();
                    BgNFSHelper.getItemFormula(_cell).putExt("ORGUNITID", orgId);
                }
                orgNumber = BgNFSHelper.getItemFormula(_cell).getExt("ORGUNIT");
                if (!orgRowsMap.containsKey(orgId)) {
                    orgRowsMap.put(orgId, new ArrayList());
                    if (ViewListHelper.getDimension(row) instanceof MbgViewListRowCol) {
                        MbgViewListRowCol rowObject = (MbgViewListRowCol)ViewListHelper.getDimension(row);
                        if (!((List)orgRowsMap.get(orgId)).contains(rowObject)) {
                            ((List)orgRowsMap.get(orgId)).add(rowObject);
                        }
                    }
                }
                if (this.isFromWorkPaper() && this.getBgFormInfo() instanceof IDimDataQuery) {
                    String schemeOrgId = ((IDimDataQuery)this.getBgFormInfo()).getBizBgScheme().getOrgUnit().getId().toString();
                    String schemeOrgNumber = ((IDimDataQuery)this.getBgFormInfo()).getBizBgScheme().getOrgUnit().getNumber();
                    orgIdAndNum.put(schemeOrgId, schemeOrgNumber);
                    if (!orgMembersMap.containsKey(schemeOrgId)) {
                        membersMap = new HashMap();
                        orgMembersMap.put(schemeOrgId, membersMap);
                    }
                } else if (!this.isOrgOnCol() || orgId.equals(this.getOrgUnitId())) {
                    if (!orgIdAndNum.containsKey(orgId)) {
                        orgIdAndNum.put(orgId, orgNumber);
                    }
                    if (!orgMembersMap.containsKey(orgId)) {
                        membersMap = new HashMap();
                        orgMembersMap.put(orgId, membersMap);
                    }
                }
                if (membersMap == null || members.isEmpty()) continue;
                for (int index = 0; index < members.size(); ++index) {
                    BgDimensionMember tmpMember = (BgDimensionMember)members.get(index);
                    String dimNumber = tmpMember.getType();
                    String srcNum = this.getSchemeHelper().getSrcNumber(dimNumber);
                    if (!membersMap.containsKey(srcNum)) {
                        membersMap.put(srcNum, new HashSet());
                    }
                    ((Set)membersMap.get(srcNum)).add(tmpMember.getNumber());
                }
            }
        }
        this.dealProperty(sheet, startRowIndex, endRowIndex, memberMapForProp);
        this.appendLeafMembers(orgMembersMap, orgIdAndNum);
        this.dealRangeLock(sheet, startRowIndex, endRowIndex);
        this.fillDimBgData(sheet, startRowIndex, endRowIndex, isQueryViewData, orgRowsMap, orgIdAndNum);
        if (isQueryViewData) {
            this.dealCalculateFormula(sheet, startRowIndex, endRowIndex);
            this.afterDealCalculateFormula(sheet, startRowIndex, endRowIndex);
        }
        ViewlistCombinHelper.reloadMemberfilter(this.context, this.getProvider(), this.getDimensionManager(), sheet);
        orgMembersMap.clear();
        orgRowsMap.clear();
        orgIdAndNum.clear();
    }

    public void afterDealCalculateFormula(Sheet sheet, int startRowIndex, int endRowIndex) {
        if (sheet == null || startRowIndex <= 0 || startRowIndex > endRowIndex) {
            return;
        }
        Range calcRange = null;
        int maxCol = sheet.getMaxColIndex();
        for (int rIndex = startRowIndex; rIndex <= endRowIndex; ++rIndex) {
            Row row = sheet.getRow(rIndex, false);
            for (int cIndex = 0; cIndex <= maxCol; ++cIndex) {
                Cell cell = row.getCell(cIndex, false);
                if (cell == null || !BgNFSHelper.checkHasExpression(cell)) continue;
                if (calcRange == null) {
                    calcRange = cell.getSheet().getRange(cell);
                    continue;
                }
                calcRange.addAll((SortedCellBlockArray)cell.getSheet().getRange(cell));
            }
        }
        if (calcRange != null && !calcRange.isEmpty()) {
            calcRange.calc();
        }
    }

    protected void dealProperty(Sheet sheet, int startRowIndex, int endRowIndex, Map<String, Set<String>> memberMapForProp) {
        try {
            this.reQueryqueryProp(memberMapForProp);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.context.getOwnerUI().handUIExceptionAndAbort(e);
        }
        ViewlistCombinHelper.fillProperty(this.getProvider(), sheet, startRowIndex, endRowIndex);
    }

    protected void fillDimBgData(Sheet sheet, int startRowIndex, int endRowIndex, boolean isQueryViewData, Map<String, List<MbgViewListRowCol>> orgRowsMap, Map<String, String> orgIdAndNum) {
        HashMap<String, List<IBgDimensionManagerBase>> dimensionManagers = new HashMap<String, List<IBgDimensionManagerBase>>();
        MbgViewListRowCol rowObject = null;
        int sheetIndex = sheet.getIndex();
        if (!orgRowsMap.isEmpty()) {
            String orgKey2 = null;
            List<MbgViewListRowCol> rowLst = null;
            for (String orgKey2 : orgRowsMap.keySet()) {
                rowLst = orgRowsMap.get(orgKey2);
                if (rowLst.isEmpty()) continue;
                MbgViewListDimensionManager dimensionManager = this.getDimensionManager().deepclone();
                this.dealPageMembers(this.getProvider().getPageF7List(sheetIndex), this.getProvider().getPageF7List(sheetIndex), dimensionManager, this.getDimensionManager(), orgIdAndNum.get(orgKey2));
                dimensionManager.getRows().clear();
                for (int i = 0; i < rowLst.size(); ++i) {
                    rowObject = rowLst.get(i);
                    if (dimensionManager.getRows().contains(rowObject)) continue;
                    if (!dimensionManagers.containsKey(orgKey2)) {
                        dimensionManagers.put(orgKey2, new ArrayList());
                    }
                    dimensionManager.getRows().add(rowObject);
                    ((List)dimensionManagers.get(orgKey2)).add(dimensionManager);
                }
            }
        }
        if (!dimensionManagers.isEmpty() && isQueryViewData) {
            try {
                Map<String, Map<String, BgNViewDataInfo>> dataMap = this.queryDimData(dimensionManagers);
                if (dataMap == null) {
                    dataMap = new HashMap<String, Map<String, BgNViewDataInfo>>();
                }
                for (int rIndex = startRowIndex; rIndex <= endRowIndex; ++rIndex) {
                    Row row = sheet.getRow(rIndex, false);
                    this.fillBgDataValue(row, dataMap, this.getBgDataMap(), true);
                    if (!(this.getProvider() instanceof MBGViewListFormAdjustProvider)) continue;
                    this.fillAdjustData(row);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.context.getOwnerUI().handUIExceptionAndAbort(e);
            }
        }
    }

    protected void appendLeafMembers(Map<String, Map<String, Set<String>>> orgMembersMap, Map<String, String> orgIdAndNum) {
        if (!orgMembersMap.isEmpty()) {
            try {
                this.reFilterQueryMembers(orgMembersMap, orgIdAndNum);
                Map leafMembers = this.getViewListFormFacade().queryMutilOrgLeafMembers(orgMembersMap, this.getSchemeHelper().getBgSchemeId(), this.isFromWorkPaper(), this.getProvider().isDecompose());
                Map membersMap = null;
                String orgNumber = null;
                if (leafMembers != null) {
                    if (this.isFromWorkPaper() && this.getBgFormInfo() instanceof IDimDataQuery) {
                        String schemeOrgId = ((IDimDataQuery)this.getBgFormInfo()).getBizBgScheme().getOrgUnit().getId().toString();
                        Map viewMap = this.getProvider().getBgViewManagerForMulOrg();
                        if (viewMap.isEmpty()) {
                            return;
                        }
                        for (String orgKey : viewMap.keySet()) {
                            MbgViewListManager viewManager = (MbgViewListManager)viewMap.get(orgKey);
                            DimensionMemberCheckHelper heler = this.getDimensionMembercheckHeler(schemeOrgId, viewManager);
                            Map<String, Set<String>> leafMap = heler.getLeafMap();
                            membersMap = (Map)leafMembers.get(schemeOrgId);
                            if (membersMap == null) continue;
                            for (String srcNumber : membersMap.keySet()) {
                                Set returnLeftMembers = (Set)membersMap.get(srcNumber);
                                if (!leafMap.containsKey(srcNumber)) {
                                    leafMap.put(srcNumber, new HashSet());
                                }
                                leafMap.get(srcNumber).addAll(returnLeftMembers);
                            }
                        }
                    } else {
                        for (String orgKey : orgMembersMap.keySet()) {
                            orgNumber = orgIdAndNum.get(orgKey);
                            if (!leafMembers.containsKey(orgKey) || !this.getProvider().getBgViewManagerForMulOrg().containsKey(orgNumber)) continue;
                            MbgViewListManager viewManager = (MbgViewListManager)this.getProvider().getBgViewManagerForMulOrg().get(orgNumber);
                            DimensionMemberCheckHelper heler = this.getDimensionMembercheckHeler(orgKey, viewManager);
                            Map<String, Set<String>> leafMap = heler.getLeafMap();
                            membersMap = (Map)leafMembers.get(orgKey);
                            if (membersMap == null) continue;
                            for (String srcNumber : membersMap.keySet()) {
                                Set returnLeftMembers = (Set)membersMap.get(srcNumber);
                                if (!leafMap.containsKey(srcNumber)) {
                                    leafMap.put(srcNumber, new HashSet());
                                }
                                leafMap.get(srcNumber).addAll(returnLeftMembers);
                            }
                        }
                    }
                }
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                this.context.getOwnerUI().handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.context.getOwnerUI().handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
    }

    protected void dealRangeLock(Sheet sheet, int startRowIndex, int endRowIndex) {
        int maxCol = sheet.getMaxColIndex();
        BgSheetRange lockRange = new BgSheetRange(sheet);
        BgSheetRange lockRangeNotPaintColor = new BgSheetRange(sheet);
        BgSheetRange unLockRange = new BgSheetRange(sheet);
        BgSheetRange unlockRangeNotPaintColor = new BgSheetRange(sheet);
        for (int rIndex = startRowIndex; rIndex <= endRowIndex; ++rIndex) {
            for (int cIndex = 0; cIndex <= maxCol; ++cIndex) {
                Row row = sheet.getRow(rIndex, false);
                Column col = sheet.getColumn(cIndex, false);
                Cell _cell = row.getCell(cIndex, false);
                if (ViewListHelper.getCombinDimension(_cell) != null || col == null || !(ViewListHelper.getDimension(col) instanceof MbgViewListRowCol) && !(ViewListHelper.getDimension(col) instanceof MbgViewListDescription)) continue;
                if (BgNFSHelper.getItemFormula(_cell) == null && ViewListHelper.getDimension(col) instanceof MbgViewListRowCol) {
                    lockRange.addCell(row.getRow(), cIndex);
                    continue;
                }
                if (this.isCanEditCell(_cell, BgNFSHelper.getItemFormula(_cell)) && !this.isLockByWorkPaperCell(BgNFSHelper.getItemFormula(_cell))) {
                    if (BgNFSHelper.getBackGroup(_cell) != null && BgNFSHelper.getBackGroup(_cell).equals(BgNConstants.LOCK_COLOR)) {
                        unLockRange.addCell(row.getRow(), cIndex);
                        continue;
                    }
                    unlockRangeNotPaintColor.addCell(row.getRow(), cIndex);
                    continue;
                }
                if (BgNFSHelper.getBackGroup(_cell) == null || BgNFSHelper.getBackGroup(_cell).equals(BgNConstants.BASE_COLOR)) {
                    lockRange.addCell(row.getRow(), cIndex);
                    continue;
                }
                lockRangeNotPaintColor.addCell(row.getRow(), cIndex);
            }
        }
        BgViewHelper.setLocked(true, lockRange.getRange(), true);
        BgViewHelper.setLocked(true, lockRangeNotPaintColor.getRange(), false);
        BgViewHelper.setLocked(false, unLockRange.getRange(), true);
        BgViewHelper.setLocked(false, unlockRangeNotPaintColor.getRange(), false);
    }

    protected void dealCalculateFormula(Sheet sheet, int startRowIndex, int endRowIndex) {
        if (this.context != null && this.context.getProvider() instanceof IViewListCombinRender) {
            try {
                ((IViewListCombinRender)((Object)this.context.getProvider())).dealCalculateColFormula(sheet, sheet.getRowRange(startRowIndex, endRowIndex));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                this.context.getOwnerUI().handUIExceptionAndAbort(e);
            }
        }
    }

    private void reFilterQueryMembers(Map<String, Map<String, Set<String>>> orgMembersMap, Map<String, String> orgIdAndNum) throws EASBizException, BOSException {
        if (orgMembersMap == null || orgMembersMap.isEmpty() || orgIdAndNum == null || orgIdAndNum.isEmpty()) {
            return;
        }
        Map<String, Set<String>> membersMap = null;
        String orgNumber = null;
        String srcNumber2 = null;
        String memberNum = null;
        for (String orgKey : orgMembersMap.keySet()) {
            membersMap = orgMembersMap.get(orgKey);
            orgNumber = orgIdAndNum.get(orgKey);
            if (!this.getProvider().getBgViewManagerForMulOrg().containsKey(orgNumber)) continue;
            MbgViewListManager viewManager = (MbgViewListManager)this.getProvider().getBgViewManagerForMulOrg().get(orgNumber);
            DimensionMemberCheckHelper heler = this.getDimensionMembercheckHeler(orgKey, viewManager);
            Map<String, Set<String>> leafMap = heler.getLeafMap();
            if (membersMap == null) continue;
            for (String srcNumber2 : membersMap.keySet()) {
                Set<String> queryMembers = membersMap.get(srcNumber2);
                if (queryMembers == null || queryMembers.isEmpty()) continue;
                Iterator<String> itr = queryMembers.iterator();
                while (itr.hasNext()) {
                    memberNum = itr.next();
                    if (!leafMap.containsKey(srcNumber2) || !leafMap.get(srcNumber2).contains(memberNum)) continue;
                    itr.remove();
                }
            }
        }
    }

    private void recordMemberForProp(Cell cell, Map<String, Set<String>> memberMapForProp) {
        String dimNumber;
        BgDimensionMember member;
        UserObject object = cell.getUserObject("dimensino.member");
        if (object != null && (member = BgDimensionParseCommonHelper.getMember(object.getValue())) != null && (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber = member.getType()) || !DimensionConstants.necessary.contains(dimNumber))) {
            if (!memberMapForProp.containsKey(dimNumber)) {
                memberMapForProp.put(dimNumber, new HashSet());
            }
            memberMapForProp.get(dimNumber).add(member.getNumber());
        }
    }

    private void reQueryqueryProp(Map<String, Set<String>> memberMapForProp) throws EASBizException, BOSException {
        String dimNumber;
        HashSet<String> allDimension = new HashSet<String>();
        HashMap propSortIds = new HashMap();
        ArrayList objects = new ArrayList();
        objects.addAll(this.getDimensionManager().getRowDimension());
        objects.addAll(this.getDimensionManager().getColDimension());
        for (IMbgViewListObject object : objects) {
            if (!(object instanceof MbgViewListAtribute)) continue;
            allDimension.add(((MbgViewListAtribute)object).getDimNumber());
            if (((MbgViewListAtribute)object).getPropertySort().getId() == null) continue;
            dimNumber = ((MbgViewListAtribute)object).getDimNumber();
            if (!propSortIds.containsKey(dimNumber)) {
                propSortIds.put(dimNumber, new HashSet());
            }
            ((Set)propSortIds.get(dimNumber)).add(((MbgViewListAtribute)object).getPropertySort().getId().toString());
        }
        Map<String, Map<String, String>> propMap = this.getProvider().getPropMaps();
        if (propMap == null || propMap.isEmpty()) {
            return;
        }
        Iterator<String> iterator = memberMapForProp.keySet().iterator();
        while (iterator.hasNext()) {
            dimNumber = iterator.next();
            Set propSortIdSet = (Set)propSortIds.get(dimNumber);
            if (propSortIdSet != null) {
                for (String sortId : propSortIdSet) {
                    if (propMap.get(dimNumber + "_" + sortId) == null) continue;
                    memberMapForProp.get(dimNumber).removeAll(propMap.get(dimNumber + "_" + sortId).keySet());
                }
            }
            if (propMap.get(dimNumber + "_" + BgPropertyHelper.genDimNamePropertySortNumber((String)dimNumber)) != null) {
                memberMapForProp.get(dimNumber).removeAll(propMap.get(dimNumber + "_" + BgPropertyHelper.genDimNamePropertySortNumber((String)dimNumber)).keySet());
            }
            if (propMap.get(dimNumber + "_" + BgPropertyHelper.genDimDescPropertySortNumber((String)dimNumber)) != null) {
                memberMapForProp.get(dimNumber).removeAll(propMap.get(dimNumber + "_" + BgPropertyHelper.genDimDescPropertySortNumber((String)dimNumber)).keySet());
            }
            if (!memberMapForProp.get(dimNumber).isEmpty()) continue;
            iterator.remove();
        }
        if (memberMapForProp.isEmpty()) {
            return;
        }
        String bgSchemeID = this.getProvider().getBgSchemeId();
        Map result = ViewListFacadeFactory.getRemoteInstance().queryProp(memberMapForProp, propSortIds, bgSchemeID, allDimension);
        for (String key : result.keySet()) {
            if (propMap.containsKey(key)) {
                propMap.get(key).putAll((Map)result.get(key));
                continue;
            }
            propMap.put(key, new HashMap());
            propMap.get(key).putAll((Map)result.get(key));
        }
    }

    protected boolean isOrgOnRow() {
        boolean isorgOnPageOrView;
        if (this.isOrgOnRow == null && !(isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(this.getDimensionManager()))) {
            this.isOrgOnRow = String.valueOf(MBGViewListFormCommonHelper.isOrgOnRow(this.getDimensionManager()));
        }
        return this.isOrgOnRow == null ? false : Boolean.valueOf(this.isOrgOnRow);
    }

    protected boolean isOrgOnCol() {
        boolean isorgOnPageOrView;
        if (this.isOrgOnCol == null && !(isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(this.getDimensionManager()))) {
            this.isOrgOnCol = String.valueOf(!MBGViewListFormCommonHelper.isOrgOnRow(this.getDimensionManager()));
        }
        return this.isOrgOnCol == null ? false : Boolean.valueOf(this.isOrgOnCol);
    }

    private boolean isFromWorkPaper() {
        boolean isFormWorkPaper = false;
        if (this.getSchemeHelper() != null && ("com.kingdee.eas.ma.bgcsl.utils.MbgWorkSchemeDimensionHelper".equals(this.getSchemeHelper().getClass().getName()) || DimensionConstants.CSLSCHEME_HELPER.equals(this.getSchemeHelper().getClass().getName()))) {
            isFormWorkPaper = true;
        }
        return isFormWorkPaper;
    }

    public String getOrgNumsForCurSheet(int sheetIndex, Set<String> orgNums) {
        return null;
    }

    protected String getRowColOrgId(Cell cell) {
        if (cell == null) {
            return null;
        }
        String rowColOrgId = null;
        String orgNumber = null;
        MbgViewListRowCol rowColObj = null;
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(this.getDimensionManager());
        if (!isorgOnPageOrView) {
            if (MBGViewListFormCommonHelper.isOrgOnRow(this.getDimensionManager())) {
                if (ViewListHelper.getDimension(cell.getRowObject()) instanceof MbgViewListRowCol) {
                    rowColObj = (MbgViewListRowCol)ViewListHelper.getDimension(cell.getRowObject());
                }
            } else if (ViewListHelper.getDimension(cell.getSheet().getColumn(cell.getCol(), false)) instanceof MbgViewListRowCol) {
                rowColObj = (MbgViewListRowCol)ViewListHelper.getDimension(cell.getSheet().getColumn(cell.getCol(), false));
            }
        } else {
            if (this.getProvider() instanceof MBGViewListFormBaseProvider) {
                return ((MBGViewListFormBaseProvider)this.getProvider()).getOrgUnitForCurSheet(this.getDimensionManager().getSheet().getSheetIndex()).getId().toString();
            }
            if (this.getProvider() instanceof BgCslViewListFormProvider && ((BgCslViewListFormProvider)this.getProvider()).getOrgUnitForCurSheet(this.getDimensionManager().getSheet().getSheetIndex()) != null) {
                return ((BgCslViewListFormProvider)this.getProvider()).getOrgUnitForCurSheet(this.getDimensionManager().getSheet().getSheetIndex()).getId().toString();
            }
        }
        if (rowColObj != null) {
            for (int i = 0; i < rowColObj.getDimensions().size(); ++i) {
                if (!rowColObj.getDimensions().get(i).getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) || rowColObj.getDimensions().get(i).getMember().isEmpty()) continue;
                orgNumber = ((BgDimensionMember)rowColObj.getDimensions().get(i).getMember().get(0)).getNumber();
                if (!this.getProvider().getOrgUnitMap().containsKey(orgNumber)) continue;
                rowColOrgId = this.getProvider().getOrgUnitMap().get(orgNumber).getId().toString();
                break;
            }
        }
        return rowColOrgId;
    }

    protected void setDialogFilter(Map<String, Set<String>> filterMap, Cell cell, MbgViewlistCombinBizPromptBox kdbox) {
        if (filterMap != null && !filterMap.isEmpty() && kdbox != null) {
            if (kdbox.getSelector() instanceof NewDimensionMemberSelectDialog) {
                ((NewDimensionMemberSelectDialog)kdbox.getSelector()).setFilterValueMap(filterMap);
            } else if (!(kdbox.getSelector() instanceof BgPeriodDialog) || filterMap.containsKey(DimensionConstants.DEF_PERIOD_SRCNUMBER)) {
                // empty if block
            }
        }
    }

    private void getDeletedFormulas(Cell cell, List<ItemFormula> deletedFormulas) {
        Row row = cell.getSheet().getRow(cell.getRow(), false);
        if (row != null) {
            for (int j = 0; j < row.size(); ++j) {
                Cell tCell = row.getAt(j);
                if (tCell == null || !BgNFSHelper.checkHasFormulaOfCell(tCell)) continue;
                ItemFormula formula = BgNFSHelper.getItemFormula(tCell);
                deletedFormulas.add(formula);
            }
        }
    }

    private void setDeletedFormulasToSheetUserObject(Cell cell, List<ItemFormula> deletedFormulas) {
        if (deletedFormulas.size() > 0) {
            StringBuffer formulasSb = new StringBuffer();
            for (ItemFormula formula : deletedFormulas) {
                String orgUnitid = formula.getExt("ORGUNITID");
                String formulaStr = orgUnitid + "##" + formula.getFormula();
                formulasSb.append(formulaStr).append("@@");
            }
            if (formulasSb.length() > 0) {
                String formulasString = formulasSb.toString();
                formulasString = formulasString.substring(0, formulasString.length() - 2);
                cell.getSheet().setUserObject("deletedFormulas", (Object)formulasString);
            }
        }
    }

    private void resetBgDataInfo(Row row) {
        for (int j = 0; j < row.size(); ++j) {
            ItemFormula formula;
            Cell tCell = row.getAt(j);
            if (tCell == null || (formula = BgNFSHelper.getItemFormula(tCell)) == null) continue;
            String versionNumber = formula.getExt("Version");
            String orgId = formula.getExt("ORGUNITID");
            MBGViewListFormClientHelper.createNullData(this.getBgDataMap(), orgId, formula.toString(), versionNumber);
        }
    }

    private void resetBgAdjustData(Row row) {
        for (int j = 0; j < row.size(); ++j) {
            ItemFormula formula;
            Cell tCell = row.getAt(j);
            if (tCell == null || (formula = BgNFSHelper.getItemFormula(tCell)) == null) continue;
            String orgId = formula.getExt("ORGUNITID");
            if (this.getAdjustMap() == null || orgId == null) {
                return;
            }
            Map subMap = null;
            if (!this.getAdjustMap().containsKey(orgId) || !(subMap = (Map)this.getAdjustMap().get(orgId)).containsKey(formula.toString())) continue;
            BgAdjustFormDiversityData data = (BgAdjustFormDiversityData)subMap.get(formula.toString());
            data.setNewValue(null);
        }
    }

    private boolean checkDumpRow(Cell cell, BgDimensionMember memberInfo) {
        boolean flag = false;
        Row srcRow = cell.getRowObject();
        Sheet sheet = cell.getSheet();
        BgDimensionMember member = null;
        ArrayList<BgDimensionMember> memberSet = new ArrayList<BgDimensionMember>();
        MbgViewListRowCol rowCol = (MbgViewListRowCol)cell.getRowObject().getUserObject("dimension.object").getValue();
        int maxCol = cell.getSheet().getMaxColIndex();
        for (int i = 0; i <= maxCol; ++i) {
            if (i == cell.getCol()) {
                memberSet.add(memberInfo);
                continue;
            }
            Cell _cell = sheet.getCell(cell.getRow(), i, false);
            if (_cell == null || ViewListHelper.getCombinDimension(_cell) == null || _cell.getCol() == cell.getCol()) continue;
            Object obj = ViewListHelper.getHeadCellValue(_cell);
            member = BgDimensionParseCommonHelper.getMember(obj);
            memberSet.add(member);
        }
        BgDimensionMember[] bgDimensionMembers = memberSet.toArray(new BgDimensionMember[memberSet.size()]);
        BgDimensionMember combinMemberByDimMember = ViewlistCombinHelper.getCombinMemberByDimMember(bgDimensionMembers);
        if (rowCol.getCombinMembers().contains(combinMemberByDimMember)) {
            flag = true;
        }
        return flag;
    }

    private int dealInsertRow(Cell cell, List memberSet) {
        MbgViewListRowCol rowCol = (MbgViewListRowCol)cell.getRowObject().getUserObject("dimension.object").getValue();
        int col = cell.getCol();
        int dealRowIndex = cell.getRow();
        int insertRowCount = 0;
        Sheet sheet = cell.getSheet();
        List<BgDimensionMember> combinMembers = rowCol.getCombinMembers();
        StringBuffer detailMsg = new StringBuffer();
        String msg = BgCommCHelper.getMessageStr((String)RES_CLIENT, (String)"existSameDimensionMemberOfBatch");
        ActionInsertRow actionInsertRow = new ActionInsertRow();
        actionInsertRow.setSheet(cell.getSheet());
        actionInsertRow.setProvide(this.getProvider());
        actionInsertRow.setDimensionManager(this.getDimensionManager());
        LinkedHashMap<MbgViewListRowCol, Map<Integer, Row>> selectRowMap = new LinkedHashMap<MbgViewListRowCol, Map<Integer, Row>>();
        Object member = null;
        for (int i = 0; i < memberSet.size(); ++i) {
            Cell tmpCell;
            BgDimensionMember temp = (BgDimensionMember)memberSet.get(i);
            if (rowCol.getEndIndex() < dealRowIndex) {
                selectRowMap.clear();
                selectRowMap.put(rowCol, new LinkedHashMap());
                ((Map)selectRowMap.get(rowCol)).put(dealRowIndex - 1, sheet.getRow(dealRowIndex - 1, false));
                actionInsertRow.doInsertRow(selectRowMap, this.context.getSpreadContext());
                ++insertRowCount;
                tmpCell = sheet.getCell(dealRowIndex, col, false);
                ViewlistCombinHelper.setCombinCellMember(this.getProvider(), tmpCell, temp);
            } else {
                tmpCell = sheet.getCell(dealRowIndex, col, false);
                if (tmpCell != null && ViewListHelper.getCombinDimension(tmpCell) != null && ViewListHelper.getHeadCellValue(tmpCell) != null && dealRowIndex != cell.getRow()) {
                    selectRowMap.put(rowCol, new LinkedHashMap());
                    ((Map)selectRowMap.get(rowCol)).put(dealRowIndex - 1, sheet.getRow(dealRowIndex - 1, false));
                    actionInsertRow.doInsertRow(selectRowMap, this.context.getSpreadContext());
                    ++insertRowCount;
                    tmpCell = sheet.getCell(dealRowIndex, col, false);
                    ViewlistCombinHelper.setCombinCellMember(this.getProvider(), tmpCell, temp);
                } else if (!this.checkDumpRow(tmpCell, temp)) {
                    ViewlistCombinHelper.setCombinCellMember(this.getProvider(), tmpCell, temp);
                } else {
                    detailMsg.append(MessageFormat.format(msg, i)).append("\r\n");
                    continue;
                }
            }
            ++dealRowIndex;
        }
        ViewListSheetParseHelper sheetParseHelper = this.getProvider().getBookParseHelper().getSheetMap().get(sheet.getIndex());
        ActionInsertRow.synCalculateRow(this.getProvider(), sheetParseHelper, sheet);
        this.context.getSpreadContext().repaint();
        return 0;
    }

    protected boolean checkCanEditOtherAddedBgForm(Cell cell) {
        if (cell != null && this.getProvider() != null && this.getProvider().getCurMbgSheetManager() != null) {
            String cellOrgId = this.getRowColOrgId(cell);
            if (!(((MbgViewListSheetManager)this.getProvider().getCurMbgSheetManager()).isCanEditOtherAddedBgForm().booleanValue() || StringUtils.isEmpty((String)cellOrgId) || cellOrgId.equals(this.getOrgUnitId()))) {
                return false;
            }
            if (!StringUtils.isEmpty((String)cellOrgId)) {
                return this.getProvider().isCanEditByFormState(cellOrgId);
            }
        }
        return true;
    }

    public class MbgViewlistCombinBizPromptBox
    extends KDBizPromptBox {
        private static final long serialVersionUID = -3312270016353386243L;
        private Cell cell = null;
        boolean isUpdate = false;
        boolean canChangeMember = false;
        boolean isDoChangeEvent = true;

        public Cell getCell() {
            return this.cell;
        }

        public void setCell(Cell cell) {
            this.cell = cell;
        }

        public MbgViewlistCombinBizPromptBox(Cell cell) {
            this.cell = cell;
        }

        public boolean isUpdate() {
            return this.isUpdate;
        }

        public void setUpdate(boolean isUpdate) {
            this.isUpdate = isUpdate;
        }

        public boolean isCanChangeMember() {
            return this.canChangeMember;
        }

        public void setCanChangeMember(boolean canChangeMember) {
            this.canChangeMember = canChangeMember;
        }

        public boolean isDoChangeEvent() {
            return this.isDoChangeEvent;
        }

        public void setDoChangeEvent(boolean isDoChangeEvent) {
            this.isDoChangeEvent = isDoChangeEvent;
        }

        public void setData(Object newdata, boolean postEvent) {
            super.setData(newdata, postEvent);
        }
    }
}

