/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.worktable;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.uiframe.client.IUIManager;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.fi.newrpt.ReportProcessException;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialog;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.mutex.IVOChangeListener;
import com.kingdee.eas.framework.client.mutex.VOChangeEvent;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.client.BgNProcessUI;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.bgworktable.BgFormWorkTableID;
import com.kingdee.eas.ma.mbg.client.worktable.IWorkTableUI;
import com.kingdee.eas.ma.mbg.client.worktable.KDTabbedPaneExt;
import com.kingdee.eas.ma.mbg.client.worktable.KingdeeTabbedPaneExtUI;
import com.kingdee.eas.ma.mbg.client.worktable.MultiRptPropertiesManager;
import com.kingdee.eas.ma.mbg.client.worktable.SingleRptProperties;
import com.kingdee.eas.ma.mbg.client.worktable.WorkTableID;
import com.kingdee.eas.ma.mbg.common.AbstractBookParseHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.provider.AbstractProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class WorkTableProcessUI
extends CoreUI {
    private static final long serialVersionUID = 665231860798258030L;
    public static final String RESOURCE = "com.kingdee.eas.ma.mbg.WorkTableResource";
    public static int TAB_LIMITED = 10;
    public static final String WORKTABLEID_OBJECT = "WORKTABLEID_OBJECT";
    public static final String WORKTABLEID_All = "WORKTABLEID_All";
    public static final String WORKTABLE_PROCESSUI = "WORKTABLE_PROCESSUI";
    public static final String OPEN_UICONTEXT = "OPEN_UICONTEXT";
    protected KDTabbedPaneExt tabpane = null;
    private boolean isOnLoad = false;
    private final MultiRptPropertiesManager manager = new MultiRptPropertiesManager();
    private KDToolBar preOtherToolBar;
    private Component closeBtn;
    private SingleRptProperties curProp = null;

    public WorkTableProcessUI() throws Exception {
        this.tabpane = new KDTabbedPaneExt();
        this.initEventListener();
    }

    public void initUIContentLayout() {
        this.setLayout(new BorderLayout(0, 0));
    }

    public int getRptProSize() {
        if (this.manager != null && this.manager.getBgMultiRptPro() != null) {
            return this.manager.getBgMultiRptPro().size();
        }
        return 0;
    }

    protected WorkTableID getWorkIDFromUiContext() {
        return (WorkTableID)this.getUIContext().get(WORKTABLEID_OBJECT);
    }

    public void onLoad() throws Exception {
        this.initLayout();
        this.getUIContentPane().add((Component)((Object)this.tabpane), "Center");
        this.addNewTab(this.getWorkIDFromUiContext());
        this.initRptSelfProperties(true);
        this.isOnLoad = true;
        WorkTableProcessUI.acquireTabSizeByDB();
    }

    public static Integer acquireTabSizeByDB() throws BOSException {
        IRowSet rst = null;
        try {
            rst = SQLFacadeFactory.getRemoteInstance().getRowset("SELECT FVALUE FROM T_MBG_PARAM where FNUMBER = 'TAB_LIMIT_SIZE'");
            if (rst != null && rst.next()) {
                TAB_LIMITED = Integer.parseInt(rst.getString(1));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (null != rst) {
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        return TAB_LIMITED;
    }

    private void addNewTab(WorkTableID id) throws Exception {
        if (id == null) {
            return;
        }
        this.curProp = this.createNewRptProperties();
        this.curProp.setId(id);
        if (!this.manager.hasRptProperties(this.curProp.getId().getId())) {
            this.manager.putRptPro(this.curProp.getId().getId(), this.curProp);
        }
        this.addNewTab(this.curProp);
    }

    public SingleRptProperties createNewRptProperties() {
        return new SingleRptProperties();
    }

    protected void addNewTab(SingleRptProperties prop) throws Exception {
        this.initProcessUI(prop);
    }

    protected void initProcessUI(SingleRptProperties prop) throws BOSException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"ID", (Object)prop.getId().getId());
        Class<? extends IWorkTableUI> editUiClass = this.getEditUIClass((BgFormWorkTableID)prop.getId());
        try {
            prop.setWorkTableUI(editUiClass.newInstance());
            prop.getWorkTableUI().getUIContext().putAll(uiContext);
            prop.getWorkTableUI().getUIContext().put(WORKTABLE_PROCESSUI, this);
            if (prop.getId().getOprtState() != null) {
                prop.getWorkTableUI().setOprtState(prop.getId().getOprtState());
            } else {
                prop.getWorkTableUI().setOprtState(this.getOprtState());
            }
            prop.getWorkTableUI().initLayout();
            prop.getWorkTableUI().onLoad();
            this.registParentCom((CoreUI)prop.getWorkTableUI());
            this.tabpane.addTab(prop.getTabTitle(), null, prop.getWorkTableUI().getWorkTableComponent(), prop.getTabTitle(), true, prop.getId().getId());
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected abstract Class<? extends IWorkTableUI> getEditUIClass(WorkTableID var1);

    private void initRptSelfProperties(boolean isNewRpt) throws Exception {
        this.curProp = this.manager.getRptProperties(this.tabpane.getSeletedTabCtxId());
        this.setOprtState(this.curProp.getWorkTableUI().getOprtState());
        this.synchrToolBar(this.curProp);
        this.synchrTitle();
        this.synchrCompanent(this.curProp);
        this.setTabColor(this.tabpane.getSelectedIndex());
    }

    protected void synchrCompanent(SingleRptProperties rptpro) {
        this.tabpane.setSelectedComponent(rptpro.getWorkTableUI().getWorkTableComponent());
        ((CoreUI)rptpro.getWorkTableUI()).getActionManager().registerAction("actionExitCurrent", this.getActionManager().getAction("actionExitCurrent"));
    }

    private void synchrToolBar(SingleRptProperties rptpro) {
        KDToolBar toolBar;
        this.setUIMenuBar(rptpro.getWorkTableUI().getUIMenuBar());
        this.setUIToolBar(rptpro.getWorkTableUI().getUIToolBar());
        this.setStatusBar(rptpro.getWorkTableUI().getStatusBar());
        if (this.preOtherToolBar != null) {
            this.remove((Component)this.preOtherToolBar);
        }
        if ((toolBar = rptpro.getWorkTableUI().getOtherToolBar()) != null) {
            this.add((Component)toolBar, "North");
            toolBar.validate();
        }
        this.preOtherToolBar = toolBar;
        this.initCommToolBarManager();
    }

    protected void registParentCom(CoreUI ui) {
        if (ui.getParent() == null) {
            new UINewFrame((IUIObject)ui, (IUIManager)null);
            KDToolBar toolBar = ui.getUIToolBar();
            toolBar.remove(toolBar.countComponents() - 1);
        }
    }

    public void onShow() throws Exception {
        this.closeBtn = (Component)this.getUIContext().get("btnClose");
        if (this.curProp != null && this.curProp.getWorkTableUI() != null) {
            this.curProp.getWorkTableUI().onShow();
        }
    }

    protected void initEventListener() {
        this.tabpane.addCloseActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkTableProcessUI.this.closeTabPane();
            }
        });
        this.tabpane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!WorkTableProcessUI.this.isOnLoad) {
                    return;
                }
                if (WorkTableProcessUI.this.tabpane.getTabCount() > 0 && WorkTableProcessUI.this.manager.hasRptProperties(WorkTableProcessUI.this.tabpane.getSeletedTabCtxId())) {
                    try {
                        WorkTableProcessUI.this.initRptSelfProperties(false);
                    }
                    catch (Exception e1) {
                        WorkTableProcessUI.this.discardFailedTab();
                        WorkTableProcessUI.this.handUIExceptionAndAbort(e1);
                    }
                }
            }
        });
    }

    public void closeTabPane() {
        SingleRptProperties single = this.manager.getRptProperties(this.tabpane.getSeletedTabCtxId());
        String detail = this.manager.getModifyBgCslDetailBySingleRpt(single);
        boolean isClose = true;
        if (!StringUtils.isEmpty((String)detail)) {
            int re = MsgBox.showConfirm3((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (2 == re) {
                isClose = false;
            } else {
                if (0 == re) {
                    ArrayList<SingleRptProperties> singles = new ArrayList<SingleRptProperties>(1);
                    singles.add(single);
                    try {
                        this.saveBgRptBeforeDetroyWindows(singles);
                    }
                    catch (Exception var1) {
                        this.handUIExceptionAndAbort(var1);
                    }
                }
                isClose = true;
            }
        }
        if (isClose) {
            try {
                this.closeReportTab(single);
            }
            catch (Exception e1) {
                this.handUIExceptionAndAbort(e1);
            }
        }
    }

    private void closeReportTab(SingleRptProperties single) throws Exception {
        single.getWorkTableUI().discardAllEdits();
        if (this.check()) {
            this.releaseNetControl(single);
            this.releaseMutexLock(single);
            this.manager.removeRptPro(this.tabpane.getSeletedTabCtxId());
            this.tabpane.removeTabAt(this.tabpane.getSelectedIndex());
            KingdeeTabbedPaneExtUI ui = (KingdeeTabbedPaneExtUI)this.tabpane.getUI();
            ui.getColorMap().clear();
            this.initRptSelfProperties(false);
        }
    }

    private void releaseNetControl(SingleRptProperties rptprop) {
        IVOChangeListener listener = this.getVOChangeListener();
        if (listener != null) {
            VOChangeEvent e = new VOChangeEvent((Object)this);
            if ((IObjectValue)this.getUIContext().get("CURRENT.VO") != null) {
                e.setCurrentObject((IObjectValue)this.getUIContext().get("CURRENT.VO"));
            }
            e.setState("RELEASEALL");
            if (rptprop.getWorkTableUI().getReportID() != null) {
                e.setCurrentObjectId(rptprop.getWorkTableUI().getReportID());
                try {
                    listener.change(e);
                }
                catch (Throwable e1) {
                    this.handUIException(e1);
                    this.abort();
                }
            }
        }
    }

    private void releaseMutexLock(SingleRptProperties single) {
        if (single == null || single.getWorkTableUI() == null) {
            return;
        }
        String requestId = single.getWorkTableUI().getReportID();
        MutexServiceControlFactory.getRemoteInstance().releaseObjIDForUpdate(requestId);
    }

    private boolean check() {
        if (this.curProp != null && this.curProp.getWorkTableUI() != null) {
            return this.curProp.getWorkTableUI().checkBefore();
        }
        return true;
    }

    private void discardFailedTab() {
        if (!this.manager.hasRptProperties(this.tabpane.getSeletedTabCtxId()) && this.tabpane.getSelectedIndex() > 0) {
            this.tabpane.removeTabAt(this.tabpane.getSelectedIndex());
        }
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.manager.size() > 0) {
            int size = this.tabpane.getTabCount();
            ArrayList<SingleRptProperties> bgRpts = new ArrayList<SingleRptProperties>();
            for (int i = size - 1; i >= 0; --i) {
                SingleRptProperties single = this.manager.getRptProperties(this.tabpane.getctxid(i));
                bgRpts.add(single);
            }
            this.saveBgRptBeforeDetroyWindows(bgRpts);
        }
    }

    public static void openReports(CoreUI ownerUi, UIContext uiContext, Class<? extends WorkTableProcessUI> uiClass, List<WorkTableID> ids, String defaultOprtState) throws UIException {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        if (ids.size() > TAB_LIMITED) {
            int re = MsgBox.showConfirm2((Component)ownerUi, (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"checkLimited", (Object[])new Object[]{TAB_LIMITED}));
            if (re == 1 || re == 2) {
                return;
            }
            ids = ids.subList(0, TAB_LIMITED);
        }
        WorkTableProcessUI uiObject = (WorkTableProcessUI)RptNewUIUtil.findUI((UIContext)uiContext, (String)uiClass.getName());
        ArrayList<WorkTableID> allIds = new ArrayList<WorkTableID>(ids);
        uiContext.put((Object)WORKTABLEID_All, allIds);
        if (uiObject == null) {
            uiContext.put((Object)WORKTABLEID_OBJECT, (Object)ids.remove(0));
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClass.getName(), (Map)uiContext, null, defaultOprtState);
            uiObject = (WorkTableProcessUI)window.getUIObject();
            Component cmpClose = uiObject.getUIToolBar().getComponent(uiObject.getUIToolBar().getComponentCount() - 1);
            uiObject.getUIContext().put("btnClose", cmpClose);
        }
        WorkTableProcessUI.openReportUsedExistFrame(ids, uiContext, uiObject, defaultOprtState);
    }

    private static void openReportUsedExistFrame(List<WorkTableID> ids, UIContext uiContext, WorkTableProcessUI uiObject, String defaultOprtState) {
        if (!uiObject.isShowing()) {
            uiObject.getUIWindow().show();
        }
        if (uiObject.getUIWindow() instanceof KDFrame) {
            ((KDFrame)uiObject.getUIWindow()).setExtendedState(6);
        }
        uiObject.requestFocus();
        uiObject.getUIContext().putAll(uiContext);
        uiObject.openReports(ids, defaultOprtState);
    }

    public void openReports(final List<WorkTableID> ids, final String defaultOprtState) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        ProgressDialog dialog = ProgressDialog.createProgressDialog((Component)((Object)this), (boolean)true);
        dialog.run4New(false, true, new IRunnableWithProgress(){
            boolean isGreatestLimited = false;
            int defaultSelectedIndex;
            boolean isSelectedTab;
            {
                this.defaultSelectedIndex = WorkTableProcessUI.this.tabpane.getTabCount() - 1;
                this.isSelectedTab = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) {
                monitor.beginTask(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"36_RptReportProcessNewUI"), -1);
                monitor.setTaskName(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"37_RptReportProcessNewUI"));
                monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"42_RptReportProcessNewUI"));
                String ctxid = null;
                WorkTableID id = null;
                String oprt = null;
                try {
                    for (int i = 0; i < ids.size() && i < TAB_LIMITED; ++i) {
                        id = (WorkTableID)ids.get(i);
                        oprt = id.getOprtState();
                        ctxid = WorkTableProcessUI.this.manager.findReportByID(id.getId());
                        if (!"NOTFOUND".equals(ctxid)) {
                            WorkTableProcessUI.this.tabpane.SetSelectedTab(ctxid);
                            this.isSelectedTab = true;
                            continue;
                        }
                        if (WorkTableProcessUI.this.isGreatestLimited()) {
                            this.isGreatestLimited = true;
                            break;
                        }
                        WorkTableProcessUI.this.getUIContext().put("ID", id.getId());
                        WorkTableProcessUI.this.setOprt(oprt != null ? oprt : defaultOprtState);
                        if (id.getOprtState() == null) {
                            id.setOprtState(defaultOprtState);
                        }
                        WorkTableProcessUI.this.addNewTab(id);
                        WorkTableProcessUI.this.onShow();
                        String name = WorkTableProcessUI.this.curProp.getTabTitle();
                        String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"110_RptReportProcessNewUI");
                        monitor.subTaskBegin(MessageFormat.format(msg, name));
                    }
                    WorkTableProcessUI.this.setTabColor(WorkTableProcessUI.this.tabpane.getSelectedIndex());
                    WorkTableProcessUI.this.tabpane.repaint();
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"41_RptReportProcessNewUI"));
                }
                catch (Exception e) {
                    block8: {
                        try {
                            if (e instanceof NullPointerException) break block8;
                            WorkTableProcessUI.this.handUIExceptionAndAbort(e);
                        }
                        catch (Throwable throwable) {
                            monitor.done();
                            WorkTableProcessUI.this.requestFocus();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (isGreatestLimited) {
                                        WorkTableProcessUI.this.handUIExceptionAndAbort((Exception)new ReportProcessException(ReportProcessException.OPENREPORTLIMITED, new Object[]{TAB_LIMITED}));
                                    } else if (defaultSelectedIndex < 0 || defaultSelectedIndex >= WorkTableProcessUI.this.tabpane.getTabCount() || !isSelectedTab) {
                                        // empty if block
                                    }
                                }
                            });
                            throw throwable;
                        }
                    }
                    monitor.done();
                    WorkTableProcessUI.this.requestFocus();
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                monitor.done();
                WorkTableProcessUI.this.requestFocus();
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private void setOprt(String oprtStatus) {
        this.setOprtState(oprtStatus);
    }

    protected void synchrTitle() {
        this.setUITitle(this.curProp.getWorkTableUI().getUITitle());
    }

    private void setTabColor(int seleted) {
        Color color = new Color(0, 139, 0);
        KingdeeTabbedPaneExtUI ui = (KingdeeTabbedPaneExtUI)this.tabpane.getUI();
        ui.getColorMap().clear();
        for (int i = 0; i < this.tabpane.getTabCount(); ++i) {
            ui.getColorMap().put(i, color);
        }
        color = Color.RED;
        ui.getColorMap().put(seleted, color);
    }

    private void initCommToolBarManager() {
        if (this.closeBtn != null) {
            this.getUIToolBar().add(this.closeBtn);
        }
        KDWorkButton btnSave = (KDWorkButton)this.getUIToolBar().getComponentAtIndex(1);
        Icon icon = btnSave.getIcon();
        boolean isEnable = btnSave.isEnabled();
        String text = btnSave.getText();
        int memmonic = btnSave.getMnemonic();
        short textIconDisStyle = btnSave.getTextIconDisStyle();
        btnSave.setActionCommand("com.kingdee.eas.ma.mbg.client.AbstractBgSpreadViewUI$ActionSave");
        btnSave.setBounds(0, 4, 27, 21);
        btnSave.setIcon(icon);
        btnSave.setEnabled(isEnable);
        btnSave.setText(text);
        btnSave.setMnemonic(memmonic);
        btnSave.setTextIconDisStyle(textIconDisStyle);
    }

    private boolean isGreatestLimited() {
        return this.manager.size() + 1 > TAB_LIMITED;
    }

    public boolean destroyWindow() {
        Map map = this.manager.getAllModifyDetail();
        String detail = (String)map.get("detail");
        if (!StringUtils.isEmpty((String)detail)) {
            int choose = MsgBox.showConfirm4a((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"), (String)detail);
            if (2 == choose) {
                return false;
            }
            if (1 == choose) {
                this.manager.discardAllEdits();
            } else {
                try {
                    List bgRpts = (List)map.get("bgRpts");
                    this.saveBgRptBeforeDetroyWindows(bgRpts);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.manager.discardAllEdits();
            }
        }
        int size = this.tabpane.getTabCount();
        for (int i = size - 1; i >= 0; --i) {
            SingleRptProperties single = this.manager.getRptProperties(this.tabpane.getctxid(i));
            this.releaseNetControl(single);
            this.releaseMutexLock(single);
        }
        this.manager.clearAll();
        ProgressDialogHelper.destroyAllMonitorFromThreadPool();
        return super.destroyWindow();
    }

    public Map<String, String> getPageViewNumber() throws EASBizException, BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        BgSpreadCoreViewUI ui = null;
        AbstractProvider provider = null;
        for (SingleRptProperties prop : this.manager.getBgMultiRptPro().values()) {
            if (prop == null || !(prop.getWorkTableUI() instanceof BgSpreadCoreViewUI)) continue;
            ui = (BgSpreadCoreViewUI)prop.getWorkTableUI();
            provider = (AbstractProvider)ui.getContextManager().getProvider();
            this.collectMember(provider.getBillId(), result, provider.getBookParseHelper().getPagePnlMap(), provider.getSchemeHelper().getAllDimensions());
            this.collectMember(provider.getBillId(), result, provider.getBookParseHelper().getViewPnlMap(), provider.getSchemeHelper().getAllDimensions());
        }
        return result;
    }

    private void collectMember(String billId, Map<String, String> result, Map<Integer, List<KDPanel>> pnlMap, List<BgDimensionInfo> dimesions) {
        if (pnlMap == null || pnlMap.isEmpty()) {
            return;
        }
        List members = null;
        for (Integer sheetIndex : pnlMap.keySet()) {
            members = BgViewHelper.getCurrPageMember(AbstractBookParseHelper.getF7List(sheetIndex, pnlMap), dimesions);
            if (members == null || members.isEmpty()) continue;
            for (BgDimensionMember m : members) {
                result.put(WorkTableProcessUI.getNumberKey(billId, sheetIndex, m.getType()), m.getNumber());
            }
        }
    }

    public static String getNumberKey(String id, int sheetIndex, String dimNumber) {
        return BgNFSHelper.getNumberKey(id, sheetIndex, dimNumber);
    }

    private void saveBgRptBeforeDetroyWindows(List<SingleRptProperties> bgRpts) throws Exception {
        for (SingleRptProperties pro : bgRpts) {
            IWorkTableUI processui = pro.getWorkTableUI();
            if (processui instanceof BgNProcessUI) {
                ((BgNProcessUI)((Object)processui)).actionSave_actionPerformed(new ActionEvent(((BgNProcessUI)((Object)processui)).getUIToolBar().getComponent(1), 1001, "com.kingdee.eas.fi.newrpt.client.designer.AbstractReportDesignerUI$actionSave", 16));
                continue;
            }
            if (!(processui instanceof BgSpreadCoreViewUI)) continue;
            ((BgSpreadCoreViewUI)processui).actionSave_actionPerformed(new ActionEvent(((BgSpreadCoreViewUI)processui).getUIToolBar().getComponent(1), 1001, "com.kingdee.eas.ma.mbg.client.AbstractBgSpreadViewUI$ActionSave", 16));
        }
    }

    public void paint(Graphics g) {
        SingleRptProperties currentProp = this.manager.getRptProperties(this.tabpane.getSeletedTabCtxId());
        if (currentProp != null && currentProp.getWorkTableUI() != null) {
            if (currentProp.getWorkTableUI() instanceof BgSpreadCoreViewUI && ((BgSpreadCoreViewUI)currentProp.getWorkTableUI()).getChatGptUI() != null) {
                ((BgSpreadCoreViewUI)currentProp.getWorkTableUI()).paintChatGptUI(g);
            } else if (currentProp.getWorkTableUI() instanceof BgNProcessUI && ((BgNProcessUI)((Object)currentProp.getWorkTableUI())).getChatGptUI() != null) {
                ((BgNProcessUI)((Object)currentProp.getWorkTableUI())).paintChatGptUI(g);
            }
        }
        super.paint(g);
    }

    public CoreUI getCurrentProcessUI() {
        IGetSchemeHelper coreUI = null;
        SingleRptProperties currentProp = this.manager.getRptProperties(this.tabpane.getSeletedTabCtxId());
        if (currentProp != null && currentProp.getWorkTableUI() != null) {
            if (currentProp.getWorkTableUI() instanceof BgSpreadCoreViewUI) {
                coreUI = (BgSpreadCoreViewUI)currentProp.getWorkTableUI();
            } else if (currentProp.getWorkTableUI() instanceof BgNProcessUI) {
                coreUI = (BgNProcessUI)((Object)currentProp.getWorkTableUI());
            }
        }
        return coreUI;
    }
}

