/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.ma.biz.BizCalcCollection;
import com.kingdee.eas.ma.biz.BizCalcFactory;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizRefBgTemplateCollection;
import com.kingdee.eas.ma.biz.BizRefBgTemplateFactory;
import com.kingdee.eas.ma.biz.BizRefBgTemplateInfo;
import com.kingdee.eas.ma.biz.BizRelyCollection;
import com.kingdee.eas.ma.biz.BizRelyFactory;
import com.kingdee.eas.ma.biz.BizRelyInfo;
import com.kingdee.eas.ma.biz.IBizCalc;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.common.AbstractBgSchemeCopy;
import com.kingdee.eas.ma.mbg.common.BgCopySchemeParam;
import com.kingdee.eas.ma.mbg.common.BgCopySchemeResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class BgBizCopy
extends AbstractBgSchemeCopy {
    public BgBizCopy(BgCopySchemeParam param, BgSchemeInfo scheme, boolean isAddScheme, Context ctx, BgSchemeInfo target) {
        super(param, scheme, isAddScheme, ctx, target);
    }

    @Override
    public boolean isCopy(BgCopySchemeParam param) {
        return param.isCopyBiz() && this.getScheme() != null && this.getTarget() != null;
    }

    @Override
    protected List<BgCopySchemeResult> dealCopyByParam() throws Exception {
        ArrayList<BgCopySchemeResult> result = new ArrayList<BgCopySchemeResult>();
        BgSchemeInfo sourceScheme = this.getScheme();
        String sourceSchemeId = sourceScheme.getId().toString();
        BgSchemeInfo targetScheme = this.getTarget();
        String tarSchmemId = targetScheme.getId().toString();
        String targetOrgId = targetScheme.getOrgUnit().getId().toString();
        LinkedHashMap<String, BizCalcInfo> calcMap = new LinkedHashMap<String, BizCalcInfo>();
        HashMap<String, BgTemplateCollection> refBgTempMap = new HashMap<String, BgTemplateCollection>();
        HashMap relyMap = new HashMap();
        IBizCalc localInstance = BizCalcFactory.getLocalInstance((Context)this.ctx);
        BizCalcCollection bizCalcCollection = this.getBizColl(localInstance, sourceSchemeId);
        HashSet<String> calcIdSet = new HashSet<String>();
        for (int i = 0; i < bizCalcCollection.size(); ++i) {
            BizCalcInfo bizCalcInfo = bizCalcCollection.get(i);
            String bizCalcId = bizCalcInfo.getId().toString();
            calcIdSet.add(bizCalcId);
            calcMap.put(bizCalcId, bizCalcInfo);
        }
        BizRefBgTemplateCollection bizRefBgTemplateCollection = this.getTemplates(calcIdSet);
        for (int i = 0; i < bizRefBgTemplateCollection.size(); ++i) {
            BizRefBgTemplateInfo bizRefBgTemplateInfo = bizRefBgTemplateCollection.get(i);
            String bizCalcId = bizRefBgTemplateInfo.getBizCalc().getId().toString();
            BgTemplateInfo bgTemplate = bizRefBgTemplateInfo.getBgTemplate();
            if (!refBgTempMap.containsKey(bizCalcId)) {
                refBgTempMap.put(bizCalcId, new BgTemplateCollection());
            }
            ((BgTemplateCollection)((Object)refBgTempMap.get(bizCalcId))).add(bgTemplate);
        }
        BizRelyCollection relyColl = this.getRelyColl(calcIdSet);
        for (int i = 0; i < relyColl.size(); ++i) {
            BizRelyInfo bizRelyInfo = relyColl.get(i);
            String bizCalcId = bizRelyInfo.getBizCalc().getId().toString();
            if (!relyMap.containsKey(bizCalcId)) {
                relyMap.put(bizCalcId, new ArrayList());
            }
            ((List)relyMap.get(bizCalcId)).add(bizRelyInfo.getRelyBiz());
        }
        List importCalc = localInstance.importCalc(tarSchmemId, targetOrgId, calcMap, refBgTempMap, relyMap);
        if (importCalc != null) {
            result.addAll(importCalc);
        }
        return result;
    }

    private BizRefBgTemplateCollection getTemplates(Set<String> calcIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectorsTemp());
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getFilter().getFilterItems().add(new FilterItemInfo("bizCalc.id", calcIdSet, CompareType.INCLUDE));
        BizRefBgTemplateCollection bizRefBgTemplateCollection = BizRefBgTemplateFactory.getLocalInstance((Context)this.ctx).getBizRefBgTemplateCollection(view);
        return bizRefBgTemplateCollection;
    }

    private BizCalcCollection getBizColl(IBizCalc localInstance, String tarSchmemId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectors());
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)tarSchmemId));
        view.getFilter().getFilterItems().add(new FilterItemInfo("state", (Object)2));
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgTree.id", null));
        BizCalcCollection bizCalcCollection = localInstance.getBizCalcCollection(view);
        return bizCalcCollection;
    }

    private BizRelyCollection getRelyColl(Set<String> calcIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectorsRely());
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getFilter().getFilterItems().add(new FilterItemInfo("bizCalc.id", calcIdSet, CompareType.INCLUDE));
        BizRelyCollection bizRelyCollection = BizRelyFactory.getLocalInstance((Context)this.ctx).getBizRelyCollection(view);
        return bizRelyCollection;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("creator.id");
        sic.add("createTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateTime");
        sic.add("CU.id");
        sic.add("orgUnit.*");
        sic.add("bgScheme.*");
        sic.add("bizCalcSubSet.*");
        sic.add("bizCalcSubSet.scope.*");
        sic.add("bizCalcGroup.*");
        sic.add("orgTree.*");
        return sic;
    }

    public SelectorItemCollection getSelectorsTemp() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("bizCalc.*");
        sic.add("bgTemplate.*");
        return sic;
    }

    public SelectorItemCollection getSelectorsRely() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("bizCalc.*");
        sic.add("relyBiz.*");
        return sic;
    }
}

