/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgItemCollection;
import com.kingdee.eas.ma.base.BgItemInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.utils.BgElementCollObject;
import com.kingdee.eas.ma.mbg.DimensionDisplayModeEnum;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgItemViewObject;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BgDimensionBaseInfo
implements Serializable,
Cloneable {
    private IBgDimensionManagerBase dimensionManager;
    private static final long serialVersionUID = -7474751634701106168L;
    public static final String DISPLAY_NAME = "NAME";
    public static final String DISPLAY_NUMBER = "NUMBER";
    public static final String DISPLAY_NUMBER_NAME = "NAMEANDNUMBER";
    public static final String DISPLAY_ALIAS = "ALIAS";
    public static final String DISPLAY_SIMPLE_NAME = "SIMPLENAME";
    public static final String DISPLAY_LONGNAME = "LONGNAME";
    private String type = null;
    private String value = null;
    private String layout = null;
    private String showType = "NAME";
    private boolean rowAddMember = false;
    private String canAddValue = null;
    private int index = -1;
    private String number = null;
    private String name = null;
    private String alias = null;
    private String simpleName = null;
    private boolean necessary = false;
    private String attribute = null;
    private boolean subTotal = false;
    private boolean dimTotal = false;
    private boolean show = true;
    private boolean dinamicAdd = false;
    private boolean isSelectRelationship = false;
    private int periodDisplayStyle = 1;
    private BgDimensionMember defaultMember = null;
    private String viewId = null;
    private DimensionMemberValueModeEnum memberValueType = DimensionMemberValueModeEnum.Null;
    private BgPeriodTypeInfo bgPeriodType = null;
    private final List member = new ArrayList();
    private final List canAddMember = new ArrayList();
    private List<DimensionRelationshipGroupInfo> mappingList = new ArrayList<DimensionRelationshipGroupInfo>();

    public BgDimensionBaseInfo(IBgDimensionManagerBase dimenManager) {
        this.dimensionManager = dimenManager;
    }

    public IBgDimensionManagerBase getDimensionManager() {
        return this.dimensionManager;
    }

    public void setDimensionManager(IBgDimensionManagerBase dimensionManager) {
        this.dimensionManager = dimensionManager;
    }

    public BgDimensionMember getDefaultMember() {
        return this.defaultMember;
    }

    public void setDefaultMember(BgDimensionMember defaultMember) {
        this.defaultMember = defaultMember;
    }

    public BgPeriodTypeInfo getBgPeriodType() {
        return this.bgPeriodType;
    }

    public void setBgPeriodType(BgPeriodTypeInfo bgPeriodType) {
        this.bgPeriodType = bgPeriodType;
    }

    public void setMember(List member) {
        if (member != null && member.size() != 0) {
            this.member.addAll(member);
        }
    }

    public String getShowType() {
        return this.showType;
    }

    public void setShowType(String showType) {
        if (!StringUtils.isEmpty((String)showType)) {
            this.showType = showType;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getCanAddValue() {
        return this.canAddValue;
    }

    public void setCanAddValue(String canAddValue) {
        this.canAddValue = canAddValue;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public String getRefField() {
        return this.attribute;
    }

    public String getAttribute() {
        if (MBGLayoutConstants.BG_ORGANIZATION.equals(this.getNumber())) {
            return "F-4";
        }
        if (MBGLayoutConstants.BG_CURRENCY.equals(this.getNumber())) {
            return "F-3";
        }
        if (MBGLayoutConstants.BG_ELEMENT.equals(this.getNumber())) {
            return "F-2";
        }
        if (MBGLayoutConstants.BG_PERIOD.equals(this.getNumber())) {
            return "F-1";
        }
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public boolean isRowAddMember() {
        return this.rowAddMember;
    }

    public void setRowAddMember(boolean rowAddMember) {
        this.rowAddMember = rowAddMember;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public List getMember() {
        return this.member;
    }

    public List getCanAddMember() {
        return this.canAddMember;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public boolean isNecessary() {
        return this.necessary;
    }

    public void setNecessary(boolean necessary) {
        this.necessary = necessary;
    }

    public boolean isSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(boolean subTotal) {
        this.subTotal = subTotal;
    }

    public boolean isDimTotal() {
        return this.dimTotal;
    }

    public void setDimTotal(boolean dimTotal) {
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    public boolean isDinamicAdd() {
        return this.dinamicAdd;
    }

    public void setDinamicAdd(boolean dinamicAdd) {
        this.dinamicAdd = dinamicAdd;
    }

    public DimensionMemberValueModeEnum getMemberValueType() {
        return this.memberValueType;
    }

    public boolean isMapping() {
        return DimensionMemberValueModeEnum.RelationMapping.equals((Object)this.getMemberValueType());
    }

    public void setMemberValueType(DimensionMemberValueModeEnum memberValueType) {
        this.memberValueType = memberValueType;
    }

    public List<DimensionRelationshipGroupInfo> getMappingList() {
        return this.mappingList;
    }

    public int getPeriodDisplayStyle() {
        return this.periodDisplayStyle;
    }

    public void setPeriodDisplayStyle(int periodDisplayStyle) {
        this.periodDisplayStyle = periodDisplayStyle;
    }

    public DimensionDisplayModeEnum getShowTypeEnum() {
        if (DISPLAY_NAME.equals(this.getShowType())) {
            return DimensionDisplayModeEnum.Name;
        }
        if (DISPLAY_NUMBER.equals(this.getShowType())) {
            return DimensionDisplayModeEnum.Number;
        }
        if (DISPLAY_NUMBER_NAME.equals(this.getShowType())) {
            return DimensionDisplayModeEnum.NumberAndName;
        }
        if (DISPLAY_SIMPLE_NAME.equals(this.getShowType())) {
            return DimensionDisplayModeEnum.SimpleName;
        }
        if (DISPLAY_LONGNAME.equals(this.getShowType())) {
            return DimensionDisplayModeEnum.LongName;
        }
        return DimensionDisplayModeEnum.Name;
    }

    public String getAttributeNumber() {
        if (!StringUtils.isEmpty((String)this.attribute)) {
            if (this.attribute.indexOf(",") > 0) {
                return this.attribute.split(",")[0];
            }
            return this.attribute;
        }
        if ("ORGUNIT".equals(this.getType())) {
            return "ORGUNIT";
        }
        return null;
    }

    public String getAttributeName() {
        if (!StringUtils.isEmpty((String)this.attribute) && "BGITEM".equals(this.getType()) && this.attribute.indexOf(",") > 1) {
            return this.attribute.split(",")[1];
        }
        return "";
    }

    public BgDimensionBaseInfo cloneValue() {
        return this.cloneValue(null);
    }

    public BgDimensionBaseInfo cloneValue(BgDimensionBaseInfo dimension) {
        if (dimension == null) {
            dimension = this.createNewInstance();
        }
        dimension.setType(this.getType());
        dimension.setName(this.getName());
        dimension.setNumber(this.getNumber());
        dimension.setAlias(this.getAlias());
        dimension.setValue(this.getValue());
        dimension.setAttribute(this.getAttribute());
        dimension.setLayout(this.getLayout());
        return dimension;
    }

    protected abstract BgDimensionBaseInfo createNewInstance();

    public BgDimensionBaseInfo clone() {
        int i;
        BgDimensionBaseInfo clone = this.cloneValue();
        BgDimensionMember member = null;
        BgDimensionMember selectMember = null;
        int in = this.getMember().size();
        for (i = 0; i < in; ++i) {
            member = (BgDimensionMember)this.getMember().get(i);
            try {
                clone.getMember().add(member.clone());
                continue;
            }
            catch (CloneNotSupportedException e) {
                e.getStackTrace();
                SysUtil.abort();
            }
        }
        try {
            in = this.getSelectMembers().size();
            for (i = 0; i < in; ++i) {
                Object obj = this.getSelectMembers().get(i);
                if (obj instanceof BgDimensionMember) {
                    selectMember = (BgDimensionMember)obj;
                    clone.getSelectMembers().add(selectMember.clone());
                    continue;
                }
                if (obj instanceof CoreBaseInfo) {
                    CoreBaseInfo se = (CoreBaseInfo)obj;
                    clone.getSelectMembers().add(se.clone());
                    continue;
                }
                clone.getSelectMembers().addAll(this.getSelectMembers());
            }
        }
        catch (CloneNotSupportedException e) {
            e.getStackTrace();
            SysUtil.abort();
        }
        return clone;
    }

    public void parseMappingList(String value) {
        String[] relations;
        this.getMappingList().clear();
        if (!StringUtils.isEmpty((String)value) && (relations = value.split("\\|")) != null) {
            for (int i = 0; i < relations.length; ++i) {
                DimensionRelationshipGroupInfo relationShipGroup = new DimensionRelationshipGroupInfo();
                try {
                    relationShipGroup.setId(BOSUuid.read((String)relations[i]));
                    this.getMappingList().add(relationShipGroup);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String unParseMappingList() {
        StringBuilder builder = new StringBuilder();
        if (this.getMappingList() != null) {
            for (int i = 0; i < this.getMappingList().size(); ++i) {
                if (this.getMappingList().get(i).getId() == null) continue;
                builder.append(this.getMappingList().get(i).getId().toString());
                builder.append("|");
            }
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public void parse() {
        this.parseMember(this.getMember(), this.getValue());
        if (!(MBGLayoutConstants.BG_PERIOD.equalsIgnoreCase(this.getNumber()) || MBGLayoutConstants.BG_INDEX.equalsIgnoreCase(this.getNumber()) || "BG_Index".equalsIgnoreCase(this.getNumber()) || MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(this.getNumber()))) {
            this.sortMember();
        }
    }

    protected void parseMember(List memberList, String value) {
        String[] members;
        memberList.clear();
        if (!StringUtils.isEmpty((String)value) && (members = value.split("\\|")) != null) {
            String _tmpStr2 = null;
            BgDimensionMember member = null;
            for (String _tmpStr2 : members) {
                if (StringUtils.isEmpty((String)_tmpStr2)) continue;
                String[] _tmp = this.split(_tmpStr2);
                member = new BgDimensionMember(this.getType(), this.getAttribute(), null, null);
                member.setType(this.getNumber());
                member.setAttribute(this.getAttribute());
                if (_tmp.length == 1 && "BGPERIOD".equals(this.getType()) && this.getValue().contains("!")) {
                    member.setNumber(_tmp[0]);
                    member.setName(_tmp[0]);
                } else {
                    member.setNumber(_tmp[0]);
                    member.setName(_tmp[1]);
                }
                if (_tmp.length >= 3 && Integer.parseInt(_tmp[2]) == 1) {
                    member.setAllowEdit(true);
                }
                if (_tmp.length >= 4) {
                    member.setVersion(new BigDecimal(_tmp[3]));
                }
                if (_tmp.length >= 5) {
                    member.setFillType(new Integer(_tmp[4]));
                }
                if (_tmp.length >= 6) {
                    member.setSrcNumber(StringUtils.isEmpty((String)_tmp[5]) ? null : _tmp[5]);
                }
                if (_tmp.length >= 7) {
                    member.setAlias(StringUtils.isEmpty((String)_tmp[6]) ? null : _tmp[6]);
                }
                memberList.add(member);
            }
        }
    }

    private String[] split(String _tmpStr) {
        String[] _tmp = _tmpStr.split(",");
        if (_tmpStr.endsWith(",")) {
            String[] t = new String[_tmp.length + 1];
            System.arraycopy(_tmp, 0, t, 0, _tmp.length);
            _tmp = t;
        }
        if (_tmp.length > 6 && !DimensionConstants.DEF_PERIOD_NUMBER.equals(this.getNumber())) {
            String[] res = new String[6];
            for (int i = 0; i < res.length; ++i) {
                if (i == 0) {
                    res[i] = _tmp[i];
                    continue;
                }
                if (i == 1) {
                    StringBuffer s = new StringBuffer();
                    for (int r = i; r <= _tmp.length - res.length + i; ++r) {
                        if (s.length() > 0) {
                            s.append(",");
                        }
                        s.append(_tmp[r]);
                    }
                    res[i] = s.toString();
                    continue;
                }
                res[i] = _tmp[i + _tmp.length - res.length];
            }
            return res;
        }
        return _tmp;
    }

    public String unParseMember() throws DimensionException {
        if (!(DimensionMemberValueModeEnum.Manual.equals((Object)this.getMemberValueType()) || DimensionMemberValueModeEnum.Null.equals((Object)this.getMemberValueType()) || DimensionMemberValueModeEnum.SelectMember.equals((Object)this.getMemberValueType()))) {
            return "";
        }
        return this.buildMemberString(this.getMember());
    }

    public String upParseCanAddMember() throws DimensionException {
        if (this.isDinamicAdd()) {
            return this.buildMemberString(this.getCanAddMember());
        }
        return "";
    }

    protected String buildMemberString(List memberList) throws DimensionException {
        if (memberList == null || memberList.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < memberList.size(); ++i) {
            BgDimensionMember member = (BgDimensionMember)memberList.get(i);
            if (member.isFilled()) continue;
            this.checkNumber(member.getNumber());
            this.checkName(member.getName());
            builder.append(member.getNumber());
            builder.append(",");
            builder.append(member.getName());
            builder.append(",");
            if (member.isAllowEdit()) {
                builder.append("1");
            } else {
                builder.append("0");
            }
            builder.append(",");
            builder.append(member.getVersion());
            builder.append(",");
            builder.append(member.getFillType());
            builder.append(",");
            builder.append(member.getSrcNumber() == null ? "" : member.getSrcNumber());
            if (DimensionConstants.DEF_PERIOD_NUMBER.equals(this.getNumber())) {
                builder.append(",");
                builder.append(member.getAlias() == null ? "" : member.getAlias());
            }
            builder.append("|");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private void checkNumber(String str) throws DimensionException {
        if (str != null && (str.indexOf(",") >= 0 || str.indexOf("|") >= 0)) {
            throw new DimensionException(DimensionException.NUMBERERROR, new Object[]{str});
        }
    }

    private void checkName(String str) throws DimensionException {
        if (str != null && str.indexOf("|") >= 0) {
            throw new DimensionException(DimensionException.NUMBERERROR, new Object[]{str});
        }
    }

    public void unParseBgPeriod() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.getMember().size(); ++i) {
            BgDimensionMember member = (BgDimensionMember)this.getMember().get(i);
            builder.append(member.getNumber());
            builder.append(",");
            builder.append(member.getName());
            builder.append("|");
        }
        builder.deleteCharAt(builder.length() - 1);
        this.setValue(builder.toString());
    }

    public void sortMember() {
        Collections.sort(this.getMember());
    }

    public Object unParse() {
        if (StringUtils.isEmpty((String)this.getValue())) {
            return null;
        }
        String[] values = this.getValue().split("\\|");
        String type = this.getType();
        if ("BGITEM".equals(type)) {
            BgItemCollection itemConn = new BgItemCollection();
            for (int n = 0; n < values.length; ++n) {
                String[] child = values[n].split(",");
                BgItemInfo itemInfo = new BgItemInfo();
                itemInfo.setNumber(child[0]);
                itemInfo.setName(child[1]);
                itemConn.add(itemInfo);
            }
            return new BgItemViewObject(itemConn);
        }
        if ("BGELEMENT".equals(type)) {
            BgElementCollection bgEleColl = new BgElementCollection();
            for (int n = 0; n < values.length; ++n) {
                String[] child = values[n].split(",");
                BgElementInfo info = new BgElementInfo();
                info.setNumber(child[0]);
                info.setName(child[1]);
                bgEleColl.add(info);
            }
            return new BgElementCollObject(bgEleColl);
        }
        if ("BGPERIOD".equals(type)) {
            if (this.getValue().contains("!")) {
                ArrayList<String> list = new ArrayList<String>();
                for (int n = 0; n < values.length; ++n) {
                    list.add(values[n]);
                }
                return list;
            }
            BgPeriodInfo[] period = new BgPeriodInfo[values.length];
            for (int index = 0; index < values.length; ++index) {
                String[] child = values[index].split(",");
                BgPeriodInfo periodInfo = new BgPeriodInfo();
                periodInfo.setNumber(child[0]);
                periodInfo.setName(child[1]);
                period[index] = periodInfo;
            }
            return period;
        }
        if (!"ORGUNIT".equals(type) && "CURRENCY".equals(type)) {
            String[] child = values[0].split(",");
            CurrencyInfo info = new CurrencyInfo();
            info.setNumber(child[0]);
            info.setName(child[1]);
            return info;
        }
        return null;
    }

    public String getMemberNames() {
        String value = "";
        if (this.getMember() != null && this.getMember().size() > 0) {
            for (int i = 0; i < this.getMember().size(); ++i) {
                value = value + ((BgDimensionMember)this.getMember().get(i)).getName();
                value = value + ",";
            }
        }
        if (value.length() > 0) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public String toString() {
        return "number=" + this.number + ", value=" + this.value + ", attribute=" + this.attribute;
    }

    public boolean isSelectRelationship() {
        return this.isSelectRelationship;
    }

    public void setSelectRelationship(boolean isSelectRelationship) {
        this.isSelectRelationship = isSelectRelationship;
    }

    public List getSelectMembers() {
        return this.member;
    }

    public Map<String, Set<String>> getFilterMap(List members, BgSchemeDimensionHelper schemeHelper, Map<String, Set<String>> filterValueMap) throws EASBizException, BOSException {
        if (filterValueMap == null) {
            filterValueMap = new HashMap<String, Set<String>>();
        }
        HashSet<String> subSet = new HashSet<String>();
        String srcNumber = schemeHelper.getSrcNumber(this.getNumber());
        if (!filterValueMap.containsKey(srcNumber)) {
            filterValueMap.put(srcNumber, subSet);
        }
        for (int i = 0; i < members.size(); ++i) {
            subSet.add(BgViewHelper.getNumber(members.get(i)));
        }
        return filterValueMap;
    }
}

