/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.ma.mbg.BgExamineCollection;
import com.kingdee.eas.ma.mbg.BgExamineFactory;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgExamineRefBgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgExamineRefBgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgExamineRefBgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgExamine;
import com.kingdee.eas.ma.mbg.common.AbstractBgSchemeCopy;
import com.kingdee.eas.ma.mbg.common.BgCopySchemeParam;
import com.kingdee.eas.ma.mbg.common.BgCopySchemeResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class BgExamineCopy
extends AbstractBgSchemeCopy {
    public BgExamineCopy(BgCopySchemeParam param, BgSchemeInfo scheme, boolean isAddScheme, Context ctx, BgSchemeInfo target) {
        super(param, scheme, isAddScheme, ctx, target);
    }

    @Override
    public boolean isCopy(BgCopySchemeParam param) {
        return param.isCopyExamine() && this.getScheme() != null && this.getTarget() != null;
    }

    @Override
    protected List<BgCopySchemeResult> dealCopyByParam() throws Exception {
        ArrayList<BgCopySchemeResult> result = new ArrayList<BgCopySchemeResult>();
        BgSchemeInfo sourceScheme = this.getScheme();
        String sourceSchemeId = sourceScheme.getId().toString();
        BgSchemeInfo targetScheme = this.getTarget();
        String tarSchmemId = targetScheme.getId().toString();
        String targetOrgId = targetScheme.getOrgUnit().getId().toString();
        LinkedHashMap<String, BgExamineInfo> bgExamineMap = new LinkedHashMap<String, BgExamineInfo>();
        HashMap<String, BgTemplateCollection> refBgTempMap = new HashMap<String, BgTemplateCollection>();
        IBgExamine localInstance = BgExamineFactory.getLocalInstance(this.ctx);
        BgExamineCollection bgExamineCollection = this.getBgExamineColl(localInstance, sourceSchemeId);
        HashSet<String> examineIds = new HashSet<String>();
        for (int i = 0; i < bgExamineCollection.size(); ++i) {
            BgExamineInfo bgExamineInfo = bgExamineCollection.get(i);
            String bgExaminId = bgExamineInfo.getId().toString();
            examineIds.add(bgExaminId);
            bgExamineMap.put(bgExaminId, bgExamineInfo);
        }
        BgExamineRefBgTemplateCollection refBgTemplateCollection = this.getTemplates(examineIds);
        for (int i = 0; i < refBgTemplateCollection.size(); ++i) {
            BgExamineRefBgTemplateInfo refBgTemplateInfo = refBgTemplateCollection.get(i);
            String bizExamineId = refBgTemplateInfo.getBgExamine().getId().toString();
            BgTemplateInfo bgTemplate = refBgTemplateInfo.getBgTemplate();
            if (!refBgTempMap.containsKey(bizExamineId)) {
                refBgTempMap.put(bizExamineId, new BgTemplateCollection());
            }
            ((BgTemplateCollection)((Object)refBgTempMap.get(bizExamineId))).add(bgTemplate);
        }
        List list = localInstance.importExamineSchemeCopy(tarSchmemId, targetOrgId, bgExamineMap, refBgTempMap);
        if (list != null) {
            result.addAll(list);
        }
        return result;
    }

    private BgExamineRefBgTemplateCollection getTemplates(Set<String> calcIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectorsTemp());
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgExamine.id", calcIdSet, CompareType.INCLUDE));
        BgExamineRefBgTemplateCollection coll = BgExamineRefBgTemplateFactory.getLocalInstance(this.ctx).getBgExamineRefBgTemplateCollection(view);
        return coll;
    }

    public SelectorItemCollection getSelectorsTemp() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("bgExamine.*");
        sic.add("bgTemplate.*");
        return sic;
    }

    private BgExamineCollection getBgExamineColl(IBgExamine localInstance, String sourceSchemeId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectors());
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)sourceSchemeId));
        view.getFilter().getFilterItems().add(new FilterItemInfo("state", (Object)1));
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgTree.id", null));
        BgExamineCollection coll = localInstance.getBgExamineCollection(view);
        return coll;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("creator.id");
        sic.add("createTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateTime");
        sic.add("CU.id");
        sic.add("orgUnit.*");
        sic.add("bgScheme.*");
        sic.add("bgExamineSubset.*");
        sic.add("bgExamineSubset.scope.*");
        sic.add("bgExamineGroup.*");
        return sic;
    }
}

