/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import java.util.BitSet;

public class BgSheetRange {
    private Sheet sheet;
    private BitSet flags;
    private int rowCount;
    private int colCount;

    public BgSheetRange(Sheet sheet) {
        this.sheet = sheet;
        this.rowCount = sheet.getMaxRowIndex() + 2;
        this.colCount = sheet.getMaxColIndex() + 2;
        this.flags = new BitSet(this.rowCount * this.colCount / 2);
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void addCell(int row, int col) {
        this.flags.set(this.calIndex(row, col));
    }

    public void setFlag(BitSet flags, int row, int col, boolean flag) {
        flags.set(this.calIndex(row, col), flag);
    }

    private void setFlag(BitSet flags, int row, int col, int row1, int col1, boolean flag) {
        for (int r = row; r <= row1; ++r) {
            for (int c = col; c <= col1; ++c) {
                flags.set(this.calIndex(r, c), flag);
            }
        }
    }

    public boolean isFlag(int row, int col) {
        return this.isFlag(this.flags, row, col);
    }

    public boolean isFlag(BitSet flags, int row, int col) {
        return flags.get(this.calIndex(row, col));
    }

    public int calIndex(int row, int col) {
        return row * this.colCount + col;
    }

    public Range getRange() {
        BitSet backup = (BitSet)this.flags.clone();
        Range result = null;
        block0: for (int r = 0; r < this.rowCount; ++r) {
            int startCol = 0;
            while (startCol < this.colCount) {
                int col1 = -1;
                int row1 = -1;
                int col = -1;
                int row = -1;
                for (int c = startCol; c < this.colCount; ++c) {
                    if (!this.isFlag(backup, r, c)) continue;
                    row = r;
                    col = c;
                    break;
                }
                if (row < 0) continue block0;
                col1 = this.findMaxCol(backup, col, r);
                row1 = this.findMaxRow(backup, row, col, col1);
                this.setFlag(backup, row, col, row1, col1, false);
                result = this.addRange(result, row, col, row1, col1);
                startCol = col1 + 1;
            }
        }
        System.out.println(result);
        return result;
    }

    private int findMaxRow(BitSet backup, int row, int col, int col1) {
        int row1;
        for (row1 = row; row1 < this.rowCount; ++row1) {
            for (int c = col; c <= col1; ++c) {
                if (this.isFlag(backup, row1 + 1, c)) continue;
                return row1;
            }
        }
        return row1;
    }

    private int findMaxCol(BitSet backup, int col, int r) {
        int col1;
        for (col1 = col; col1 < this.colCount; ++col1) {
            if (this.isFlag(backup, r, col1 + 1)) continue;
            return col1;
        }
        return col1;
    }

    public static Range addRange(Range target, Range source) {
        if (target == null) {
            return source;
        }
        target.addAll((SortedCellBlockArray)source);
        return target;
    }

    public Range addRange(Range range, int row, int col, int row1, int col1) {
        Range r = this.sheet.getRange(row, col, row1, col1);
        return BgSheetRange.addRange(range, r);
    }
}

