/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.mbg.common.AbstractBookParseHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgDimensionParseCommonHelper;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBookDimensionParse;
import com.kingdee.eas.ma.mbg.common.LineFlowLayout;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;

public abstract class BookDimensionParseBase
implements IBookDimensionParse {
    @Override
    public Component parsePageBgDimension(IUIObject owner, String orgUnitId, String orgViewId, IBgDimensionManager bgDimensionManager, boolean isEnable, List f7List, String permissionNumber) {
        KDPanel page = new KDPanel();
        page.setLayout((LayoutManager)new LineFlowLayout(0));
        page.setEnabled(isEnable);
        BgDimensionInfo dimensionInfo = null;
        int in = bgDimensionManager.getPageDisplayDimension().size();
        for (int i = 0; i < in; ++i) {
            dimensionInfo = (BgDimensionInfo)bgDimensionManager.getPageDisplayDimension().get(i);
            if ("orgunit".equalsIgnoreCase(dimensionInfo.getType())) {
                this.parseOrgUnitDimension(owner, page, orgViewId, dimensionInfo, isEnable, f7List, permissionNumber);
                continue;
            }
            if ("bgitem".equalsIgnoreCase(dimensionInfo.getType())) {
                this.parseBgItemDimension(owner, page, orgUnitId, dimensionInfo, isEnable, f7List);
                continue;
            }
            if ("bgperiod".equalsIgnoreCase(dimensionInfo.getType())) {
                this.parseBgPeriodDimension(owner, page, dimensionInfo, isEnable, f7List);
                continue;
            }
            if ("bgelement".equalsIgnoreCase(dimensionInfo.getType())) {
                this.parseBgElementDimension(owner, page, dimensionInfo, isEnable, f7List);
                continue;
            }
            if (!"currency".equalsIgnoreCase(dimensionInfo.getType())) continue;
            this.parseCurrencyDimension(owner, page, dimensionInfo, false, f7List);
        }
        this.afterParsePageBgDimension(owner);
        return page;
    }

    protected void afterParsePageBgDimension(IUIObject owner) {
    }

    @Override
    public KDPromptBox getDimensionF7(AbstractBookParseHelper bookParseHelper, CoreUIObject ownerUI, String orgUnitId, String unionGroupId, BgDimensionBaseInfo dimensionInfo, boolean isEnable, String permissionNumber) throws Exception {
        if (ownerUI == null || StringUtils.isEmpty((String)orgUnitId) || dimensionInfo == null) {
            return null;
        }
        KDPromptBox f7 = null;
        if (MBGLayoutConstants.BG_CURRENCY.equals(dimensionInfo.getNumber())) {
            f7 = this.parseCurrencyF7((IUIObject)ownerUI, dimensionInfo.getNumber(), dimensionInfo, isEnable);
        } else if (MBGLayoutConstants.BG_SCENARIO.equals(dimensionInfo.getNumber())) {
            f7 = this.parseScenarioF7((IUIObject)ownerUI, dimensionInfo.getNumber(), dimensionInfo, isEnable, bookParseHelper.getEditScenType(), bookParseHelper.getCacheHelper());
        } else if (MBGLayoutConstants.BG_VERSION.equals(dimensionInfo.getNumber())) {
            f7 = this.parseVersionF7((IUIObject)ownerUI, dimensionInfo.getNumber(), dimensionInfo, isEnable, bookParseHelper.getVersionNumber());
        } else if (MBGLayoutConstants.BG_ELEMENT.equals(dimensionInfo.getNumber())) {
            f7 = this.parseBgElementF7((IUIObject)ownerUI, dimensionInfo.getNumber(), dimensionInfo, isEnable);
        } else if (MBGLayoutConstants.BG_PERIOD.equals(dimensionInfo.getNumber())) {
            f7 = this.parseBgPeriodF7((IUIObject)ownerUI, dimensionInfo.getNumber(), dimensionInfo, isEnable, bookParseHelper.getBgFormPeriodNumber());
            this.setBgPeriodFilter(bookParseHelper, dimensionInfo, f7);
        } else if (MBGLayoutConstants.BG_ORGANIZATION.equals(dimensionInfo.getNumber())) {
            f7 = this.parseOrgUnitF7((IUIObject)ownerUI, dimensionInfo.getNumber(), bookParseHelper.getOrgViewId(), dimensionInfo, isEnable && bookParseHelper.isOrgF7Enable(), permissionNumber);
            if (bookParseHelper.isSetDefaultOrg()) {
                f7.setDataNoNotify((Object)bookParseHelper.getOrgUnitInfo());
                if (!dimensionInfo.getMember().isEmpty()) {
                    boolean hasCurrOrg = false;
                    for (BgDimensionMember member : dimensionInfo.getMember()) {
                        if (!bookParseHelper.getOrgUnitInfo().getNumber().equals(member.getNumber())) continue;
                        hasCurrOrg = true;
                        break;
                    }
                    if (!hasCurrOrg) {
                        BgDimensionMember member;
                        member = (BgDimensionMember)dimensionInfo.getMember().get(0);
                        if (bookParseHelper.getOrgUnitMap().containsKey(member.getNumber())) {
                            f7.setDataNoNotify((Object)bookParseHelper.getOrgUnitMap().get(member.getNumber()));
                        } else {
                            FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
                            orgUnit.setNumber(member.getNumber());
                            orgUnit.setLongNumber((String)((Object)member.getSortValue()));
                            orgUnit.setId(BOSUuid.read((String)member.getAttribute()));
                            orgUnit.setLevel(member.getLevel());
                            orgUnit.setSimpleName(member.getSimpleName());
                            f7.setDataNoNotify((Object)orgUnit);
                        }
                    }
                }
            }
        } else {
            f7 = this.parseDimensionF7(ownerUI, dimensionInfo, orgUnitId, unionGroupId, isEnable);
        }
        this.setDisplayFormatter(dimensionInfo, f7);
        return f7;
    }

    protected void setDisplayFormatter(BgDimensionBaseInfo dimensionInfo, KDPromptBox f7) {
    }

    protected void setBgPeriodFilter(AbstractBookParseHelper bookParseHelper, BgDimensionBaseInfo dimensionInfo, KDPromptBox f7) {
    }

    private KDLabelContainer createContainer() {
        KDLabelContainer cont = new KDLabelContainer();
        cont.setBounds(new Rectangle(240, 19));
        cont.setBoundLabelLength(80);
        cont.setBoundLabelUnderline(true);
        cont.setPreferredSize(new Dimension(240, 19));
        cont.setMinimumSize(new Dimension(240, 19));
        return cont;
    }

    protected abstract KDPromptBox createBizPrmt(IUIObject var1);

    protected abstract KDPromptBox createBizPrmtItem(IUIObject var1);

    private void parseOrgUnitDimension(IUIObject owner, KDPanel panel, String orgViewId, BgDimensionInfo dimensionInfo, boolean isEnable, List f7List, String permissionNumber) {
        KDLabelContainer contOrgUnit = this.createContainer();
        contOrgUnit.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgViewCommonResource", (String)dimensionInfo.getType()));
        KDPromptBox prmtOrgUnit = this.parseOrgUnitF7(owner, dimensionInfo.getAttributeNumber(), orgViewId, dimensionInfo, isEnable, permissionNumber);
        f7List.add(prmtOrgUnit);
        contOrgUnit.setBoundEditor((JComponent)prmtOrgUnit);
        panel.add((Component)contOrgUnit);
    }

    public KDPromptBox parseOrgUnitF7(IUIObject owner, String f7Name, String orgViewId, BgDimensionBaseInfo dimensionInfo, boolean isEnable, String permissionNumber) {
        KDPromptBox prmtOrgUnit = this.createBizPrmt(owner);
        prmtOrgUnit.setName(f7Name);
        this.setOrgF7Filter(owner, orgViewId, dimensionInfo, permissionNumber, prmtOrgUnit);
        prmtOrgUnit.setEnabled(isEnable);
        if (dimensionInfo.getMember().isEmpty()) {
            prmtOrgUnit.setEnabled(false);
        }
        return prmtOrgUnit;
    }

    protected void setOrgF7Filter(IUIObject owner, String orgViewId, BgDimensionBaseInfo dimensionInfo, String permissionNumber, KDPromptBox prmtOrgUnit) {
    }

    public KDPromptBox parseVersionF7(IUIObject owner, String f7Name, BgDimensionBaseInfo dimensionInfo, boolean isEnable, String versionNumber) {
        KDPromptBox prmtElement = this.createBizPrmt(owner);
        prmtElement.setName(f7Name);
        prmtElement.setEnabled(isEnable);
        this.setVersionFilter(dimensionInfo, versionNumber, prmtElement);
        BgDimensionParseCommonHelper.setNumberFilter(prmtElement, dimensionInfo, versionNumber);
        return prmtElement;
    }

    protected void setVersionFilter(BgDimensionBaseInfo dimensionInfo, String versionNumber, KDPromptBox prmtElement) {
    }

    private void parseBgItemDimension(IUIObject owner, KDPanel panel, String orgUnitId, BgDimensionBaseInfo dimensionInfo, boolean isEnable, List f7List) {
        KDLabelContainer contBgItem = this.createContainer();
        panel.add((Component)contBgItem);
        String[] group = dimensionInfo.getAttribute().split(",");
        String groupNumber = group[0];
        if (group.length == 2) {
            contBgItem.setBoundLabelText(group[1]);
            contBgItem.setToolTipText(group[1]);
        } else {
            contBgItem.setBoundLabelText(group[0]);
            contBgItem.setToolTipText(group[0]);
        }
        KDPromptBox prmtBgItem = this.createBizPrmt(owner);
        prmtBgItem.setName(dimensionInfo.getAttributeNumber());
        prmtBgItem.setEnabled(isEnable);
        this.setBgItemFilter(owner, orgUnitId, dimensionInfo, prmtBgItem);
        BgDimensionParseCommonHelper.setDefault(prmtBgItem, dimensionInfo, null);
        contBgItem.setBoundEditor((JComponent)prmtBgItem);
        f7List.add(prmtBgItem);
    }

    protected void setBgItemFilter(IUIObject owner, String orgUnitId, BgDimensionBaseInfo dimensionInfo, KDPromptBox prmtBgItem) {
    }

    private void parseBgPeriodDimension(IUIObject owner, KDPanel panel, BgDimensionBaseInfo dimensionInfo, boolean isEnable, List f7List) {
        KDLabelContainer contBgPeriod = this.createContainer();
        contBgPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgViewCommonResource", (String)dimensionInfo.getType()));
        panel.add((Component)contBgPeriod);
        KDPromptBox prmtBgPeriod = this.parseBgPeriodF7(owner, dimensionInfo.getAttributeNumber(), dimensionInfo, isEnable, null);
        contBgPeriod.setBoundEditor((JComponent)prmtBgPeriod);
        f7List.add(prmtBgPeriod);
    }

    public KDPromptBox parseBgPeriodF7(IUIObject owner, String f7Name, BgDimensionBaseInfo dimensionInfo, boolean isEnable, String defaultPeriod) {
        KDPromptBox prmtBgPeriod = this.createBizPrmt(owner);
        prmtBgPeriod.setName(f7Name);
        prmtBgPeriod.setEnabled(isEnable);
        this.setBgPeriodFilter(dimensionInfo, defaultPeriod, prmtBgPeriod);
        BgDimensionParseCommonHelper.setNumberFilter(prmtBgPeriod, dimensionInfo, defaultPeriod);
        return prmtBgPeriod;
    }

    protected void setBgPeriodFilter(BgDimensionBaseInfo dimensionInfo, String defaultPeriod, KDPromptBox prmtBgPeriod) {
    }

    private void parseBgElementDimension(IUIObject owner, KDPanel panel, BgDimensionBaseInfo dimensionInfo, boolean isEnable, List f7List) {
        KDLabelContainer contBgElement = this.createContainer();
        contBgElement.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgViewCommonResource", (String)dimensionInfo.getType()));
        panel.add((Component)contBgElement);
        KDPromptBox prmtElement = this.parseBgElementF7(owner, dimensionInfo.getAttributeNumber(), dimensionInfo, isEnable);
        contBgElement.setBoundEditor((JComponent)prmtElement);
        f7List.add(prmtElement);
    }

    public KDPromptBox parseBgElementF7(IUIObject owner, String f7Name, BgDimensionBaseInfo dimensionInfo, boolean isEnable) {
        KDPromptBox prmtElement = this.createBizPrmt(owner);
        prmtElement.setName(f7Name);
        prmtElement.setEnabled(isEnable);
        this.setBgElementFilter(prmtElement);
        BgDimensionParseCommonHelper.setNumberFilter(prmtElement, dimensionInfo, null);
        return prmtElement;
    }

    protected void setBgElementFilter(KDPromptBox prmtElement) {
    }

    public KDPromptBox parseScenarioF7(IUIObject owner, String f7Name, BgDimensionBaseInfo dimensionInfo, boolean isEnable, BgScenarioType editScenType, DimensionCacheHelper cacheHelper) {
        KDPromptBox prmtElement = this.createBizPrmt(owner);
        prmtElement.setName(f7Name);
        prmtElement.setEnabled(isEnable);
        this.setScenarioFilter(prmtElement);
        BgDimensionMember member = BgDimensionParseCommonHelper.getDefaultMember(owner, dimensionInfo, editScenType, cacheHelper);
        String number = member != null ? member.getNumber() : null;
        BgDimensionParseCommonHelper.setNumberFilter(prmtElement, dimensionInfo, number);
        return prmtElement;
    }

    protected void setScenarioFilter(KDPromptBox prmtElement) {
    }

    private void parseCurrencyDimension(IUIObject owner, KDPanel panel, BgDimensionBaseInfo dimensionInfo, boolean isEnable, List f7List) {
        KDLabelContainer contCurrency = this.createContainer();
        contCurrency.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgViewCommonResource", (String)dimensionInfo.getType()));
        panel.add((Component)contCurrency);
        KDPromptBox prmtCurrency = this.parseCurrencyF7(owner, dimensionInfo.getAttributeNumber(), dimensionInfo, isEnable);
        contCurrency.setBoundEditor((JComponent)prmtCurrency);
        f7List.add(prmtCurrency);
    }

    public KDPromptBox parseCurrencyF7(IUIObject owner, String f7Name, BgDimensionBaseInfo dimensionInfo, boolean isEnable) {
        KDPromptBox prmtCurrency = this.createBizPrmt(owner);
        prmtCurrency.setName(f7Name);
        prmtCurrency.setEnabled(isEnable);
        this.setCurrencyFilter(prmtCurrency);
        BgDimensionParseCommonHelper.setNumberFilter(prmtCurrency, dimensionInfo, null);
        return prmtCurrency;
    }

    protected void setCurrencyFilter(KDPromptBox prmtCurrency) {
    }

    public KDPromptBox parseDimensionF7(CoreUIObject owner, BgDimensionBaseInfo dimensionInfo, String orgUnitId, String unionGroupId, boolean isEnable) {
        KDPromptBox prmt = this.createBizPrmtItem((IUIObject)owner);
        this.setBgItemFilter(owner, dimensionInfo, orgUnitId, unionGroupId, prmt);
        prmt.setEnabled(isEnable);
        prmt.setName(dimensionInfo.getNumber());
        if (dimensionInfo.getMember() != null && dimensionInfo.getMember().size() > 0) {
            prmt.setDataNoNotify(dimensionInfo.getMember().get(0));
        } else {
            prmt.setDataNoNotify(null);
        }
        return prmt;
    }

    protected void setBgItemFilter(CoreUIObject owner, BgDimensionBaseInfo dimensionInfo, String orgUnitId, String unionGroupId, KDPromptBox prmt) {
    }
}

