/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.eas.ma.mbg.common.DimensionMemberFilterMember;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DimensionMemberFilterInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String UIPK = "com.kingdee.eas.ma.mbg.client.DimensionMemberFilterUI";
    private boolean isEnableFilter = false;
    private String currId = null;
    private Map<String, DimensionMemberFilterMember> memberFilter = new HashMap<String, DimensionMemberFilterMember>();
    private static final String MEMBER_FILTER = "MEMBER_FILTER";
    private Set<Integer> hideRowIndexs4Desc = new HashSet<Integer>();

    public Map<String, DimensionMemberFilterMember> getMemberFilter() {
        return this.memberFilter;
    }

    public boolean isEnableFilter() {
        return this.isEnableFilter;
    }

    public void setEnableFilter(boolean isEnableFilter) {
        this.isEnableFilter = isEnableFilter;
    }

    public void removeMemberFilter(String sheetName, String dimensionNumber) {
        this.memberFilter.remove(this.getKey(sheetName, dimensionNumber));
    }

    public DimensionMemberFilterMember getMemberFilter(String sheetName, String dimensionMember) {
        return this.memberFilter.get(this.getKey(sheetName, dimensionMember));
    }

    public void addMemberFilter(String sheetName, DimensionMemberFilterMember member) {
        if (member != null) {
            this.memberFilter.put(this.getKey(sheetName, member.getDimensionNumber()), member);
        }
    }

    public void setCurrId(String currId) {
        this.currId = currId;
    }

    public String getCurrId() {
        return this.currId;
    }

    protected String getKey(String sheetName, String dimensionNumber) {
        return sheetName + "_" + dimensionNumber;
    }

    public void clear() {
        this.currId = null;
        this.memberFilter.clear();
    }

    public byte[] getBytes() {
        HashMap values = new HashMap();
        HashMap<String, Map> filterMap = new HashMap<String, Map>();
        values.put(MEMBER_FILTER, filterMap);
        for (String key : this.memberFilter.keySet()) {
            DimensionMemberFilterMember member = this.memberFilter.get(key);
            Map subMap = member.getByteMap();
            if (subMap == null) continue;
            filterMap.put(key, subMap);
        }
        return BgAnalyseHelper.getBytes(values);
    }

    public void load(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        this.memberFilter.clear();
        Map values = (Map)BgAnalyseHelper.getObject(bytes);
        Map filterMap = (Map)values.get(MEMBER_FILTER);
        for (String key : filterMap.keySet()) {
            Map subMap = (Map)filterMap.get(key);
            DimensionMemberFilterMember member = new DimensionMemberFilterMember();
            String[] split = key.split("_");
            if (this.isNumeric(split[split.length - 1])) {
                member.setDesc(true);
            }
            member.load(subMap);
            this.memberFilter.put(key, member);
        }
    }

    private boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public Set<Integer> getHideRowIndexs4Desc() {
        Map<String, DimensionMemberFilterMember> memberFilters = this.getMemberFilter();
        this.clearHideRowIndexs4Desc();
        for (DimensionMemberFilterMember member : memberFilters.values()) {
            if (!member.isDesc()) continue;
            this.hideRowIndexs4Desc.addAll(member.getHideRowIndexs4Desc());
        }
        return this.hideRowIndexs4Desc;
    }

    public void clearHideRowIndexs4Desc() {
        this.hideRowIndexs4Desc.clear();
    }
}

