/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MBGRowData {
    private Set<String> effectiveItemCombinSet = new LinkedHashSet<String>();
    private Map<String, List<Integer>> srcNumberIndex = new HashMap<String, List<Integer>>();
    private final List<BgDimensionBaseInfo> dimensionList = new ArrayList<BgDimensionBaseInfo>();
    private final Map<String, Integer> refFieldIndexes = new LinkedHashMap<String, Integer>();
    private String[] refFields;
    private BgSchemeDimensionHelper schemeHelper = null;
    private boolean hasRelation = false;
    private boolean isShowDefaultMember = false;

    public MBGRowData(List<BgDimensionBaseInfo> dimensionList, boolean isShowDefaultMember, BgSchemeDimensionHelper schemeHelper) {
        this.dimensionList.addAll(dimensionList);
        this.isShowDefaultMember = isShowDefaultMember;
        this.schemeHelper = schemeHelper;
    }

    public void afterLoadData() {
        this.convertEffectiveItemCombinIndex();
    }

    private void convertEffectiveItemCombinIndex() {
        this.srcNumberIndex.clear();
        Integer index = 0;
        String itemCombin2 = null;
        String[] itemcombinArr = null;
        String oneCombin = null;
        for (String itemCombin2 : this.effectiveItemCombinSet) {
            itemcombinArr = itemCombin2.split(",");
            for (int j = 0; j < itemcombinArr.length; ++j) {
                List<Integer> indexes;
                oneCombin = itemcombinArr[j];
                if (StringUtils.isEmpty((String)oneCombin)) continue;
                if (oneCombin.indexOf(":") < 0) {
                    String refField = this.refFields[j];
                    String srcNumber = null;
                    if (DimensionConstants.DEF_CURRENCY_FIELD.equals(refField)) {
                        srcNumber = DimensionConstants.DEF_CURRENCY_SRCNUMBER;
                    } else if (DimensionConstants.DEF_ORGUNIT_FIELD.equals(refField)) {
                        srcNumber = DimensionConstants.DEF_ORGUNIT_SRCNUMBER;
                    } else if (DimensionConstants.DEF_ELEMENT_FIELD.equals(refField)) {
                        srcNumber = DimensionConstants.DEF_ELEMENT_SRCNUMBER;
                    } else if (DimensionConstants.DEF_PERIOD_FIELD.equals(refField)) {
                        srcNumber = DimensionConstants.DEF_PERIOD_SRCNUMBER;
                    } else if (DimensionConstants.DEF_SCENARIO_FIELD.equals(refField)) {
                        srcNumber = DimensionConstants.DEF_SCENARIO_SRCNUMBER;
                    } else if (DimensionConstants.DEF_VERSION_FIELD.equals(refField)) {
                        srcNumber = DimensionConstants.DEF_VERSION_SRCNUMBER;
                    }
                    if (srcNumber != null) {
                        oneCombin = DimensionFormulaHelper.getCombination(srcNumber, oneCombin);
                    }
                }
                if (!this.srcNumberIndex.containsKey(oneCombin)) {
                    this.srcNumberIndex.put(oneCombin, new ArrayList());
                }
                if (!(indexes = this.srcNumberIndex.get(oneCombin)).isEmpty() && index.equals(indexes.get(indexes.size() - 1))) continue;
                indexes.add(index);
            }
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
    }

    public void setRefFieldSort(String[] refFields) {
        this.refFields = new String[refFields.length];
        this.refFieldIndexes.clear();
        HashMap<Integer, Integer> tempMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < refFields.length; ++i) {
            tempMap.put(DimensionCommonHelper.getField(refFields[i]), new Integer(i));
        }
        Object[] indexes = tempMap.keySet().toArray();
        Arrays.sort(indexes);
        for (int i = 0; i < indexes.length; ++i) {
            this.refFieldIndexes.put(BgBaseConstants.REFFIELD + indexes[i], (Integer)tempMap.get(indexes[i]));
            this.refFields[i] = BgBaseConstants.REFFIELD + indexes[i];
        }
    }

    public boolean addEffectiveItemCombin(String[] itemCombin) {
        return this.effectiveItemCombinSet.add(this.getShortCombin(itemCombin));
    }

    public Set<String> getEffectiveItemCombinSet() {
        return this.effectiveItemCombinSet;
    }

    private String getShortCombin(String[] itemCombin) {
        StringBuilder strBuilder = new StringBuilder();
        String field2 = null;
        int index = -1;
        for (String field2 : this.refFieldIndexes.keySet()) {
            index = this.refFieldIndexes.get(field2);
            String item = itemCombin[index];
            if (StringUtils.isEmpty((String)item) && this.isShowDefaultMember) {
                strBuilder.append(this.schemeHelper.getSrcNumberByRefField(field2)).append(":");
                strBuilder.append(" ");
            } else {
                if (!StringUtils.isEmpty((String)item) && item.indexOf(":") < 0) {
                    strBuilder.append(DimensionFormulaHelper.getDefaultSrcNumberByField(field2)).append(":");
                }
                strBuilder.append(item == null ? "" : item);
            }
            strBuilder.append(",");
        }
        if (strBuilder.toString().endsWith(",")) {
            return strBuilder.toString().substring(0, strBuilder.length() - 1);
        }
        return strBuilder.toString();
    }

    public void clear() {
        this.effectiveItemCombinSet.clear();
        this.dimensionList.clear();
        this.refFieldIndexes.clear();
        this.hasRelation = false;
    }

    public void setHasRelation(boolean hasRelation) {
        this.hasRelation = hasRelation;
    }

    public boolean hasRelation() {
        return this.hasRelation;
    }

    public boolean isInRalation(String[] _tmpMembers, String[] refFields) {
        if (!this.hasRelation) {
            return true;
        }
        if (_tmpMembers == null || _tmpMembers.length == 0) {
            return true;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        boolean isFirst = true;
        for (int i = 0; i < _tmpMembers.length; ++i) {
            if (!this.refFieldIndexes.containsKey(refFields[i])) continue;
            String oneCombin = _tmpMembers[i];
            if (StringUtils.isEmpty((String)oneCombin)) {
                return true;
            }
            List<Integer> indexes = this.srcNumberIndex.get(oneCombin);
            if (indexes == null || indexes.isEmpty()) {
                return false;
            }
            if (isFirst) {
                result.addAll(indexes);
            } else {
                for (int r = result.size() - 1; r >= 0; --r) {
                    if (Collections.binarySearch(indexes, result.get(r)) >= 0) continue;
                    result.remove(r);
                }
            }
            isFirst = false;
            if (!result.isEmpty()) continue;
            return false;
        }
        return isFirst || !result.isEmpty();
    }

    public boolean isInRalation(List<BgDimensionMember> _tmpMembers) {
        if (!this.hasRelation) {
            return true;
        }
        if (_tmpMembers == null || _tmpMembers.isEmpty()) {
            return true;
        }
        String[] _newMembers = new String[_tmpMembers.size()];
        String[] _refFields = new String[_tmpMembers.size()];
        for (int i = 0; i < _tmpMembers.size(); ++i) {
            _refFields[i] = _tmpMembers.get(i).getRefField();
            _newMembers[i] = MBgTemplateHelper.getDimensionMemeberSign(_tmpMembers.get(i));
        }
        return this.isInRalation(_newMembers, _refFields);
    }
}

