/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormat;
import com.kingdee.eas.ma.mbg.common.AbstractBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.AbstractMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListAtribute;
import com.kingdee.eas.ma.mbg.common.MbgViewListCell;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.utils.ConditionalFormatHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MbgViewListDimensionManager
extends AbstractBgDimensionManagerBase
implements Cloneable {
    private static final long serialVersionUID = -8149554429815873131L;
    private List<IMbgViewListObject> rows = new ArrayList<IMbgViewListObject>();
    private List<IMbgViewListObject> columns = new ArrayList<IMbgViewListObject>();
    private List<MbgViewListCell> cells = new ArrayList<MbgViewListCell>();
    private transient List<ConditionalFormat> formConditionalFormats = new ArrayList<ConditionalFormat>();
    private List<MbgRelationMap> pageRelationMaps = null;
    private boolean isCloneCells = true;

    public MbgViewListDimensionManager(MbgViewListSheetManager sheet) {
        super(sheet);
    }

    public List<MbgRelationMap> getPageRelationMaps() {
        return this.pageRelationMaps;
    }

    public void setPageRelationMaps(List<MbgRelationMap> pageRelationMaps) {
        this.pageRelationMaps = pageRelationMaps;
    }

    public List<IMbgViewListObject> getRows() {
        return this.rows;
    }

    public List<IMbgViewListObject> getColumns() {
        return this.columns;
    }

    public List<MbgViewListCell> getCells() {
        return this.cells;
    }

    @Override
    public void verifyData() throws Exception {
    }

    @Override
    public void clear() {
        super.clear();
    }

    public Map<String, MbgViewListCell> getCellStyles() {
        HashMap<String, MbgViewListCell> cellMap = new HashMap<String, MbgViewListCell>();
        for (int i = 0; i < this.cells.size(); ++i) {
            cellMap.put(this.cells.get(i).getCellName(), this.cells.get(i));
        }
        return cellMap;
    }

    @Override
    public MbgViewListSheetManager getSheet() {
        return (MbgViewListSheetManager)super.getSheet();
    }

    public void addAttribute(MbgViewListAtribute attrib) {
        this.getDimension().add(attrib);
        if ("row".equals(attrib.getLayout())) {
            this.getRowDimension().add(attrib);
        } else {
            this.getColDimension().add(attrib);
        }
    }

    @Override
    public List getPageDisplayDimension() {
        return this.getPageDimension();
    }

    @Override
    public List getColDisplayDimension() {
        return this.getColDimension();
    }

    @Override
    public List getRowDisplayDimension() {
        return this.getRowDimension();
    }

    @Override
    public List getViewDisplayDimension() {
        return this.getViewDimension();
    }

    public List<MbgViewListDimensionInfo> getRowOnlyDimension() {
        return MbgViewListDimensionManager.filterDimension(this.getRowDimension());
    }

    public List<MbgViewListDimensionInfo> getColOnlyDimension() {
        return MbgViewListDimensionManager.filterDimension(this.getColDimension());
    }

    public static List<MbgViewListDimensionInfo> filterDimension(List dimensions) {
        ArrayList<MbgViewListDimensionInfo> result = new ArrayList<MbgViewListDimensionInfo>();
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!(dimensions.get(i) instanceof MbgViewListDimensionInfo)) continue;
            result.add((MbgViewListDimensionInfo)dimensions.get(i));
        }
        return result;
    }

    public void synLevelConfig(MbgViewListDimensionManager source) {
        if (source == null) {
            return;
        }
        for (int i = 0; i < this.getRows().size(); ++i) {
            if (!(this.getRows().get(i) instanceof MbgViewListRowCol)) continue;
            MbgViewListRowCol tRow = (MbgViewListRowCol)this.getRows().get(i);
            MbgViewListRowCol sRow = (MbgViewListRowCol)source.getRows().get(i);
            tRow.getLevelConfig().clear();
            tRow.getLevelConfig().putAll(sRow.getLevelConfig());
        }
    }

    public void synRowColInitIndex() {
        List<IMbgViewListObject> rowCols = this.getRowCols();
        for (int index = 0; index < rowCols.size(); ++index) {
            if (!(rowCols.get(index) instanceof AbstractMbgViewListObject)) continue;
            ((AbstractMbgViewListObject)rowCols.get(index)).setInitIndex(((AbstractMbgViewListObject)rowCols.get(index)).getIndex());
        }
    }

    public List<ConditionalFormat> getFormConditionalFormats() {
        return this.formConditionalFormats;
    }

    public List<IMbgViewListObject> getRowCols() {
        ArrayList<IMbgViewListObject> objects = new ArrayList<IMbgViewListObject>();
        objects.addAll(this.getRows());
        objects.addAll(this.getColumns());
        return objects;
    }

    public List<MbgViewListDimensionInfo> getAllDimensions() {
        return this.getAllDimensions(true);
    }

    public List<MbgViewListDimensionInfo> getAllDimensions(boolean hasCombin) {
        ArrayList<MbgViewListDimensionInfo> dimensions = new ArrayList<MbgViewListDimensionInfo>();
        dimensions.addAll(this.getPageDimension());
        dimensions.addAll(this.getViewDimension());
        List<IMbgViewListObject> rowCols = this.getRowCols();
        for (int i = 0; i < rowCols.size(); ++i) {
            if (!(rowCols.get(i) instanceof MbgViewListRowCol) || !hasCombin && ((MbgViewListRowCol)rowCols.get(i)).isCombin()) continue;
            dimensions.addAll(((MbgViewListRowCol)rowCols.get(i)).getDimensions());
        }
        return dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MbgViewListDimensionManager deepclone() {
        Object obj = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(this);
            bis = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bis);
            obj = ois.readObject();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException iOException) {}
        }
        return (MbgViewListDimensionManager)obj;
    }

    public boolean isEquals(MbgViewListDimensionManager dimensionManager) {
        if (dimensionManager.getDimension().size() != this.getDimension().size()) {
            return false;
        }
        if (!this.compareMbgViewListObjects(dimensionManager.getDimension(), this.getDimension())) {
            return false;
        }
        if (!this.compareMbgViewListObjects(dimensionManager.getRows(), this.getRows())) {
            return false;
        }
        if (!this.compareMbgViewListObjects(dimensionManager.getColumns(), this.getColumns())) {
            return false;
        }
        return this.compareCells(dimensionManager.getCells(), this.getCells());
    }

    private boolean compareMbgViewListObjects(List dimension1, List dimension2) {
        if (dimension1.size() != dimension2.size()) {
            return false;
        }
        for (int i = 0; i < dimension1.size(); ++i) {
            if (this.compareMbgViewListObject((IMbgViewListObject)dimension1.get(i), (IMbgViewListObject)dimension2.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean compareMbgViewListObject(IMbgViewListObject obj1, IMbgViewListObject obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 != null && obj2 != null) {
            return obj1.isEquals(obj2);
        }
        return false;
    }

    private boolean compareCells(List<MbgViewListCell> cells1, List<MbgViewListCell> cells2) {
        if (cells1.size() != cells2.size()) {
            return false;
        }
        for (int i = 0; i < cells1.size(); ++i) {
            if (StringUtils.equals((String)cells1.get(i).getCellName(), (String)cells2.get(i).getCellName())) continue;
            if (!ObjectUtil.equals((Object)cells1.get(i).getStyle(), (Object)cells2.get(i).getStyle())) {
                return false;
            }
            if (ConditionalFormatHelper.equalsCondFormat(cells1.get(i).getConditionaFormat(), cells2.get(i).getConditionaFormat())) continue;
            return false;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        String condStr = ConditionalFormatHelper.getTemplateConditionaFormat(this);
        if (condStr != null) {
            out.writeObject("TemplateConditionaFormat");
            out.writeObject(condStr);
        }
        if ((condStr = ConditionalFormatHelper.getFormConditionaFormat(this)) != null) {
            out.writeObject("FormConditionaFormat");
            out.writeObject(condStr);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.formConditionalFormats = new ArrayList<ConditionalFormat>();
        Object condStr = null;
        try {
            while ((condStr = in.readObject()) != null) {
                if ("TemplateConditionaFormat".equals(condStr)) {
                    try {
                        ConditionalFormatHelper.parseTemplateConditionaFormat(this, (String)in.readObject());
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
                if (!"FormConditionaFormat".equals(condStr)) continue;
                try {
                    ConditionalFormatHelper.parseFormConditionaFormat(this, (String)in.readObject());
                }
                catch (Exception e) {
                    throw new IOException(e);
                    return;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setCloneCells(boolean isCloneCells) {
        this.isCloneCells = isCloneCells;
    }

    public boolean isCloneCells() {
        return this.isCloneCells;
    }

    @Override
    public MbgViewListDimensionManager clone() {
        try {
            MbgViewListDimensionManager clone = (MbgViewListDimensionManager)super.clone();
            clone.cells = this.isCloneCells ? DimensionCommonHelper.cloneViewListObject(this.cells) : new ArrayList<MbgViewListCell>();
            clone.columns = DimensionCommonHelper.cloneViewListObject(this.columns);
            clone.rows = DimensionCommonHelper.cloneViewListObject(this.rows);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

