/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListStyleHelper;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class ViewListTitleRenderBase {
    public static boolean hasTitle(Cell cell) {
        if (cell == null) {
            return false;
        }
        return cell.getUserObjectValue("edit.orgunit") instanceof ViewListRenderObject || cell.getUserObjectValue("edit.period") instanceof ViewListRenderObject || cell.getUserObjectValue("amout.unit") instanceof ViewListRenderObject;
    }

    protected static Map<Integer, String> parseHeader(Cell cell) {
        HashMap<Integer, String> values = new HashMap<Integer, String>();
        ViewListTitleRenderBase.parseHeader(values, cell, "edit.orgunit");
        ViewListTitleRenderBase.parseHeader(values, cell, "edit.period");
        ViewListTitleRenderBase.parseHeader(values, cell, "amout.unit");
        return values;
    }

    private static void parseHeader(Map<Integer, String> values, Cell cell, String headerKey) {
        if (cell == null || !(cell.getUserObjectValue(headerKey) instanceof ViewListRenderObject)) {
            return;
        }
        ViewListRenderObject object = (ViewListRenderObject)cell.getUserObjectValue(headerKey);
        Integer align = new Integer(object.align);
        if (values.containsKey(align)) {
            values.put(align, values.get(align) + "  " + object.value);
        } else {
            values.put(align, object.value);
        }
    }

    public static Styles.HorizontalAlignment getAlign(Cell cell) {
        if (cell == null) {
            return null;
        }
        Styles.HorizontalAlignment align = cell.getStyle().getHorizontalAlign();
        if (ViewListTitleRenderBase.hasTitle(cell)) {
            int size = 0;
            String headerKey = null;
            if (cell.getUserObjectValue("edit.orgunit") != null) {
                ++size;
            }
            if (cell.getUserObjectValue("edit.period") != null) {
                ++size;
            }
            if (cell.getUserObjectValue("amout.unit") != null) {
                ++size;
            }
            if (size == 1) {
                if (cell.getUserObjectValue("edit.orgunit") != null) {
                    headerKey = "edit.orgunit";
                }
                if (cell.getUserObjectValue("edit.period") != null) {
                    headerKey = "edit.period";
                }
                if (cell.getUserObjectValue("amout.unit") != null) {
                    headerKey = "amout.unit";
                }
                ViewListRenderObject object = (ViewListRenderObject)cell.getUserObjectValue(headerKey);
                align = ViewListStyleHelper.convertHorizontalAlign(new Integer(object.align));
            } else {
                align = Styles.HorizontalAlignment.CENTER;
            }
        }
        return align;
    }

    public static Style getStyle(Style cellStyle, int align) {
        StyleAttributes style = Styles.getSA((ShareStyleAttributes)cellStyle);
        style.setHorizontalAlign(ViewListStyleHelper.convertHorizontalAlign(align));
        return new Style((ShareStyleAttributes)style);
    }

    public static void processTitle(Book book) {
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        block0: for (int s = 0; s < book.getSheetCount(); ++s) {
            sheet = book.getSheet(s);
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                String title;
                row = sheet.getRow(r, false);
                if (row == null) continue;
                if (ViewListHelper.getDimension(row) != null) continue block0;
                cell = row.getCell(0, false);
                if (cell == null || StringUtils.isEmpty((String)(title = ViewListTitleRenderBase.getTitle(cell)))) continue;
                BgNFSHelper.setValue(cell, title);
            }
        }
    }

    public static String getTitle(Cell cell) {
        if (cell == null || cell.getCol() != 0) {
            return null;
        }
        Map<Integer, String> values = ViewListTitleRenderBase.parseHeader(cell);
        if (values != null && !values.isEmpty()) {
            Integer[] aligns = values.keySet().toArray(new Integer[0]);
            StringBuffer title = new StringBuffer();
            for (int i = 0; i < aligns.length; ++i) {
                if (title.length() > 0) {
                    title.append("   ");
                }
                title.append(values.get(aligns[i]));
            }
            return title.toString();
        }
        return null;
    }

    public static class ViewListRenderObject {
        private String value;
        private int align;

        public ViewListRenderObject(String value, int align) {
            this.value = value;
            this.align = align;
        }
    }
}

