/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common.calcRow;

import com.kingdee.eas.ma.mbg.common.calcRow.AbstractCalcExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.CalcRowParser2RPN;
import com.kingdee.eas.ma.mbg.common.calcRow.ConstExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.IExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.LeftBracket;
import com.kingdee.eas.ma.mbg.common.calcRow.OperatorExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.RightBracket;
import com.kingdee.eas.ma.mbg.common.calcRow.SpaceWhiteExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.UnkownExpr;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.StyledDocument;

public class ExprParseHelper {
    public static void parseDocument(String text, StyledDocument doc) {
        List<IExpr> exprs = ExprParseHelper.parse(text);
        for (int i = 0; i < exprs.size(); ++i) {
            if (exprs.get(i) == null) continue;
            exprs.get(i).buildDocument(doc);
        }
    }

    public static List<IExpr> parse(String text) {
        ArrayList<IExpr> result = new ArrayList<IExpr>();
        CalcRowParser2RPN parser2 = new CalcRowParser2RPN(text);
        parser2.parse();
        Stack<String> tokens = parser2.getTokens();
        for (int i = 0; i < tokens.size(); ++i) {
            result.add(ExprParseHelper.parseExpr((String)tokens.get(i)));
        }
        return result;
    }

    private static IExpr parseExpr(String exprStr) {
        if (StringUtils.isEmpty((String)exprStr)) {
            return null;
        }
        if (ExprParseHelper.isOperator(exprStr)) {
            return new OperatorExpr(exprStr);
        }
        if (ExprParseHelper.isLeftBracket(exprStr)) {
            return new LeftBracket(exprStr);
        }
        if (ExprParseHelper.isRightBracket(exprStr)) {
            return new RightBracket(exprStr);
        }
        if (ExprParseHelper.isSpaceWhite(exprStr)) {
            return new SpaceWhiteExpr(exprStr);
        }
        if (AbstractCalcExpr.isCalExpr(exprStr)) {
            return AbstractCalcExpr.createExpr(exprStr);
        }
        if (ExprParseHelper.isConst(exprStr)) {
            return new ConstExpr(exprStr);
        }
        return new UnkownExpr(exprStr);
    }

    private static boolean isConst(String exprStr) {
        if (!StringUtils.isEmpty((String)exprStr)) {
            for (int i = 0; i < exprStr.length(); ++i) {
                char c = exprStr.charAt(i);
                if (c == ',' || c == '.' || c >= '0' && c <= '9') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isRightBracket(String exprStr) {
        if (ExprParseHelper.isChar(exprStr)) {
            return CalcRowParser2RPN.isRightBracket(exprStr.charAt(0));
        }
        return false;
    }

    private static boolean isLeftBracket(String exprStr) {
        if (ExprParseHelper.isChar(exprStr)) {
            return CalcRowParser2RPN.isLeftBracket(exprStr.charAt(0));
        }
        return false;
    }

    private static boolean isSpaceWhite(String exprStr) {
        if (!StringUtils.isEmpty((String)exprStr)) {
            for (int i = 0; i < exprStr.length(); ++i) {
                if (CalcRowParser2RPN.isSpaceWhite(exprStr.charAt(i))) continue;
                return false;
            }
        }
        return false;
    }

    private static boolean isOperator(String exprStr) {
        if (ExprParseHelper.isChar(exprStr)) {
            return CalcRowParser2RPN.isOperation(exprStr.charAt(0));
        }
        return false;
    }

    private static boolean isChar(String exprStr) {
        return exprStr != null && exprStr.length() == 1;
    }
}

