/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube;

import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.utils.BgElementCollObject;
import com.kingdee.eas.ma.base.utils.BgScenarioCollObject;
import com.kingdee.eas.ma.mbg.BgSchemeRefDimInfo;
import com.kingdee.eas.ma.mbg.BgSchemeRefMemberInfo;
import com.kingdee.eas.ma.mbg.BgSchemeRefMemberTypeEnum;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class RefDimInfo {
    public static final String SPLIT = ";";
    private String indexSrcNumber;
    private String indexNumber;
    private String bgElementNumber;
    private List<String> refFields;
    private String combin;

    public RefDimInfo(String combin, List<String> refFields) {
        if (StringUtils.isEmpty((String)combin)) {
            return;
        }
        this.combin = combin;
        String[] split = DimensionFormulaHelper.splitCombinations(combin);
        for (int i = 0; i < split.length; ++i) {
            String srcNumber = DimensionFormulaHelper.getSrcNumber(split[i]);
            String number = DimensionFormulaHelper.getMemberNumber(split[i]);
            if (DimensionConstants.DEF_ELEMENT_SRCNUMBER.equals(srcNumber)) {
                this.bgElementNumber = number;
                continue;
            }
            this.indexSrcNumber = srcNumber;
            this.indexNumber = number;
        }
        this.refFields = refFields;
    }

    public String getIndexNumber() {
        return this.indexNumber;
    }

    public String getIndexSrcNumber() {
        return this.indexSrcNumber;
    }

    public String getBgElementNumber() {
        return this.bgElementNumber;
    }

    public List<String> getRefFields() {
        return this.refFields;
    }

    public String getCombin() {
        return this.combin;
    }

    public boolean isLeaf() {
        return !StringUtils.isEmpty((String)this.indexNumber) && !StringUtils.isEmpty((String)this.bgElementNumber);
    }

    public String getIndexCombin() {
        return DimensionFormulaHelper.getCombination(this.getIndexSrcNumber(), this.getIndexNumber());
    }

    public String[] getNoLeafCombin() {
        return new String[]{RefDimInfo.getCombin(this.getIndexSrcNumber(), null, this.getBgElementNumber())};
    }

    public static String getCombin(String indexSrcNumber, String indexNumber, String bgElementNumber) {
        return RefDimInfo.getCombin(DimensionFormulaHelper.getCombination(DimensionConstants.DEF_ELEMENT_SRCNUMBER, bgElementNumber), DimensionFormulaHelper.getCombination(indexSrcNumber, indexNumber));
    }

    public static String getCombin(String indexSrcNumber, String indexNumber, String scenNumber, String bgElementNumber) {
        return RefDimInfo.getCombinKey(DimensionFormulaHelper.getCombination(DimensionConstants.DEF_SCENARIO_SRCNUMBER, scenNumber), DimensionFormulaHelper.getCombination(DimensionConstants.DEF_ELEMENT_SRCNUMBER, bgElementNumber), DimensionFormulaHelper.getCombination(indexSrcNumber, indexNumber));
    }

    public static String getCombin(String bgElementComb, String indexComb) {
        return bgElementComb + "," + indexComb;
    }

    public static String getCombinKey(String bgScenarioComb, String bgElementComb, String indexComb) {
        return bgScenarioComb + "," + bgElementComb + "," + indexComb;
    }

    public static String getIndexNumber(String key) {
        if (key == null) {
            return null;
        }
        String[] keys = key.split(",");
        for (int i = 0; i < keys.length; ++i) {
            String srcNumber = DimensionFormulaHelper.getSrcNumber(keys[i]);
            if (DimensionConstants.DEF_SCENARIO_SRCNUMBER.equals(srcNumber) || DimensionConstants.DEF_ELEMENT_SRCNUMBER.equals(srcNumber)) continue;
            return keys[i];
        }
        return null;
    }

    public static List<BgDimensionMember> getIndexMembers(BgSchemeRefDimInfo info) {
        ArrayList<BgDimensionMember> indexMembers = new ArrayList<BgDimensionMember>();
        for (int m = 0; m < info.getMembers().size(); ++m) {
            BgSchemeRefMemberInfo refMember = info.getMembers().get(m);
            if (!BgSchemeRefMemberTypeEnum.BgIndex.equals((Object)refMember.getMemberType())) continue;
            BgDimensionMember member = new BgDimensionMember(info.getIndexSource().getDimension().getNumber(), info.getIndexSource().getDimension().getRefField(), refMember.getName(), refMember.getNumber());
            indexMembers.add(member);
        }
        return indexMembers;
    }

    public static BgElementCollObject getBgElementMembers(BgSchemeRefDimInfo info) {
        BgElementCollection bgElementCol = new BgElementCollection();
        BgElementCollObject bgElement = new BgElementCollObject(bgElementCol, true);
        for (int m = 0; m < info.getMembers().size(); ++m) {
            BgSchemeRefMemberInfo refMember = info.getMembers().get(m);
            if (!BgSchemeRefMemberTypeEnum.BgElement.equals((Object)refMember.getMemberType())) continue;
            BgElementInfo value = new BgElementInfo();
            value.setNumber(refMember.getNumber());
            value.setName(refMember.getName());
            bgElementCol.add(value);
        }
        if (bgElementCol.isEmpty()) {
            return null;
        }
        return bgElement;
    }

    public static BgScenarioCollObject getBgScenarioMembers(BgSchemeRefDimInfo refDimInfo) {
        BgScenarioCollection colls = new BgScenarioCollection();
        BgScenarioCollObject bgScenarios = new BgScenarioCollObject(colls, true);
        for (int m = 0; m < refDimInfo.getMembers().size(); ++m) {
            BgSchemeRefMemberInfo refMember = refDimInfo.getMembers().get(m);
            if (!BgSchemeRefMemberTypeEnum.BgScenario.equals((Object)refMember.getMemberType())) continue;
            BgScenarioInfo value = new BgScenarioInfo();
            value.setNumber(refMember.getNumber());
            value.setName(refMember.getName());
            colls.add(value);
        }
        if (colls.isEmpty()) {
            return null;
        }
        return bgScenarios;
    }
}

