/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube.query;

import com.kingdee.eas.ma.biz.execute.calc.impl.ICalcMember;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.cube.query.IControlManager;
import com.kingdee.eas.ma.mbg.cube.query.IDataManager;
import com.kingdee.eas.ma.mbg.cube.query.IMDXStrategy;
import com.kingdee.eas.ma.mbg.cube.query.IQuery;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.cube.query.IQueryParameter;
import com.kingdee.eas.ma.mbg.cube.query.IResultStrategy;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class QueryStrategy
implements IQuery {
    private static Logger logger = Logger.getLogger(QueryStrategy.class);
    private IDataManager dataManager = null;
    private IControlManager controlManager = null;
    private IMDXStrategy mdxStrategy = null;
    private IResultStrategy resultStrategy = null;

    protected void setDataManager(IDataManager dataManager) {
        this.dataManager = dataManager;
    }

    protected IDataManager getDataManager() {
        return this.dataManager;
    }

    protected void setControlManager(IControlManager controlManager) {
        this.controlManager = controlManager;
    }

    protected IControlManager getControlManager() {
        return this.controlManager;
    }

    protected IMDXStrategy getMdxStrategy() {
        return this.mdxStrategy;
    }

    protected abstract IMDXStrategy createMdxStrategy();

    protected IResultStrategy getResultStrategy() {
        return this.resultStrategy;
    }

    protected abstract IResultStrategy createRstStrategy();

    public QueryStrategy(IDataManager dataManager, IControlManager controlManager) {
        this.setDataManager(dataManager);
        this.setControlManager(controlManager);
        this.createMdxStrategy();
        this.createRstStrategy();
    }

    @Override
    public Map<String, IMbgData> executeMdxQuery(IQueryParameter queryParameter, Map<String, Object> olapParams) throws Exception {
        HashMap<String, IMbgData> mbgDataMap = new HashMap<String, IMbgData>();
        if (queryParameter == null || olapParams == null) {
            return mbgDataMap;
        }
        String mdx = null;
        Map<String, IMbgData> _mbgDataMap = null;
        Object result = null;
        try {
            this.beforeQuery();
            if (!queryParameter.getQuerys().isEmpty()) {
                for (IQueryData queryData : queryParameter.getQuerys()) {
                    try {
                        mdx = this.getMdxStrategy().getQueryMdx(queryData);
                        result = this.executeMdxQuery(mdx);
                        _mbgDataMap = this.getResultStrategy().getResult(result);
                        if (_mbgDataMap == null || !_mbgDataMap.isEmpty()) continue;
                        mbgDataMap.putAll(_mbgDataMap);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"executeMdxQuery error:", (Throwable)ex);
                        logger.error((Object)("executeMdxQuery error mdx :" + mdx));
                    }
                }
            } else if (!this.getDataManager().getBizCalcs().isEmpty()) {
                for (ICalcMember calcMember : this.getDataManager().getBizCalcs()) {
                    try {
                        mdx = this.getMdxStrategy().getQueryMdx(calcMember);
                        result = this.executeMdxQuery(mdx);
                        _mbgDataMap = this.getResultStrategy().getResult(result);
                        if (_mbgDataMap == null || !_mbgDataMap.isEmpty()) continue;
                        mbgDataMap.putAll(_mbgDataMap);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"executeMdxQuery error:", (Throwable)ex);
                        logger.error((Object)("executeMdxQuery error mdx :" + mdx));
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"executeMdxQuery error:", (Throwable)ex);
            logger.error((Object)("execute Mdx:" + mdx));
            throw ex;
        }
        finally {
            this.afterQuery();
        }
        return mbgDataMap;
    }

    protected abstract void beforeQuery() throws Exception;

    protected abstract Object executeMdxQuery(String var1) throws Exception;

    protected abstract void afterQuery() throws Exception;
}

