/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube.query.algo;

import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.cube.CubeConstants;
import com.kingdee.eas.ma.mbg.cube.query.IControlManager;
import com.kingdee.eas.ma.mbg.cube.query.IDataManager;
import com.kingdee.eas.ma.mbg.cube.query.SchemeCube;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.ClosureUtils;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

public class KDSchemeCube
extends SchemeCube {
    private boolean hasMultipleOrg = false;
    private boolean hasDataState = false;
    private String FACT_NAME = "budgetFact";

    public KDSchemeCube(IDataManager dataManager, IControlManager controlManager) {
        super(dataManager, controlManager);
    }

    @Override
    public String getSchemeCube(Map<String, Object> olapParams) throws Exception {
        if (olapParams == null || !olapParams.containsKey(CubeConstants.OLAP_SCHEME)) {
            return null;
        }
        Map cubeParams = (Map)olapParams.get(CubeConstants.OLAP_SCHEME);
        if (cubeParams == null) {
            return null;
        }
        this.verdictParams(cubeParams);
        ByteArrayOutputStream os = null;
        XMLStreamWriter writer = null;
        String scheme = null;
        os = new ByteArrayOutputStream();
        writer = XMLOutputFactory.newInstance().createXMLStreamWriter(os, "UTF-8");
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeStartElement(DimensionConstants.SCHEME);
        writer.writeAttribute(DimensionConstants.NAME, "KDOLAP");
        this.outTable(writer, cubeParams);
        this.dimensionOrgUnit(writer, cubeParams);
        this.dimensionItem(writer, cubeParams);
        this.dimensionPeriod(writer, cubeParams);
        this.dimensionElement(writer, cubeParams);
        this.dimensionCurrency(writer, cubeParams);
        this.dimensionScenario(writer, cubeParams);
        this.dimensionVersion(writer, cubeParams);
        this.dimensionState(writer, cubeParams);
        this.schemeCube(writer, cubeParams);
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        scheme = ((Object)os).toString();
        return scheme;
    }

    public void setHasMultipleOrg(boolean hasMultipleOrg) {
        this.hasMultipleOrg = hasMultipleOrg;
    }

    public boolean isHasMultipleOrg() {
        return this.hasMultipleOrg;
    }

    public void setHasDataState(boolean hasDataState) {
        this.hasDataState = hasDataState;
    }

    public boolean isHasDataState() {
        return this.hasDataState;
    }

    private void verdictParams(Map<String, String> params) throws Exception {
        if (params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        String hasMultiple = params.get(CubeConstants.ORGUNIT_MULTIPLE);
        if (hasMultiple != null && Boolean.valueOf(hasMultiple).booleanValue()) {
            this.setHasMultipleOrg(true);
        }
        if (this.getControlManager().isControl()) {
            this.setHasDataState(true);
        }
    }

    protected void outTable(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        boolean hasGroup = false;
        String groupStr = params.get(CubeConstants.DATA_SQL_GROUP);
        if (groupStr != null && Boolean.valueOf(groupStr).booleanValue()) {
            hasGroup = true;
        }
        if (params.containsKey(CubeConstants.DATA_SQL)) {
            String sql = params.get("DATA_TABLE_SQL");
            sql = sql.replaceAll(CubeConstants.DATA_SQL_CUBE, params.get(CubeConstants.CUBE_TABLE));
            String fieldValue = this.getControlManager().isAdjust() ? "FTMPVALUE" : "FVALUE";
            String refFieldStr = params.get(CubeConstants.FIELD_REFFIELDS);
            if (!StringUtils.isEmpty((String)refFieldStr)) {
                refFieldStr = refFieldStr.replaceAll(";", ",");
                String repStr = null;
                repStr = hasGroup ? refFieldStr + " FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION, sum(" + fieldValue + ") " + fieldValue : refFieldStr + " FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION, " + fieldValue;
                if (this.isHasDataState()) {
                    repStr = repStr + ", FState ";
                }
                sql = sql.replaceAll("\\*", repStr);
                String customState = params.get(CubeConstants.DATA_CUSTOM_STATE);
                if (!StringUtils.isEmpty((String)customState)) {
                    sql = sql + " AND FState IN (" + customState + ")";
                }
                if (hasGroup) {
                    sql = sql + " group by " + refFieldStr + " FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION";
                    if (this.isHasDataState()) {
                        sql = sql + ", FState ";
                    }
                }
            }
            writer.writeStartElement(DimensionConstants.TABLE);
            writer.writeAttribute(DimensionConstants.NAME, this.FACT_NAME);
            writer.writeAttribute(DimensionConstants.SQL.toLowerCase(), sql);
            writer.writeEndElement();
        }
    }

    protected void dimensionOrgUnit(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        if (!this.isHasMultipleOrg()) {
            return;
        }
        String factTable = params.get(CubeConstants.ORGUNIT_FACT_TABLE);
        if (factTable == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.ORGUNIT_DIM_NAME);
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_FID);
        writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), factTable.toUpperCase());
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.ORGUNIT_DIM_NAME + " Level");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_FID);
        writer.writeAttribute(DimensionConstants.PARENTCOLUMN, DimensionConstants.COLUMN_PARENTID);
        writer.writeStartElement(DimensionConstants.PROPERTY);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.NAME);
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_NUMBER);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected void dimensionItem(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.BGITEMPROPCHECKERROR);
        }
        String fieldStr = params.get(DimensionConstants.BGITEM_DIM_REFFIELD);
        if (fieldStr == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        String[] fields = fieldStr.split(";");
        if (fields != null) {
            String field2 = null;
            String factTable = null;
            for (String field2 : fields) {
                factTable = params.get(field2 + CubeConstants.FIELD_FACT_TABLE);
                writer.writeStartElement(DimensionConstants.DIMENSION);
                writer.writeAttribute(DimensionConstants.NAME, "DIM" + field2.toUpperCase());
                writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_DIMNUMBER);
                writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), factTable.toUpperCase());
                writer.writeStartElement(DimensionConstants.HIERARCHY);
                writer.writeStartElement(DimensionConstants.LEVEL);
                writer.writeAttribute(DimensionConstants.NAME, field2 + " Level");
                writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_DIMNUMBER);
                writer.writeAttribute(DimensionConstants.PARENTCOLUMN, DimensionConstants.COLUMN_PARENTNUMBER);
                if (DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field2)) {
                    writer.writeStartElement(DimensionConstants.PROPERTY);
                    writer.writeAttribute(DimensionConstants.NAME, "kmtype");
                    writer.writeAttribute(DimensionConstants.COLUMN, "FBgAccountType");
                    writer.writeEndElement();
                    writer.writeStartElement(DimensionConstants.PROPERTY);
                    writer.writeAttribute(DimensionConstants.NAME, "kmdatatype");
                    writer.writeAttribute(DimensionConstants.COLUMN, "FBgAccountDataType");
                    writer.writeEndElement();
                    writer.writeStartElement(DimensionConstants.PROPERTY);
                    writer.writeAttribute(DimensionConstants.NAME, "kmdctype");
                    writer.writeAttribute(DimensionConstants.COLUMN, "FBgDecreditAlgorithm");
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
    }

    protected void dimensionPeriod(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        String factTable = DimensionConstants.PERIOD_FACTTABLE_NAME;
        if (params.containsKey(DimensionConstants.PERIOD_FISCALYEAR)) {
            factTable = ClosureUtils.HK_PERIOD_TABLE_FACT;
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.PERIOD_DIM_NAME);
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_FID);
        writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), factTable.toUpperCase());
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.PERIOD_DIM_NAME + " Level");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_FID);
        writer.writeAttribute(DimensionConstants.ORDERCOLUMN, DimensionConstants.COLUMN_LONGNUMBER);
        writer.writeAttribute(DimensionConstants.PARENTCOLUMN, DimensionConstants.COLUMN_PARENTID);
        writer.writeStartElement(DimensionConstants.PROPERTY);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.NAME);
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_NUMBER);
        writer.writeEndElement();
        writer.writeStartElement(DimensionConstants.PROPERTY);
        writer.writeAttribute(DimensionConstants.NAME, "type");
        writer.writeAttribute(DimensionConstants.COLUMN, "FPERIODTYPE");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected void dimensionElement(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.ELEMENT_DIM_NAME);
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_FID);
        writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), DimensionConstants.ELEMENT_FACTTABLE_NAME);
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.ELEMENT_DIM_NAME + " Level");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_FID);
        writer.writeAttribute(DimensionConstants.PARENTCOLUMN, DimensionConstants.COLUMN_PARENTID);
        writer.writeStartElement(DimensionConstants.PROPERTY);
        writer.writeAttribute(DimensionConstants.NAME, "name");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_NUMBER);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected void dimensionCurrency(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.CURRENCY_DIM_NAME);
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_FID);
        writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), DimensionConstants.CURRENCY_FACTTABLE_NAME);
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.CURRENCY_DIM_NAME + " Level");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_FID);
        writer.writeStartElement(DimensionConstants.PROPERTY);
        writer.writeAttribute(DimensionConstants.NAME, "name");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_NUMBER);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected void dimensionScenario(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.SCENARIO_DIM_NAME);
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_SCENARIOID);
        writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), DimensionConstants.SCENARIO_FACTTABLE_NAME.toUpperCase());
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.SCENARIO_DIM_NAME + " Level");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_FID);
        writer.writeAttribute(DimensionConstants.PARENTCOLUMN, DimensionConstants.COLUMN_PARENTID);
        writer.writeStartElement(DimensionConstants.PROPERTY);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.NAME);
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_SCENARIOID);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected void dimensionVersion(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.VERSION_DIM_NAME);
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_VERSIONID);
        writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), DimensionConstants.VERSION_FACTTABLE_NAME);
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.VERSION_DIM_NAME + " Level");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_FID);
        writer.writeAttribute(DimensionConstants.PARENTCOLUMN, DimensionConstants.COLUMN_PARENTID);
        writer.writeStartElement(DimensionConstants.PROPERTY);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.NAME);
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_VERSIONID);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected void dimensionState(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        if (this.isHasDataState()) {
            writer.writeStartElement(DimensionConstants.DIMENSION);
            writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.STATE_DIM_NAME);
            writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_STATE);
            writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), DimensionConstants.STATE_FACTTABLE_NAME);
            writer.writeStartElement(DimensionConstants.HIERARCHY);
            writer.writeStartElement(DimensionConstants.LEVEL);
            writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.STATE_DIM_NAME + " Level");
            writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_STATE);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    protected void schemeCube(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        boolean hasSQL = false;
        String cubeName = params.get(DimensionConstants.TABLE_NAME);
        String dataSql = params.get(DimensionConstants.DATA_TABLE_SQL);
        if (!StringUtils.isEmpty((String)dataSql)) {
            hasSQL = true;
        }
        writer.writeStartElement(DimensionConstants.CUBE);
        writer.writeAttribute(DimensionConstants.NAME, "budgetCube");
        if (hasSQL) {
            writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), this.FACT_NAME);
        } else {
            writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), cubeName);
        }
        if (this.isHasMultipleOrg()) {
            writer.writeStartElement(DimensionConstants.DIMUSAGE);
            writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.ORGUNIT_DIM_NAME);
            writer.writeAttribute(DimensionConstants.FOREIGNKEY, "FORGUNITID");
            writer.writeEndElement();
        }
        this.dimensionUsage(writer, params);
        writer.writeStartElement(DimensionConstants.DIMUSAGE);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.PERIOD_DIM_NAME);
        writer.writeAttribute(DimensionConstants.FOREIGNKEY, "FBGPERIODID");
        writer.writeEndElement();
        writer.writeStartElement(DimensionConstants.DIMUSAGE);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.ELEMENT_DIM_NAME);
        writer.writeAttribute(DimensionConstants.FOREIGNKEY, "FBGELEMENTID");
        writer.writeEndElement();
        writer.writeStartElement(DimensionConstants.DIMUSAGE);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.CURRENCY_DIM_NAME);
        writer.writeAttribute(DimensionConstants.FOREIGNKEY, "FCURRENCYID");
        writer.writeEndElement();
        writer.writeStartElement(DimensionConstants.DIMUSAGE);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.SCENARIO_DIM_NAME);
        writer.writeAttribute(DimensionConstants.FOREIGNKEY, DimensionConstants.COLUMN_SCENARIO);
        writer.writeEndElement();
        writer.writeStartElement(DimensionConstants.DIMUSAGE);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.VERSION_DIM_NAME);
        writer.writeAttribute(DimensionConstants.FOREIGNKEY, DimensionConstants.COLUMN_VERSION);
        writer.writeEndElement();
        if (this.isHasDataState()) {
            writer.writeStartElement(DimensionConstants.DIMUSAGE);
            writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.STATE_DIM_NAME);
            writer.writeAttribute(DimensionConstants.FOREIGNKEY, DimensionConstants.COLUMN_STATE.toUpperCase());
            writer.writeEndElement();
        }
        this.cubeMeasure(writer, params);
        writer.writeEndElement();
    }

    protected void dimensionUsage(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        String fieldStr = params.get(CubeConstants.FIELD_REFFIELDS);
        String[] fields = fieldStr.split(";");
        if (fields != null && fields.length > 0) {
            String field = null;
            int in = fields.length;
            for (int i = 0; i < in; ++i) {
                field = fields[i].toUpperCase();
                writer.writeStartElement(DimensionConstants.DIMUSAGE);
                writer.writeAttribute(DimensionConstants.NAME, "DIM" + field);
                writer.writeAttribute(DimensionConstants.FOREIGNKEY, field);
                writer.writeEndElement();
            }
        }
    }

    protected void cubeMeasure(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        this.measure(writer, params);
    }

    protected void measure(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        String fieldValue = "FVALUE";
        String type = params.get(DimensionConstants.DATA_TABLE_FIELD);
        String dataType = params.get(DimensionConstants.DATA_VALUE_TYPE);
        if ((String.valueOf(2).equals(dataType) || String.valueOf(1).equals(dataType)) && Boolean.valueOf(type).booleanValue()) {
            fieldValue = "FTMPVALUE";
        }
        writer.writeStartElement(DimensionConstants.MRESURE);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.VALUE);
        writer.writeAttribute(DimensionConstants.COLUMN, fieldValue);
        writer.writeAttribute(DimensionConstants.AGGREGATOR, "sum");
        writer.writeEndElement();
    }
}

