/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.dimension.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.ClosureData;
import com.kingdee.eas.ma.mbg.dimension.vo.ClosureObject;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClosureUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.dimension.util.ClosureUtils");
    private static String outTime = "invoke process use = {0} ms; alluse = {1} ms;";
    private static MessageFormat format = new MessageFormat(outTime);
    public static String HK_PERIOD_TABLE_FACT = "T_MBG_BGPERIOD_FACT";
    public static String HK_PERIOD_TABLE_CLOSURE = "T_MBG_DBGPERIOD_CLOSURE";

    public static String getClosureTableName(String dimNumber) {
        return "T_MBG_D" + ClosureUtils.getClosureName(dimNumber) + "_Closure";
    }

    public static String getFactTableName(String dimNumber) {
        return "T_MBG_D" + ClosureUtils.getFactName(dimNumber) + "_Fact";
    }

    private static String getClosureName(String dimNumber) {
        if (StringUtils.isEmpty((String)dimNumber)) {
            return "";
        }
        if ((dimNumber = dimNumber.replaceAll(" ", "").replaceAll("_", "")).length() > 15) {
            dimNumber = dimNumber.substring(0, 15);
        }
        return dimNumber;
    }

    private static String getFactName(String dimNumber) {
        if (StringUtils.isEmpty((String)dimNumber)) {
            return "";
        }
        if ((dimNumber = dimNumber.replaceAll(" ", "").replaceAll("_", "")).length() > 18) {
            dimNumber = dimNumber.substring(0, 18);
        }
        return dimNumber;
    }

    private String outTime(long startTime, long beginTime, long endTime) {
        return format.format(new String[]{String.valueOf(endTime - beginTime), String.valueOf(endTime - startTime)});
    }

    public void checkBgPeriodData(Context ctx, BOSUuid bgPeriodTypeId) throws BOSException, EASBizException {
        if (ctx == null || bgPeriodTypeId == null || "lVIAAABXqWlwHwZ1".equals(bgPeriodTypeId.toString())) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("fiscalYear");
        sic.add("selfDefined");
        BgPeriodTypeInfo bgPeriodType = BgPeriodTypeFactory.getLocalInstance((Context)ctx).getBgPeriodTypeInfo((IObjectPK)new ObjectUuidPK(bgPeriodTypeId));
        if (bgPeriodType == null || bgPeriodType.getFiscalYear() == null || 1 == bgPeriodType.getFiscalYear().getValue() && !bgPeriodType.isSelfDefined()) {
            return;
        }
        Connection conn = null;
        TempTablePool pool = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pool = TempTablePool.getInstance((Context)ctx);
            this.checkHKBgPeriodTable(conn);
            this.checkBgPeriodData(conn);
            List<BgPeriodInfo> bgPeriods = this.checkBgPeriodFact(conn, pool, bgPeriodType);
            this.checkBgPeriodClosure(conn, pool, bgPeriodType, bgPeriods);
        }
        catch (Exception ex) {
            logger.error((Object)"checkBgOrgClosure Sql Error", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void checkHKBgPeriodTable(Connection conn) throws SQLException {
        StringBuffer sql;
        int re = BgDBUtils.existTable((Connection)conn, (String)HK_PERIOD_TABLE_FACT);
        if (re == BgDBUtils.NO) {
            sql = new StringBuffer();
            sql.append("Create Table " + HK_PERIOD_TABLE_FACT + " (FID VARCHAR(44) DEFAULT '' NOT NULL, FNUMBER NVARCHAR(80) DEFAULT '' NOT NULL, FLongNumber NVARCHAR(1000) DEFAULT '' NOT NULL, FPeriodType INT DEFAULT 0 NOT NULL, FBeginDate DateTime, FEndDate DateTime, FTypeID VARCHAR(44) DEFAULT '' NOT NULL, FPARENTID VARCHAR(44), CONSTRAINT PK_MBG_BgPeriodHK PRIMARY KEY (FID, FTypeID))");
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
            re = BgDBUtils.existIndex((Connection)conn, (String)HK_PERIOD_TABLE_FACT, (String)"IX_MBG_BgPeriodHK");
            if (re == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("CREATE INDEX IX_MBG_BgPeriodHK ON " + HK_PERIOD_TABLE_FACT + " (FNumber ASC)"));
            }
            if ((re = BgDBUtils.existIndex((Connection)conn, (String)HK_PERIOD_TABLE_FACT, (String)"IX_MBG_BgPeriodHKP")) == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("CREATE INDEX IX_MBG_BgPeriodHKP ON " + HK_PERIOD_TABLE_FACT + " (FPARENTID ASC)"));
            }
            if ((re = BgDBUtils.existIndex((Connection)conn, (String)HK_PERIOD_TABLE_FACT, (String)"IX_MBG_BgPeriodHKT")) == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("CREATE INDEX IX_MBG_BgPeriodHKT ON " + HK_PERIOD_TABLE_FACT + " (FTypeID ASC)"));
            }
        }
        if ((re = BgDBUtils.existTable((Connection)conn, (String)HK_PERIOD_TABLE_CLOSURE)) == BgDBUtils.NO) {
            String ixIndex;
            sql = new StringBuffer();
            sql.append("Create Table " + HK_PERIOD_TABLE_CLOSURE + " (FID VARCHAR(44) DEFAULT '' NOT NULL, FChildId VARCHAR(44) DEFAULT '' NOT NULL, distance INT DEFAULT 0 NOT NULL)");
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
            String uxIndex = "UX_MBG_BgPeriodCHK";
            int check = BgDBUtils.existIndex((Connection)conn, (String)HK_PERIOD_TABLE_CLOSURE, (String)uxIndex);
            if (check == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("CREATE UNIQUE INDEX " + uxIndex + " ON " + HK_PERIOD_TABLE_CLOSURE + " (FID, FChildId)"));
            }
            if ((check = BgDBUtils.existIndex((Connection)conn, (String)HK_PERIOD_TABLE_CLOSURE, (String)(ixIndex = "IX_MBG_BgPeriodCHK"))) == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("CREATE INDEX " + ixIndex + " ON " + HK_PERIOD_TABLE_CLOSURE + " (FChildId)"));
            }
        }
    }

    private void checkBgPeriodData(Connection conn) throws SQLException {
        if (conn == null) {
            return;
        }
        BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + HK_PERIOD_TABLE_CLOSURE + " where not exists (select FID from T_MBG_BGPeriod where FID = " + HK_PERIOD_TABLE_CLOSURE + ".FID)"));
    }

    private List<BgPeriodInfo> checkBgPeriodFact(Connection conn, TempTablePool pool, BgPeriodTypeInfo bgPeriodType) throws Exception {
        IRowSet rst;
        String tmpTableName;
        ArrayList<BgPeriodInfo> bgPeriods;
        block18: {
            bgPeriods = new ArrayList<BgPeriodInfo>();
            if (conn == null || bgPeriodType == null) {
                return bgPeriods;
            }
            String bgTypeId = bgPeriodType.getId().toString();
            tmpTableName = null;
            BgPeriodInfo bgPeriod = null;
            HashMap<BOSUuid, BOSUuid> bgPeriodIdMap = new HashMap<BOSUuid, BOSUuid>();
            PreparedStatement pstmt = null;
            rst = null;
            try {
                BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + HK_PERIOD_TABLE_FACT + " where FTypeID = ?"), (Object[])new Object[]{bgTypeId});
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID, FBgPeriodId, FNumber, FLongNumber, FPeriodType, FBeginDate, FEndDate, FParentId from T_MBG_BgPeriodDisp where FTypeID = ? order by FLongNumber", (Object[])new Object[]{bgTypeId});
                while (rst.next()) {
                    bgPeriod = new BgPeriodInfo();
                    bgPeriod.setId(BOSUuid.read((String)rst.getString("FBgPeriodId")));
                    bgPeriod.setName(rst.getString("FNumber"));
                    bgPeriod.setNumber(rst.getString("FNumber"));
                    bgPeriod.setLongNumber(rst.getString("FLongNumber"));
                    bgPeriod.setPeriodType(BgPeriodEnum.getEnum((int)rst.getInt("FPeriodType")));
                    bgPeriod.setBeginDate((Date)rst.getDate("FBeginDate"));
                    bgPeriod.setEndDate((Date)rst.getDate("FEndDate"));
                    if (!StringUtils.isEmpty((String)rst.getString("FParentId"))) {
                        bgPeriod.setParent(new BgPeriodInfo());
                        bgPeriod.getParent().setId(BOSUuid.read((String)rst.getString("FParentId")));
                    }
                    bgPeriods.add(bgPeriod);
                    bgPeriodIdMap.put(BOSUuid.read((String)rst.getString("FID")), bgPeriod.getId());
                }
                SQLUtils.cleanup((ResultSet)rst);
                int in = bgPeriods.size();
                for (int i = 0; i < in; ++i) {
                    bgPeriod = (BgPeriodInfo)bgPeriods.get(i);
                    if (bgPeriod.getParent() == null || bgPeriod.getParent().getId() == null) continue;
                    bgPeriod.getParent().setId((BOSUuid)bgPeriodIdMap.get(bgPeriod.getParent().getId()));
                }
                StringBuffer sql = new StringBuffer();
                sql.append("Create Table TEML_KSQL_0 (FID VARCHAR(44) DEFAULT '' NOT NULL, FNUMBER NVARCHAR(80) DEFAULT '' NOT NULL, FLongNumber NVARCHAR(1000) DEFAULT '' NOT NULL, FPeriodType INT DEFAULT 0 NOT NULL, FBeginDate DateTime, FEndDate DateTime, FTypeID VARCHAR(44) DEFAULT '' NOT NULL, FPARENTID VARCHAR(44))");
                tmpTableName = pool.createDBSystemTempTable(sql.toString(), conn);
                if (tmpTableName == null) break block18;
                pstmt = conn.prepareStatement("Insert Into " + tmpTableName + " (FID, FNUMBER, FLongNumber, FPeriodType, FBeginDate, FEndDate, FTypeID, FPARENTID) values (?,?,?,?,?,?,?,?)");
                int batchIndex = 0;
                int in2 = bgPeriods.size();
                for (int i = 0; i < in2; ++i) {
                    bgPeriod = (BgPeriodInfo)bgPeriods.get(i);
                    pstmt.setString(1, bgPeriod.getId().toString());
                    pstmt.setString(2, bgPeriod.getNumber());
                    pstmt.setString(3, bgPeriod.getLongNumber());
                    pstmt.setInt(4, bgPeriod.getPeriodType().getValue());
                    pstmt.setTimestamp(5, bgPeriod.getBeginDate() == null ? null : new Timestamp(bgPeriod.getBeginDate().getTime()));
                    pstmt.setTimestamp(6, bgPeriod.getBeginDate() == null ? null : new Timestamp(bgPeriod.getEndDate().getTime()));
                    pstmt.setString(7, bgTypeId);
                    if (bgPeriod.getParent() != null) {
                        pstmt.setString(8, bgPeriod.getParent().getId().toString());
                    } else {
                        pstmt.setString(8, null);
                    }
                    pstmt.addBatch();
                    if (++batchIndex < 50) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                }
                SQLUtils.cleanup((Statement)pstmt);
                BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + HK_PERIOD_TABLE_FACT + "(FID, FNUMBER, FLongNumber, FPeriodType, FBeginDate, FEndDate, FTypeID, FPARENTID) select FID, FNUMBER, FLongNumber, FPeriodType, FBeginDate, FEndDate, FTypeID, FPARENTID from " + tmpTableName + " where not exists (select FID from " + HK_PERIOD_TABLE_FACT + " where FID = " + tmpTableName + ".FID and FTypeID = " + tmpTableName + ".FTypeID)"));
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)"checkBgPeriodFact Error:", (Throwable)ex);
                    throw ex;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    if (pool != null) {
                        try {
                            pool.releaseDBSystemTempTable(tmpTableName, conn);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        if (pool != null) {
            try {
                pool.releaseDBSystemTempTable(tmpTableName, conn);
            }
            catch (Exception sql) {}
        }
        return bgPeriods;
    }

    private void checkBgPeriodClosure(Connection conn, TempTablePool pool, BgPeriodTypeInfo bgPeriodType, List<BgPeriodInfo> bgPeriods) throws Exception {
        if (conn == null || pool == null || bgPeriodType == null || bgPeriods == null || bgPeriods.isEmpty()) {
            return;
        }
        ClosureObject object = null;
        ArrayList<ClosureObject> closures = new ArrayList<ClosureObject>();
        for (BgPeriodInfo bgPeriod : bgPeriods) {
            object = new ClosureObject();
            object.setId(bgPeriod.getId().toString());
            object.setNumber(bgPeriod.getNumber());
            object.setLongNumber(bgPeriod.getLongNumber());
            if (bgPeriod.getParent() != null) {
                object.setParentId(bgPeriod.getParent().getId().toString());
            }
            closures.add(object);
        }
        Map<String, ClosureData> closureMap = this.getClosureDataMap(closures);
        List<ClosureData> closureDatas = this.ergodicClosureData(closureMap);
        this.saveClosureData(conn, pool, HK_PERIOD_TABLE_CLOSURE, closureDatas);
    }

    protected Map<String, ClosureData> getClosureDataMap(List<ClosureObject> closures) {
        if (closures == null || closures.isEmpty()) {
            return null;
        }
        HashMap<String, ClosureData> dataMap = new HashMap<String, ClosureData>();
        ClosureObject object = null;
        ClosureData data = null;
        int in = closures.size();
        block0: for (int i = 0; i < in; ++i) {
            object = closures.get(i);
            if (object.getParentId() == null || object.getId().equals(object.getParentId())) {
                dataMap.put(object.getLongNumber(), new ClosureData(object));
                continue;
            }
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : dataMap.entrySet()) {
                if (!object.getLongNumber().startsWith((String)entry2.getKey())) continue;
                data = (ClosureData)entry2.getValue();
                data.addChildren(object);
                continue block0;
            }
        }
        return dataMap;
    }

    protected Map<String, ClosureData> getClosureDataMapByNumber(List<ClosureObject> closures) {
        if (closures == null || closures.isEmpty()) {
            return null;
        }
        HashMap<String, ClosureData> dataMap = new HashMap<String, ClosureData>();
        ClosureObject object = null;
        ClosureData data = null;
        int in = closures.size();
        block0: for (int i = 0; i < in; ++i) {
            object = closures.get(i);
            if (object.getNumber().equals(object.getParentNumber())) {
                dataMap.put(object.getLongNumber(), new ClosureData(object));
                continue;
            }
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : dataMap.entrySet()) {
                if (object.getLongNumber() == null || !object.getLongNumber().startsWith((String)entry2.getKey())) continue;
                data = (ClosureData)entry2.getValue();
                data.addChildrenByNumber(object);
                continue block0;
            }
        }
        return dataMap;
    }

    protected List<ClosureData> ergodicClosureData(Map<String, ClosureData> closureDataMap) {
        if (closureDataMap == null || closureDataMap.isEmpty()) {
            return null;
        }
        ClosureData closureData2 = null;
        ClosureData _tmpData = null;
        ArrayList<ClosureData> closureDatas = new ArrayList<ClosureData>();
        for (ClosureData closureData2 : closureDataMap.values()) {
            if (!closureData2.getObject().isVirtual()) {
                _tmpData = new ClosureData();
                _tmpData.getObject().setId(closureData2.getObject().getId());
                _tmpData.getObject().setParentId(closureData2.getObject().getId());
                _tmpData.getObject().setNumber(closureData2.getObject().getNumber());
                _tmpData.getObject().setParentNumber(closureData2.getObject().getNumber());
                _tmpData.getObject().setLongNumber(closureData2.getObject().getNumber() + "_" + closureData2.getObject().getNumber());
                _tmpData.setLevel(closureData2.getLevel());
                closureDatas.add(_tmpData);
            }
            this.ergodicClosureData(closureData2, closureDatas);
        }
        return closureDatas;
    }

    private void ergodicClosureData(ClosureData closureData, List<ClosureData> closureDatas) {
        if (closureData == null || closureDatas == null) {
            return;
        }
        this.ergodicClosureData(closureData, closureData.getChildren(), closureDatas);
        if (!closureData.getChildren().isEmpty()) {
            ClosureData _tmpData = null;
            ClosureData _closureData2 = null;
            for (ClosureData _closureData2 : closureData.getChildren().values()) {
                if (!_closureData2.getObject().isVirtual()) {
                    _tmpData = new ClosureData();
                    _tmpData.getObject().setId(_closureData2.getObject().getId());
                    _tmpData.getObject().setParentId(_closureData2.getObject().getId());
                    _tmpData.getObject().setNumber(_closureData2.getObject().getNumber());
                    _tmpData.getObject().setParentNumber(_closureData2.getObject().getNumber());
                    _tmpData.getObject().setLongNumber(_closureData2.getObject().getNumber() + "_" + _closureData2.getObject().getNumber());
                    _tmpData.setLevel(_closureData2.getLevel() - _closureData2.getLevel());
                    closureDatas.add(_tmpData);
                }
                this.ergodicClosureData(_closureData2, closureDatas);
            }
        }
    }

    private void ergodicClosureData(ClosureData root, Map<String, ClosureData> children, List<ClosureData> closureDatas) {
        if (root == null || children == null || closureDatas == null) {
            return;
        }
        ClosureData _tmpData = null;
        ClosureData _closureData2 = null;
        for (ClosureData _closureData2 : children.values()) {
            if (!_closureData2.getObject().isVirtual()) {
                _tmpData = new ClosureData();
                _tmpData.getObject().setId(_closureData2.getObject().getId());
                _tmpData.getObject().setParentId(root.getObject().getId());
                _tmpData.getObject().setNumber(_closureData2.getObject().getNumber());
                _tmpData.getObject().setParentNumber(root.getObject().getNumber());
                _tmpData.getObject().setLongNumber(root.getObject().getNumber() + "_" + _closureData2.getObject().getNumber());
                _tmpData.setLevel(_closureData2.getLevel() - root.getLevel());
                closureDatas.add(_tmpData);
            }
            this.ergodicClosureData(root, _closureData2.getChildren(), closureDatas);
        }
    }

    protected void saveClosureData(Connection conn, TempTablePool pool, String closureName, List<ClosureData> closureDatas) throws Exception {
        if (conn == null || StringUtils.isEmpty((String)closureName) || closureDatas == null || closureDatas.isEmpty()) {
            return;
        }
        long _beginTime = System.currentTimeMillis();
        logger.info((Object)"invoke begin process ClosureTable Data!");
        String tmpTableName = null;
        ClosureData closureData = null;
        int batchIndex = 0;
        PreparedStatement pstmt = null;
        try {
            tmpTableName = pool.createDBSystemTempTable("Create Table TEML_KSQL_0 (FID VARCHAR(44) DEFAULT '' NOT NULL, FChildId VARCHAR(44) DEFAULT '' NOT NULL, distance INT DEFAULT 0 NOT NULL)", conn);
            if (tmpTableName != null) {
                pstmt = conn.prepareStatement("Insert Into " + tmpTableName + "(FID, FChildId, distance) values (?, ?, ?)");
                int in = closureDatas.size();
                for (int i = 0; i < in; ++i) {
                    closureData = closureDatas.get(i);
                    pstmt.setString(1, closureData.getObject().getParentId());
                    pstmt.setString(2, closureData.getObject().getId());
                    pstmt.setInt(3, closureData.getLevel());
                    pstmt.addBatch();
                    if (++batchIndex <= 50) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                }
                SQLUtils.cleanup((Statement)pstmt);
                StringBuffer sql = new StringBuffer();
                sql.append("Insert Into " + closureName + "(FID, FChildId, distance) Select a.FID, a.FChildId, a.distance from " + tmpTableName + " a where not exists (select * from " + closureName + " b where a.FID = b.FID and a.FChildId = b.FChildId)");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"insert BgPeriod Closure Data Error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup(pstmt);
            try {
                pool.releaseDBSystemTempTable(tmpTableName, conn);
            }
            catch (Exception exception) {}
        }
        long _endTime = System.currentTimeMillis();
        logger.info((Object)"invoke end process ClosureTable Data!");
        logger.info((Object)this.outTime(_beginTime, _beginTime, _endTime));
    }
}

