/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.dimension.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;

public class MetaUtils {
    public static EntityObjectInfo getEntity(Context ctx, BOSObjectType type) {
        if (ctx == null || type == null) {
            return null;
        }
        return MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)type);
    }

    public static EntityObjectInfo getEntity(BOSObjectType type) {
        if (type == null) {
            return null;
        }
        return MetaDataLoader.getEntity(null, (BOSObjectType)type);
    }

    public static DataTableInfo getEntityTable(EntityObjectInfo entity) {
        if (entity != null) {
            return entity.getTable();
        }
        return null;
    }

    public static ColumnInfo getEntityColumn(EntityObjectInfo entity, String columnName) {
        DataTableInfo table = MetaUtils.getEntityTable(entity);
        if (table != null) {
            return table.getColumnByName(columnName);
        }
        return null;
    }

    public static String getEntityTableName(EntityObjectInfo entity) {
        DataTableInfo table = MetaUtils.getEntityTable(entity);
        if (table != null) {
            return table.getName();
        }
        return null;
    }

    public static String getPropertyAlias(EntityObjectInfo entity, String propertyName) {
        String alias = "";
        if (entity == null || StringUtils.isEmpty((String)propertyName)) {
            return alias;
        }
        String[] tmpStrs = propertyName.split("\\.");
        if (tmpStrs != null) {
            PropertyInfo prop = null;
            EntityObjectInfo _entity = entity;
            int in = tmpStrs.length;
            block0: for (int i = 0; i < in; ++i) {
                PropertyCollection props = _entity.getInheritedProperties();
                int jn = props.size();
                for (int j = 0; j < jn; ++j) {
                    EntityObjectInfo _supplier;
                    prop = props.get(j);
                    if (!prop.getName().equalsIgnoreCase(tmpStrs[i])) continue;
                    alias = alias + prop.getAlias() + ".";
                    if (!(prop instanceof LinkPropertyInfo)) continue block0;
                    LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
                    RelationshipInfo relation = linkProp.getRelationship();
                    _entity = _supplier = relation.getSupplierObject();
                    continue block0;
                }
            }
        }
        if (!StringUtils.isEmpty((String)alias) && alias.length() > 0) {
            alias = alias.substring(0, alias.length() - 1);
        }
        return alias;
    }

    public static boolean checkTreeEntity(EntityObjectInfo entity) {
        if (entity == null) {
            return false;
        }
        if (entity.getName().equalsIgnoreCase("TreeBase")) {
            return true;
        }
        if (entity.getBaseEntity() != null) {
            return MetaUtils.checkTreeEntity(entity.getBaseEntity());
        }
        return false;
    }

    public static SQLType getFieldDataType(EntityObjectInfo entity, String columnName) {
        if (entity == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        ColumnInfo column = MetaUtils.getEntityColumn(entity, columnName);
        if (column != null) {
            return column.getTypeName();
        }
        return null;
    }
}

