/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.dimension.vo;

import com.kingdee.eas.ma.mbg.dimension.vo.ClosureObject;
import java.util.HashMap;
import java.util.Map;

public class ClosureData {
    private ClosureObject object = null;
    private Map<String, ClosureData> children = null;
    private int level = 0;

    public ClosureData() {
        this.object = new ClosureObject();
    }

    public ClosureData(ClosureObject object) {
        this.object = object;
    }

    public void setObject(ClosureObject object) {
        this.object = object;
    }

    public ClosureObject getObject() {
        return this.object;
    }

    public void setChildren(Map<String, ClosureData> children) {
        this.children = children;
    }

    public Map<String, ClosureData> getChildren() {
        if (this.children == null) {
            this.children = new HashMap<String, ClosureData>();
        }
        return this.children;
    }

    public void addChildren(ClosureObject object) {
        if (object == null) {
            return;
        }
        if (object.getParentId().equals(this.getObject().getId())) {
            object.setParentNumber(this.getObject().getNumber());
            if (!this.getChildren().containsKey(object.getLongNumber())) {
                ClosureData data = new ClosureData(object);
                data.setLevel(this.getLevel() + 1);
                this.getChildren().put(object.getLongNumber(), data);
            }
        } else {
            this.addChildren(this, object);
        }
    }

    private void addChildren(ClosureData data, ClosureObject object) {
        if (data == null || object == null) {
            return;
        }
        Map.Entry<String, ClosureData> entry2 = null;
        String longnumber = null;
        ClosureData closureData = null;
        for (Map.Entry<String, ClosureData> entry2 : data.getChildren().entrySet()) {
            longnumber = entry2.getKey();
            closureData = entry2.getValue();
            if (object.getParentId().equals(closureData.getObject().getId())) {
                closureData.addChildren(object);
                continue;
            }
            if (!object.getLongNumber().startsWith(longnumber)) continue;
            this.addChildren(closureData, object);
        }
    }

    public void addChildrenByNumber(ClosureObject object) {
        if (object == null) {
            return;
        }
        if (object.getParentNumber().equals(this.getObject().getNumber())) {
            if (!this.getChildren().containsKey(object.getLongNumber())) {
                ClosureData data = new ClosureData(object);
                data.setLevel(this.getLevel() + 1);
                this.getChildren().put(object.getLongNumber(), data);
            }
        } else {
            this.addChildrenByNumber(this, object);
        }
    }

    private void addChildrenByNumber(ClosureData data, ClosureObject object) {
        if (data == null || object == null) {
            return;
        }
        Map.Entry<String, ClosureData> entry2 = null;
        String longnumber = null;
        ClosureData closureData = null;
        for (Map.Entry<String, ClosureData> entry2 : data.getChildren().entrySet()) {
            longnumber = entry2.getKey();
            closureData = entry2.getValue();
            if (object.getParentNumber().equals(closureData.getObject().getNumber())) {
                closureData.addChildrenByNumber(object);
                continue;
            }
            if (!object.getLongNumber().startsWith(longnumber)) continue;
            this.addChildrenByNumber(closureData, object);
        }
    }

    public void addChildrenById(ClosureObject object) {
        if (object == null) {
            return;
        }
        if (object.getParentId().equals(this.getObject().getId())) {
            if (!this.getChildren().containsKey(object.getLongNumber())) {
                ClosureData data = new ClosureData(object);
                data.setLevel(this.getLevel() + 1);
                this.getChildren().put(object.getLongNumber(), data);
            }
        } else {
            this.addChildrenById(this, object);
        }
    }

    private void addChildrenById(ClosureData data, ClosureObject object) {
        if (data == null || object == null) {
            return;
        }
        Map.Entry<String, ClosureData> entry2 = null;
        String longnumber = null;
        ClosureData closureData = null;
        for (Map.Entry<String, ClosureData> entry2 : data.getChildren().entrySet()) {
            longnumber = entry2.getKey();
            closureData = entry2.getValue();
            if (object.getParentId().equals(closureData.getObject().getId())) {
                closureData.addChildrenById(object);
                continue;
            }
            if (!object.getLongNumber().startsWith(longnumber)) continue;
            this.addChildrenById(closureData, object);
        }
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }
}

