/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.parse;

import com.kingdee.eas.ma.biz.BizCalcParseException;
import com.kingdee.eas.ma.biz.expr.oper.AbstractOper;
import com.kingdee.eas.ma.biz.parse.AbstractBizChecker;
import com.kingdee.eas.ma.biz.parse.BizParseParam;
import com.kingdee.eas.ma.biz.parse.operand.impl.Operand;
import com.kingdee.eas.ma.mbg.BgExamineParseException;
import com.kingdee.eas.ma.mbg.parse.BgExamineParseExceptionHandler;
import com.kingdee.eas.ma.mbg.parse.Parse2RPN;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class BgExamineExprChecker
extends AbstractBizChecker {
    private BizParseParam param = null;
    private Integer currLine = null;
    private String text = null;
    private String bizName = null;
    private String subsetName = null;
    private static Set<String> ILLEGAL_OPER = new HashSet<String>();
    public static Set<String> LEGAL_OPER = new HashSet<String>();

    public BgExamineExprChecker(BizParseParam param) {
        Collections.addAll(ILLEGAL_OPER, "=", "IF", "ELSE", "NOT", "AND", "OR");
        Collections.addAll(LEGAL_OPER, "==", ">", "<", "<>", ">=", "<=");
        this.param = param;
        this.text = param.getText();
        this.currLine = param.getCurrLine();
        this.subsetName = param.getSubsetName();
    }

    public boolean check(Stack expr) {
        if (!this.checkToken(expr)) {
            this.recordException(BgExamineParseException.ERROR_EXPR, this.text.trim());
            return false;
        }
        Parse2RPN rpnParser = new Parse2RPN("", this.currLine, (Stack)expr.clone());
        try {
            rpnParser.parse();
            String type = rpnParser.getExprReturnType();
            if (!type.equals("boolean")) {
                this.recordException(BgExamineParseException.ERROR_EXPR, this.text.trim());
                return false;
            }
        }
        catch (BizCalcParseException e) {
            e.printStackTrace();
            this.recordException(BgExamineParseException.ERROR_EXPR, this.text.trim());
            return false;
        }
        return true;
    }

    protected boolean checkToken(Stack expr) {
        if (!super.checkToken(expr)) {
            return false;
        }
        boolean left = true;
        boolean leftOperand = false;
        for (int i = 0; i < expr.size(); ++i) {
            Object obj = expr.get(i);
            if (obj instanceof AbstractOper) {
                if (LEGAL_OPER.contains(((AbstractOper)obj).getOper())) {
                    if (left) {
                        left = false;
                        leftOperand = true;
                    } else {
                        return false;
                    }
                }
                if (!ILLEGAL_OPER.contains(((AbstractOper)obj).getOper())) continue;
                return false;
            }
            if (left) {
                if (!leftOperand) {
                    this.verifyExprLeft((Operand)obj);
                    continue;
                }
                return false;
            }
            this.verifyExprRight((Operand)obj);
        }
        return true;
    }

    private void verifyExprLeft(Operand operand) {
        if (this.isGVF(operand.getOperand())) {
            this.recordException(BgExamineParseException.EXPR_LEFT_GVF, operand.getOperand());
        }
    }

    private void verifyExprRight(Operand operand) {
    }

    private void recordException(NumericExceptionSubItem excSubItem, String charSeq) {
        BgExamineParseExceptionHandler.recordException(excSubItem, charSeq, this.param);
    }
}

