/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.utils.BgElementHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgFormTitleEnum;
import com.kingdee.eas.ma.mbg.BgNFormException;
import com.kingdee.eas.ma.mbg.IMbgViewListDesCell;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellCollection;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellFactory;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellInfo;
import com.kingdee.eas.ma.mbg.common.AbstractMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.DimensionMemberFilterInfo;
import com.kingdee.eas.ma.mbg.common.DimensionMemberFilterMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.common.ViewListBookParseHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.provider.AbstractProvider;
import com.kingdee.eas.ma.mbg.provider.IViewListProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MbgViewlistMeasureUnitHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class ViewListProvider
extends AbstractProvider<MbgViewListManager, MbgViewListSheetManager>
implements IViewListProvider {
    private static final Logger logger = Logger.getLogger((String)ViewListProvider.class.getName());
    protected ViewListBookParseHelper bookParseHelper;
    protected MbgViewListXMLParser parser = new MbgViewListXMLParser(this.getCtx());
    private TemplateStyleInfo templateStyle = null;
    protected String editOrgUnit = null;
    protected String editPeriod = null;
    private boolean insertRowDirection = false;
    private Map<String, Map<String, String>> propMaps = null;
    private Map<String, Set<String>> multiOrgFormulasMap = null;
    private Map<String, String> multiOrgCreatorMap = new HashMap<String, String>();
    public Map<String, Map<String, Map<String, MbgViewListDesCellInfo>>> syncDescs = null;
    protected Map<Integer, MbgViewListDesCellCollection> bgDescriptionColls = new HashMap<Integer, MbgViewListDesCellCollection>();
    protected Map<String, Map<String, MbgViewListDesCellInfo>> defaultDesMap = null;
    protected ViewListBookParseHelper oldBookParseHelper = null;
    private Set<Row> calcRowSet = new HashSet<Row>();
    Map<String, BgElementInfo> elementObjMap = null;

    public boolean isInsertRowDirection() {
        return this.insertRowDirection;
    }

    public void setInsertRowDirection(boolean insertRowDirection) {
        this.insertRowDirection = insertRowDirection;
    }

    public Map<String, Set<String>> getMultiOrgFormulasMap() {
        return this.multiOrgFormulasMap;
    }

    public void setMultiOrgFormulasMap(Map<String, Set<String>> multiOrgFormulasMap) {
        this.multiOrgFormulasMap = multiOrgFormulasMap;
    }

    public Map<String, String> getMultiOrgCreatorMap() {
        return this.multiOrgCreatorMap;
    }

    public void setMultiOrgCreatorMap(Map<String, String> multiOrgCreatorMap) {
        this.multiOrgCreatorMap = multiOrgCreatorMap;
    }

    public MbgViewListDesCellCollection getBgDescriptionColls(int sheetIndex) {
        if (!this.bgDescriptionColls.containsKey(sheetIndex)) {
            this.bgDescriptionColls.put(sheetIndex, new MbgViewListDesCellCollection());
        }
        return this.bgDescriptionColls.get(sheetIndex);
    }

    public Map<String, Map<String, Map<String, MbgViewListDesCellInfo>>> getBgDescriptionMap(Sheet sheet) throws Exception {
        HashMap result = new HashMap();
        Map<String, Map<String, Map<String, MbgViewListDesCellInfo>>> descMap = this.queryDescMap(sheet);
        return descMap;
    }

    public Map<String, Map<String, MbgViewListDesCellInfo>> getDefaultDesMap() throws BOSException {
        if (this.defaultDesMap == null) {
            this.defaultDesMap = new HashMap<String, Map<String, MbgViewListDesCellInfo>>();
            if (!this.isHasDefaultDesc()) {
                return this.defaultDesMap;
            }
            String billId = this.getBillId();
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("isFromTemplate", (Object)Boolean.TRUE, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)("Select FViewListDesId FROM T_MBG_MbgViewListDesCellEntry Where FBgFormId = '" + billId + "'"), CompareType.INNER));
            IMbgViewListDesCell desCell = null;
            desCell = this.getCtx() == null ? MbgViewListDesCellFactory.getRemoteInstance() : MbgViewListDesCellFactory.getLocalInstance(this.getCtx());
            MbgViewListDesCellCollection colls = desCell.getMbgViewListDesCellCollection(view);
            if (colls != null && !colls.isEmpty()) {
                MbgViewListDesCellInfo info = null;
                for (int index = 0; index < colls.size(); ++index) {
                    info = colls.get(index);
                    String orgId = info.getOrgUnitId().toString();
                    String rowColIndex = info.getSheetIndex() + ":" + String.valueOf(info.getRowIndex()) + ":" + String.valueOf(info.getColIndex());
                    String memberNumber = info.getMemberNumber();
                    BgViewHelper.getSubMap(this.defaultDesMap, rowColIndex, true).put(memberNumber, info);
                }
            }
        }
        return this.defaultDesMap;
    }

    protected boolean isHasDefaultDesc() {
        return false;
    }

    public MbgViewListDesCellCollection getAllBgDescriptionColls() {
        MbgViewListDesCellCollection col = new MbgViewListDesCellCollection();
        Iterator<MbgViewListDesCellCollection> it = this.bgDescriptionColls.values().iterator();
        while (it.hasNext()) {
            col.addCollection(it.next());
        }
        return col;
    }

    public void setEditOrgUnit(String editOrgUnit) {
        this.editOrgUnit = editOrgUnit;
    }

    public void setEditPeriod(String editPeriod) {
        this.editPeriod = editPeriod;
    }

    public void setPropMaps(Map<String, Map<String, String>> propMaps) {
        this.propMaps = propMaps;
    }

    public Map<String, Map<String, String>> getPropMaps() {
        return this.propMaps;
    }

    public void addOtherOrgViewData(FullOrgUnitInfo orgUnitInfo, MbgViewListManager mbgViewManager) {
        this.getBgViewManagerForMulOrg().put(orgUnitInfo.getNumber(), mbgViewManager);
        this.orgUnitMap.put(orgUnitInfo.getNumber(), orgUnitInfo);
    }

    public void resetBookParserHelper() {
        this.oldBookParseHelper = this.bookParseHelper;
        this.bookParseHelper = null;
    }

    @Override
    public ViewListBookParseHelper getBookParseHelper() {
        if (this.bookParseHelper == null) {
            this.bookParseHelper = new ViewListBookParseHelper(this.getBookDimensionParse(), this.getOrgUnitInfo(), this.getBgViewManagerForMulOrg(), this.orgUnitMap, this.isCheckFull(), this.getMemberFilter(), this.getCheckFactory().getCacheHelper());
            this.bookParseHelper.setCtx(this.getCtx());
            if (this.oldBookParseHelper != null) {
                this.bookParseHelper.getPagePnlMap().putAll(this.oldBookParseHelper.getPagePnlMap());
                this.bookParseHelper.getViewPnlMap().putAll(this.oldBookParseHelper.getViewPnlMap());
                this.oldBookParseHelper = null;
            }
        }
        this.bookParseHelper.setTemplateStyle(this.getTemplateStyle());
        this.bookParseHelper.setVersionNumber(this.getVersionNumber());
        if (this.getBgPeriod() != null) {
            this.bookParseHelper.setBgFormPeriodNumber(this.getBgPeriod().getNumber());
        }
        this.bookParseHelper.setOrgViewId(this.getOrgViewId());
        this.bookParseHelper.setEditScenType(this.getEditScenType());
        this.bookParseHelper.setSheetTitle(this.getSheetTitle());
        this.bookParseHelper.setEditOrgUnit(this.editOrgUnit);
        this.bookParseHelper.setEditPeriod(this.editPeriod);
        this.bookParseHelper.setPropMaps(this.propMaps);
        this.bookParseHelper.setAdapter(this.getReportAdapter());
        this.bookParseHelper.getOrgUnitMap().putAll(this.getOrgUnitMap());
        this.bookParseHelper.getMultiOrgCreatorMap().putAll(this.getMultiOrgCreatorMap());
        try {
            this.bookParseHelper.getElementObjMap().putAll(this.getElementoObjMap());
            this.bookParseHelper.setSchemeHelper(this.getSchemeHelper());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return this.bookParseHelper;
    }

    protected abstract IReportPropertyAdapter getReportAdapter();

    @Override
    public boolean isCheckFull() {
        return false;
    }

    protected String getSheetTitle() {
        return null;
    }

    public void setTemplateStyle(TemplateStyleInfo templateStyle) {
        this.templateStyle = templateStyle;
    }

    public TemplateStyleInfo getTemplateStyle() {
        return this.templateStyle;
    }

    public TemplateStyleInfo getTemplateStyle(IDimDataQuery info) {
        return this.templateStyle;
    }

    @Override
    public List<KDPromptBox> getPageF7List(int sheetIndex) {
        return this.getBookParseHelper().getPageF7List(sheetIndex);
    }

    @Override
    public List<KDPromptBox> getViewF7List(int sheetIndex) {
        return this.getBookParseHelper().getViewF7List(sheetIndex);
    }

    public MbgViewListXMLParser getParser() {
        return this.parser;
    }

    @Override
    public MbgViewListDimensionManager getBgDimensionManager() {
        return ((MbgViewListSheetManager)this.getCurMbgSheetManager()).getDimensionManager();
    }

    protected void storeDesCellValue(Cell cell, MbgViewListDesCellCollection desCellCol, boolean isTemplateSheet, Map<String, Map<String, Map<String, MbgViewListDesCellInfo>>> bgDescriptionMap) throws Exception {
        if (MbgViewListDescriptionHelper.checkHashDescriptionFormula(cell)) {
            Row row = cell.getSheet().getRow(cell.getRow(), false);
            Column col = cell.getSheet().getColumn(cell.getCol(), false);
            AbstractMbgViewListObject rowObject = (AbstractMbgViewListObject)ViewListHelper.getDimension(row);
            AbstractMbgViewListObject colObject = (AbstractMbgViewListObject)ViewListHelper.getDimension(col);
            int rowIndex = rowObject.getInitIndex() >= 0 ? rowObject.getInitIndex() : rowObject.getIndex();
            int colIndex = colObject.getInitIndex() >= 0 ? colObject.getInitIndex() : colObject.getIndex();
            String value = null;
            if (cell != null) {
                if (BgNFSHelper.getValue(cell) != null && (value = String.valueOf(BgNFSHelper.getValue(cell))).length() > 2000) {
                    throw new BgNFormException(BgNFormException.DESCRIPTIONLONG, new String[]{cell.getName(false, false)});
                }
                String orgId = MbgViewListDescriptionHelper.getDescriptionOrgUnitId(cell);
                if (!BOSUuid.isValidLength((String)orgId)) {
                    orgId = this.getOrgUnitId();
                }
                String descFormula = MbgViewListDescriptionHelper.getDescriptionFormula(cell);
                if (cell.getUserObject("description_object") != null && cell.getUserObject("description_object").getValue() instanceof MbgViewListDesCellInfo) {
                    MbgViewListDesCellInfo desCellInfo = (MbgViewListDesCellInfo)cell.getUserObject("description_object").getValue();
                    if (!desCellInfo.getMemberNumber().equals(descFormula)) {
                        desCellInfo.setValue(null);
                        desCellCol.add(desCellInfo);
                        String rowColIndex = String.valueOf(desCellInfo.getRowIndex()) + ":" + String.valueOf(desCellInfo.getColIndex()) + "@" + desCellInfo.getMemberNumber();
                        Map<String, Map<String, MbgViewListDesCellInfo>> map = null;
                        Map<String, MbgViewListDesCellInfo> map2 = null;
                        if (bgDescriptionMap != null) {
                            for (String orgUnitId : bgDescriptionMap.keySet()) {
                                map = bgDescriptionMap.get(orgUnitId);
                                if (!map.containsKey(rowColIndex) || (map2 = map.get(rowColIndex)) == null || map2.isEmpty()) continue;
                                for (String memberNumber : map2.keySet()) {
                                    map2.get(memberNumber).setValue(null);
                                    desCellCol.add(map2.get(memberNumber));
                                }
                            }
                        }
                        if (BgNFSHelper.getValue(cell) != null) {
                            desCellInfo = this.createDescInfo(orgId, descFormula, cell.getSheet().getSheetIndex(), rowIndex, colIndex);
                            desCellInfo.setValue(String.valueOf(BgNFSHelper.getValue(cell)));
                            desCellCol.add(desCellInfo);
                        }
                    } else if (BgNFSHelper.getValue(cell) != null) {
                        value = String.valueOf(BgNFSHelper.getValue(cell));
                        if (!value.equals(desCellInfo.getValue()) || isTemplateSheet) {
                            desCellInfo.setValue(value);
                            desCellCol.add(desCellInfo);
                        }
                    } else {
                        desCellInfo.setValue(null);
                        desCellCol.add(desCellInfo);
                    }
                } else if (BgNFSHelper.getValue(cell) != null) {
                    MbgViewListDesCellInfo desCellInfo = this.createDescInfo(orgId, descFormula, cell.getSheet().getSheetIndex(), rowIndex, colIndex);
                    desCellInfo.setValue(String.valueOf(BgNFSHelper.getValue(cell)));
                    desCellCol.add(desCellInfo);
                }
            }
        }
    }

    protected void storeDesCellValue(Cell cell, MbgViewListDesCellCollection desCellCol, boolean isTemplateSheet) throws Exception {
        this.storeDesCellValue(cell, desCellCol, isTemplateSheet, null);
    }

    protected MbgViewListDesCellInfo createDescInfo(String orgId, String descFormula, int sheetIndex, int rowIndex, int colIndex) {
        MbgViewListDesCellInfo desCellInfo = new MbgViewListDesCellInfo();
        desCellInfo.setBgSchemeId(BOSUuid.read((String)this.getBgSchemeId()));
        desCellInfo.setBgTemplateId(this.getBgTemplateId());
        desCellInfo.setVersionId(this.getBgVersionId());
        desCellInfo.setBgPeriodId(this.getBgPeriodId());
        desCellInfo.setCurrencyId(this.getCurrencyId());
        desCellInfo.setOrgUnitId(BOSUuid.read((String)orgId));
        desCellInfo.setMemberNumber(descFormula);
        desCellInfo.setSheetIndex(sheetIndex);
        desCellInfo.setRowIndex(rowIndex);
        desCellInfo.setColIndex(colIndex);
        if (this.getActualPeriodId() != null) {
            desCellInfo.setActualPeriodId(BOSUuid.read((String)this.getActualPeriodId()));
        }
        return desCellInfo;
    }

    public Map<String, Map<String, Map<String, MbgViewListDesCellInfo>>> queryDescMap(Sheet sheet) throws Exception {
        String bgPeriodId;
        HashMap<String, Map<String, Map<String, MbgViewListDesCellInfo>>> desMap = new HashMap<String, Map<String, Map<String, MbgViewListDesCellInfo>>>();
        Set<Object> billIds = new HashSet<String>();
        boolean isOrgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheet.getIndex())).getDimensionManager());
        Object editValue = this.getEditValue();
        if (editValue instanceof BgActualRecordInfo) {
            editValue = ((BgActualRecordInfo)editValue).getBgForm();
        }
        if (editValue instanceof BgFormInfo) {
            HashSet<String> orgNums = new HashSet<String>();
            String curOrgNumForDimensionData = this.getOrgNumsForCurSheet(sheet.getIndex(), orgNums);
            orgNums.add(curOrgNumForDimensionData);
            billIds = MBGViewListFormCommonHelper.getBgFormIds(this.getCtx(), (BgFormInfo)editValue, orgNums, null);
            if (billIds.isEmpty()) {
                billIds.add(this.getBillId());
            }
            if ((((BgFormInfo)editValue).getState().equals((Object)BgFormStateEnum.Adjusted) || ((BgFormInfo)editValue).getState().equals((Object)BgFormStateEnum.RollEdited)) && ((BgFormInfo)editValue).getAdjustId() != null) {
                billIds.add(((BgFormInfo)editValue).getAdjustId().toString());
            } else {
                BgFormInfo info = (BgFormInfo)editValue;
                if (!info.getId().toString().equals(info.getAdjustId().toString())) {
                    billIds.add(info.getAdjustId().toString());
                }
                billIds.add(info.getId().toString());
            }
        } else {
            billIds.add(this.getBillId());
        }
        String bgSchemeId = this.getBgSchemeId();
        String bgTemplateId = this.getBgTemplateId() == null ? null : this.getBgTemplateId().toString();
        String versionId = this.getBgVersionId() == null ? null : this.getBgVersionId().toString();
        String string = bgPeriodId = this.getBgPeriodId() == null ? null : this.getBgPeriodId().toString();
        if (this.getOwner() != null && this.getOwner().getOprtState() != null && this.getOwner().getOprtState().equals(OprtState.ADDNEW)) {
            bgPeriodId = null;
        }
        String currencyId = this.getCurrencyId() == null ? null : this.getCurrencyId().toString();
        String actualPeriodId = this.getActualPeriodId();
        Map queryMap = MbgViewListDescriptionHelper.getQueryMap(sheet);
        HashSet orgids = new HashSet();
        orgids.addAll(queryMap.keySet());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgSchemeId", (Object)bgSchemeId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgTemplateId", (Object)bgTemplateId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("versionId", (Object)versionId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriodId", (Object)bgPeriodId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("actualPeriodId", (Object)actualPeriodId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("currencyId", (Object)currencyId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("sheetIndex", (Object)sheet.getSheetIndex(), CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitId", orgids, CompareType.INCLUDE));
        if (billIds.size() > 1) {
            String billId = StringUtils.arrayToString((Object[])billIds.toArray(), (String)"','");
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)("SELECT FVIEWLISTDESID FROM T_MBG_MbgViewListDesCellEntry where FBGFORMID in ('" + billId + "')"), CompareType.INNER));
        } else {
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)("SELECT FVIEWLISTDESID FROM T_MBG_MbgViewListDesCellEntry where FBGFORMID = '" + billIds.toArray()[0] + "'"), CompareType.INNER));
        }
        IMbgViewListDesCell descCell = null;
        descCell = this.getCtx() == null ? MbgViewListDesCellFactory.getRemoteInstance() : MbgViewListDesCellFactory.getLocalInstance(this.getCtx());
        MbgViewListDesCellCollection colls = descCell.getMbgViewListDesCellCollection(view);
        if (colls != null && !colls.isEmpty()) {
            MbgViewListDesCellInfo info = null;
            for (int index = 0; index < colls.size(); ++index) {
                info = colls.get(index);
                String orgId = info.getOrgUnitId().toString();
                String rowColIndex = String.valueOf(info.getRowIndex()) + ":" + String.valueOf(info.getColIndex());
                String memberNumber = info.getMemberNumber();
                rowColIndex = rowColIndex + "@" + memberNumber;
                if (!desMap.containsKey(orgId)) {
                    desMap.put(orgId, new HashMap());
                }
                if (!BgViewHelper.getSubMap((Map)desMap.get(orgId), rowColIndex, true).containsKey(rowColIndex)) {
                    ((Map)desMap.get(orgId)).put(rowColIndex, new HashMap());
                }
                if (((Map)((Map)desMap.get(orgId)).get(rowColIndex)).containsKey(memberNumber)) continue;
                ((Map)((Map)desMap.get(orgId)).get(rowColIndex)).put(memberNumber, info);
            }
        }
        return desMap;
    }

    protected int calculateHeaderRowCount() {
        if (this.templateStyle == null) {
            return -1;
        }
        int rowIndex = -1;
        if (!BgFormTitleEnum.DontDisplay.equals((Object)this.templateStyle.getBgFormTitle())) {
            rowIndex = 0;
        }
        if (!StringUtils.isEmpty((String)this.templateStyle.getUnitName()) && rowIndex < this.templateStyle.getUnitPosition()) {
            rowIndex = this.templateStyle.getUnitPosition();
        }
        if (!StringUtils.isEmpty((String)this.templateStyle.getDateName()) && rowIndex < this.templateStyle.getDatePosition()) {
            rowIndex = this.templateStyle.getDatePosition();
        }
        if (!StringUtils.isEmpty((String)this.templateStyle.getCurrencyUnitName()) && rowIndex < this.templateStyle.getCurrencyUnitPosition()) {
            rowIndex = this.templateStyle.getCurrencyUnitPosition();
        }
        return rowIndex;
    }

    public void fillDescriptions(Cell cell, Map<String, Map<String, Map<String, MbgViewListDesCellInfo>>> desMap) {
        if (MbgViewListDescriptionHelper.checkHashDescriptionFormula(cell)) {
            Map<String, Map<String, MbgViewListDesCellInfo>> map;
            if (desMap == null) {
                desMap = new HashMap<String, Map<String, Map<String, MbgViewListDesCellInfo>>>();
            }
            MbgViewListDesCellInfo info = null;
            Row row = cell.getSheet().getRow(cell.getRow(), false);
            Column col = cell.getSheet().getColumn(cell.getCol(), false);
            Cell cellDesc = cell.getSheet().getCell(this.calculateHeaderRowCount() + 1, cell.getCol(), false);
            Object cellData = BgNFSHelper.getCellData(cellDesc, "MEMBER_FILTER_DIMENSION_INFO");
            BgDimensionBaseInfo descDim = null;
            if (cellData instanceof BgDimensionBaseInfo) {
                descDim = (BgDimensionBaseInfo)cellData;
            }
            AbstractMbgViewListObject rowObject = (AbstractMbgViewListObject)ViewListHelper.getDimension(row);
            AbstractMbgViewListObject colObject = (AbstractMbgViewListObject)ViewListHelper.getDimension(col);
            int rowIndex = rowObject.getInitIndex() >= 0 ? rowObject.getInitIndex() : rowObject.getIndex();
            int colIndex = colObject.getInitIndex() >= 0 ? colObject.getInitIndex() : colObject.getIndex();
            String rowcolIndex = String.valueOf(rowIndex) + ":" + String.valueOf(colIndex);
            String orgId = MbgViewListDescriptionHelper.getDescriptionOrgUnitId(cell);
            if (!BOSUuid.isValidLength((String)orgId)) {
                orgId = this.getOrgUnitId();
            }
            if (!this.isCanEditByOtherForm(orgId) || !this.isCanEditByFormState(orgId)) {
                BgNFSHelper.setLockOfCell(cell, true);
            }
            String descFormula = MbgViewListDescriptionHelper.getDescriptionFormula(cell);
            rowcolIndex = rowcolIndex + "@" + descFormula;
            if (BgViewHelper.getSubMap(desMap, orgId, true).containsKey(rowcolIndex)) {
                if (BgViewHelper.getSubMap(BgViewHelper.getSubMap(desMap, orgId, true), rowcolIndex, true).containsKey(descFormula)) {
                    info = (MbgViewListDesCellInfo)BgViewHelper.getSubMap(BgViewHelper.getSubMap(desMap, orgId, true), rowcolIndex, true).get(descFormula);
                    if (info.getValue() != null) {
                        BgNFSHelper.setValue(cell, info.getValue());
                        if (descDim != null) {
                            BgDimensionMember member = new BgDimensionMember(null, null, info.getValue(), info.getValue());
                            member.setSortValue((Comparable)((Object)""));
                            HashSet<String> desNumbers = new HashSet<String>();
                            for (int x = 0; x < descDim.getMember().size(); ++x) {
                                if (!(descDim.getMember().get(x) instanceof BgDimensionMember)) continue;
                                desNumbers.add(((BgDimensionMember)descDim.getMember().get(x)).getNumber());
                            }
                            if (!desNumbers.contains(member.getNumber())) {
                                descDim.getMember().add(member);
                            }
                        }
                    }
                    MbgViewListDescriptionHelper.setDescriptionCell(cell, info);
                    return;
                }
            } else if (this.syncDescs != null && (map = this.syncDescs.get(cell.getSheet().getSheetIndex() + ":" + orgId)) != null && map.containsKey(rowcolIndex) && map.get(rowcolIndex).containsKey(descFormula)) {
                info = map.get(rowcolIndex).get(descFormula);
                BgNFSHelper.setValue(cell, info.getValue());
                if (descDim != null) {
                    BgDimensionMember member = new BgDimensionMember(null, null, info.getValue(), info.getValue());
                    member.setSortValue((Comparable)((Object)""));
                    HashSet<String> desNumbers = new HashSet<String>();
                    for (int x = 0; x < descDim.getMember().size(); ++x) {
                        if (!(descDim.getMember().get(x) instanceof BgDimensionMember)) continue;
                        desNumbers.add(((BgDimensionMember)descDim.getMember().get(x)).getNumber());
                    }
                    if (!desNumbers.contains(member.getNumber())) {
                        descDim.getMember().add(member);
                    }
                }
                return;
            }
            try {
                Map<String, Map<String, MbgViewListDesCellInfo>> defDesMap = this.getDefaultDesMap();
                rowcolIndex = cell.getSheet().getSheetIndex() + ":" + String.valueOf(rowIndex) + ":" + String.valueOf(colIndex);
                Map<String, MbgViewListDesCellInfo> subMap = defDesMap == null ? null : defDesMap.get(rowcolIndex);
                String number = null;
                if (subMap != null && !subMap.isEmpty()) {
                    if ("#".equals(descFormula)) {
                        descFormula = "";
                    }
                    Map<String, String> memberMap = DimensionFormulaHelper.getMemberMap(descFormula);
                    Map<String, String> memberMap1 = null;
                    block5: for (MbgViewListDesCellInfo desc : subMap.values()) {
                        memberMap1 = DimensionFormulaHelper.getMemberMap("#".equals(desc.getMemberNumber()) ? "" : desc.getMemberNumber());
                        for (String srcNumber : memberMap1.keySet()) {
                            number = memberMap1.get(srcNumber);
                            if (DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(srcNumber) && this.getBgPeriod() != null) {
                                number = BgPeriodNVariableHelper.getBgPeriodByN((String)this.getBgPeriod().getNumber(), (String)number, (int)this.getBgPeriod().getPeriodType().getValue());
                            }
                            if (memberMap.get(srcNumber) != null && memberMap.get(srcNumber).equals(number)) continue;
                            continue block5;
                        }
                        BgNFSHelper.setValue(cell, desc.getValue());
                        if (descDim != null) {
                            BgDimensionMember member = new BgDimensionMember(null, null, desc.getValue(), desc.getValue());
                            member.setSortValue((Comparable)((Object)""));
                            if (!descDim.getMember().contains(member)) {
                                descDim.getMember().add(member);
                            }
                        }
                        return;
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (BgPeriodException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isCanEditByOtherForm(String orgId) {
        return true;
    }

    public boolean isCanEditByFormState(String orgId) {
        return true;
    }

    public void storeCombin(Sheet sheet) {
        MbgViewListRowCol rowObject;
        if (sheet == null) {
            return;
        }
        int maxRow = sheet.getMaxRowIndex();
        HashMap tmpMap = new HashMap();
        String orgNumber = null;
        String rowIndex = null;
        for (int r = 0; r <= maxRow; ++r) {
            Row row = sheet.getRow(r, false);
            if (!ViewlistCombinHelper.checkRowIsCombin(row).booleanValue()) continue;
            rowObject = (MbgViewListRowCol)ViewListHelper.getDimension(row);
            orgNumber = this.getRowOrgNum(rowObject);
            rowIndex = !StringUtils.isEmpty((String)orgNumber) ? orgNumber + String.valueOf(rowObject.getInitIndex()) : String.valueOf(rowObject.getIndex());
            BgDimensionMember combinmember = ViewlistCombinHelper.getCombinMemberByDimMember(row);
            if (combinmember == null) continue;
            if (!tmpMap.containsKey(rowIndex)) {
                tmpMap.put(rowIndex, new ArrayList());
            }
            ((List)tmpMap.get(rowIndex)).add(combinmember);
        }
        if (tmpMap.isEmpty()) {
            return;
        }
        List<IMbgViewListObject> rows = null;
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheet.getSheetIndex())).getDimensionManager());
        if (isorgOnPageOrView) {
            String curOrgNumForDimensionData = this.getOrgNumsForCurSheet(sheet.getSheetIndex(), new HashSet<String>());
            rows = this.getBgViewManagerForMulOrg().containsKey(curOrgNumForDimensionData) ? ((MbgViewListSheetManager)((MbgViewListManager)this.getBgViewManagerForMulOrg().get(curOrgNumForDimensionData)).getSheetManagers().get(sheet.getSheetIndex())).getDimensionManager().getRows() : ((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheet.getSheetIndex())).getDimensionManager().getRows();
        } else {
            rows = ((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheet.getSheetIndex())).getDimensionManager().getRows();
        }
        for (int i = 0; i < rows.size(); ++i) {
            if (!(rows.get(i) instanceof MbgViewListRowCol) || !tmpMap.containsKey(rowIndex = !StringUtils.isEmpty((String)(orgNumber = this.getRowOrgNum(rowObject = (MbgViewListRowCol)rows.get(i)))) ? orgNumber + String.valueOf(rowObject.getInitIndex()) : String.valueOf(rowObject.getIndex()))) continue;
            List tmpMembers = (List)tmpMap.get(rowIndex);
            if (ViewlistCombinHelper.isHasHidedCombinMember(rowObject)) {
                ArrayList<List<BgDimensionMember>> groupMembers = new ArrayList<List<BgDimensionMember>>();
                this.groupHideMember(rowObject, groupMembers);
                BgDimensionMember member = null;
                BgDimensionMember tMember = null;
                BgDimensionMember preHide = null;
                for (List list : groupMembers) {
                    preHide = (BgDimensionMember)list.get(0);
                    for (int p = 0; p < rowObject.getCombinMembers().size(); ++p) {
                        int t;
                        int nextIndex;
                        member = rowObject.getCombinMembers().get(p);
                        BgDimensionMember preMember = null;
                        BgDimensionMember nextMember = null;
                        if (!member.isHide() || !ViewlistCombinHelper.membersEqual(member, preHide)) continue;
                        if (p - 1 >= 0 && rowObject.getCombinMembers().get(p - 1) != null) {
                            preMember = rowObject.getCombinMembers().get(p - 1);
                        }
                        if ((nextIndex = p + list.size()) < rowObject.getCombinMembers().size() && rowObject.getCombinMembers().get(nextIndex) != null) {
                            nextMember = rowObject.getCombinMembers().get(nextIndex);
                        }
                        if ((t = 0) >= tmpMembers.size()) continue;
                        tMember = (BgDimensionMember)tmpMembers.get(t);
                        if (ViewlistCombinHelper.membersEqual(preMember, tMember) && ViewlistCombinHelper.membersEqual(nextMember, t + 1 < tmpMembers.size() ? (BgDimensionMember)tmpMembers.get(t + 1) : null)) {
                            tmpMembers.addAll(t + 1, list);
                            continue;
                        }
                        if (preMember == null && ViewlistCombinHelper.membersEqual(nextMember, tMember)) {
                            tmpMembers.addAll(t, list);
                            continue;
                        }
                        tmpMembers.addAll(0, list);
                    }
                }
            }
            rowObject.getCombinMembers().clear();
            rowObject.getCombinMembers().addAll(tmpMembers);
            ViewlistCombinHelper.parseCombinMembers(rowObject);
        }
    }

    private void groupHideMember(MbgViewListRowCol rowObject, List<List<BgDimensionMember>> groupMembers) {
        ArrayList hideMembers = null;
        int in = rowObject.getCombinMembers().size();
        for (int i = 0; i < in; ++i) {
            BgDimensionMember member = rowObject.getCombinMembers().get(i);
            if (member.isHide()) {
                if (hideMembers == null) {
                    hideMembers = new ArrayList();
                    groupMembers.add(hideMembers);
                }
                groupMembers.get(groupMembers.size() - 1).add(member);
                continue;
            }
            hideMembers = null;
        }
    }

    protected String getRowOrgNum(MbgViewListRowCol rowObj) {
        String orgNumber = "";
        for (int i = 0; i < rowObj.getDimensions().size(); ++i) {
            if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(rowObj.getDimensions().get(i).getNumber()) || rowObj.getDimensions().get(i).getMember().isEmpty()) continue;
            orgNumber = ((MbgViewListDimensionMember)rowObj.getDimensions().get(i).getMember().get(0)).getNumber();
            break;
        }
        return orgNumber;
    }

    protected abstract BOSUuid getCurrencyId();

    protected abstract BOSUuid getBgPeriodId();

    protected BgPeriodInfo getBgPeriod() {
        return null;
    }

    protected abstract BOSUuid getBgVersionId();

    protected abstract BOSUuid getBgTemplateId();

    protected String getActualPeriodId() {
        return null;
    }

    public void setCalcRowSet(Set<Row> calcRowSet) {
        this.calcRowSet = calcRowSet;
    }

    public Set<Row> getCalcRowSet() {
        return this.calcRowSet;
    }

    protected void processMeasureUnit(Book book) throws BOSException {
        if (book == null) {
            return;
        }
        Sheet sheet = null;
        Cell cell = null;
        for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            if (sheet == null) continue;
            for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
                for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    this.processMeasureUnit(cell);
                }
            }
        }
    }

    protected Map<String, BgElementInfo> getElementoObjMap() throws BOSException {
        if (this.elementObjMap == null) {
            this.elementObjMap = BgElementHelper.getElementoObjMap((Context)this.getCtx());
        }
        return this.elementObjMap;
    }

    private void processMeasureUnit(Cell cell) throws BOSException {
        if (cell != null && cell.getValue() != null && !cell.getValue().isEmpty() && cell.getValue().getValue() != null) {
            String bgAccountNumber;
            MbgViewlistMeasureUnitHelper viewlistMeasureHelper = new MbgViewlistMeasureUnitHelper(this.getAccountDataTypeMap(), this.getTemplateStyle(), this.getElementoObjMap());
            String viewlistValue = null;
            BigDecimal tmpCoefficient = BgNConstants.ONE;
            if (BgNFSHelper.checkHasItemFormula(cell) && (bgAccountNumber = String.valueOf(cell.getUserObject("BGACCOUNT_NUMBER").getValue())) != null) {
                BigDecimal _value;
                if (viewlistMeasureHelper.getTemplateStyle().isDataTYpe()) {
                    if (!MBGViewListFormCommonHelper.checkElementRateOrPrice(cell, this.getElementoObjMap(), this.getFormulaMap())) {
                        tmpCoefficient = viewlistMeasureHelper.getCoef(bgAccountNumber, null);
                    }
                } else {
                    String eleNumber = MBGViewListFormCommonHelper.getCellElement(cell, this.elementObjMap, this.getFormulaMap());
                    tmpCoefficient = viewlistMeasureHelper.getCoef(bgAccountNumber, eleNumber);
                }
                if (cell.getValue().getValue() instanceof BigDecimal && (_value = (BigDecimal)cell.getValue().getValue()).compareTo(BigDecimal.ZERO) < 0) {
                    viewlistValue = viewlistMeasureHelper.getDisplayValue(cell.getValue(), tmpCoefficient, 8, null);
                }
            }
            if (ViewListHelper.getCalculatorDataStyle(cell) != null) {
                viewlistValue = viewlistMeasureHelper.getCalcDisplayValue(cell, cell.getValue());
            }
            if (!StringUtils.isEmpty(viewlistValue)) {
                if (cell.getValue().getValue() instanceof BigDecimal) {
                    try {
                        BgNFSHelper.setValue(cell, new BigDecimal(viewlistValue));
                    }
                    catch (Exception e) {
                        logger.error((Object)("MBGViewListFormExportProvider processMeasureUnit error CellName is:" + cell.getName(false, true) + "***** message is" + e.getMessage()));
                        BgNFSHelper.setValue(cell, viewlistValue);
                    }
                } else {
                    BgNFSHelper.setValue(cell, viewlistValue);
                }
            }
        }
    }

    public abstract Map<String, Integer> getAccountDataTypeMap();

    public void filterDesc(Book book, Sheet sheet) {
        Set<Integer> hideRowIndexs4Desc;
        DimensionMemberFilterInfo filter = this.getMemberFilter();
        Map<String, DimensionMemberFilterMember> memberFilters = filter.getMemberFilter();
        if (memberFilters != null) {
            int calculateHeaderRowCount = this.calculateHeaderRowCount();
            for (Map.Entry<String, DimensionMemberFilterMember> entry : memberFilters.entrySet()) {
                DimensionMemberFilterMember memFilterItem = entry.getValue();
                Set<String> members = memFilterItem.getMembers();
                boolean isDesc = memFilterItem.isDesc();
                String dimensionNumber = memFilterItem.getDimensionNumber();
                if (!isDesc) continue;
                HashSet hideRowSet = new HashSet();
                int decColIndex = -1;
                for (int c = 0; c < sheet.getMaxColIndex() + 1; ++c) {
                    Cell cell = sheet.getCell(calculateHeaderRowCount + 1, c, false);
                    BgDimensionBaseInfo filterDimension = (BgDimensionBaseInfo)BgNFSHelper.getCellData(cell, "MEMBER_FILTER_DIMENSION_INFO");
                    if (filterDimension == null || dimensionNumber == null || !dimensionNumber.equals(filterDimension.getNumber())) continue;
                    decColIndex = c;
                    break;
                }
                if (decColIndex == -1) continue;
                ArrayList<Integer> hideRowList = new ArrayList<Integer>();
                ArrayList<Integer> showRowList = new ArrayList<Integer>();
                for (int r = calculateHeaderRowCount + 1; r < sheet.getMaxRowIndex() + 1; ++r) {
                    Cell cell = sheet.getCell(r, decColIndex, false);
                    Row row = sheet.getRow(r, false);
                    if (!MbgViewListDescriptionHelper.checkHashDescriptionFormula(cell)) continue;
                    Object value = BgNFSHelper.getValue(cell);
                    if (members != null) {
                        if (!members.contains(value)) {
                            hideRowList.add(r);
                            row.setUserObject("IS_SET_WIDTH", (Object)false);
                            continue;
                        }
                        showRowList.add(r);
                        row.removeUserObject("IS_SET_WIDTH");
                        continue;
                    }
                    showRowList.add(r);
                    memFilterItem.clearHideRowIndexs4Desc();
                }
                if (!hideRowList.isEmpty()) {
                    hideRowSet.addAll(hideRowList);
                }
                Range showRange = this.getRange(book, sheet, showRowList);
                this.setHidden(showRange, false, true);
                if (hideRowSet.isEmpty()) continue;
                memFilterItem.clearHideRowIndexs4Desc();
                memFilterItem.getHideRowIndexs4Desc().addAll(hideRowSet);
            }
        }
        if (!(hideRowIndexs4Desc = filter.getHideRowIndexs4Desc()).isEmpty()) {
            Range hideRange = this.getRange(book, sheet, new ArrayList<Integer>(hideRowIndexs4Desc));
            this.setHidden(hideRange, true, true);
        }
    }

    private Range getRange(Book book, Sheet sheet, List<Integer> hideRowList) {
        Range range = null;
        for (Integer rowIndex : hideRowList) {
            CellBlock cb = CellBlock.getNewCellBlock((int)rowIndex, (int)0, (int)rowIndex, (int)16383);
            if (range == null) {
                range = book.getSheet(sheet.getIndex()).getRange(cb);
                continue;
            }
            range.append((Object)cb);
        }
        return range;
    }

    protected void setHidden(Range range, boolean isHide, boolean bRow) {
        StyleAttributes sa = Styles.getEmptySA();
        if (range != null) {
            range.setIgnoreProtected(true);
            range.setStyle(sa, Styles.getEmptySA());
            range.setHidden(isHide, bRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dealMultiCurView() {
        for (int sheetIndex = 0; sheetIndex < ((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().size(); ++sheetIndex) {
            MbgViewListDimensionManager oldDimensionManager = ((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager();
            oldDimensionManager.setCloneCells(false);
            Map<String, List<IMbgViewListObject>> orgAndRowCols = null;
            LinkedHashSet<String> orgNums = new LinkedHashSet<String>();
            boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(oldDimensionManager);
            String curOrgNumForDimensionData = this.getOrgNumsForCurSheet(sheetIndex, orgNums);
            ArrayList<Integer> indexLst = new ArrayList<Integer>();
            HashMap newViewlistObjMap = new HashMap();
            if (isorgOnPageOrView || orgNums.size() <= 1) continue;
            boolean isOrgOnRow = MBGViewListFormCommonHelper.isOrgOnRow(oldDimensionManager);
            try {
                boolean isRowColShowbyTemp = true;
                isRowColShowbyTemp = this.getCurMbgSheetManager() != null ? ((MbgViewListSheetManager)this.getCurMbgSheetManager()).isRowColShowbyTemp() : oldDimensionManager.getSheet().isRowColShowbyTemp();
                orgAndRowCols = isRowColShowbyTemp ? MBGViewListFormCommonHelper.getViewListObjectsByTemp(oldDimensionManager, isOrgOnRow, this.getOrgUnitInfo().getNumber()) : MBGViewListFormCommonHelper.getViewListObjectsByOrg(oldDimensionManager, isOrgOnRow);
                if (orgAndRowCols == null || orgAndRowCols.isEmpty()) continue;
                for (String viewOrgNum : orgNums) {
                    if (orgAndRowCols == null || !orgAndRowCols.containsKey(viewOrgNum) || viewOrgNum.equals(curOrgNumForDimensionData) || !this.getBgViewManagerForMulOrg().containsKey(viewOrgNum)) continue;
                    MbgViewListDimensionManager otherDimensionManager = ((MbgViewListSheetManager)((MbgViewListManager)this.getBgViewManagerForMulOrg().get(viewOrgNum)).getSheetManagers().get(sheetIndex)).getDimensionManager().clone();
                    Map<String, List<IMbgViewListObject>> otherOrgCols = null;
                    otherOrgCols = otherDimensionManager.getSheet().isRowColShowbyTemp() ? MBGViewListFormCommonHelper.getViewListObjectsByTemp(otherDimensionManager, isOrgOnRow, viewOrgNum) : MBGViewListFormCommonHelper.getViewListObjectsByOrg(otherDimensionManager, isOrgOnRow);
                    if (otherOrgCols.containsKey(viewOrgNum)) {
                        List<IMbgViewListObject> rows;
                        List<IMbgViewListObject> initRows = otherOrgCols.get(viewOrgNum);
                        if (isRowColShowbyTemp) {
                            rows = orgAndRowCols.get(viewOrgNum);
                            ArrayList<IMbgViewListObject> tRows = new ArrayList<IMbgViewListObject>();
                            for (int k = 0; k < initRows.size(); ++k) {
                                if (!(initRows.get(k) instanceof MbgViewListRowCol)) continue;
                                tRows.add(initRows.get(k));
                            }
                            if (tRows.size() == rows.size()) {
                                for (int x = 0; x < rows.size(); ++x) {
                                    ((IMbgViewListObject)tRows.get(x)).setIndex(rows.get(x).getIndex());
                                    rows.remove(x);
                                    rows.add(x, (IMbgViewListObject)tRows.get(x));
                                }
                            }
                        } else if (initRows != null && !initRows.isEmpty()) {
                            orgAndRowCols.get(viewOrgNum).clear();
                            orgAndRowCols.get(viewOrgNum).addAll(initRows);
                        }
                        if ((rows = orgAndRowCols.get(viewOrgNum)) != null && !rows.isEmpty()) {
                            for (int index = 0; index < rows.size(); ++index) {
                                rows.get(index).setIndex(index);
                            }
                        }
                        continue;
                    }
                    return;
                }
                if (isOrgOnRow) {
                    oldDimensionManager.getRows().clear();
                } else {
                    oldDimensionManager.getColumns().clear();
                }
                if (isRowColShowbyTemp) {
                    for (IMbgViewListObject iObject : orgAndRowCols.get(curOrgNumForDimensionData)) {
                        if (indexLst.contains(MBGViewListFormCommonHelper.getIndex(iObject))) continue;
                        indexLst.add(MBGViewListFormCommonHelper.getIndex(iObject));
                    }
                    Collections.sort(indexLst);
                    for (String orgNumber : orgAndRowCols.keySet()) {
                        List<IMbgViewListObject> lst = orgAndRowCols.get(orgNumber);
                        if (!newViewlistObjMap.containsKey(orgNumber)) {
                            newViewlistObjMap.put(orgNumber, new HashMap());
                        }
                        for (IMbgViewListObject iObject : lst) {
                            ((Map)newViewlistObjMap.get(orgNumber)).put(MBGViewListFormCommonHelper.getIndex(iObject), iObject);
                        }
                    }
                    for (Integer index : indexLst) {
                        for (String viewOrgNum : orgNums) {
                            if (!newViewlistObjMap.containsKey(viewOrgNum) || !((Map)newViewlistObjMap.get(viewOrgNum)).containsKey(index)) continue;
                            if (isOrgOnRow) {
                                oldDimensionManager.getRows().add((IMbgViewListObject)((Map)newViewlistObjMap.get(viewOrgNum)).get(index));
                                continue;
                            }
                            oldDimensionManager.getColumns().add((IMbgViewListObject)((Map)newViewlistObjMap.get(viewOrgNum)).get(index));
                        }
                    }
                    continue;
                }
                for (String viewOrgNum : orgNums) {
                    if (!orgAndRowCols.containsKey(viewOrgNum)) continue;
                    for (int i = 0; i < orgAndRowCols.get(viewOrgNum).size(); ++i) {
                        if (isOrgOnRow) {
                            oldDimensionManager.getRows().add(orgAndRowCols.get(viewOrgNum).get(i));
                            continue;
                        }
                        oldDimensionManager.getColumns().add(orgAndRowCols.get(viewOrgNum).get(i));
                    }
                }
                continue;
            }
            finally {
                if (oldDimensionManager != null) {
                    oldDimensionManager.setCloneCells(true);
                }
            }
        }
    }
}

