/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.provider.viewListForm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.common.ViewListBookParseHelper;
import com.kingdee.eas.ma.mbg.common.ViewListExportBookParseHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgExportThreadProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MBGViewListFormExportProvider
extends MBGViewListFormProvider {
    private static final Logger logger = CoreUIObject.getLogger(MBGViewListFormExportProvider.class);
    private boolean isRunning = true;
    private boolean isMoveDimension = true;
    private CoreUIObject ownerUI = null;
    private LinkedHashMap<String, BgFormInfo> bgFormInfoMap = null;
    private Map<String, Book> bookMap = new HashMap<String, Book>();
    private Map<String, String> pageViewNumbers = null;
    private MbgExportThreadProcessor threadProcessor = null;
    private BgFormInfo currentBgFormInfo = null;
    private Map<String, TemplateStyleInfo> templateStyleMap = new HashMap<String, TemplateStyleInfo>();

    public boolean isMoveDimension() {
        return this.isMoveDimension;
    }

    @Override
    public BgFormInfo getBgFormInfo() {
        return this.currentBgFormInfo;
    }

    public void setBgFormInfo(BgFormInfo info) {
        this.currentBgFormInfo = info;
    }

    @Override
    public void setTemplateStyle(TemplateStyleInfo templateStyle) {
        if (this.getBgFormInfo() != null && this.getBgFormInfo().getId() != null && templateStyle != null) {
            this.templateStyleMap.put(this.getBgFormInfo().getId().toString(), templateStyle);
        }
        super.setTemplateStyle(templateStyle);
    }

    @Override
    public TemplateStyleInfo getTemplateStyle(IDimDataQuery bgFormInfo) {
        if (bgFormInfo != null && bgFormInfo.getId() != null && this.templateStyleMap.containsKey(bgFormInfo.getId().toString())) {
            return this.templateStyleMap.get(bgFormInfo.getId().toString());
        }
        return this.getTemplateStyle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Book getBook(String formId) {
        long st = System.currentTimeMillis();
        logger.error((Object)("**************** start wait time " + st + " " + formId));
        while (this.isRunning) {
            Map<String, Book> map = this.bookMap;
            synchronized (map) {
                if (this.bookMap.containsKey(formId)) {
                    break;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.error((Object)("**************** end wait time " + (System.currentTimeMillis() - st) + " ms " + formId));
        Book book = this.bookMap.get(formId);
        this.removeBook(formId);
        return book;
    }

    public void removeBook(String formId) {
        this.bookMap.remove(formId);
    }

    public MBGViewListFormExportProvider(LinkedHashMap<String, BgFormInfo> bgFormInfoMap, CoreUIObject ownerUI) {
        this.bgFormInfoMap = bgFormInfoMap;
        this.ownerUI = ownerUI;
        Thread thread = new Thread(){

            @Override
            public void run() {
                MBGViewListFormExportProvider.this.init();
            }
        };
        thread.start();
    }

    public MBGViewListFormExportProvider(LinkedHashMap<String, BgFormInfo> bgFormInfoMap, CoreUIObject ownerUI, Boolean isMoveDimension, Map<String, String> pageViewNumbers) {
        this(bgFormInfoMap, ownerUI, isMoveDimension, pageViewNumbers, null);
    }

    public MBGViewListFormExportProvider(LinkedHashMap<String, BgFormInfo> bgFormInfoMap, CoreUIObject ownerUI, Boolean isMoveDimension, Map<String, String> pageViewNumbers, MbgExportThreadProcessor threadProcessor) {
        this.threadProcessor = threadProcessor;
        this.bgFormInfoMap = bgFormInfoMap;
        this.ownerUI = ownerUI;
        this.isMoveDimension = isMoveDimension;
        this.pageViewNumbers = pageViewNumbers;
        Thread thread = new Thread(){

            @Override
            public void run() {
                MBGViewListFormExportProvider.this.init();
            }
        };
        thread.start();
    }

    public Map<String, Book> getBookMap() {
        return this.bookMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        BgFormInfo bgFormInfo;
        HashSet<String> formIds = new HashSet<String>();
        for (String formId : this.bgFormInfoMap.keySet()) {
            bgFormInfo = this.bgFormInfoMap.get(formId);
            if (bgFormInfo.getBgTemplate().getFormType().getValue() != 2) continue;
            formIds.add(formId);
        }
        if (formIds.isEmpty()) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(this.getViewlistSelectors());
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", formIds, CompareType.INCLUDE));
        try {
            BgFormCollection colls = BgFormFactory.getRemoteInstance().getBgFormCollection(evi);
            Map viewlistFormMap = BgCommHelper.transeToMap((IObjectCollection)colls);
            for (String formId : this.bgFormInfoMap.keySet()) {
                bgFormInfo = (BgFormInfo)viewlistFormMap.get(formId);
                if (bgFormInfo == null) continue;
                if (this.bgFormInfoMap.containsKey(formId) && this.bgFormInfoMap.get(formId).containsKey("IS_FINALIZED")) {
                    bgFormInfo.put("IS_FINALIZED", this.bgFormInfoMap.get(formId).get("IS_FINALIZED"));
                }
                if (this.threadProcessor != null && !this.threadProcessor.requestProcess(formId)) continue;
                this.setBgFormInfo(bgFormInfo);
                this.setEditValue((IObjectValue)bgFormInfo);
                this.setOrgUnitInfo(bgFormInfo.getOrgUnit());
                this.setOwner(this.ownerUI);
                long ct = System.currentTimeMillis();
                logger.info((Object)("******************* start initViewListBook (" + formId + ") : " + ct));
                Book book = this.initViewListBook();
                logger.info((Object)("******************* end initViewListBook  (" + formId + ") : " + (System.currentTimeMillis() - ct) + "ms"));
                Map<String, Book> map = this.bookMap;
                synchronized (map) {
                    this.bookMap.put(formId, book);
                }
                if (this.threadProcessor == null) continue;
                this.threadProcessor.addToBookMap(formId, book);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            if (this.threadProcessor != null) {
                this.threadProcessor.setRunning(false);
            }
            this.ownerUI.handUIException((Throwable)e);
        }
    }

    private Book initViewListBook() throws Exception {
        this.defaultDesMap = null;
        this.bookParseHelper = null;
        this.getBgViewManagerForMulOrg().clear();
        Book _book = (Book)this.load();
        if (this.isMoveDimension()) {
            BgViewHelper.movePageDimensionsToRow((MbgViewListManager)this.curMbgViewManager, true);
            this.loadMultiOrg();
        } else {
            MBGViewListFormCommonHelper.filterCurPageView(this.curMbgViewManager, this.getBgFormInfo().getId().toString(), this.pageViewNumbers);
        }
        this.fillData(_book);
        this.calcBook(_book, this.getReportAdapter());
        this.processMeasureUnit(_book);
        return _book;
    }

    @Override
    protected void processOrgNumsOnRowCol(int sheetIndex, Map<String, List<IBgDimensionManagerBase>> dimensionManagers, Set<String> orgNums, String curOrgNumForDimensionData) {
        if (!this.isMoveDimension()) {
            super.processOrgNumsOnRowCol(sheetIndex, dimensionManagers, orgNums, curOrgNumForDimensionData);
        } else {
            this.processOrgNumsOnRowColExport(sheetIndex, dimensionManagers, orgNums, curOrgNumForDimensionData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processOrgNumsOnRowColExport(int sheetIndex, Map<String, List<IBgDimensionManagerBase>> dimensionManagers, Set<String> orgNums, String curOrgNumForDimensionData) {
        boolean isOrgOnRow = MBGViewListFormCommonHelper.isOrgOnRow(((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager());
        MbgViewListDimensionManager dimensionManager = null;
        MbgViewListDimensionManager oldDimensionManager = null;
        try {
            if (this.getBgViewManagerForMulOrg().containsKey(curOrgNumForDimensionData)) {
                oldDimensionManager = ((MbgViewListSheetManager)((MbgViewListManager)this.getBgViewManagerForMulOrg().get(curOrgNumForDimensionData)).getSheetManagers().get(sheetIndex)).getDimensionManager();
                MbgViewListRowCol rowCol = null;
                MbgViewListDimensionInfo dimInfo = null;
                List<IMbgViewListObject> rowCols = oldDimensionManager.getRowCols();
                for (int i = 0; i < rowCols.size(); ++i) {
                    if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
                    rowCol = (MbgViewListRowCol)rowCols.get(i);
                    for (int j = 0; j < rowCol.getDimensions().size(); ++j) {
                        dimInfo = rowCol.getDimensions().get(j);
                        if (!dimInfo.getNumber().equalsIgnoreCase(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
                        for (int p = dimInfo.getMember().size() - 1; p > 0; --p) {
                            if (((BgDimensionMember)dimInfo.getMember().get(p)).getNumber().equals(curOrgNumForDimensionData)) continue;
                            dimInfo.getMember().remove(p);
                        }
                    }
                }
            }
            if (orgNums.size() > 0) {
                dimensionManager = null;
                for (String orgNum : orgNums) {
                    if (!this.orgUnitMap.containsKey(orgNum)) continue;
                    if (!dimensionManagers.containsKey(((FullOrgUnitInfo)this.orgUnitMap.get(orgNum)).getId().toString())) {
                        dimensionManagers.put(((FullOrgUnitInfo)this.orgUnitMap.get(orgNum)).getId().toString(), new ArrayList());
                    }
                    if (!this.getBgViewManagerForMulOrg().containsKey(orgNum)) continue;
                    oldDimensionManager = ((MbgViewListSheetManager)((MbgViewListManager)this.getBgViewManagerForMulOrg().get(orgNum)).getSheetManagers().get(sheetIndex)).getDimensionManager();
                    oldDimensionManager.setCloneCells(false);
                    dimensionManager = oldDimensionManager.deepclone();
                    this.dealPageMembers(this.getViewF7List(sheetIndex), this.getPageF7List(sheetIndex), dimensionManager, ((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager(), this.getOrgUnitInfo().getNumber());
                    dimensionManager = dimensionManager.deepclone();
                    this.synHideDimension((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex), dimensionManager);
                    dimensionManagers.get(((FullOrgUnitInfo)this.orgUnitMap.get(orgNum)).getId().toString()).add(dimensionManager);
                }
            }
        }
        finally {
            if (oldDimensionManager != null) {
                oldDimensionManager.setCloneCells(true);
            }
        }
    }

    @Override
    protected void fillBgDataValue(Sheet sheet, Map<String, Map<String, BgNViewDataInfo>> dataMap, Map<String, Map<String, BgNViewDataInfo>> tmpDataMap, Map<String, Map<String, Map<String, MbgViewListDesCellInfo>>> descMap, String editNote) throws Exception {
        if (sheet == null) {
            return;
        }
        Cell cell = null;
        ItemFormula formula = null;
        String cellOrgId = null;
        BgNViewDataInfo dataValue = null;
        BgNFSHelper.disableUndo(sheet.getBook());
        BgNFSHelper.disableCal(sheet.getBook());
        DimensionCacheHelper cachehelper = this.getCheckFactory().getCacheHelper();
        for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
            for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, false);
                formula = BgNFSHelper.getItemFormula(cell);
                if (formula != null) {
                    String version = formula.getExt("Version");
                    cellOrgId = formula.getExt("ORGUNITID");
                    dataValue = MBGViewListFormCommonHelper.getData(tmpDataMap, cellOrgId, formula.getFormula(), version, false);
                    if (dataValue == null) {
                        dataValue = MBGViewListFormCommonHelper.getData(dataMap, cellOrgId, formula.getFormula(), version, false);
                    }
                    if (dataValue != null) {
                        MBGViewListFormCommonHelper.setDataValueToCell(cell, dataValue, cachehelper, this.getDataType());
                    } else {
                        MBGViewListFormCommonHelper.setDataValueToCell(cell, null, cachehelper, this.getDataType());
                    }
                }
                this.fillDescriptions(cell, descMap);
                this.fillEditNote(cell, editNote);
            }
        }
        this.dealCalculateColFormula(sheet);
        BgNFSHelper.enableUndo(sheet.getBook());
    }

    @Override
    protected void startQueryData(Map<String, List<IBgDimensionManagerBase>> initDimensionManagers) throws BOSException, EASBizException {
    }

    @Override
    protected void loadMbgViewManager() throws Exception {
        super.loadMbgViewManager();
        if (this.isMoveDimension()) {
            MBGViewListFormCommonHelper.moveHideDimToView((MbgViewListManager)this.curMbgViewManager);
        } else {
            MBGViewListFormCommonHelper.filterCurPageView(this.curMbgViewManager, this.getBgFormInfo().getId().toString(), this.pageViewNumbers);
        }
    }

    @Override
    public ViewListBookParseHelper getBookParseHelper() {
        if (!this.isMoveDimension()) {
            ViewListBookParseHelper bookParseHelper = super.getBookParseHelper();
            return bookParseHelper;
        }
        if (this.bookParseHelper == null) {
            this.bookParseHelper = new ViewListExportBookParseHelper(this.getBookDimensionParse(), this.getBgFormInfo().getOrgUnit(), this.getBgViewManagerForMulOrg(), this.orgUnitMap, this.isCheckFull(), this.getMemberFilter(), this.getCheckFactory().getCacheHelper());
        }
        this.bookParseHelper.setTemplateStyle(this.getTemplateStyle());
        this.bookParseHelper.setVersionNumber(this.getVersionNumber());
        this.bookParseHelper.setOrgViewId(this.getOrgViewId());
        this.bookParseHelper.setEditScenType(this.getEditScenType());
        this.bookParseHelper.setSheetTitle(this.getSheetTitle());
        this.bookParseHelper.setEditOrgUnit(this.editOrgUnit);
        this.bookParseHelper.setEditPeriod(this.editPeriod);
        this.bookParseHelper.setViewF7Enable(true);
        this.bookParseHelper.setPageF7Enable(true);
        this.bookParseHelper.setOrgF7Enable(true);
        this.bookParseHelper.setParseForm(true);
        this.bookParseHelper.setAccountMap(this.getAccountDataTypeMap());
        this.bookParseHelper.setReadonly(this.getBgFormInfo().getBgTemplate().isReadonly());
        this.bookParseHelper.setShowDefaultMember(true);
        this.bookParseHelper.setPropMaps(this.getPropMaps());
        this.bookParseHelper.setExport(true);
        this.bookParseHelper.setAdapter(this.getReportAdapter());
        return this.bookParseHelper;
    }

    private SelectorItemCollection getViewlistSelectors() {
        SelectorItemCollection sic = BgNFSHelper.getSelectors();
        sic.add("entries.id");
        sic.add("entries.bgformid");
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        sic.add("bgTemplate.styleSet.id");
        sic.add("bgTemplate.styleSet.number");
        sic.add("bgTemplate.styleSet.name");
        sic.add("bgTemplate.styleSet.data");
        sic.add("bgTemplate.styleSet.isSysDefault");
        sic.add("bgTemplate.bgScheme.id");
        return sic;
    }

    @Override
    protected void loadMultiOrg() throws Exception {
        HashSet<String> orgNums = new HashSet<String>();
        this.getOrgNumsForCurViewManager((MbgViewListManager)this.curMbgViewManager, orgNums);
        if (orgNums != null && orgNums.size() > 1) {
            this.addBgViewManagerForMultiOrg(orgNums);
        }
    }

    @Override
    protected void getOrgNumsForCurViewManager(MbgViewListManager viewManager, Set<String> orgNums) {
        if (viewManager == null || orgNums == null) {
            return;
        }
        for (int sheetIndex = 0; sheetIndex < viewManager.getSheetManagers().size(); ++sheetIndex) {
            ArrayList<BgDimensionBaseInfo> dimensions;
            boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetIndex)).getDimensionManager());
            if (!isorgOnPageOrView) {
                dimensions = new ArrayList();
                List<IMbgViewListObject> rowCols = ((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager().getRowCols();
                for (int i = 0; i < rowCols.size(); ++i) {
                    if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
                    dimensions.addAll(((MbgViewListRowCol)rowCols.get(i)).getDimensions());
                }
                this.getOrgMembers(orgNums, dimensions);
                continue;
            }
            if (!this.isMoveDimension()) continue;
            dimensions = ((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager().getPageDimension();
            this.getOrgMembers(orgNums, dimensions);
        }
    }

    @Override
    public boolean isDecompose() {
        if (this.getEditValue() instanceof BgFormInfo) {
            return ((BgFormInfo)this.getEditValue()).isDecompose();
        }
        return false;
    }

    @Override
    protected int getDataType() {
        if (this.getBgFormInfo() != null) {
            return this.getBgFormInfo().getDataType();
        }
        return 1;
    }
}

