/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.provider.viewListForm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUI;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgFormEntryInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.IBgAdjustFacada;
import com.kingdee.eas.ma.mbg.IMBGFormFacade;
import com.kingdee.eas.ma.mbg.IMBGViewListFormFacade;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.client.MbgViewListFormProcessUI;
import com.kingdee.eas.ma.mbg.client.action.actions.form.ActionShowAdjust;
import com.kingdee.eas.ma.mbg.client.utils.DimensionClientHelper;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.convertexcel.impl.MbgViewListFormConvertExcelProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormAdjustProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormBaseProvider;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MBGViewListFormProvider
extends MBGViewListFormBaseProvider {
    private static final Logger logger = Logger.getLogger((String)MBGViewListFormProvider.class.getName());
    public Map<String, BgFormStateEnum> orgIdFormState = new HashMap<String, BgFormStateEnum>();

    @Override
    public BgFormInfo getBgFormInfo() {
        return (BgFormInfo)this.getEditValue();
    }

    @Override
    protected void loadMbgViewManager() throws Exception {
        byte[] dataBytes = null;
        BgFormInfo bgFormInfo = this.getBgFormInfo();
        if (bgFormInfo != null) {
            Map multiOrgCreatorMap;
            Map multiFormulas;
            BgFormEntryInfo obj;
            this.setOrgUnitInfo(bgFormInfo.getOrgUnit());
            if (bgFormInfo.getEntries() != null && (obj = bgFormInfo.getEntries().get(0)) instanceof BgFormEntryInfo) {
                dataBytes = obj.getDimensionData();
                this.curMbgViewManager = this.getParser().parse(dataBytes);
                if (null != this.getCurMbgViewManager()) {
                    MBGViewListFormCommonHelper.initCanEditOtherBgForm(this.getCtx(), (MbgViewListManager)this.getCurMbgViewManager());
                }
                if (!(this instanceof MbgViewListFormConvertExcelProvider)) {
                    DimensionClientHelper.verifyExpr(this.getOwner(), (MbgViewListManager)this.curMbgViewManager);
                }
            }
            long st = System.currentTimeMillis();
            logger.error((Object)"start initViewListData ");
            Map vilewListData = this.getMbgViewListFacade().loadViewManagersForProvider(bgFormInfo, this.getTemplateStyle(), this.getOrgViewId(), (MbgViewListManager)this.getCurMbgViewManager(), this.getReportAdapter(), this.getOrgPermission(), this.isCurrOrg());
            logger.error((Object)("end initViewListData " + (System.currentTimeMillis() - st) + " ms."));
            this.setEditOrgUnit((String)vilewListData.get("edit.orgunit"));
            this.setEditPeriod((String)vilewListData.get("edit.period"));
            this.setPropMaps((Map)vilewListData.get("dimension.property"));
            this.curMbgViewManager = (MbgViewListManager)vilewListData.get("dimensino.member");
            Map multiMap = (Map)vilewListData.get("MULTI_ORG_VIEW_MANAGER");
            if (multiMap != null && !multiMap.isEmpty()) {
                for (Object key : multiMap.keySet()) {
                    if (!(key instanceof FullOrgUnitInfo) || !(multiMap.get(key) instanceof MbgViewListManager)) continue;
                    this.addOtherOrgViewData((FullOrgUnitInfo)key, (MbgViewListManager)multiMap.get(key));
                }
            }
            if (vilewListData.containsKey("MULTI_ORG_VIEW_MANAGER_FORMULAS") && !(multiFormulas = (Map)vilewListData.get("MULTI_ORG_VIEW_MANAGER_FORMULAS")).isEmpty()) {
                this.setMultiOrgFormulasMap(multiFormulas);
            }
            this.dealMultiCurView();
            if (vilewListData.containsKey("MULTI_ORG_CREATOR") && (multiOrgCreatorMap = (Map)vilewListData.get("MULTI_ORG_CREATOR")) != null && !multiOrgCreatorMap.isEmpty()) {
                this.setMultiOrgCreatorMap(multiOrgCreatorMap);
            }
            if (vilewListData.containsKey("MULTI_ORG_BGFORM")) {
                this.orgIdBgForm = (Map)vilewListData.get("MULTI_ORG_BGFORM");
            }
            this.clearCache();
        }
    }

    @Override
    protected Map loadMbgViewManagers(Set<String> notExitOrgNum) throws EASBizException, BOSException {
        long st = System.currentTimeMillis();
        Map map = null;
        logger.error((Object)"start loadMbgViewManagers ");
        map = this.getMbgViewListFacade().getViewListManagers(((BgFormInfo)this.getEditValue()).getId().toString(), this.getOrgViewId(), notExitOrgNum, this.getOrgPermission(), this.getInitOrgId(), this.isCurrOrg());
        logger.error((Object)("end loadMbgViewManagers " + (System.currentTimeMillis() - st) + " ms."));
        return map;
    }

    public IMBGViewListFormFacade getMbgViewListFacade() throws BOSException {
        if (this.getCtx() == null) {
            return MBGViewListFormFacadeFactory.getRemoteInstance();
        }
        return MBGViewListFormFacadeFactory.getLocalInstance(this.getCtx());
    }

    @Override
    public void reloadBook(Book book) throws Exception {
        super.reloadBook(book);
        this.showAdjust(book);
        this.showRollOrgLock(book);
    }

    @Override
    public void store(Object obj) throws Exception {
    }

    @Override
    public void store(Book book) throws Exception {
        for (int s = 0; s < book.getSheetCount(); ++s) {
            this.storeCombin(book.getSheet(s));
            this.store(book.getSheet(s));
        }
    }

    @Override
    public void fillData(Book book) throws Exception {
        super.fillData(book);
        this.showAdjust(book);
        this.showRollOrgLock(book);
        logger.error((Object)("Load Check Helper Use(ms):" + this.getCheckFactory().useTime));
    }

    private void showOtherFormOrgLock(Book book) {
        BgSheetRange lockRange = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            Sheet sheet = book.getSheet(s);
            lockRange = new BgSheetRange(sheet);
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    ItemFormula itemFormula;
                    String orgNumber;
                    Cell cell = sheet.getCell(r, c, false);
                    if (((MbgViewListSheetManager)this.getCurMbgSheetManager()).isCanEditOtherAddedBgForm().booleanValue()) continue;
                    String currentOrgNum = this.getBgFormInfo().getOrgUnit().getNumber();
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell) || StringUtils.isEmpty((String)(orgNumber = (itemFormula = BgNFSHelper.getItemFormula(cell)).getExt("ORGUNIT"))) || orgNumber.equals(currentOrgNum)) continue;
                    lockRange.addCell(cell.getRow(), cell.getCol());
                }
            }
        }
        if (lockRange != null && lockRange.getRange() != null && !lockRange.getRange().isEmpty()) {
            BgViewHelper.setLockedAndBackgroud(true, lockRange.getRange());
        }
    }

    protected void showRollOrgLock(Book book) throws Exception {
    }

    @Override
    public boolean isCheckFull() {
        return true;
    }

    public void updateBackState(Book book) throws EASBizException, BOSException {
        HashSet<String> orgNumbers = new HashSet<String>();
        this.getOrgNumsForCurBook(book, orgNumbers);
        if (!orgNumbers.isEmpty()) {
            IMBGFormFacade iMBGFormFacade = null;
            iMBGFormFacade = this.getCtx() == null ? MBGFormFacadeFactory.getRemoteInstance() : MBGFormFacadeFactory.getLocalInstance(this.getCtx());
            iMBGFormFacade.updateBackState(((BgFormInfo)this.getEditValue()).getId().toString(), orgNumbers);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = BgNFSHelper.getSelectors();
        sic.add("entries.id");
        sic.add("entries.bgformid");
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        sic.add("bgTemplate.styleSet.id");
        sic.add("bgTemplate.styleSet.number");
        sic.add("bgTemplate.styleSet.name");
        sic.add("bgTemplate.styleSet.data");
        sic.add("bgTemplate.styleSet.isSysDefault");
        sic.add("bgTemplate.bgScheme.id");
        sic.add("adjust.versionNo");
        return sic;
    }

    private void showAdjust(Book book) {
        if (this instanceof MbgViewListFormConvertExcelProvider) {
            return;
        }
        try {
            if (!(this.getOwner() instanceof MbgViewListFormProcessUI)) {
                return;
            }
            MbgViewListFormProcessUI ui = (MbgViewListFormProcessUI)this.getOwner();
            Map adjustMap = null;
            if (ui.getContextManager().getProvider() instanceof MBGViewListFormAdjustProvider) {
                adjustMap = ((MBGViewListFormAdjustProvider)ui.getContextManager().getProvider()).getAdjustMap();
            }
            ActionShowAdjust.showAdjust(book, this.getOrgUnitId(), this.getBgFormInfo().getBgScheme().getId().toString(), !ActionShowAdjust.isShowAdjust(ui.getShowAdjustMenuItem()), adjustMap, this.getBgFormInfo().getBgVersion().getNumber(), this.getBgFormInfo().getProcessType());
        }
        catch (NoClassDefFoundError e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public void beforeSaveCheck(Book _book) throws Exception {
        Sheet _sheet = null;
        Cell _cell = null;
        boolean hasBgFormula = false;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        Object _obj = null;
        BigDecimal _value = null;
        int sheetSize = _book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = _book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    hasBgFormula = BgNFSHelper.checkHasFormulaOfCell(_cell);
                    if (!hasBgFormula || BgNFSHelper.checkIsEmptyValue(_cell)) continue;
                    _obj = BgNFSHelper.getValue(_cell);
                    if (_obj != null) {
                        if (_obj instanceof BigDecimal) {
                            _value = (BigDecimal)_obj;
                        } else {
                            try {
                                _value = new BigDecimal(_obj.toString().trim().replaceAll(",", ""));
                            }
                            catch (Exception ex) {
                                _value = BgNConstants.ZERO;
                            }
                        }
                    } else {
                        _value = BgNConstants.ZERO;
                    }
                    if (!MBGViewListFormCommonHelper.checkCanSave(_cell, this, this.getEditScenType())) continue;
                    MBGViewListFormCommonHelper.checkFormulaValue(_value, rowIndex, colIndex);
                }
            }
        }
    }

    @Override
    protected IObjectValue getQueryDataInfo() {
        return this.getBgFormInfo();
    }

    @Override
    public boolean isCanEditBgData(Cell cell, String formula, BgNViewDataInfo bgData, String orgUnitId, IMbgViewBase view, int sheetIndex, String version) throws EASBizException, BOSException {
        boolean isInWfEdit = false;
        Object obj = null;
        if (this.getOwner() != null) {
            obj = this.getOwner().getUIContext().get("Owner");
        }
        if (OprtState.EDIT.equals(this.getOwner().getOprtState()) && obj != null && (obj instanceof MessageCenterUI || obj instanceof MultiApproveUI)) {
            isInWfEdit = true;
        }
        boolean check = super.isCanEditBgData(cell, formula, bgData, orgUnitId, view, sheetIndex, version);
        if (isInWfEdit && check && this.getBgFormInfo().getOrgUnit().getId().toString().equals(orgUnitId)) {
            return true;
        }
        return check && this.isCanEditByFormState(orgUnitId) && this.isCanEditByOtherForm(orgUnitId);
    }

    @Override
    protected boolean isCanEditByOtherForm(String orgId) {
        if (StringUtils.isEmpty((String)orgId)) {
            return true;
        }
        if (!((MbgViewListSheetManager)this.getCurMbgSheetManager()).isCanEditOtherAddedBgForm().booleanValue()) {
            String currentOrgId = this.getBgFormInfo().getOrgUnit().getId().toString();
            return currentOrgId.equals(orgId);
        }
        return true;
    }

    @Override
    public boolean isCanEditByFormState(String orgId) {
        if (orgId == null) {
            return true;
        }
        if ((BgFormStateEnum.Approving.equals((Object)this.orgIdFormState.get(orgId)) || BgFormStateEnum.REFERRING.equals((Object)this.orgIdFormState.get(orgId))) && !this.checkInProInst(orgId)) {
            return true;
        }
        return this.orgIdFormState.get(orgId) == null || BgFormStateEnum.Edited.equals((Object)this.orgIdFormState.get(orgId)) || BgFormStateEnum.Back.equals((Object)this.orgIdFormState.get(orgId));
    }

    @Override
    protected void getOrgIdFormStateMap() throws EASBizException, BOSException {
        Set<String> orgIdSetByCurManager = this.getOrgIdSetByCurManager();
        BgFormInfo bgFormInfo = this.getBgFormInfo();
        if (bgFormInfo != null && bgFormInfo.getId() != null && orgIdSetByCurManager != null && !orgIdSetByCurManager.isEmpty()) {
            IBgAdjustFacada iBgAdjustFacada = null;
            iBgAdjustFacada = this.getCtx() == null ? BgAdjustFacadaFactory.getRemoteInstance() : BgAdjustFacadaFactory.getLocalInstance(this.getCtx());
            Map orgIdFormIdMap = iBgAdjustFacada.getOrgIdFormIdMap(bgFormInfo.getId().toString(), orgIdSetByCurManager);
            if (orgIdFormIdMap != null && !orgIdFormIdMap.isEmpty()) {
                this.orgIdFormState = orgIdFormIdMap;
            }
        }
    }

    public void clearCache() {
        this.orgFormInPorInst.clear();
        this.orgIdFormState.clear();
    }
}

