/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.roll.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.mbg.BgRollException;
import com.kingdee.eas.ma.mbg.roll.impl.AbstractBgRollRuleStrategy;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MonthWeekRollStrategy
extends AbstractBgRollRuleStrategy {
    private Map<String, Integer> offsets = new LinkedHashMap<String, Integer>();
    private List<String> values = new ArrayList<String>();

    @Override
    public boolean isProcessPeriod(String bgPeriodNumber) {
        return 6 == (this.ctx != null ? BgPeriodHelper.getPeriodType((Context)this.ctx, (String)bgPeriodNumber) : BgPeriodHelper.getPeriodType((String)bgPeriodNumber));
    }

    @Override
    protected void initData() throws BOSException {
        this.initOffsetPeriod();
    }

    private void initOffsetPeriod() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("number");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)6, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type.fiscalYear", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type.selfDefined", (Object)false, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        IBgPeriodDisp instance = this.ctx != null ? BgPeriodDispFactory.getLocalInstance((Context)this.ctx) : BgPeriodDispFactory.getRemoteInstance();
        BgPeriodDispCollection col = instance.getBgPeriodDispCollection(view);
        int in = col.size();
        for (int i = 0; i < in; ++i) {
            this.offsets.put(col.get(i).getNumber(), i);
            this.values.add(col.get(i).getNumber());
        }
    }

    @Override
    public String getOffsetBgPeriodNumber(String periodNumber, int offset) throws BgRollException {
        if (this.offsets.containsKey(periodNumber)) {
            Integer index = this.offsets.get(periodNumber);
            if (index + offset < this.values.size()) {
                return this.values.get(index + offset);
            }
            throw new BgRollException(BgRollException.ROLLPERIODLIMIT1, this.getExceptionParam());
        }
        throw new BgRollException(BgRollException.ROLLPERIODLIMIT1, this.getExceptionParam());
    }
}

