/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.Aggregators;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;

public abstract class Aggregator
implements Serializable {
    public static final long serialVersionUID = 4576365898477547547L;
    public static final String SUM = "sum";
    public static final String MAX = "max";
    public static final String MIN = "min";
    public static final String AVG = "avg";
    public static final String COUNT = "count";
    public static final String FIRST = "first";
    public static final String LAST = "last";
    private static final HashMap aggregators = new HashMap();
    public final String name;

    private static HashMap getAggregators() {
        if (aggregators.isEmpty()) {
            Aggregators.register();
        }
        return aggregators;
    }

    public static void registerAggregator(Aggregator x) {
        aggregators.put(x.name, x);
    }

    public static Aggregator getAggregator(String name) throws CUBAException {
        Aggregator x = (Aggregator)Aggregator.getAggregators().get(name);
        if (x == null) {
            throw new CUBAException("Aggregator '" + name + "' not found.");
        }
        return x;
    }

    public Aggregator(String _name) {
        this.name = _name;
    }

    public abstract Object appendValue(Object var1, Object var2) throws CUBAException;

    public abstract Object appendAggregator(Object var1, Object var2) throws CUBAException;

    public abstract Object getValue(Object var1) throws CUBAException;

    public abstract boolean valueIsCompounded();

    public ValueSerializable getSerialize() {
        return null;
    }

    public static interface ValueSerializable {
        public Object deserialize(int var1, DataInput var2) throws IOException, ClassNotFoundException;

        public void serialize(Object var1, int var2, DataOutput var3) throws IOException;
    }
}

