/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.dbsource;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.dbsource.Table;
import java.util.Hashtable;

public class ArrayTable
implements Table {
    private Object[][] values;
    private String[] columnNames;
    private int[] columnTypes;
    private int colCount;
    private int rowCount;
    private int cursor = -1;
    private Hashtable columns = new Hashtable();

    public ArrayTable(Object[][] values, String[] columnNames, int[] columnTypes) {
        this.values = values;
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.colCount = columnNames.length;
        this.rowCount = values.length;
        for (int i = 0; i < this.colCount; ++i) {
            this.columns.put(columnNames[i].toLowerCase(), new Integer(i));
        }
    }

    @Override
    public int getColumnCount() throws CUBAException {
        return this.colCount;
    }

    @Override
    public int getColumnType(int index) throws CUBAException {
        if (index < 0 || index >= this.colCount) {
            throw new CUBAException("Index " + index + " is illegal.");
        }
        return this.columnTypes[index];
    }

    @Override
    public int getColumnIndex(String name) throws CUBAException {
        Integer index = (Integer)this.columns.get(name.toLowerCase());
        if (index == null) {
            throw new CUBAException("Column '" + name + "' not found.");
        }
        return index;
    }

    @Override
    public String[] getColumnNames() throws CUBAException {
        return this.columnNames;
    }

    @Override
    public boolean next() throws CUBAException {
        ++this.cursor;
        return this.cursor < this.rowCount;
    }

    @Override
    public Object getValue(int index) throws CUBAException {
        if (index < 0 || index >= this.colCount) {
            throw new CUBAException("Index " + index + " is illegal.");
        }
        return this.values[this.cursor][index];
    }

    @Override
    public Object[] getValues() throws CUBAException {
        return this.values[this.cursor];
    }

    @Override
    public void close() {
    }

    public int getRowCount() {
        return this.values.length;
    }

    public void reset() {
        this.cursor = -1;
    }
}

