/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.impl;

import com.kingdee.eas.ma.mbg.streamwork.cuba.Aggregator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Cube;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.DataIndex;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.HierarchyImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.MemberImpl;
import java.util.HashMap;

public class BlockIndex
implements DataIndex {
    private Cube cube;
    private HashMap data = new HashMap(1);
    protected Aggregator[] aggs;
    private int dimIndex;
    private int indexLen;
    private Object[] measureValues;
    private boolean childIsIndex = false;
    private int dataSize;
    private BlockIndex rootIndex;
    public static Object[] NULL = new Object[0];

    public BlockIndex(BlockIndex rootIndex, Cube cube, int dimIndex, int indexLen, Aggregator[] aggs) throws CUBAException {
        this.cube = cube;
        this.dimIndex = dimIndex;
        this.indexLen = indexLen;
        this.aggs = aggs;
        if (dimIndex < indexLen) {
            this.childIsIndex = true;
        }
        this.rootIndex = rootIndex;
    }

    @Override
    public boolean addRecord(Member[] point, Object[] values) throws CUBAException {
        if (this.childIsIndex) {
            Member key = point[this.dimIndex];
            Object[] oldValues = null;
            BlockIndex index = (BlockIndex)this.data.get(key);
            if (index != null) {
                oldValues = index.measureValues;
            } else {
                index = new BlockIndex(this.rootIndex, this.cube, this.dimIndex + 1, this.indexLen, this.aggs);
                this.data.put(key, index);
            }
            index.measureValues = this.appendValue(oldValues, values);
            if (index.addRecord(point, values)) {
                ++this.dataSize;
                return true;
            }
            return false;
        }
        IndexKey key = new IndexKey(point);
        Object[] vs = (Object[])this.data.get(key);
        if (this.data.put(key, vs = this.appendValue(vs, values)) == null) {
            ++this.dataSize;
            return true;
        }
        return false;
    }

    @Override
    public Object[] getData(Member[] members) throws CUBAException {
        if (this.dimIndex == 0 && members.length > 0 && members[0].isAll() && members[0].isInner()) {
            return this.aggChildrenIndex(members[0], members);
        }
        if (this.measureValues != null) {
            boolean isAllTuple = true;
            for (int i = this.dimIndex; i < members.length; ++i) {
                if (members[i].isInner() && members[i].isAll()) continue;
                isAllTuple = false;
                break;
            }
            if (isAllTuple) {
                return this.measureValues;
            }
        }
        if (this.childIsIndex) {
            Member key = members[this.dimIndex];
            Object index = this.data.get(key);
            if (index == NULL) {
                return null;
            }
            if (index == null) {
                if (key.isLeaf() && !key.isInner() && !key.isAll()) {
                    return null;
                }
                return this.aggChildrenIndex(key, members);
            }
            return ((BlockIndex)index).getData(members);
        }
        IndexKey key = new IndexKey(members);
        Object value = this.data.get(key);
        if (value == NULL) {
            return null;
        }
        if (value == null) {
            if (key.isLeaf()) {
                return null;
            }
            Object[] values = this.aggChildrenNotIndex(key, members);
            return values;
        }
        return (Object[])value;
    }

    private Object[] aggChildrenIndex(Member key, Member[] members) throws CUBAException {
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        Object[] values = new Object[this.aggs.length];
        MemberImpl[] children = null;
        children = members[this.dimIndex].isInner() && members[this.dimIndex].isAll() ? ((HierarchyImpl)members[this.dimIndex].getHierarchy()).getRootMembers() : ((MemberImpl)members[this.dimIndex]).getChildren();
        boolean hasData = false;
        for (int j = 0; j < children.length; ++j) {
            ms[this.dimIndex] = children[j];
            if (!ms[this.dimIndex].hasData()) continue;
            Object[] vs = this.getRootBlockIndex().getData(ms);
            if (children.length == 1) {
                return vs;
            }
            if (vs == null) continue;
            for (int k = 0; k < this.aggs.length; ++k) {
                if (this.aggs[k] == null) continue;
                values[k] = this.aggs[k].appendAggregator(values[k], vs[k]);
            }
            hasData = true;
        }
        if (hasData) {
            BlockIndex index = new BlockIndex(this.rootIndex, this.cube, this.dimIndex, this.indexLen, this.aggs);
            index.addRecord(members, values);
            this.data.put(key, index);
        } else {
            this.data.put(key, NULL);
        }
        return hasData ? values : null;
    }

    private Object[] aggChildrenNotIndex(IndexKey key, Member[] members) throws CUBAException {
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        Object[] values = new Object[this.aggs.length];
        boolean hasData = false;
        for (int i = this.dimIndex; i < members.length; ++i) {
            MemberImpl[] children = null;
            children = members[i].isInner() && members[i].isAll() ? ((HierarchyImpl)members[i].getHierarchy()).getRootMembers() : ((MemberImpl)members[i]).getChildren();
            if (children == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                ms[i] = children[j];
                if (!ms[i].hasData()) continue;
                Object[] vs = this.getRootBlockIndex().getData(ms);
                if (children.length == 1) {
                    return vs;
                }
                if (vs == null) continue;
                for (int k = 0; k < this.aggs.length; ++k) {
                    if (this.aggs[k] == null) continue;
                    values[k] = this.aggs[k].appendAggregator(values[k], vs[k]);
                }
                hasData = true;
            }
            break;
        }
        if (hasData) {
            this.data.put(key, values);
        } else {
            this.data.put(key, NULL);
        }
        return hasData ? values : null;
    }

    public Object[] appendValue(Object[] v1, Object[] v2) throws CUBAException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v1 == null) {
            v1 = new Object[v2.length];
            for (int i = 0; i < v1.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendValue(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new CUBAException("Measure '" + this.cube.getMeasures()[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendValue(v1[i], v2[i]);
        }
        return result;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    private BlockIndex getRootBlockIndex() {
        return this.rootIndex == null ? this : this.rootIndex;
    }

    private class IndexKey {
        Member[] keys = null;
        private int h;

        public IndexKey(Member[] point) {
            int index = 0;
            this.keys = new Member[point.length - BlockIndex.this.indexLen];
            for (int i = BlockIndex.this.indexLen; i < point.length; ++i) {
                this.keys[index++] = point[i];
            }
        }

        public boolean isLeaf() {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i].isLeaf() && (!this.keys[i].isInner() || !this.keys[i].isAll())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.h == 0) {
                for (int i = 0; i < this.keys.length; ++i) {
                    this.h += this.h << 2 ^ this.keys[i].getGlobalOrder();
                }
            }
            return this.h;
        }

        public boolean equals(Object x) {
            Member[] keys1 = this.keys;
            Member[] keys2 = ((IndexKey)x).keys;
            for (int i = 0; i < keys2.length; ++i) {
                if (keys1[i].equals(keys2[i])) continue;
                return false;
            }
            return true;
        }
    }
}

