/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.impl;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CalculatedMember;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Connection;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Cube;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Dimension;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Hierarchy;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.exception.HierarchyNoMemberException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.Coordy;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.HierarchyImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.MemberImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.Point2;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.CacheType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.CellReader;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Evaluator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Exp;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.MdxQuery;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.SchemaReader;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.BBFilter;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EvaluatorImpl
implements Evaluator {
    private static final Logger logger = Logger.getLogger(EvaluatorImpl.class);
    private static Object NULL = new Object();
    protected final MdxQuery query;
    protected final Cube cube;
    protected final Connection connection;
    protected Member[] currentMembers;
    protected final Evaluator parent;
    protected CellReader cellReader;
    protected final int depth;
    private final Map expResultCache;
    private final Map expFactResultCache;
    private final Map<Point2, Object> cellCalculationCache;
    private BBFilter cellCalculationNullFilter;
    private final Coordy coordy;
    private Member expandingMember;
    private boolean nonEmpty;
    private boolean nonFactEmpty;
    private int currentMemberLength;
    private Map dimensionOrdinal;
    private Member[] slicerMember;
    private boolean isCalcCellCalculation = true;
    private Map pinMap;

    public void setCalcCellCalculation(boolean isCalcCellCalculation) {
        this.isCalcCellCalculation = isCalcCellCalculation;
    }

    private EvaluatorImpl(Connection cn, MdxQuery query, Cube cube, CellReader cellReader, Evaluator parent, int depth, Map expResultCache, Map expFactResultCache, Map cellCalculationCache) {
        this.cube = cube;
        this.query = query;
        this.connection = cn;
        this.cellReader = cellReader;
        this.parent = parent;
        this.depth = depth;
        this.expResultCache = expResultCache;
        this.expFactResultCache = expFactResultCache;
        this.cellCalculationCache = cellCalculationCache;
        this.coordy = new Coordy(cube.getDimensions(true));
        this.cellCalculationNullFilter = cube.getCellCalculationNullFilter();
    }

    public Map<Point2, Object> getCellCalculationCache() {
        return this.cellCalculationCache;
    }

    public BBFilter getCellCalculationNullFilter() {
        return this.cellCalculationNullFilter;
    }

    public EvaluatorImpl(Connection cn, MdxQuery query, Cube cube, CellReader cellReader) throws CUBAException {
        this(cn, query, cube, cellReader, null, 0, new HashMap(3, 2.0f), new HashMap(3, 2.0f), new HashMap());
        SchemaReader scr = this.connection.getSchemaReader();
        Dimension[] dimensions = cube.getDimensions();
        this.currentMembers = new Member[dimensions.length + 1];
        this.dimensionOrdinal = new HashMap();
        for (int i = 0; i < dimensions.length; ++i) {
            Dimension dimension = dimensions[i];
            int ordinal = dimension.getOrdinal(cube);
            this.dimensionOrdinal.put(dimension, new Integer(ordinal));
            Hierarchy hier = dimension.getDefaultHierarchy();
            Member member = scr.getHierarchyDefaultMember(hier);
            if (member == null) {
                throw new HierarchyNoMemberException(hier);
            }
            this.currentMembers[ordinal] = member;
        }
        this.dimensionOrdinal.put(cube.getMeasureDimension(), new Integer(-1));
        this.currentMembers[dimensions.length] = cube.getMeasureDimension().getDefaultHierarchy().getDefaultMember();
        this.currentMemberLength = this.currentMembers.length;
    }

    protected EvaluatorImpl(Connection cn, MdxQuery query, Cube cube, Member[] currentMembers, EvaluatorImpl parent) {
        this(cn, query, cube, parent.cellReader, parent, parent.depth + 1, parent.expResultCache, parent.expFactResultCache, parent.cellCalculationCache);
        this.currentMembers = currentMembers;
        this.dimensionOrdinal = parent.dimensionOrdinal;
        this.currentMemberLength = parent.currentMemberLength;
        this.slicerMember = parent.slicerMember;
        this.pinMap = parent.pinMap;
    }

    @Override
    public Cube getCube() {
        return this.cube;
    }

    @Override
    public Evaluator push(Member[] members) throws CUBAException {
        Evaluator evaluator = this.push();
        evaluator.setContext(members);
        return evaluator;
    }

    @Override
    public Evaluator push() {
        Member[] cloneCurrentMembers = (Member[])this.currentMembers.clone();
        EvaluatorImpl evaluator = new EvaluatorImpl(this.connection, this.query, this.cube, cloneCurrentMembers, this);
        return evaluator;
    }

    @Override
    public Evaluator push(Member member) throws CUBAException {
        Evaluator evaluator = this.push();
        evaluator.setContext(member);
        return evaluator;
    }

    @Override
    public Evaluator pop() {
        return this.parent;
    }

    @Override
    public Member setContext(Member member) throws CUBAException {
        Member previous;
        Member m = member;
        if (m.isMeasure()) {
            previous = this.currentMembers[this.currentMemberLength - 1];
            this.currentMembers[this.currentMemberLength - 1] = m;
        } else {
            int ordinal = (Integer)this.dimensionOrdinal.get(m.getDimension());
            previous = this.currentMembers[ordinal];
            this.currentMembers[ordinal] = m;
        }
        return previous;
    }

    @Override
    public void setContext(Member[] members) throws CUBAException {
        this.setContextAsObject(members);
    }

    private void setContextAsObject(Object[] members) throws CUBAException {
        for (int i = 0; i < members.length; ++i) {
            Member member = (Member)members[i];
            if (member == null) continue;
            this.setContext(member);
        }
    }

    @Override
    public Member getContext(Dimension dimension) throws CUBAException {
        if (dimension.isMeasureDimension()) {
            return this.currentMembers[this.currentMemberLength - 1];
        }
        int ordinal = (Integer)this.dimensionOrdinal.get(dimension);
        return this.currentMembers[ordinal];
    }

    @Override
    public Object evaluateCurrent() throws CUBAException {
        Object o;
        int i;
        Calc cellCalculation;
        Point2 point = new Point2(this.coordy, this.currentMembers);
        long coord = point.getCoordinate();
        if (coord > 0L && this.cellCalculationNullFilter.get(coord)) {
            return null;
        }
        Object o2 = this.cellCalculationCache.get(point);
        if (o2 == NULL) {
            return null;
        }
        if (o2 != null) {
            return o2;
        }
        if (this.isCalcCellCalculation && (cellCalculation = this.query.getCellCalculation(this)) != null) {
            if (coord > 0L && this.cellCalculationNullFilter.get(coord)) {
                return null;
            }
            Object o3 = this.cellCalculationCache.get(point);
            if (o3 == null) {
                o3 = cellCalculation.evaluate(this);
                if (o3 == null) {
                    if (coord > 0L) {
                        this.cellCalculationNullFilter.set(coord);
                    } else {
                        this.cellCalculationCache.put(point, NULL);
                    }
                    boolean isAllLeaf = true;
                    for (int i2 = 0; i2 < this.currentMembers.length; ++i2) {
                        if (this.currentMembers[i2].getDimension().isMeasureDimension() || this.currentMembers[i2].isLeaf()) continue;
                        isAllLeaf = false;
                        break;
                    }
                    if (isAllLeaf && this.cellReader.get(this) != null) {
                        ArrayList<Member> list = new ArrayList<Member>(this.currentMembers.length);
                        Member measure = null;
                        for (int i3 = 0; i3 < this.currentMembers.length; ++i3) {
                            if (this.currentMembers[i3].getDimension().isMeasureDimension()) {
                                measure = this.currentMembers[i3];
                                continue;
                            }
                            list.add(this.currentMembers[i3]);
                        }
                        int measureIndex = -1;
                        Member[] measures = this.cube.getMeasures();
                        for (int i4 = 0; i4 < measures.length; ++i4) {
                            if (measure == null || !measures[i4].getName().equals(measure.getName())) continue;
                            measureIndex = i4;
                            break;
                        }
                        Member[] point1 = new Member[list.size()];
                        list.toArray(point1);
                        Point2 pk = new Point2(this.coordy, point1);
                        if (this.getPinCache().get(pk) == null) {
                            this.getPinCache().put(pk, new Object[measures.length]);
                        }
                        this.cellReader.buildBB(point1);
                        ((Object[])this.getPinCache().get((Object)pk))[measureIndex] = o3;
                    }
                } else {
                    this.cellCalculationCache.put(point, o3);
                    ArrayList<Member> list = new ArrayList<Member>(this.currentMembers.length);
                    Member measure = null;
                    for (int i5 = 0; i5 < this.currentMembers.length; ++i5) {
                        if (this.currentMembers[i5].getDimension().isMeasureDimension()) {
                            measure = this.currentMembers[i5];
                            continue;
                        }
                        list.add(this.currentMembers[i5]);
                    }
                    int measureIndex = -1;
                    Member[] measures = this.cube.getMeasures();
                    for (int i6 = 0; i6 < measures.length; ++i6) {
                        if (measure == null || !measures[i6].getName().equals(measure.getName())) continue;
                        measureIndex = i6;
                        break;
                    }
                    Member[] point1 = new Member[list.size()];
                    list.toArray(point1);
                    Point2 pk = new Point2(this.coordy, point1);
                    if (this.getPinCache().get(pk) == null) {
                        this.getPinCache().put(pk, new Object[measures.length]);
                    }
                    this.cellReader.buildBB(point1);
                    ((Object[])this.getPinCache().get((Object)pk))[measureIndex] = o3;
                    for (int i7 = 0; i7 < this.currentMembers.length; ++i7) {
                        if (!(this.currentMembers[i7] instanceof MemberImpl)) continue;
                        ((MemberImpl)this.currentMembers[i7]).setHasData(true);
                    }
                }
                return o3;
            }
            if (o3 == NULL) {
                return null;
            }
            return o3;
        }
        Member maxSolveMember = this.getMaxSolveMember();
        if (maxSolveMember != null) {
            boolean cache;
            Member defaultMember = maxSolveMember.getHierarchy().getDefaultMember();
            EvaluatorImpl evaluator = (EvaluatorImpl)this.push(defaultMember);
            evaluator.setExpanding(maxSolveMember);
            Object o4 = null;
            Exp exp = null;
            CalculatedMember cMember = (CalculatedMember)maxSolveMember;
            boolean bl = cache = !CacheType.NO.equals(cMember.getCacheType());
            if (cache && (o4 = this.getCachedResult(exp = cMember.getExpression())) != null) {
                if (o4 == Util.nullValue) {
                    return null;
                }
                return o4;
            }
            if (cMember.isNull()) {
                o4 = null;
            } else {
                exp = cMember.getExpression();
                Calc calc = this.query.compileExpression(exp, true);
                o4 = calc.evaluate(evaluator);
            }
            if (cache) {
                if (o4 == null) {
                    this.setCachedResult(exp, Util.nullValue);
                } else {
                    this.setCachedResult(exp, o4);
                }
            }
            if (o4 == Util.nullValue) {
                return null;
            }
            return o4;
        }
        for (i = 0; i < this.currentMembers.length; ++i) {
            if (this.currentMembers[i] != null) continue;
            return null;
        }
        for (i = 0; i < this.currentMembers.length; ++i) {
            Exp exp = this.currentMembers[i].getExpression();
            if (exp == null) continue;
            Calc calc = this.query.compileExpression(exp, true);
            return calc.evaluate(this.push());
        }
        if (this.query.getConnection().isLeafBeforeCalc()) {
            boolean allLeaf = true;
            for (int i8 = 0; i8 < this.currentMembers.length; ++i8) {
                if (!this.currentMembers[i8].isLeaf()) {
                    allLeaf = false;
                    break;
                }
                if (!this.currentMembers[i8].isInner() || !this.currentMembers[i8].isAll()) continue;
                allLeaf = false;
                break;
            }
            if (!allLeaf) {
                Member[] ms = new Member[this.currentMembers.length];
                System.arraycopy(this.currentMembers, 0, ms, 0, ms.length);
                this.evaluateLeaf(ms, 0);
            }
        }
        if ((o = this.cellReader.get(this)) == null) {
            this.cellCalculationNullFilter.set(coord);
        } else {
            this.cellCalculationCache.put(point, o);
        }
        return o;
    }

    private void evaluateLeaf(Member[] ms, int index) throws CUBAException {
        ArrayList<Member> leafChild = new ArrayList<Member>();
        Member old = ms[index];
        this.getLeafMember(ms[index], leafChild);
        if (index == ms.length - 1) {
            if (leafChild != null && leafChild.isEmpty()) {
                this.push(ms).evaluateCurrent();
            } else {
                for (int i = 0; i < leafChild.size(); ++i) {
                    ms[index] = (Member)leafChild.get(i);
                    this.push(ms).evaluateCurrent();
                }
                ms[index] = old;
            }
        } else if (leafChild != null && leafChild.isEmpty()) {
            this.evaluateLeaf(ms, index + 1);
        } else {
            for (int i = 0; i < leafChild.size(); ++i) {
                ms[index] = (Member)leafChild.get(i);
                this.evaluateLeaf(ms, index + 1);
            }
            ms[index] = old;
        }
    }

    private void getLeafMember(Member member, List<Member> leafChild) {
        MemberImpl[] children = null;
        children = member.isInner() && member.isAll() ? ((HierarchyImpl)member.getHierarchy()).getRootMembers() : ((MemberImpl)member).getChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (children[i].isLeaf()) {
                    leafChild.add(children[i]);
                    continue;
                }
                this.getLeafMember(children[i], leafChild);
            }
        }
    }

    private void setExpanding(Member member) throws CUBAException {
        this.expandingMember = member;
        int memberCount = this.currentMembers.length;
        if (this.depth > memberCount && this.depth % memberCount == 0) {
            EvaluatorImpl.checkRecursion((EvaluatorImpl)this.parent);
        }
    }

    private static void checkRecursion(EvaluatorImpl eval) throws CUBAException {
        while (true) {
            if (eval == null) {
                return;
            }
            if (eval.expandingMember != null) break;
            eval = (EvaluatorImpl)eval.getParent();
        }
        block1: for (EvaluatorImpl eval2 = (EvaluatorImpl)eval.getParent(); eval2 != null; eval2 = (EvaluatorImpl)eval2.getParent()) {
            if (eval2.expandingMember != eval.expandingMember) continue;
            for (int i = 0; i < eval.currentMembers.length; ++i) {
                Member parentMember;
                Member member = eval2.currentMembers[i];
                if (member != null && member != (parentMember = eval.getContext(member.getDimension()))) continue block1;
            }
            throw new CUBAException("Infinite loop while evaluating calculated member '" + eval.expandingMember + "'; context stack is " + eval.getContextString());
        }
    }

    private String getContextString() {
        boolean skipDefaultMembers = true;
        StringBuffer sb = new StringBuffer("{");
        int frameCount = 0;
        for (EvaluatorImpl eval = this; eval != null; eval = (EvaluatorImpl)eval.getParent()) {
            if (eval.expandingMember == null) continue;
            if (frameCount++ > 0) {
                sb.append(", ");
            }
            sb.append("(");
            int memberCount = 0;
            for (int j = 0; j < eval.currentMembers.length; ++j) {
                Member m = eval.currentMembers[j];
                if (skipDefaultMembers && m == m.getHierarchy().getDefaultMember()) continue;
                if (memberCount++ > 0) {
                    sb.append(", ");
                }
                sb.append(m.getUniqueName());
            }
            sb.append(")");
        }
        sb.append("}");
        return sb.toString();
    }

    public Member getMaxSolveMember() {
        int maxSolve = Integer.MIN_VALUE;
        Member maxSolveMember = null;
        for (Member currentMember : this.currentMembers) {
            int solve;
            if (currentMember == null || !currentMember.isCalculated() || (solve = ((CalculatedMember)currentMember).getSolveOrder()) <= maxSolve) continue;
            maxSolve = solve;
            maxSolveMember = currentMember;
        }
        return maxSolveMember;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public Evaluator getParent() {
        return this.parent;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public SchemaReader getSchemaReader() {
        return this.connection.getSchemaReader();
    }

    private Object getExpResultCacheKey(Exp exp) {
        ArrayList<Serializable> key = new ArrayList<Serializable>();
        key.add(exp);
        for (int i = 0; i < this.currentMembers.length; ++i) {
            Dimension dim;
            Member member = this.currentMembers[i];
            if (member == null || !exp.dependsOn(dim = member.getDimension())) continue;
            key.add(this.currentMembers[i]);
        }
        return key;
    }

    @Override
    public Object getCachedResult(Exp exp) {
        Object key = this.getExpResultCacheKey(exp);
        return this.expResultCache.get(key);
    }

    @Override
    public void setCachedResult(Exp exp, Object result) {
        Object key = this.getExpResultCacheKey(exp);
        this.expResultCache.put(key, result);
    }

    public void clearExpResultCache(boolean clearFact) {
        this.expResultCache.clear();
        if (clearFact) {
            this.expFactResultCache.clear();
        }
    }

    @Override
    public boolean isNonEmpty() {
        return this.nonEmpty;
    }

    @Override
    public void setNonEmpty(boolean b) {
        this.nonEmpty = b;
    }

    @Override
    public boolean isNonFactEmpty() {
        return this.nonFactEmpty;
    }

    @Override
    public void setNonFactEmpty(boolean nonFactEmpty) {
        this.nonFactEmpty = nonFactEmpty;
    }

    @Override
    public Member[] getCurrentMembers() {
        return this.currentMembers;
    }

    @Override
    public MdxQuery getQuery() {
        return this.query;
    }

    @Override
    public Member[] getSlicerMember() {
        return this.slicerMember;
    }

    public void setSlicerMember(Member[] slicerMember) {
        this.slicerMember = slicerMember;
    }

    public CellReader getCellReader() {
        return this.cellReader;
    }

    @Override
    public void setContext(Object o) throws CUBAException {
        if (o instanceof Member) {
            this.setContext((Member)o);
        } else if (o instanceof Object[]) {
            this.setContextAsObject((Member[])o);
        } else {
            throw Util.newInternal("can't go here");
        }
    }

    @Override
    public void setPinCache(Map map) {
        this.pinMap = map;
    }

    @Override
    public Map getPinCache() {
        return this.pinMap;
    }
}

