/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.impl;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.dbsource.Table;
import com.kingdee.eas.ma.mbg.streamwork.cuba.def.LevelDef;
import com.kingdee.eas.ma.mbg.streamwork.cuba.def.PropertyDef;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.Field;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.LevelImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.MemberImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.MemberTreeNode;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.Util;
import java.util.HashMap;

class LevelFetch {
    Field field;
    Field[] propFields = new Field[0];
    PropertyDef[] props = new PropertyDef[0];
    String[] propDataTypes = new String[0];
    LevelImpl level;
    LevelDef def;
    Field childField = null;
    Field parentField = null;
    Field orderByField = null;
    boolean hasName = false;

    LevelFetch(LevelImpl _level, LevelDef _def) {
        this.def = _def;
        this.level = _level;
        this.field = new Field(this.def.column);
        this.field.type = this.level.levelType;
        if (this.def.parentColumn != null) {
            this.parentField = new Field(this.def.parentColumn);
        }
        if (this.def.childColumn != null) {
            this.childField = new Field(this.def.childColumn);
        }
        if (this.def.properties != null) {
            this.props = this.def.properties;
            this.propFields = new Field[this.props.length];
            this.propDataTypes = new String[this.props.length];
            for (int i = 0; i < this.propFields.length; ++i) {
                this.propFields[i] = new Field(this.props[i].column);
                this.propDataTypes[i] = this.props[i].dataType;
                if (!this.props[i].name.equals("name")) continue;
                this.hasName = true;
            }
        }
        if (this.def.orderBy != null) {
            this.orderByField = new Field(this.def.orderBy);
        }
    }

    MemberTreeNode fetch(MemberTreeNode parent, Table table) throws CUBAException {
        MemberTreeNode item;
        Object key = this.field.getValue(table);
        if (key == null) {
            return null;
        }
        Object childKey = key;
        if (this.childField != null) {
            childKey = this.childField.getValue(table);
        }
        if (parent.children == null) {
            parent.children = new HashMap();
        }
        if ((item = (MemberTreeNode)parent.children.get(childKey)) == null) {
            MemberImpl member = new MemberImpl();
            member.level = this.level;
            member.memberType = 1;
            member.setKey(key);
            member.parent = (MemberImpl)parent.member;
            for (int i = 0; i < this.props.length; ++i) {
                Object value = this.propFields[i].getValue(table);
                member.setProperty(this.props[i].name, value);
                if (this.propDataTypes[i] != null) continue;
                this.propDataTypes[i] = Util.decideDataType(value);
            }
            if (this.orderByField != null) {
                Object value = this.orderByField.getValue(table);
                member.setProperty("orderBy", value);
            }
            item = new MemberTreeNode();
            item.member = member;
            if (this.parentField != null) {
                item.childValue = childKey;
                item.parentValue = this.parentField.getValue(table);
            }
            item.levelDef = this.def;
            parent.children.put(childKey, item);
        }
        return item;
    }

    public void finish() {
        if (this.level.props == null) {
            return;
        }
        for (int i = 0; i < this.level.props.length; ++i) {
            this.level.props[i].setProperty("dataType", this.propDataTypes[i]);
        }
    }
}

