/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.mdx;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Exp;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.ExpBase;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.ExpResolver;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunDef;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunTable;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Syntax;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.ExpCompiler;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.Type;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.Walkable;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.log4j.Logger;

public class FunCall
extends ExpBase
implements Walkable {
    private static final long serialVersionUID = -3537813866095205073L;
    private static Logger logger = Logger.getLogger(FunCall.class);
    private transient FunDef funDef;
    private String function;
    private Exp[] args;
    private Syntax syntax;
    private Type type;
    private boolean isWrapSortOrFilter;
    private boolean resolved;

    public FunCall(String fun, Exp[] args) {
        this(fun, args, Syntax.Function);
    }

    public FunCall(String fun, Exp[] args, Syntax syntax) {
        this.function = fun;
        this.args = args;
        this.syntax = syntax;
    }

    public FunDef getFunDef() {
        return this.funDef;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    @Override
    public Object clone() {
        Exp[] cloneArgs = new Exp[this.args.length];
        for (int i = 0; i < cloneArgs.length; ++i) {
            cloneArgs[i] = (Exp)this.args[i].clone();
        }
        return new FunCall(this.function, cloneArgs, this.syntax);
    }

    public boolean isCallTo(String fName) {
        return fName.compareToIgnoreCase(this.function) == 0;
    }

    public boolean isCallToTuple() {
        return this.syntax == Syntax.Parentheses;
    }

    public Exp[] getArgs() {
        return this.args;
    }

    @Override
    public Object[] getChildren() {
        return this.args;
    }

    public Exp getArg(int index) {
        if (this.args == null) {
            return null;
        }
        return this.args[index];
    }

    public int getArgCount() {
        if (this.args == null) {
            return 0;
        }
        return this.args.length;
    }

    public String getFunction() {
        return this.function;
    }

    public String getFunName() {
        return this.function;
    }

    @Override
    public int getCategory() {
        return this.funDef.getReturnCategory();
    }

    @Override
    public Exp resolve(ExpResolver resolver) throws CUBAException {
        if (this.resolved) {
            return this;
        }
        for (int i = 0; i < this.args.length; ++i) {
            Exp exp = this.args[i];
            this.args[i] = resolver.resolve(this.args[i]);
            if (this.args[i] != null) continue;
            throw new CUBAException("Parse error,can't resolver expression " + exp.toMdx());
        }
        this.funDef = FunTable.instance.getDef(this);
        return this.funDef.resolveCall(resolver, this);
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void unparse(StringBuffer sb) {
        if (this.funDef != null) {
            this.funDef.unparse(this.args, sb);
        } else {
            this.syntax.unparse(this.function, this.args, sb);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.syntax = Syntax.get(this.syntax.getOrdinal());
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    @Override
    public Calc compile(ExpCompiler compiler) throws CUBAException {
        if (this.resolved) {
            return this.funDef.compileCall(this, compiler);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isWrapSortOrFilter() {
        return this.isWrapSortOrFilter;
    }

    public void setWrapSortOrFilter(boolean isWrapSortOrFilter) {
        this.isWrapSortOrFilter = isWrapSortOrFilter;
    }
}

