/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.mdx;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Cube;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Dimension;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Hierarchy;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Level;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Category;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Exp;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.ExpResolver;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunCall;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunDef;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FuncResolver;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Syntax;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.TypeConvertUtil;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.func.FuncUtil2;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.BooleanType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.CubeType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.DimensionType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.HierarchyType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.LevelType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.MemberType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.NumericType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.ScalarType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.SetType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.StringType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.SymbolType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.Type;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.TypeUtil;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.Util;

public abstract class FunDefBase
implements FunDef {
    private final Syntax syntax;
    private final String name;
    private final String description;
    protected final int returnCategory;
    protected final int[] argCategorys;

    public FunDefBase(String name, String description, Syntax syntax, int returnCategory, int[] argCategorys) {
        this.name = name;
        this.description = description;
        this.syntax = syntax;
        this.returnCategory = returnCategory;
        this.argCategorys = argCategorys;
    }

    protected FunDefBase(String name, String signature, String description, String flags) {
        this(name, description, FuncUtil2.decodeSyntacticType(flags), FuncUtil2.decodeReturnCategory(flags), FuncUtil2.decodeArgCategory(flags));
    }

    public FunDefBase(FuncResolver resolver, int returnCategory, int[] argCategorys) {
        this(resolver.getName(), null, resolver.getSyntax(), returnCategory, argCategorys);
    }

    public FunDefBase(FunDef funDef) {
        this(funDef.getName(), funDef.getDescription(), funDef.getSyntax(), funDef.getReturnCategory(), funDef.getArgCategorys());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Syntax getSyntax() {
        return this.syntax;
    }

    @Override
    public int getReturnCategory() {
        return this.returnCategory;
    }

    @Override
    public int[] getArgCategorys() {
        return this.argCategorys;
    }

    @Override
    public FunCall resolveCall(ExpResolver resolver, FunCall call) throws CUBAException {
        int[] types = this.getArgCategorys();
        Exp[] args = call.getArgs();
        for (int i = 0; i < args.length; ++i) {
            Exp arg = args[i];
            args[i] = TypeConvertUtil.convert(arg, types[i], resolver);
        }
        Type type = this.getResultType(resolver, args);
        if (type == null) {
            throw new CUBAException("could not derive type");
        }
        call.setType(type);
        call.setResolved(true);
        return call;
    }

    static Type guessResultType(Exp[] args, int category, String name) {
        switch (category) {
            case 5: {
                return new BooleanType();
            }
            case 7: {
                return new NumericType();
            }
            case 9: {
                return new StringType();
            }
            case 11: {
                return new SymbolType();
            }
            case 13: {
                return new ScalarType();
            }
            case 12: {
                if (args.length <= 0 || !(args[0] instanceof Cube)) break;
                return new CubeType((Cube)((Object)args[0]));
            }
            case 2: {
                if (args.length <= 0) break;
                Type type = args[0].getType();
                Hierarchy hierarchy = type.getHierarchy();
                Dimension dimension = hierarchy == null ? null : hierarchy.getDimension();
                return new DimensionType(dimension);
            }
            case 3: {
                if (args.length <= 0) break;
                Type type = args[0].getType();
                Hierarchy hierarchy = type.getHierarchy();
                return new HierarchyType(hierarchy);
            }
            case 4: {
                if (args.length <= 0 || !(args[0] instanceof Level)) break;
                Type type = args[0].getType();
                Level level = TypeUtil.typeToLevel(type);
                return new LevelType(level.getHierarchy(), level);
            }
            case 6: 
            case 10: {
                if (args.length > 0) {
                    Type type = args[0].getType();
                    if ((type = TypeUtil.toMemberType(type)) != null) {
                        return type;
                    }
                }
                return MemberType.Unknown;
            }
            case 8: {
                if (args.length <= 0) break;
                Type type = args[0].getType();
                return new SetType(TypeUtil.toMemberType(type));
            }
            default: {
                throw Category.instance.badValue(category);
            }
        }
        throw Util.newInternal("Cannot deduce type of call to function '" + name + "'");
    }

    public Type getResultType(ExpResolver resolver, Exp[] args) throws CUBAException {
        return FunDefBase.guessResultType(args, this.getReturnCategory(), this.name);
    }

    @Override
    public void unparse(Exp[] args, StringBuffer sb) {
        this.getSyntax().unparse(this.getName(), args, sb);
    }

    @Override
    public boolean shouldCacheFact() {
        return false;
    }
}

