/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.impl;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Dimension;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Hierarchy;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Level;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.IList;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Evaluator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Exp;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.BigDecimalCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.DoubleCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.IntegerCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.StringCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.VoidCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.impl.AbstractCalc;
import java.math.BigDecimal;

public abstract class GenericCalc
extends AbstractCalc
implements StringCalc,
IntegerCalc,
DoubleCalc,
BigDecimalCalc,
VoidCalc {
    protected GenericCalc(Exp exp) {
        super(exp);
    }

    public IList evaluateList(Evaluator evaluator) throws CUBAException {
        return (IList)this.evaluate(evaluator);
    }

    @Override
    public String evaluateString(Evaluator evaluator) throws CUBAException {
        Object o = this.evaluate(evaluator);
        if (o == null) {
            return null;
        }
        if (o instanceof Member) {
            o = evaluator.push((Member)o).evaluateCurrent();
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Number) {
            return o.toString();
        }
        if (o instanceof Member) {
            return this.evaluateString(evaluator.push((Member)o));
        }
        throw new CUBAException("Can't convert " + this.exp.toMdx() + " to String.");
    }

    @Override
    public int evaluateInteger(Evaluator evaluator) throws CUBAException {
        Object o = this.evaluate(evaluator);
        if (o instanceof Member) {
            o = evaluator.push((Member)o).evaluateCurrent();
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        throw new CUBAException("Can't convert " + this.exp.toMdx() + " to Integer.");
    }

    @Override
    public double evaluateDouble(Evaluator evaluator) throws CUBAException {
        Object o = this.evaluate(evaluator);
        if (o instanceof Member) {
            o = evaluator.push((Member)o).evaluateCurrent();
        }
        Number number = (Number)o;
        return number.doubleValue();
    }

    @Override
    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws CUBAException {
        Object o = this.evaluate(evaluator);
        if (o == null) {
            return null;
        }
        if (o instanceof Member) {
            o = evaluator.push((Member)o).evaluateCurrent();
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return new BigDecimal(number.doubleValue());
        }
        throw new CUBAException("Can't convert " + this.exp.toMdx() + " to Number.");
    }

    @Override
    public void evaluateVoid(Evaluator evaluator) throws CUBAException {
        this.evaluate(evaluator);
    }

    public Member evaluateMember(Evaluator evaluator) throws CUBAException {
        return (Member)this.evaluate(evaluator);
    }

    public Level evaluateLevel(Evaluator evaluator) throws CUBAException {
        return (Level)this.evaluate(evaluator);
    }

    public Hierarchy evaluateHierarchy(Evaluator evaluator) throws CUBAException {
        return (Hierarchy)this.evaluate(evaluator);
    }

    public Dimension evaluateDimension(Evaluator evaluator) throws CUBAException {
        return (Dimension)this.evaluate(evaluator);
    }
}

