/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.impl.func;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Level;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.IMemberList;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Evaluator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Exp;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.SchemaReader;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.LevelCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.MemberCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.impl.AbstractMemberListCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.func.FuncUtil2;

public class DescendantsCalc
extends AbstractMemberListCalc {
    MemberCalc memberCalc;
    LevelCalc levelCalc;
    private final boolean self;
    private final boolean before;
    private final boolean after;
    private final boolean depthSpecified;
    private final int depthLimit;

    public DescendantsCalc(Exp exp, MemberCalc memberCalc, LevelCalc levelCalc, boolean self, boolean before, boolean after, boolean depthSpecified, int depthLimit) {
        super(exp, new Calc[]{memberCalc, levelCalc});
        this.memberCalc = memberCalc;
        this.self = self;
        this.before = before;
        this.after = after;
        this.depthSpecified = depthSpecified;
        this.depthLimit = depthLimit;
    }

    @Override
    public IMemberList evaluateMemberList(Evaluator evaluator) throws CUBAException {
        Member member = this.memberCalc.evaluateMember(evaluator);
        IMemberList result = evaluator.getQuery().getListFactory().createMemberList();
        SchemaReader schemaReader = evaluator.getSchemaReader();
        if (this.depthSpecified) {
            DescendantsCalc.descendantsByDepth(evaluator, member, result, schemaReader, this.depthLimit, this.before, this.self, this.after);
        } else {
            Level level = this.levelCalc != null ? this.levelCalc.evaluateLevel(evaluator) : member.getLevel();
            schemaReader.getMemberDescendants(member, result, level, this.before, this.self, this.after);
        }
        FuncUtil2.hierarchize(result, false);
        return result;
    }

    private static IMemberList descendantsByDepth(Evaluator evaluator, Member member, IMemberList result, SchemaReader schemaReader, int depthLimitFinal, boolean before, boolean self, boolean after) {
        IMemberList children = evaluator.getQuery().getListFactory().createMemberList();
        children.add(member);
        int depth = 0;
        while (true) {
            if (depth == depthLimitFinal) {
                if (self) {
                    FuncUtil2.addAll(result, children);
                }
                if (!after) {
                    break;
                }
            } else if (depth < depthLimitFinal) {
                if (before) {
                    FuncUtil2.addAll(result, children);
                }
            } else {
                if (!after) break;
                FuncUtil2.addAll(result, children);
            }
            try {
                children = schemaReader.getMemberChildren(children);
            }
            catch (CUBAException e) {
                break;
            }
            if (children.isEmpty()) break;
            ++depth;
        }
        return result;
    }
}

