/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.func;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Dimension;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Evaluator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Exp;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunCall;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunDefBase;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.DimensionCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.ExpCompiler;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.impl.AbstractMemberCalc;

public class DimensionCurrentMemberFunDef
extends FunDefBase {
    static final DimensionCurrentMemberFunDef instance = new DimensionCurrentMemberFunDef();

    private DimensionCurrentMemberFunDef() {
        super("CurrentMember", "<Dimension>.CurrentMember", "Returns the current member along a dimension during an iteration.", "pmd");
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
        DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
        return new CalcImpl((Exp)call, dimensionCalc);
    }

    public static class CalcImpl
    extends AbstractMemberCalc {
        private final DimensionCalc dimensionCalc;

        public CalcImpl(Exp exp, DimensionCalc dimensionCalc) {
            super(exp, new Calc[]{dimensionCalc});
            this.dimensionCalc = dimensionCalc;
        }

        @Override
        protected String getName() {
            return "CurrentMember";
        }

        @Override
        public Member evaluateMember(Evaluator evaluator) throws CUBAException {
            Dimension dimension = this.dimensionCalc.evaluateDimension(evaluator);
            if (evaluator == null) {
                return dimension.getDefaultHierarchy().getDefaultMember();
            }
            return evaluator.getContext(dimension);
        }

        public boolean dependsOn(Dimension dimension) {
            return this.dimensionCalc.getType().usesDimension(dimension);
        }
    }
}

