/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.util;

import com.kingdee.eas.ma.mbg.streamwork.cuba.util.InOutSqlUtil;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;

public class ByteArrayOutputStream
extends OutputStream
implements DataOutput {
    protected byte[] buf;
    protected int count;

    public ByteArrayOutputStream() {
        this(1024);
    }

    public ByteArrayOutputStream(int size) {
        if (size < 1024) {
            size = 1024;
        }
        this.buf = new byte[size];
    }

    public ByteArrayOutputStream(byte[] buffer) {
        this.buf = buffer;
    }

    @Override
    public final void writeShort(int v) {
        this.ensureRoom(2);
        this.buf[this.count++] = (byte)(v >>> 8);
        this.buf[this.count++] = (byte)v;
    }

    @Override
    public final void writeInt(int v) {
        if (this.count + 4 > this.buf.length) {
            this.ensureRoom(4);
        }
        this.buf[this.count++] = (byte)(v >>> 24);
        this.buf[this.count++] = (byte)(v >>> 16);
        this.buf[this.count++] = (byte)(v >>> 8);
        this.buf[this.count++] = (byte)v;
    }

    @Override
    public final void writeLong(long v) {
        this.writeInt((int)(v >>> 32));
        this.writeInt((int)v);
    }

    @Override
    public final void writeBytes(String s) {
        int len = s.length();
        this.ensureRoom(len);
        for (int i = 0; i < len; ++i) {
            this.buf[this.count++] = (byte)s.charAt(i);
        }
    }

    @Override
    public final void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.ensureRoom(1);
        this.buf[this.count++] = (byte)(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.ensureRoom(1);
        this.buf[this.count++] = (byte)v;
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.ensureRoom(2);
        this.buf[this.count++] = (byte)(v >>> 8);
        this.buf[this.count++] = (byte)v;
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        this.ensureRoom(len * 2);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.buf[this.count++] = (byte)(v >>> 8);
            this.buf[this.count++] = (byte)v;
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        int len = str.length();
        if (len > 65535) {
            throw new UTFDataFormatException();
        }
        this.ensureRoom(len * 3 + 2);
        int initpos = this.count;
        this.count += 2;
        InOutSqlUtil.writeUTF(str, this);
        int bytecount = this.count - initpos - 2;
        if (bytecount > 65535) {
            this.count = initpos;
            throw new UTFDataFormatException();
        }
        this.buf[initpos++] = (byte)(bytecount >>> 8);
        this.buf[initpos] = (byte)bytecount;
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    @Override
    public void write(int b) {
        this.ensureRoom(1);
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.ensureRoom(len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, enc);
    }

    @Override
    public void close() throws IOException {
    }

    public void fill(int b, int len) {
        this.ensureRoom(len);
        for (int i = 0; i < len; ++i) {
            this.buf[this.count++] = (byte)b;
        }
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    protected void ensureRoom(int extra) {
        int newcount = this.count + extra;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[newcount + newcount / 2 + 256 & 0xFFFFFF00];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
    }

    protected void reset(int newSize) {
        this.count = 0;
        if (newSize > this.buf.length) {
            this.buf = new byte[newSize];
        }
    }
}

