/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeEntryInfo;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeFacadeFactory;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeInfo;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeReportInfo;
import com.kingdee.eas.ma.mbg.BgFinalizedResultEnum;
import com.kingdee.eas.ma.mbg.BgFinalizedResultFactory;
import com.kingdee.eas.ma.mbg.BgFinalizedResultInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgReCalcSchemeHelper;
import com.kingdee.eas.ma.mbg.IBgCalculateSchemeFacade;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class BgCalculateSchemeServerThread {
    private static Logger logger = Logger.getLogger((String)BgCalculateSchemeServerThread.class.getName());
    private static int availableProcessors = Runtime.getRuntime().availableProcessors();
    private static int CALC_DEFAULT_POOLSIZE = availableProcessors / 2 + 1;
    private Context ctx = null;
    private Set<String> orgList = null;
    private IObjectValue info = null;
    private Map<String, Map<String, BgCalculateSchemeReportInfo>> bgCalcSchemeReportMap = null;
    private Map<String, BgCalculateSchemeInfo> bcsMap = null;

    public BgCalculateSchemeServerThread(Context ctx, Set<String> orgList, IObjectValue info, Map<String, Map<String, BgCalculateSchemeReportInfo>> bgCalcSchemeReportMap, Map<String, BgCalculateSchemeInfo> bcsMap) {
        this.ctx = ctx;
        this.orgList = orgList;
        this.info = info;
        this.bgCalcSchemeReportMap = bgCalcSchemeReportMap;
        this.bcsMap = bcsMap;
    }

    public void reCalculateThread() throws BOSException {
        BgCalculateSchemeInfo calcSchemeInfo = null;
        try {
            int optimalPoolSize = BgCalculateSchemeServerThread.getOptimalPoolSize(this.ctx);
            if (this.orgList.isEmpty()) {
                optimalPoolSize = 1;
            } else if (optimalPoolSize >= this.orgList.size()) {
                optimalPoolSize = this.orgList.size();
            }
            logger.error((Object)("BgCalculateSchemeServerThread CALC_POOL_SIZE is: " + optimalPoolSize));
            if (optimalPoolSize == 1 || this.orgList.size() == 1) {
                for (String orgId : this.orgList) {
                    if (!this.bcsMap.containsKey(orgId)) continue;
                    calcSchemeInfo = this.bcsMap.get(orgId);
                    this.reCalcSingleOrg(this.ctx, this.orgList, orgId, calcSchemeInfo, this.info, this.bgCalcSchemeReportMap);
                }
            } else {
                ExecutorService threadPool = Executors.newFixedThreadPool(optimalPoolSize);
                for (String orgId : this.orgList) {
                    if (!this.bcsMap.containsKey(orgId)) continue;
                    logger.error((Object)("begin calc orgId  : " + orgId));
                    calcSchemeInfo = this.bcsMap.get(orgId);
                    Calc calcCall = new Calc(orgId, calcSchemeInfo);
                    threadPool.submit(calcCall);
                    logger.error((Object)("end calc orgId  : " + orgId));
                }
                threadPool.shutdown();
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public Object reCalcSingleOrg(Context ctx, Set<String> orgList, String orgId, BgCalculateSchemeInfo calcSchemeInfo, IObjectValue info, Map<String, Map<String, BgCalculateSchemeReportInfo>> bgCalcSchemeReportMap) throws EASBizException, BOSException {
        BgFinalizedResultInfo resultInfo;
        String bgPeriodId = null;
        String bgVersionId = null;
        String bgTemplateId = null;
        String currencyId = null;
        int sumCount = 0;
        for (int j = 0; j < calcSchemeInfo.getEntry().size(); ++j) {
            BgCalculateSchemeEntryInfo entryInfo = calcSchemeInfo.getEntry().get(j);
            for (int k = 0; k < entryInfo.getTemplate().getPeriod().size(); ++k) {
                List<BgProcessEnum> bgProcessTypes = BgReCalcSchemeHelper.getBgProcessTypes(calcSchemeInfo.getProcessTypeNumber());
                for (BgProcessEnum bgProcessType : bgProcessTypes) {
                    ++sumCount;
                }
            }
        }
        BgFinalizedResultInfo bgFinalizedResultInfo = resultInfo = info instanceof BgFinalizedResultInfo ? (BgFinalizedResultInfo)info : null;
        if (resultInfo != null) {
            resultInfo.setTotalCount(sumCount);
            resultInfo.setCurrentIndex(0);
            resultInfo.setState(BgFinalizedResultEnum.calc);
            BgFinalizedResultFactory.getLocalInstance(ctx).save(resultInfo);
        }
        IBgCalculateSchemeFacade bgCalculateSchemeFacade = BgCalculateSchemeFacadeFactory.getLocalInstance(ctx);
        int index = 0;
        BgReCalcSchemeHelper.sortBgCalcSchemeInfosTemplateAndPeriods(calcSchemeInfo);
        for (int j = 0; j < calcSchemeInfo.getEntry().size(); ++j) {
            BgCalculateSchemeEntryInfo entryInfo = calcSchemeInfo.getEntry().get(j);
            for (int k = 0; k < entryInfo.getTemplate().getPeriod().size(); ++k) {
                List<BgProcessEnum> bgProcessTypes = BgReCalcSchemeHelper.getBgProcessTypes(calcSchemeInfo.getProcessTypeNumber());
                for (BgProcessEnum bgProcessType : bgProcessTypes) {
                    bgTemplateId = entryInfo.getTemplate().getTemplate().getId().toString();
                    bgPeriodId = entryInfo.getTemplate().getPeriod().get(k).getPeriod().getId().toString();
                    bgVersionId = calcSchemeInfo.getBgVersion().getId().toString();
                    currencyId = calcSchemeInfo.getCurrency().getId().toString();
                    String key = BgReCalcSchemeHelper.getCalcFormKey(orgId, bgPeriodId, bgVersionId, currencyId, bgTemplateId, bgProcessType.getName());
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("org_id", calcSchemeInfo.getOrgUnit().getId().toString());
                    param.put("bgScheme_id", calcSchemeInfo.getBgScheme().getId().toString());
                    param.put("bgTemplate_id", bgTemplateId);
                    param.put("bgPeriod_id", bgPeriodId);
                    param.put("currency_id", currencyId);
                    param.put("bgversion_id", bgVersionId);
                    param.put("bgprocess_numbers", bgProcessType.getName());
                    param.put("isCalculate", entryInfo.isIsCalculate());
                    param.put("sheetIdList", null);
                    param.put("isMultiOrg", Boolean.TRUE);
                    param.put("selectOrgIds", orgList);
                    param.put("is_write_report", Boolean.TRUE);
                    ++index;
                    if (resultInfo != null) {
                        BgReCalcSchemeHelper.saveCalcResult(ctx, calcSchemeInfo, (IObjectValue)resultInfo, index);
                    }
                    if (bgCalcSchemeReportMap != null && bgCalcSchemeReportMap.containsKey(key)) {
                        param.put("report_info", bgCalcSchemeReportMap.get(key));
                    }
                    Object object = bgCalculateSchemeFacade.reCalculate(param);
                }
            }
        }
        if (resultInfo != null && index == sumCount) {
            resultInfo.setResult(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"calcFinish", (Locale)ctx.getLocale()));
            resultInfo.setState(BgFinalizedResultEnum.calcFinish);
            BgFinalizedResultFactory.getLocalInstance(ctx).save(resultInfo);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOptimalPoolSize(Context ctx) throws Exception {
        int poolSize = CALC_DEFAULT_POOLSIZE;
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FVALUE FROM T_MBg_PARAM where FNUMBER = ?");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{"CALC_POOL_SIZE"});
            if (rst.next()) {
                poolSize = Integer.parseInt(rst.getString("FVALUE"));
            }
            SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst, null, (Connection)conn);
        }
        return poolSize;
    }

    private class Calc
    implements Callable<Object> {
        private String orgId = null;
        private BgCalculateSchemeInfo calcSchemeInfo = null;

        public Calc(String orgId, BgCalculateSchemeInfo calcSchemeInfo) {
            this.orgId = orgId;
            this.calcSchemeInfo = calcSchemeInfo;
        }

        @Override
        public Object call() throws Exception {
            return BgCalculateSchemeServerThread.this.reCalcSingleOrg(BgCalculateSchemeServerThread.this.ctx, BgCalculateSchemeServerThread.this.orgList, this.orgId, this.calcSchemeInfo, BgCalculateSchemeServerThread.this.info, BgCalculateSchemeServerThread.this.bgCalcSchemeReportMap);
        }
    }
}

