/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.designer.comment.CommentUtil;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.IReportBase;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.PostilTypeEnum;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptComment;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamFactory;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgCommentEntryInfo;
import com.kingdee.eas.ma.mbg.BgCommentFactory;
import com.kingdee.eas.ma.mbg.BgCommentInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTemplatePostilCollection;
import com.kingdee.eas.ma.mbg.BgTemplatePostilInfo;
import com.kingdee.eas.ma.mbg.IBgComment;
import com.kingdee.eas.ma.mbg.client.utils.BudgetUtilForClient;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgTemplateComment;
import com.kingdee.eas.ma.mbg.utils.BgTemplateCommentTank;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCommentCommonHelper {
    public static final String INNER_COMMENT = "inner_comment";

    public static void setBgComment(Cell cell, BgCommentInfo bgCommentInfo) {
        BgNFSHelper.setCellData(cell, INNER_COMMENT, bgCommentInfo);
    }

    public static BgCommentInfo getBgComment(Cell cell) {
        if (cell == null) {
            return null;
        }
        return BgNFSHelper.getCellData(cell, INNER_COMMENT) != null ? (BgCommentInfo)BgNFSHelper.getCellData(cell, INNER_COMMENT) : null;
    }

    public static void setCommentProtection(Book _book) {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(32768));
        int in = _book.getSheetCount();
        for (int i = 0; i < in; ++i) {
            Sheet _sheet = _book.getSheet(i);
            Protection pro = _sheet.getSheetOption().getProtection(true);
            if (sheetOperation == null || sheetOperation.isEmpty()) continue;
            Object var6_7 = null;
            for (Object e : sheetOperation) {
                if (e == null || !(e instanceof Integer)) continue;
                pro.appendOperation(((Integer)e).intValue());
            }
        }
    }

    public static void saveBgComments(Cell cell, RptCommentTank comment, IDimDataQuery bgFormInfo) throws Exception {
        ReportBaseInfo report;
        if (cell == null) {
            return;
        }
        if (bgFormInfo instanceof ReportBaseInfo && (report = (ReportBaseInfo)bgFormInfo).getSheetParam().isEmpty()) {
            ReportBaseInfo info = ((IReportBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)report.getBOSType(), IReportBase.class)).getReportBaseInfo("select id, sheetParam.* where id = '" + report.getId() + "'");
            if (info == null || info.getSheetParam().isEmpty()) {
                BgNFSHelper.checkSheetParam(report, cell.getSheet().getBook());
                CoreBaseCollection sheets = new CoreBaseCollection();
                for (int i = 0; i < report.getSheetParam().size(); ++i) {
                    report.getSheetParam().get(i).setId(BOSUuid.create((BOSObjectType)report.getSheetParam().get(i).getBOSType()));
                    report.getSheetParam().get(i).setReport((VirtualSheetParamInfo)report);
                    sheets.add((CoreBaseInfo)report.getSheetParam().get(i));
                }
                RptSheetParamFactory.getRemoteInstance().addnew(sheets);
            } else {
                report.getSheetParam().addCollection(info.getSheetParam());
            }
        }
        cell.setComment((Comment)comment);
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(cell.getSheet().getRange(cell));
        BgCommentCommonHelper.saveBgComments(null, ranges, bgFormInfo, true);
    }

    public static void saveBgComments(Book book, IDimDataQuery bgFormInfo) throws Exception {
        if (book == null) {
            return;
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        Sheet _sheet = null;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            ranges.add(_sheet.getSheetRange());
        }
        BgCommentCommonHelper.saveBgComments(null, ranges, bgFormInfo, false);
    }

    public static void saveBgComments(Context ctx, Book book, IDimDataQuery bgFormInfo) throws Exception {
        if (book == null) {
            return;
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        Sheet _sheet = null;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            ranges.add(_sheet.getSheetRange());
        }
        BgCommentCommonHelper.saveBgComments(ctx, ranges, bgFormInfo, false);
    }

    public static void saveBgComments(List<Range> ranges, IDimDataQuery bgFormInfo, boolean isCell) throws Exception {
        BgCommentCommonHelper.saveBgComments(null, ranges, bgFormInfo, isCell);
    }

    public static void saveBgComments(Context ctx, List<Range> ranges, IDimDataQuery bgFormInfo, boolean isCell) throws Exception {
        IBgComment iBgComment;
        if (ranges == null || ranges.isEmpty() || bgFormInfo == null || bgFormInfo.getBizBgScheme() == null || bgFormInfo.getBizBgScheme().getId() == null) {
            return;
        }
        String bgSchemeId = bgFormInfo.getBizBgScheme().getId().toString();
        String bgFormOrgUnitId = bgFormInfo.getBizOrgUnit().getId().toString();
        String bgFormVersion = bgFormInfo.getBizVersion().getNumber();
        HashMap bgCommentMap = new HashMap();
        HashMap rptTankMap = new HashMap();
        CoreBaseCollection saveColls = new CoreBaseCollection();
        CoreBaseCollection deleteColls = new CoreBaseCollection();
        CoreBaseCollection postilColls = new CoreBaseCollection();
        PostilInfo postilInfo = null;
        BgCommentInfo bgCommentInfo = null;
        RptCommentTank commentTank = null;
        RptComment rptComment = null;
        String formula2 = null;
        int maxRow = -1;
        int maxCol = -1;
        Range range = null;
        CellBlock block = null;
        String cellFullName = null;
        ReportVariables variables = null;
        ReportBaseInfo reportInfo = (ReportBaseInfo)bgFormInfo;
        if (!isCell) {
            reportInfo.getPostils().clear();
        }
        for (int s = 0; s < ranges.size(); ++s) {
            range = ranges.get(s);
            Sheet sheet = range.getRangeSheets().getSheet(0);
            if (variables == null) {
                variables = ReportVariables.loadFromBook((Book)sheet.getBook());
            }
            maxRow = sheet.getMaxRowIndex();
            maxCol = sheet.getMaxColIndex();
            int bSize = range.size();
            for (int bIndex = 0; bIndex < bSize; ++bIndex) {
                block = range.getBlock(bIndex);
                for (int r = block.getRow(); r <= Math.min(block.getRow2(), maxRow); ++r) {
                    for (int c = block.getCol(); c <= Math.min(block.getCol2(), maxCol); ++c) {
                        RptComment rptComment1;
                        int i;
                        Cell cell;
                        if (isCell) {
                            cellFullName = sheet.getID() + "!" + TableToolkit.xy2range((int)c, (int)r);
                        }
                        if ((cell = sheet.getCell(r, c, false)) == null) continue;
                        if (BgNFSHelper.checkHasItemFormula(cell)) {
                            ItemFormula itemFormula = BgNFSHelper.getItemFormula(cell);
                            String version = itemFormula.getExt("Version") == null ? bgFormVersion : itemFormula.getExt("Version");
                            String orgUnitId = itemFormula.getExt("ORGUNITID") == null ? bgFormOrgUnitId : itemFormula.getExt("ORGUNITID");
                            formula2 = itemFormula.getFormula();
                            bgCommentInfo = BgCommentCommonHelper.getBgComment(cell);
                            if (BgNFSHelper.checkHasComment(cell)) {
                                RptCommentTank tempTank;
                                if (cell.getComment() instanceof RptCommentTank) {
                                    commentTank = CommentUtil.getReportComment((Cell)cell);
                                } else if (cell.getComment() instanceof BgTemplateCommentTank) {
                                    commentTank = new RptCommentTank();
                                    BgTemplateComment temComment = null;
                                    for (i = 0; i < ((BgTemplateCommentTank)cell.getComment()).getSize(); ++i) {
                                        rptComment1 = new RptComment();
                                        temComment = ((BgTemplateCommentTank)cell.getComment()).getEntry(i);
                                        rptComment1.author = temComment.author;
                                        rptComment1.setContent(temComment.getContent());
                                        rptComment1.date = temComment.getDateTimeStamp();
                                        commentTank.addEntry(rptComment1);
                                    }
                                }
                                if (commentTank == null) continue;
                                for (int e = 0; e < commentTank.getSize(); ++e) {
                                    commentTank.getEntry(e).getDate();
                                }
                                if (bgCommentInfo != null && !BgCommentInfo.checkHasChanged(commentTank, bgCommentInfo)) continue;
                                BgCommentInfo tempBgCommentInfo = (BgCommentInfo)BgViewHelper.getSubMap(BgViewHelper.getSubMap(bgCommentMap, orgUnitId, true), version, true).get(formula2);
                                if (tempBgCommentInfo == null) {
                                    ((Map)((Map)bgCommentMap.get(orgUnitId)).get(version)).put(formula2, bgCommentInfo);
                                }
                                if ((tempTank = (RptCommentTank)BgViewHelper.getSubMap(BgViewHelper.getSubMap(rptTankMap, orgUnitId, true), version, true).get(formula2)) == null) {
                                    ((Map)((Map)rptTankMap.get(orgUnitId)).get(version)).put(formula2, commentTank);
                                    continue;
                                }
                                if (BgCommentCommonHelper.getRptCommentTankLastUpdateTime(commentTank) == null || BgCommentCommonHelper.getRptCommentTankLastUpdateTime(tempTank) == null || !BgCommentCommonHelper.getRptCommentTankLastUpdateTime(commentTank).after(BgCommentCommonHelper.getRptCommentTankLastUpdateTime(tempTank))) continue;
                                ((Map)((Map)rptTankMap.get(orgUnitId)).get(version)).put(formula2, commentTank);
                                continue;
                            }
                            if (bgCommentInfo == null || bgCommentInfo.getId() == null) continue;
                            deleteColls.add((CoreBaseInfo)bgCommentInfo);
                            continue;
                        }
                        if (!BgNFSHelper.checkHasComment(cell)) continue;
                        if (cell.getComment() instanceof RptCommentTank) {
                            commentTank = CommentUtil.getReportComment((Cell)cell);
                        } else if (cell.getComment() instanceof BgTemplateCommentTank) {
                            commentTank = new RptCommentTank();
                            BgTemplateComment temComment = null;
                            for (i = 0; i < ((BgTemplateCommentTank)cell.getComment()).getSize(); ++i) {
                                rptComment1 = new RptComment();
                                temComment = ((BgTemplateCommentTank)cell.getComment()).getEntry(i);
                                rptComment1.author = reportInfo.getCreator();
                                rptComment1.setContent(temComment.getContent());
                                rptComment1.date = temComment.getDateTimeStamp();
                                commentTank.addEntry(rptComment1);
                            }
                        }
                        if (commentTank == null) continue;
                        for (int e = 0; e < commentTank.getSize(); ++e) {
                            postilInfo = commentTank.getEntry(e).getSource();
                            if (postilInfo == null) continue;
                            postilInfo.setReport((ReportBaseInfo)bgFormInfo);
                            postilInfo.setCellName(TableToolkit.xy2range((int)c, (int)r));
                            postilInfo.setPostilType(PostilTypeEnum.CELL);
                            if (postilInfo.getSheet() == null) {
                                String name = sheet.getSheetName();
                                RptSheetParamInfo pinfo = null;
                                for (int m = 0; m < reportInfo.getSheetParam().size(); ++m) {
                                    if (!reportInfo.getSheetParam().get(m).getSheetID().equals(sheet.getID())) continue;
                                    pinfo = reportInfo.getSheetParam().get(m);
                                    break;
                                }
                                if (pinfo == null) {
                                    pinfo = VariablesHelper.variables2SheetParams((ReportVariables)variables, (String)name, (boolean)true, null);
                                    pinfo.setSheetID(sheet.getID());
                                    pinfo.setRelaType(ReportTypeEnum.REPORT);
                                    reportInfo.getSheetParam().add(pinfo);
                                }
                                postilInfo.setSheet(pinfo);
                                pinfo.getPostils().add(postilInfo);
                            }
                            if (postilInfo.getId() == null) {
                                postilInfo.setId(BOSUuid.create((BOSObjectType)postilInfo.getBOSType()));
                            }
                            postilColls.add((CoreBaseInfo)postilInfo);
                        }
                    }
                }
            }
        }
        if (!rptTankMap.isEmpty()) {
            for (String orgUnitId : rptTankMap.keySet()) {
                for (String version : ((Map)rptTankMap.get(orgUnitId)).keySet()) {
                    for (String formula2 : ((Map)((Map)rptTankMap.get(orgUnitId)).get(version)).keySet()) {
                        commentTank = (RptCommentTank)((Map)((Map)rptTankMap.get(orgUnitId)).get(version)).get(formula2);
                        if (((Map)((Map)bgCommentMap.get(orgUnitId)).get(version)).get(formula2) != null) {
                            bgCommentInfo = (BgCommentInfo)((Map)((Map)bgCommentMap.get(orgUnitId)).get(version)).get(formula2);
                            bgCommentInfo.getEntries().clear();
                        } else {
                            bgCommentInfo = BgCommentCommonHelper.createNewBgCommentInfo(ctx, bgSchemeId, orgUnitId, formula2, version);
                            if (bgCommentInfo == null) continue;
                        }
                        for (int i = 0; i < commentTank.getSize(); ++i) {
                            rptComment = commentTank.getEntry(i);
                            bgCommentInfo.getEntries().add(BgCommentCommonHelper.createNewEntry(bgCommentInfo, rptComment));
                        }
                        saveColls.add((CoreBaseInfo)bgCommentInfo);
                    }
                }
            }
        }
        HashMap<String, CoreBaseCollection> bgCommentMaps = new HashMap<String, CoreBaseCollection>();
        IBgComment iBgComment2 = iBgComment = ctx == null ? BgCommentFactory.getRemoteInstance() : BgCommentFactory.getLocalInstance(ctx);
        if (!saveColls.isEmpty()) {
            bgCommentMaps.put("save_collections", saveColls);
        }
        if (!deleteColls.isEmpty()) {
            bgCommentMaps.put("delete_collections", deleteColls);
        }
        if (!isCell) {
            if (reportInfo.getPostils() == null) {
                reportInfo.put("postils", (Object)new PostilCollection());
            }
            reportInfo.getPostils().addObjectCollection((IObjectCollection)postilColls);
        }
        iBgComment.saveBgComments(bgFormInfo, bgCommentMaps, postilColls, cellFullName);
    }

    public static BgCommentInfo createNewBgCommentInfo(Context ctx, String bgSchemeId, String orgUnitId, String formula, String version) {
        if (StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)formula) || StringUtils.isEmpty((String)version)) {
            return null;
        }
        String[] formulaParams = BgNFSHelper.parseFormulaPara(formula);
        BgCommentInfo bgCommentInfo = new BgCommentInfo();
        bgCommentInfo.setId(BOSUuid.create((BOSObjectType)bgCommentInfo.getBOSType()));
        bgCommentInfo.setBgSchemeId(BOSUuid.read((String)bgSchemeId));
        bgCommentInfo.setOrgUnitId(BOSUuid.read((String)orgUnitId));
        bgCommentInfo.setFormula(formula);
        bgCommentInfo.setBgVersion(version);
        bgCommentInfo.setBgScenario(formulaParams[3]);
        String item = formulaParams[0];
        String[] arr = item.split(BgBaseConstants.SEP_THR_STR);
        bgCommentInfo.setBgAccount(arr[0].substring(arr[0].lastIndexOf(BgBaseConstants.SEP_FOUR_STR) + 1, arr[0].length()));
        bgCommentInfo.setBgPeriod(formulaParams[1]);
        bgCommentInfo.setBgCurrency(formulaParams[5]);
        bgCommentInfo.setBgElement(formulaParams[2]);
        bgCommentInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        bgCommentInfo.setCreator(ctx == null ? SysContext.getSysContext().getCurrentUserInfo() : ContextUtil.getCurrentUserInfo((Context)ctx));
        bgCommentInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        bgCommentInfo.setLastUpdateUser(ctx == null ? SysContext.getSysContext().getCurrentUserInfo() : ContextUtil.getCurrentUserInfo((Context)ctx));
        return bgCommentInfo;
    }

    private static BgCommentEntryInfo createNewEntry(BgCommentInfo bgCommentInfo, RptComment rptComment) {
        BgCommentEntryInfo entryInfo = new BgCommentEntryInfo();
        entryInfo.setBgComment(bgCommentInfo);
        entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
        entryInfo.setBgContent(rptComment.content);
        entryInfo.setCreateTime(rptComment.date);
        entryInfo.setLastUpdateTime(rptComment.date);
        entryInfo.setCreator(rptComment.author != null ? rptComment.author : bgCommentInfo.getCreator());
        entryInfo.setLastUpdateUser(rptComment.author != null ? rptComment.author : bgCommentInfo.getLastUpdateUser());
        return entryInfo;
    }

    public static void fillBgComments(Context ctx, Book book, IDimDataQuery bgFormInfo, String bgOrgViewId, IMbgViewBase viewManager) {
        String bgTypeID;
        BgFormInfo f;
        if (book == null || bgFormInfo == null || bgOrgViewId == null) {
            return;
        }
        if (bgFormInfo instanceof BgFormInfo && (f = (BgFormInfo)bgFormInfo).getBgType() != null && f.getBgType().getId() != null && "bgMAAAAKIcA7rHKd".equals(bgTypeID = f.getBgType().getId().toString())) {
            return;
        }
        BgCommentCommonHelper.fillAllBgComments(ctx, book, bgFormInfo, bgOrgViewId, viewManager);
    }

    private static void fillAllBgComments(Context ctx, Book book, IDimDataQuery bgFormInfo, String bgOrgViewId, IMbgViewBase viewManager) {
        try {
            int i;
            IBgComment biz = null;
            biz = ctx == null ? BgCommentFactory.getRemoteInstance() : BgCommentFactory.getLocalInstance(ctx);
            Map bgCommentsMap = biz.queryBgComments(bgFormInfo, bgOrgViewId, viewManager);
            int formType = bgFormInfo.getBizTemplateType();
            boolean isFix = false;
            if (formType == 0 || formType == 8) {
                isFix = true;
            }
            int sheetSize = book.getSheetCount();
            Sheet sheet2 = null;
            Cell cell = null;
            HashMap<Sheet, BgSheetRange> sheetRanges = new HashMap<Sheet, BgSheetRange>();
            BgSheetRange sheetRange = null;
            for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                sheet2 = book.getSheet(sheetIndex);
                sheetRange = null;
                for (int rowIndex = 0; rowIndex <= sheet2.getMaxRowIndex(); ++rowIndex) {
                    for (int colIndex = 0; colIndex <= sheet2.getMaxColIndex(); ++colIndex) {
                        cell = sheet2.getCell(rowIndex, colIndex, false);
                        if (!BgCommentCommonHelper.fillBgComment(bgCommentsMap, cell, bgFormInfo, isFix)) continue;
                        if (sheetRange == null) {
                            sheetRange = new BgSheetRange(sheet2);
                            sheetRanges.put(sheet2, sheetRange);
                        }
                        sheetRange.addCell(rowIndex, colIndex);
                    }
                }
            }
            ReportBaseInfo reportInfo = (ReportBaseInfo)bgFormInfo;
            HashMap<String, RptSheetParamInfo> sheetParams = new HashMap<String, RptSheetParamInfo>();
            for (i = 0; i < reportInfo.getSheetParam().size(); ++i) {
                sheetParams.put(reportInfo.getSheetParam().get(i).getId().toString(), reportInfo.getSheetParam().get(i));
            }
            for (i = 0; i < reportInfo.getPostils().size(); ++i) {
                PostilInfo pi = reportInfo.getPostils().get(i);
                pi.setLastUpdateTime(pi.getCreateTime());
                Rect rect = TableToolkit.range2xy((String)pi.getCellName());
                if (pi.getSheet().getSheetID() != null) {
                    sheet2 = book.getSheetByID(pi.getSheet().getSheetID());
                } else {
                    if (sheetParams.get(pi.getSheet().getId().toString()) == null) continue;
                    sheet2 = book.getSheetByID(((RptSheetParamInfo)sheetParams.get(pi.getSheet().getId().toString())).getSheetID());
                }
                cell = sheet2.getCell(rect.y1, rect.x1, true);
                if (!sheetRanges.containsKey(sheet2)) {
                    sheetRanges.put(sheet2, new BgSheetRange(sheet2));
                }
                ((BgSheetRange)sheetRanges.get(sheet2)).addCell(cell.getRow(), cell.getCol());
                RptCommentTank ct = CommentUtil.getReportComment((Cell)cell, (boolean)false);
                if (ct == null) {
                    ct = new RptCommentTank();
                    cell.setComment((Comment)ct);
                }
                try {
                    for (int e = 0; e < ct.getSize(); ++e) {
                        ct.getEntry(e).getDate();
                    }
                    RptComment newcm = new RptComment(pi);
                    newcm.getDate();
                    int count = 0;
                    for (int j = 0; j < ct.getSize(); ++j) {
                        RptComment cm = ct.getEntry(j);
                        if (!cm.getFullString().equals(newcm.getFullString())) continue;
                        ++count;
                    }
                    if (count != 0) continue;
                    ct.addEntry(new RptComment(pi));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (Sheet sheet2 : sheetRanges.keySet()) {
                book.fireSheetChange(sheet2, (SortedCellBlockArray)((BgSheetRange)sheetRanges.get(sheet2)).getRange(), SheetChangeEvent.Changed_Commont);
            }
        }
        catch (Exception e) {
            Logger.getLogger(BgCommentCommonHelper.class).error((Object)"", (Throwable)e);
        }
    }

    private static boolean fillBgComment(Map<String, Map<String, Map<String, BgCommentInfo>>> bgCommentsMap, Cell cell, IDimDataQuery bgFormInfo, Boolean isFix) {
        ItemFormula itemFormula;
        if (bgCommentsMap == null || cell == null || bgFormInfo == null) {
            return false;
        }
        boolean hasComment = false;
        String bgFormOrgUnitId = null;
        String bgFormVersion = null;
        if (isFix.booleanValue()) {
            bgFormOrgUnitId = bgFormInfo.getBizOrgUnit().getId().toString();
            bgFormVersion = bgFormInfo.getBizVersion().getNumber();
        }
        if ((itemFormula = BgNFSHelper.getItemFormula(cell)) != null) {
            BgCommentInfo bgCommentInfo = null;
            String versionNumber = itemFormula.getExt("Version") != null ? itemFormula.getExt("Version") : bgFormVersion;
            String cellOrgId = itemFormula.getExt("ORGUNITID") != null ? itemFormula.getExt("ORGUNITID") : bgFormOrgUnitId;
            String formula = itemFormula.getFormula();
            if (!bgCommentsMap.isEmpty() && bgCommentsMap.containsKey(cellOrgId) && bgCommentsMap.get(cellOrgId).containsKey(versionNumber) && bgCommentsMap.get(cellOrgId).get(versionNumber).containsKey(formula) && (bgCommentInfo = bgCommentsMap.get(cellOrgId).get(versionNumber).get(formula)).getBgVersion().equals(versionNumber)) {
                hasComment = true;
                BgCommentCommonHelper.setBgComment(cell, bgCommentInfo);
                try {
                    cell.setComment((Comment)bgCommentInfo.getRptCommentTank());
                }
                catch (Exception e) {
                    Logger.getLogger(BgCommentCommonHelper.class).debug((Object)e.getStackTrace(), (Throwable)e);
                }
            }
        }
        return hasComment;
    }

    private static boolean checkFixFormComment(Cell cell, Map<String, Map<String, Map<String, BgCommentInfo>>> bgCommentsMap, String orgId, String versionNum, String formula) {
        if (cell == null || StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)versionNum) || StringUtils.isEmpty((String)formula)) {
            return false;
        }
        boolean isFixCellHasComment = false;
        Comment comment = cell.getComment();
        if (comment != null) {
            if (bgCommentsMap.isEmpty()) {
                isFixCellHasComment = true;
            } else if (!bgCommentsMap.containsKey(orgId) || bgCommentsMap.containsKey(orgId) && !bgCommentsMap.get(orgId).containsKey(versionNum) || bgCommentsMap.containsKey(orgId) && bgCommentsMap.get(orgId).get(formula) != null && !bgCommentsMap.get(orgId).get(versionNum).containsKey(formula) || bgCommentsMap.containsKey(orgId) && bgCommentsMap.get(orgId).get(formula) != null && !bgCommentsMap.get(orgId).get(versionNum).get(formula).getBgVersion().equals(versionNum)) {
                isFixCellHasComment = true;
            }
        }
        return isFixCellHasComment;
    }

    private static Timestamp getRptCommentTankLastUpdateTime(RptCommentTank tank) {
        if (tank == null || tank.getSize() < 1) {
            return null;
        }
        Timestamp time = tank.getEntry((int)0).date;
        if (time == null && tank.getEntry(0).getSource() != null && tank.getEntry(0).getSource().getLastUpdateTime() != null) {
            time = (Timestamp)tank.getEntry(0).getSource().getLastUpdateTime().clone();
        }
        Timestamp time1 = null;
        for (int i = 0; i < tank.getSize(); ++i) {
            time1 = tank.getEntry((int)i).date;
            if (time1 == null && tank.getEntry(i).getSource() != null && tank.getEntry(i).getSource().getLastUpdateTime() != null) {
                time1 = (Timestamp)tank.getEntry(i).getSource().getLastUpdateTime().clone();
            }
            if (time == null || time1 == null) continue;
            time = time1.after(time) ? time1 : time;
        }
        return time;
    }

    public static void prepareTemplateInfo4Display(BgTemplateInfo info, Book book) {
        BookProperties properties = BookProperties.loadFromBook((Book)book);
        ReportVariables variables = properties.getVariables();
        RptSheetParamCollection sheetParam = info.getSheetParam();
        for (int i = 0; sheetParam != null && i < sheetParam.size(); ++i) {
            RptSheetParamInfo p = sheetParam.get(i);
            ReportVariables sheetV = BgCommentCommonHelper.sheetParams2Variables(p);
            sheetV.remove("StartYear", p.getSheetName());
            sheetV.remove("StartPeriod", p.getSheetName());
            sheetV.remove("EndYear", p.getSheetName());
            sheetV.remove("EndPeriod", p.getSheetName());
            variables.remove("StartYear", p.getSheetName());
            variables.remove("StartPeriod", p.getSheetName());
            variables.remove("EndYear", p.getSheetName());
            variables.remove("EndPeriod", p.getSheetName());
            variables.addAll(sheetV, false);
        }
        properties.restoreToBook(book);
        BgCommentCommonHelper.fillPostils(info.getPostils(), book);
    }

    public static void fillPostils(BgTemplatePostilCollection postils, Book book) {
        BgTemplatePostilInfo postil = null;
        Sheet sheet = null;
        Cell cell = null;
        BgTemplateCommentTank ct = null;
        if (postils != null) {
            int i;
            HashSet<String> pCellSet = new HashSet<String>();
            book.setComment(null);
            int in2 = book.getSheetCount();
            for (i = 0; i < in2; ++i) {
                book.getSheet(i).setComment(null);
            }
            for (i = 0; i < postils.size(); ++i) {
                postil = postils.get(i);
                postil.setLastUpdateTime(postil.getCreateTime());
                if (postil.getPostilType() == PostilTypeEnum.REPORT) {
                    ct = (BgTemplateCommentTank)book.getComment();
                    if (ct == null) {
                        ct = new BgTemplateCommentTank();
                        book.setComment((Comment)ct);
                    }
                    try {
                        ct.addEntry(new BgTemplateComment(postil));
                    }
                    catch (Exception in2) {}
                    continue;
                }
                if (postil.getPostilType() == PostilTypeEnum.SHEET) {
                    sheet = book.getSheetByID(postil.getSheet().getSheetID());
                    ct = (BgTemplateCommentTank)sheet.getComment();
                    if (ct == null) {
                        ct = new BgTemplateCommentTank();
                        sheet.setComment((Comment)ct);
                    }
                    try {
                        ct.addEntry(new BgTemplateComment(postil));
                    }
                    catch (Exception in2) {}
                    continue;
                }
                if (postil.getPostilType() != PostilTypeEnum.CELL) continue;
                String _key = postil.getSheet().getSheetID() + "_" + postil.getCellName();
                Rect rect = TableToolkit.range2xy((String)postil.getCellName());
                sheet = book.getSheetByID(postil.getSheet().getSheetID());
                cell = sheet.getCell(rect.y1, rect.x1, true);
                ct = BgCommentCommonHelper.getReportComment(cell, null, true);
                if (ct == null) {
                    ct = new BgTemplateCommentTank();
                    cell.setComment((Comment)ct);
                } else if (!pCellSet.contains(_key)) {
                    pCellSet.add(_key);
                    int jn = ct.getSize();
                    for (int j = 0; j < jn; ++j) {
                        ct.deletEntry(0);
                    }
                }
                pCellSet.add(_key);
                try {
                    ct.addEntry(new BgTemplateComment(postil));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            pCellSet.clear();
        }
    }

    public static ReportVariables sheetParams2Variables(RptSheetParamInfo p) {
        String sheetName = p.getSheetName();
        ReportVariables variables = null;
        variables = VariablesHelper.initTemplateSheetReservedVariables((String)sheetName, (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
        VariableEntry variableEntry = null;
        variableEntry = variables.get("IncludePosted", sheetName);
        variableEntry.setValue(String.valueOf(p.isIsIncludingUnposted()));
        variableEntry.setType(1);
        CSLReportGroupEnum reportClass = p.getReportClass();
        if (reportClass == null) {
            reportClass = CSLReportGroupEnum.COMMON;
        }
        variables.get("SheetClass", sheetName).setValue(String.valueOf(reportClass.getValue()));
        return variables;
    }

    public static BgTemplateCommentTank getReportComment(Cell cell, UserInfo defaultAuthor, boolean convert) {
        if (cell == null) {
            return null;
        }
        Comment comment = cell.getComment();
        if (comment == null) {
            return null;
        }
        BgTemplateCommentTank ct = null;
        if (comment instanceof BgTemplateCommentTank) {
            ct = (BgTemplateCommentTank)comment;
        } else if (convert) {
            ct = BgCommentCommonHelper.convertComment(comment, defaultAuthor != null ? defaultAuthor : SysContext.getSysContext().getCurrentUserInfo(), null);
            cell.setComment((Comment)ct);
        }
        return ct;
    }

    public static BgTemplateCommentTank convertComment(Comment c, UserInfo author, Timestamp date) {
        if (c == null) {
            return null;
        }
        if (c instanceof BgTemplateCommentTank) {
            return (BgTemplateCommentTank)c;
        }
        if (c instanceof RptCommentTank) {
            BgTemplateCommentTank ct = new BgTemplateCommentTank();
            try {
                for (int i = 0; i < ((RptCommentTank)c).getSize(); ++i) {
                    BgTemplatePostilInfo postil = new BgTemplatePostilInfo();
                    postil.setCreator(author);
                    postil.setDescription(((RptCommentTank)c).getEntry(i).getContent());
                    postil.setCreateTime(((RptCommentTank)c).getEntry((int)i).date);
                    BgTemplateComment rptComment = new BgTemplateComment(postil);
                    rptComment.setContent(((RptCommentTank)c).getEntry(i).getContent());
                    rptComment.date = ((RptCommentTank)c).getEntry((int)i).date;
                    rptComment.author = author;
                    ct.addEntry(rptComment);
                }
            }
            catch (Exception e) {
                Logger.getLogger(BudgetUtilForClient.class).debug((Object)e.getStackTrace(), (Throwable)e);
            }
            return ct;
        }
        String text = c.getText();
        BgTemplateCommentTank ct = BgCommentCommonHelper.createRptCommentTank(author, date, text);
        return ct;
    }

    public static BgTemplateCommentTank createRptCommentTank(UserInfo author, Timestamp date, String text) {
        BgTemplateCommentTank ct = new BgTemplateCommentTank();
        try {
            BgTemplatePostilInfo postil = new BgTemplatePostilInfo();
            postil.setCreator(author);
            postil.setDescription(text);
            postil.setLastUpdateTime(date);
            BgTemplateComment rptComment = new BgTemplateComment(postil);
            rptComment.content = text;
            rptComment.date = date == null ? new Timestamp(Calendar.getInstance().getTimeInMillis()) : date;
            rptComment.author = author;
            ct.addEntry(rptComment);
        }
        catch (Exception e) {
            Logger.getLogger(BudgetUtilForClient.class).debug((Object)e.getStackTrace(), (Throwable)e);
        }
        return ct;
    }

    private static class BgCommentsQuerySwingWorker
    extends SwingWorker {
        private Book book = null;
        private IDimDataQuery bgFormInfo = null;
        private String bgOrgViewId = null;
        private IMbgViewBase viewManager = null;
        private Context ctx = null;

        public BgCommentsQuerySwingWorker(Context ctx, Book book, IDimDataQuery bgFormInfo, String bgOrgViewId, IMbgViewBase viewManager) {
            this.ctx = ctx;
            this.book = book;
            this.bgFormInfo = bgFormInfo;
            this.bgOrgViewId = bgOrgViewId;
            this.viewManager = viewManager;
        }

        public Object construct() {
            BgCommentCommonHelper.fillAllBgComments(this.ctx, this.book, this.bgFormInfo, this.bgOrgViewId, this.viewManager);
            return null;
        }
    }
}

