/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BizCalcTraceFacadeFactory;
import com.kingdee.eas.ma.mbg.IBizCalcTraceFacade;
import com.kingdee.eas.ma.mbg.client.MbgDataDetailUI;
import com.kingdee.eas.ma.mbg.client.MbgDataStateEditUI;
import com.kingdee.eas.ma.mbg.common.MbgDataDetailInfo;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;

public class BgDataDetailUtils {
    public static final String REF_BGFORMS = "REF_BGFORMS";
    public static final String AUDIT_BGFORMS = "AUDIT_BGFORMS";

    public static void showDataDetailUI(CoreUI ui, Book book, BgFormInfo bgFormInfo, BgOrgUnitInfo bgOrgUnit, String editScen) throws EASBizException, BOSException {
        if (ui == null || book == null || bgFormInfo == null || bgOrgUnit == null) {
            return;
        }
        Sheet _sheet = book.getActiveSheet();
        Range range = book.getSelectionRange();
        if (range == null) {
            MsgBox.showWarning((Component)ui, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"selectData"));
            return;
        }
        MbgDataDetailInfo info = new MbgDataDetailInfo();
        CellBlock block = null;
        Cell cell = null;
        String expression = null;
        String formulaStr = null;
        String versionNumber = null;
        if (range.size() > 1) {
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"selectOneCell"));
            return;
        }
        int size = range.size();
        for (int index = 0; index < size; ++index) {
            block = range.getBlock(index);
            if (block == null) continue;
            if (block.getCol() != block.getCol2() || block.getRow() != block.getRow2()) {
                MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"selectOneCell"));
                return;
            }
            int rowEnd = block.getRow2();
            block3: for (int rowBegin = block.getRow(); rowBegin <= rowEnd; ++rowBegin) {
                int colEnd = block.getCol2();
                for (int colBegin = block.getCol(); colBegin <= colEnd; ++colBegin) {
                    cell = _sheet.getCell(rowBegin, colBegin, false);
                    if (cell == null) continue;
                    if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                        formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                        info.setFormula(formulaStr);
                        versionNumber = BgNFSHelper.getItemFormula(cell).getExt("Version");
                        if (StringUtils.isEmpty((String)versionNumber)) {
                            versionNumber = bgFormInfo.getBgVersion().getNumber();
                        }
                        info.setBgVersionNumber(versionNumber);
                    }
                    if (BgNFSHelper.checkHasExpression(cell)) {
                        expression = BgNFSHelper.getExpression(cell);
                        info.setExpression(expression);
                    }
                    if (cell.isLocked()) {
                        info.setLock(Boolean.TRUE);
                        if (BgNTemplateHelper.hasForceLock(cell)) {
                            info.setForceLock(Boolean.TRUE);
                        }
                    }
                    if (!StringUtils.isEmpty((String)formulaStr) || !StringUtils.isEmpty((String)expression)) continue block3;
                }
            }
        }
        IBizCalcTraceFacade facade = BizCalcTraceFacadeFactory.getRemoteInstance();
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"InitDataObject", (Object)((MbgDataDetailInfo)facade.queryMbgDataDetail(info, bgFormInfo, bgOrgUnit)));
        uiContext.put((Object)"editScen", (Object)editScen);
        IUIWindow window = null;
        try {
            window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MbgDataDetailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            window.show();
        }
        catch (UIException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    public static void showDataStateEditUI(CoreUI ui, SpreadContext spreadContext, Book book, BgFormInfo bgFormInfo, BgOrgUnitInfo bgOrgUnit) throws EASBizException, BOSException {
        if (ui == null || book == null || bgFormInfo == null || bgOrgUnit == null) {
            return;
        }
        if (!bgOrgUnit.isIsLeaf()) {
            MsgBox.showInfo((Component)ui, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MbgDataResource", (String)"onlyLeafOrgForm"));
            return;
        }
        Sheet _sheet = book.getActiveSheet();
        Range range = book.getSelectionRange();
        if (range == null) {
            MsgBox.showWarning((Component)ui, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"selectData"));
            return;
        }
        ArrayList<String> bgformulas = new ArrayList<String>();
        CellBlock block = null;
        Cell cell = null;
        String formulaStr = null;
        String versionNumber = null;
        int size = range.size();
        for (int index = 0; index < size; ++index) {
            block = range.getBlock(index);
            if (block == null) continue;
            int rowEnd = block.getRow2();
            for (int rowBegin = block.getRow(); rowBegin <= rowEnd; ++rowBegin) {
                int colEnd = block.getCol2();
                for (int colBegin = block.getCol(); colBegin <= colEnd; ++colBegin) {
                    cell = _sheet.getCell(rowBegin, colBegin, false);
                    if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                    versionNumber = BgNFSHelper.getItemFormula(cell).getExt("Version");
                    if (!StringUtils.isEmpty((String)versionNumber) && !versionNumber.equals(bgFormInfo.getBgVersion().getNumber())) continue;
                    bgformulas.add(formulaStr);
                }
            }
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"BGFORM_INFO", (Object)bgFormInfo);
        uiContext.put((Object)"FORMULA", bgformulas);
        uiContext.put((Object)"Book", (Object)book);
        uiContext.put((Object)"SpreadContext", (Object)spreadContext);
        IUIWindow window = null;
        try {
            window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(MbgDataStateEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            window.show();
        }
        catch (UIException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        if (window != null) {
            // empty if block
        }
    }
}

