/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.app.MutexService;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgParamUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgFinalizedUtils {
    private static final Logger logger = Logger.getLogger(BgFinalizedUtils.class);
    public static final String IS_FINALIZED = "IS_FINALIZED";

    public static void putFinalizedUIContext(Map uiContext, Boolean isFinalized) {
        if (uiContext != null) {
            uiContext.put(IS_FINALIZED, isFinalized);
        }
    }

    public static boolean getFinalizedUIContext(Map uiContext) {
        if (uiContext != null && uiContext.containsKey(IS_FINALIZED) && uiContext.get(IS_FINALIZED) instanceof Boolean) {
            return (Boolean)uiContext.get(IS_FINALIZED);
        }
        return false;
    }

    public static void setFormFinalized(Map uiContext, IObjectValue model) {
        if (BgFinalizedUtils.getFinalizedUIContext(uiContext) && model instanceof BgFormInfo) {
            ((BgFormInfo)model).put(IS_FINALIZED, (Boolean)uiContext.get(IS_FINALIZED));
        }
    }

    public static boolean isFormFinalized(IObjectValue queryInfo) {
        return queryInfo instanceof BgFormInfo && queryInfo.get(IS_FINALIZED) instanceof Boolean && (Boolean)queryInfo.get(IS_FINALIZED) != false;
    }

    public static String getFinalizedDataTable(BgSchemeInfo bgSchemeInfo, BgVersionInfo bgVersionInfo, BgPeriodInfo bgPeriodInfo) {
        String cubeName = bgSchemeInfo.getRefCube();
        int v = bgVersionInfo.getVersionId();
        String p = String.valueOf(bgPeriodInfo.getYear()) + String.valueOf(bgPeriodInfo.getMonth());
        return cubeName + v + p;
    }

    public static String getFinalizedDataEntryTable(BgSchemeInfo bgSchemeInfo, BgVersionInfo bgVersionInfo, BgPeriodInfo bgPeriodInfo) {
        String cubeEntryName = BgCubeUtils.getEntryCubeName(bgSchemeInfo.getRefCube(), BgProcessEnum.C01);
        int v = bgVersionInfo.getVersionId();
        String p = String.valueOf(bgPeriodInfo.getYear()) + String.valueOf(bgPeriodInfo.getMonth());
        return cubeEntryName + v + p;
    }

    public static String getErrorFinalizedIndex(BgSchemeInfo bgSchemeInfo, BgVersionInfo bgVersionInfo, BgPeriodInfo bgPeriodInfo) {
        String cubeName = bgSchemeInfo.getRefCube();
        String c = cubeName.substring(0, 12);
        int v = bgVersionInfo.getVersionId();
        String p = String.valueOf(bgPeriodInfo.getYear()) + String.valueOf(bgPeriodInfo.getMonth());
        return "IX_MBG_" + c + v + p;
    }

    public static String getFinalizedIndex(BgSchemeInfo bgSchemeInfo, BgVersionInfo bgVersionInfo, BgPeriodInfo bgPeriodInfo) {
        String cubeName = bgSchemeInfo.getRefCube();
        String c = cubeName.substring(12, cubeName.length());
        int v = bgVersionInfo.getVersionId();
        String p = String.valueOf(bgPeriodInfo.getYear()) + String.valueOf(bgPeriodInfo.getMonth());
        return "UX_MBG_" + c + v + p;
    }

    public static String getPk(BgSchemeInfo bgSchemeInfo, BgVersionInfo bgVersionInfo, BgPeriodInfo bgPeriodInfo) {
        String cubeName = bgSchemeInfo.getRefCube();
        String c = cubeName.substring(12, cubeName.length());
        int v = bgVersionInfo.getVersionId();
        String p = String.valueOf(bgPeriodInfo.getYear()) + String.valueOf(bgPeriodInfo.getMonth());
        return "PK_MBG_" + c + v + p;
    }

    public static Set<String> queryFinalizedKeyIds(Context ctx, String bgSchemeId, String bgOrgViewId, Object[] orgUnitInfos, Object[] bgPeriodInfos, Object[] bgVersionInfos) throws BOSException, EASBizException {
        HashSet<String> checkIds = new HashSet<String>();
        if (!BgParamUtils.checkFinalized(ctx) || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)bgOrgViewId)) {
            return checkIds;
        }
        String orgId = null;
        String bgPeriodId = null;
        String bgVersionId = null;
        String bgPeriodNumber = null;
        String year = null;
        HashSet<String> yearSet = new HashSet<String>();
        String key = null;
        HashSet<String> finalizedIds = new HashSet<String>();
        String sql = "SELECT t.ForgunitId, f.FBgPeriodId,  f.FBGVERSIONID ,p.FNumber  FROM T_MBG_BgFinalizedBgOrgUnitNode n inner join t_mbg_bgFinalized f on f.FID= n.FBgFinalizedID inner join t_mbg_bgorgunit t on t.FID  = n.FBgOrgUnitId inner join t_mbg_bgperiod p on p.FID = f.FBgPeriodId where t.FVIEWID  = ? and f.FBgSchemeId = ?";
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bgOrgViewId, bgSchemeId});
            while (rst.next()) {
                orgId = rst.getString("ForgunitId");
                bgPeriodId = rst.getString("FBgPeriodId");
                bgVersionId = rst.getString("FBGVERSIONID");
                bgPeriodNumber = rst.getString("FNumber");
                year = bgPeriodNumber.substring(5, 9);
                yearSet.add(year);
                key = orgId + ";" + year + ";" + bgVersionId;
                finalizedIds.add(key);
            }
            for (int x = 0; x < orgUnitInfos.length; ++x) {
                for (int y = 0; y < bgPeriodInfos.length; ++y) {
                    for (int z = 0; z < bgVersionInfos.length; ++z) {
                        if (!(orgUnitInfos[x] instanceof FullOrgUnitInfo) || !(bgPeriodInfos[y] instanceof BgPeriodInfo) || !(bgVersionInfos[z] instanceof BgVersionInfo)) continue;
                        orgId = ((FullOrgUnitInfo)orgUnitInfos[x]).getId().toString();
                        bgPeriodId = ((BgPeriodInfo)bgPeriodInfos[y]).getId().toString();
                        bgPeriodNumber = ((BgPeriodInfo)bgPeriodInfos[y]).getNumber();
                        year = bgPeriodNumber.substring(5, 9);
                        bgVersionId = ((BgVersionInfo)bgVersionInfos[z]).getId().toString();
                        key = orgId + ";" + bgPeriodId + ";" + bgVersionId;
                        if (!finalizedIds.contains(orgId + ";" + year + ";" + bgVersionId)) continue;
                        checkIds.add(key);
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return checkIds;
    }

    public static String checkFormAddNewFinalized(Context ctx, BgFormInfo bgFormInfo, Set<String> checkIds) {
        if (checkIds == null) {
            return null;
        }
        String msg = null;
        String orgId = bgFormInfo.getOrgUnit().getId().toString();
        String bgPeriodId = bgFormInfo.getBgPeriod().getId().toString();
        String bgVersionId = bgFormInfo.getBgVersion().getId().toString();
        String key = orgId + ";" + bgPeriodId + ";" + bgVersionId;
        if (checkIds.contains(key) && ctx != null) {
            Object[] params = new Object[]{bgFormInfo.getOrgUnit().getName(), bgFormInfo.getBgTemplate().getName(), bgFormInfo.getBgPeriod().getName(), bgFormInfo.getBgVersion().getName(), bgFormInfo.getCurrency().getName()};
            msg = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgFinalizedResource", (String)"checkFormAddNewFinalized", (Locale)ctx.getLocale()), params);
        }
        return msg;
    }

    public static Set<String> requestMutex(Context ctx, List<String> billIds, String msg) throws BOSException {
        if (billIds == null || billIds.isEmpty()) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        System.setProperty("com.kingdee.eas.base.netctrl.app.MutexService.saveLockDescription", "true");
        try {
            Field field = MutexService.class.getDeclaredField("saveLockDescription");
            field.setAccessible(true);
            field.set(field, Boolean.TRUE);
            field.setAccessible(false);
        }
        catch (Exception field) {
            // empty catch block
        }
        Map reMap = MBgCheckHelper.getMutexInstance(ctx).batchRequestBizObjIDForUpdate(billIds, msg);
        if (reMap != null) {
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : reMap.entrySet()) {
                if (((Boolean)entry2.getValue()).booleanValue()) continue;
                result.add((String)entry2.getKey());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getBgFormIds(Context ctx, List<String> billIds) {
        ArrayList<String> allIds = new ArrayList<String>();
        allIds.addAll(billIds);
        String billId = null;
        BgFormInfo model = null;
        BgOrgUnitInfo bgOrgUnit = null;
        BgSchemeInfo bgSchemeInfo = null;
        BOSUuid orgViewId = null;
        String orgUnitId = null;
        List<String> childFormIds = null;
        List<String> childOrgIds = null;
        HashMap<String, List<String>> orgChildOrgs = new HashMap<String, List<String>>();
        BgSchemeDimensionHelper schemeHelper = null;
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            int in = billIds.size();
            for (int i = 0; i < in; ++i) {
                billId = billIds.get(i);
                model = MbgDataHelper.getBgFormInfo(conn, ctx.getLocale(), BOSUuid.read((String)billId));
                orgUnitId = model.getOrgUnit().getId().toString();
                bgSchemeInfo = model.getBgScheme();
                orgViewId = bgSchemeInfo.getEditOrgViewId();
                if (schemeHelper == null && orgViewId == null) {
                    schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeInfo.getId().toString());
                    orgViewId = BOSUuid.read((String)schemeHelper.getBgOrgViewId());
                }
                if (orgChildOrgs.containsKey(orgUnitId)) {
                    childOrgIds = (List<String>)orgChildOrgs.get(orgUnitId);
                } else {
                    bgOrgUnit = MbgDataHelper.getBgOrgUnitInfo(conn, ctx.getLocale(), orgViewId, model.getOrgUnit().getId(), false);
                    childOrgIds = BgFinalizedUtils.getChildOrgUnitIds(ctx, conn, bgOrgUnit, orgViewId.toString(), model);
                    if (childOrgIds != null && !childOrgIds.isEmpty()) {
                        orgChildOrgs.put(model.getOrgUnit().getId().toString(), childOrgIds);
                    }
                }
                if (childOrgIds == null || childOrgIds.isEmpty() || (childFormIds = BgFinalizedUtils.getModelIDs(ctx, conn, model, childOrgIds)).isEmpty()) continue;
                for (String str : childFormIds) {
                    if (allIds.contains(str)) continue;
                    allIds.add(str);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return allIds;
    }

    protected static List<String> getChildOrgUnitIds(Context ctx, Connection conn, BgOrgUnitInfo bgOrgUnit, String orgViewId, IDimDataQuery model) throws Exception {
        List<String> cOrgUnitIds = new ArrayList<String>();
        if (ctx == null || conn == null || bgOrgUnit == null || DimensionCommonHelper.isDecompose(model.getProcessType())) {
            return cOrgUnitIds;
        }
        ArrayList<BgOrgUnitInfo> cOrgUnits = new ArrayList<BgOrgUnitInfo>();
        BgOrgUnitCollection bgOrgUnitChildren = MbgDataHelper.getBgOrgUnitChildren(ctx, bgOrgUnit, orgViewId);
        int in = bgOrgUnitChildren.size();
        for (int i = 0; i < in; ++i) {
            cOrgUnits.add(bgOrgUnitChildren.get(i));
        }
        cOrgUnitIds = MbgDataHelper.getBgOrgUnitIds(cOrgUnits);
        return cOrgUnitIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static List<String> getModelIDs(Context ctx, Connection conn, IDimDataQuery model, List<String> childOrgIds) throws Exception {
        IRowSet rst;
        ArrayList<String> modelIDs;
        block14: {
            modelIDs = new ArrayList<String>();
            if (conn == null) return modelIDs;
            if (model == null) return modelIDs;
            if (childOrgIds == null) return modelIDs;
            if (childOrgIds.isEmpty()) {
                return modelIDs;
            }
            String _bgSchemeId = model.getBizBgScheme().getId().toString();
            String _bgTempalteId = model.getBizTemplateId().toString();
            String _bgPeriodId = model.getBizPeriod().getId().toString();
            String _currencyId = model.getBizCurrency().getId().toString();
            String _versionId = model.getBizVersion().getId().toString();
            BgProcessEnum bgProcessType = model.getProcessType();
            int formType = model.getBizTemplateType();
            BgFormInfo _bgForm = null;
            String tmpOrgUnit = null;
            TempTablePool pool = null;
            StringBuffer sql = new StringBuffer();
            rst = null;
            try {
                pool = TempTablePool.getInstance((Context)ctx);
                tmpOrgUnit = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.createIndex((TempTablePool)pool, (String)tmpOrgUnit, (String)"FID", (boolean)false, (boolean)false);
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgUnit + " (FID) values (?)"), childOrgIds);
                sql.append("select f.FID, f.FNumber, f.FName, f.FState, f.FOrgUnitID,f.FAuditOrgUnitID from T_MBG_BgForm f ");
                if (8 == formType) {
                    sql.append(" join T_MBG_BgSpecialItems s on s.FBgFormId = f.FId ");
                }
                sql.append(" where f.FBgSchemeId = ? AND f.FBgTemplateID = ? and f.FBgPeriodID = ? and f.FCurrencyID = ? and FBgVersionId = ? and f.FOrgUnitID in (select FID from " + tmpOrgUnit + ")");
                if (8 == formType) {
                    sql.append(" and s.FDimensionNumber = ? ");
                }
                sql.append(" and f.FProcessType = ?");
                Object[] sqlParams2332 = null;
                sqlParams2332 = 8 == formType ? new Object[]{_bgSchemeId, _bgTempalteId, _bgPeriodId, _currencyId, _versionId, model.getSpecialItemNumber(), bgProcessType.getValue()} : new Object[]{_bgSchemeId, _bgTempalteId, _bgPeriodId, _currencyId, _versionId, bgProcessType.getValue()};
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])sqlParams2332);
                while (rst.next()) {
                    _bgForm = new BgFormInfo();
                    _bgForm.setId(BOSUuid.read((String)rst.getString("FID")));
                    _bgForm.setName(rst.getString("FName"));
                    _bgForm.setNumber(rst.getString("FNumber"));
                    _bgForm.setState(BgFormStateEnum.getEnum(rst.getInt("FState")));
                    _bgForm.setOrgUnit(new FullOrgUnitInfo());
                    _bgForm.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnitID")));
                    if (rst.getString("FAuditOrgUnitID") != null) {
                        _bgForm.setAuditOrgUnit(new FullOrgUnitInfo());
                        _bgForm.getAuditOrgUnit().setId(BOSUuid.read((String)rst.getString("FAuditOrgUnitID")));
                    }
                    if (15 == rst.getInt("FState") || 4 == rst.getInt("FState") || 35 == rst.getInt("FState")) continue;
                    modelIDs.add(_bgForm.getId().toString());
                }
                if (pool == null || tmpOrgUnit == null) break block14;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    if (pool != null && tmpOrgUnit != null) {
                        try {
                            pool.releaseTable(tmpOrgUnit);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            try {
                pool.releaseTable(tmpOrgUnit);
            }
            catch (Exception sqlParams2332) {
                // empty catch block
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return modelIDs;
    }
}

