/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.IBgPeriod;
import org.apache.log4j.Logger;

public final class BgHelper {
    private static Logger logger = Logger.getLogger((String)BgHelper.class.getName());

    public static String tranArray2String(String[] idArray) {
        if (idArray == null || idArray.length < 1) {
            return "('')";
        }
        StringBuffer strBuff = new StringBuffer();
        for (int i = 0; i < idArray.length && i < 999; ++i) {
            if (i == 0) {
                strBuff.append("('" + idArray[i] + "'");
                continue;
            }
            strBuff.append(", '" + idArray[i] + "'");
        }
        strBuff.append(")");
        return strBuff.toString();
    }

    public static String getRelativeBgPeriod(Context ctx, String currentBgPeriodNumber, int relativeValue) throws BOSException, EASBizException {
        int year;
        IBgPeriod iPeriod = null;
        iPeriod = ctx == null ? BgPeriodFactory.getRemoteInstance() : BgPeriodFactory.getLocalInstance((Context)ctx);
        BgPeriodInfo bgPeriod = null;
        try {
            bgPeriod = iPeriod.getBgPeriodInfo("select id, number, periodType, year, halfyear, quarter, month, week  where number = '" + currentBgPeriodNumber + "'");
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e);
        }
        if (bgPeriod == null) {
            throw new BgPeriodException(BgPeriodException.CURRENTPERIODERROR);
        }
        if (relativeValue == 0) {
            return currentBgPeriodNumber;
        }
        String newBgPeriodNumber = null;
        if (bgPeriod.getPeriodType().getValue() == 8) {
            return currentBgPeriodNumber;
        }
        if (bgPeriod.getPeriodType().getValue() == 1) {
            year = bgPeriod.getYear();
            newBgPeriodNumber = year + relativeValue + "Y";
        } else if (bgPeriod.getPeriodType().getValue() == 3) {
            year = bgPeriod.getYear();
            int quarter = bgPeriod.getQuarter();
            int newQuarter = quarter + relativeValue;
            int x = 0;
            int y = 0;
            if (relativeValue > 0) {
                x = newQuarter % 4;
                y = newQuarter / 4;
                if (x == 0) {
                    --y;
                }
            } else if (newQuarter == 0) {
                x = 0;
                y = -1;
            } else if (newQuarter < 0) {
                x = newQuarter % 4 + 4;
                y = newQuarter / 4 - 1;
            } else if (newQuarter > 0) {
                x = newQuarter;
                y = 0;
            }
            x = x == 0 ? 4 : x;
            newBgPeriodNumber = year + y + "Y.0" + x + "Q";
        } else if (bgPeriod.getPeriodType().getValue() == 4) {
            year = bgPeriod.getYear();
            int month = bgPeriod.getMonth();
            int newMonth = month + relativeValue;
            int x = 0;
            int y = 0;
            if (relativeValue > 0) {
                x = newMonth % 12;
                y = newMonth / 12;
                if (x == 0) {
                    --y;
                }
            } else if (newMonth == 0) {
                x = 0;
                y = -1;
            } else if (newMonth < 0) {
                x = newMonth % 12 + 12;
                y = newMonth / 12 - 1;
            } else if (newMonth > 0) {
                x = newMonth;
                y = 0;
            }
            x = x == 0 ? 12 : x;
            newBgPeriodNumber = year + y + "Y." + (x >= 10 ? x + "" : "0" + x) + "M";
        } else if (bgPeriod.getPeriodType().getValue() == 2) {
            year = bgPeriod.getYear();
            int hy = bgPeriod.getHalfYear();
            int newHy = hy + relativeValue;
            int x = 0;
            int y = 0;
            if (relativeValue > 0) {
                x = newHy % 2;
                y = newHy / 2;
                if (x == 0) {
                    --y;
                }
            } else if (newHy == 0) {
                x = 0;
                y = -1;
            } else if (newHy < 0) {
                x = newHy % 2 + 2;
                y = newHy / 2 - 1;
            } else if (newHy > 0) {
                x = newHy;
                y = 0;
            }
            x = x == 0 ? 2 : x;
            newBgPeriodNumber = year + y + "Y.0" + x + "HY";
        } else if (bgPeriod.getPeriodType().getValue() == 7) {
            newBgPeriodNumber = currentBgPeriodNumber;
        } else if (bgPeriod.getPeriodType().getValue() == 6) {
            newBgPeriodNumber = currentBgPeriodNumber;
        } else if (bgPeriod.getPeriodType().getValue() == 5) {
            newBgPeriodNumber = currentBgPeriodNumber;
        }
        try {
            bgPeriod = iPeriod.getBgPeriodInfo("select id where number = '" + newBgPeriodNumber + "'");
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e);
            throw new BgPeriodException(BgPeriodException.RELATIVEPERIODERROR);
        }
        return newBgPeriodNumber;
    }
}

