/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.client.utils.MbgItemFormulaPanel;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BgNFormItemHelper {
    public static final String OLD_MBG_ITEMFORMULA = "OLD_MBG_ITEMFORMULA";

    public static void doActionBeforeClearDefault(Book book) {
        Range clearRange = BgNFormItemHelper.getCelarRange(book, false, false, false);
        if (clearRange != null && !clearRange.isEmpty()) {
            StyleAttributes saUnlock = Styles.getEmptySA();
            saUnlock.setLocked(false);
            clearRange.setStyle(saUnlock, Styles.getEmptySA());
        }
    }

    public static void doActionAfterClearDefault(Book book) {
        Range clearRange = BgNFormItemHelper.getCelarRange(book, true, false, true);
        if (clearRange != null && !clearRange.isEmpty()) {
            clearRange.clear(true, true, true, true);
        }
    }

    public static Range getCelarRange(Book book, boolean isClearExt, boolean isClearAllExt, boolean isClearItemFormula) {
        if (book == null) {
            return null;
        }
        boolean lockCellByFormula = BgParamCHelper.isLockCellByFormula();
        Sheet sheet = book.getActiveSheet();
        int maxRowIndex = sheet.getMaxRowIndex();
        int maxColIndex = sheet.getMaxColIndex();
        Range range = book.getActiveSheet().getSelectionRange();
        Range clearRange = null;
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            int rowBegin = block.getRow();
            int rowEnd = block.getRow2() > maxRowIndex ? maxRowIndex : block.getRow2();
            int colBegin = block.getCol();
            int colEnd = block.getCol2() > maxColIndex ? maxColIndex : block.getCol2();
            for (int j = rowBegin; j <= rowEnd; ++j) {
                for (int k = colBegin; k <= colEnd; ++k) {
                    Cell cell = sheet.getCell(j, k, false);
                    if (cell == null || BgNFSHelper.isCellFromTemplate(cell)) continue;
                    if (BgNFSHelper.checkHasItemFormula(cell)) {
                        Object obj;
                        Map tmpMap;
                        if (isClearItemFormula) {
                            BgNTemplateHelper.clearFormulaOfCell(cell, true);
                        }
                        if (isClearAllExt) {
                            tmpMap = null;
                            obj = cell.getUserObjectValue("CELL_DATA_EXT");
                            if (obj != null && obj instanceof Map) {
                                tmpMap = (Map)obj;
                                tmpMap.clear();
                            }
                        } else if (isClearExt) {
                            tmpMap = null;
                            obj = cell.getUserObjectValue("CELL_DATA_EXT");
                            if (obj != null && obj instanceof Map) {
                                tmpMap = (Map)obj;
                                Iterator ite = tmpMap.keySet().iterator();
                                while (ite.hasNext()) {
                                    String key = (String)ite.next();
                                    if (OLD_MBG_ITEMFORMULA.equals(key)) continue;
                                    ite.remove();
                                }
                                if (tmpMap.isEmpty()) {
                                    cell.removeUserObject("CELL_DATA_EXT");
                                }
                            }
                        }
                    }
                    if (BgNFSHelper.checkHasExpression(cell) && lockCellByFormula) continue;
                    if (clearRange == null) {
                        clearRange = cell.getSheet().getRange(cell);
                        continue;
                    }
                    clearRange.addAll((SortedCellBlockArray)cell.getSheet().getRange(cell));
                }
            }
        }
        return clearRange;
    }

    public static void buildFormula(Range range) {
        if (range == null || range.isEmpty()) {
            return;
        }
        CellBlock block = null;
        Sheet sheet = range.getRangeSheets().getSheet(0);
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        String formulaString = null;
        String newFormula = null;
        String[] parameter = null;
        for (int bIndex = 0; bIndex < range.size(); ++bIndex) {
            block = range.getBlock(bIndex);
            for (int rowIndex = block.getRow(); rowIndex <= Math.min(block.getRow2(), rowCount); ++rowIndex) {
                for (int colIndex = block.getCol(); colIndex <= Math.min(block.getCol2(), colCount); ++colIndex) {
                    Cell cell = sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell) || (parameter = BgNFSHelper.parseFormulaPara(null, formulaString = BgNFSHelper.getFormulaOfCell(cell))) == null) continue;
                    if (parameter.length == 6) {
                        newFormula = new StringBuffer("=BgItem(\"" + StringUtils.cnulls((String)parameter[0]) + "\",\"" + StringUtils.cnulls((String)parameter[1]) + "\",\"" + StringUtils.cnulls((String)parameter[2]) + "\",\"" + StringUtils.cnulls((String)parameter[3]) + "\"," + StringUtils.cnulls((String)parameter[4]) + ",\"" + StringUtils.cnulls((String)parameter[5]) + "\")").toString();
                    } else if (parameter.length == 5) {
                        newFormula = new StringBuffer("=BgItem(\"" + StringUtils.cnulls((String)parameter[0]) + "\",\"" + StringUtils.cnulls((String)parameter[1]) + "\",\"" + StringUtils.cnulls((String)parameter[2]) + "\",\"" + StringUtils.cnulls((String)parameter[3]) + "\",true,\"" + StringUtils.cnulls((String)parameter[4]) + "\")").toString();
                    }
                    BgNFSHelper.setFormulaOfCell(cell, newFormula);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void processCellSelectionChanged(BgFormInfo bgFormInfo, Map itemFormulMap, Map formulaMap, SpreadManager spreadManager, Cell cell, String oprtState) throws Exception {
        if (bgFormInfo == null || bgFormInfo.getOrgUnit() == null || spreadManager == null || StringUtils.isEmpty((String)oprtState)) {
            return;
        }
        boolean isHaveFormula = false;
        boolean isCanUpdateItemFormula = true;
        boolean isCellFromTemplate = false;
        String orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
        if (cell != null) {
            String formula;
            isHaveFormula = BgNFSHelper.checkHasFormulaOfCell(cell);
            isCellFromTemplate = BgNFSHelper.isCellFromTemplate(cell);
            if (isHaveFormula) {
                String formula2;
                isCanUpdateItemFormula = BgNFSHelper.checkCanEditFormulaOfCell(cell) && !isCellFromTemplate;
                String formulaLine = BgNFSHelper.getFormulaOfCell(cell);
                if (formulaLine.toLowerCase().indexOf("=bgitem") >= 0) {
                    String itemFormulaStr;
                    String[] param;
                    BgNTemplateHelper.getItemFormulaMap(orgUnitId, formulaLine, itemFormulMap, formulaMap);
                    if (!(formulaLine.equals(itemFormulMap.get(formulaLine)) || (param = BgNFSHelper.parseFormulaPara(null, itemFormulaStr = (String)itemFormulMap.get(formulaLine))) == null || param.length != 4 && param.length != 6)) {
                        BgNFSHelper.setFormulaOfCell(cell, (String)itemFormulMap.get(formulaLine));
                    }
                }
                if (BgNFSHelper.checkHasExpression(cell) && (formula2 = BgNTemplateHelper.getFormula(cell)) != null && formula2.trim().length() != 0 && formula2.charAt(0) == '=') {
                    // empty if block
                }
            } else if (!BgNFSHelper.checkHasExpression(cell) || (formula = BgNTemplateHelper.getFormula(cell)) == null || formula.trim().length() == 0 || formula.charAt(0) != '=') {
                // empty if block
            }
        }
        if (!oprtState.equals(OprtState.VIEW)) {
            spreadManager.setItemFormulaEnable(isCanUpdateItemFormula);
            if (spreadManager.getSpreadContainer().getFacadeManager().getPromptPanel().getRightComponent() instanceof MbgItemFormulaPanel) {
                ((MbgItemFormulaPanel)((Object)spreadManager.getSpreadContainer().getFacadeManager().getPromptPanel().getRightComponent())).setEnabled(isCanUpdateItemFormula);
            }
        }
    }

    public static boolean checkBgItemFullOfDim(BgSchemeDimensionHelper schemeHelper, Cell cell) {
        if (schemeHelper == null || cell == null || !BgNFSHelper.checkHasItemFormula(cell)) {
            return false;
        }
        return BgNFormItemHelper.checkBgItemFullOfDim(schemeHelper, BgNFSHelper.getItemFormula(cell).getFormula(), false);
    }

    public static boolean checkBgItemFullOfDim(BgSchemeDimensionHelper schemeHelper, String bgItemStr, boolean isCheckNes) {
        boolean isFull = true;
        if (schemeHelper == null || StringUtils.isEmpty((String)bgItemStr)) {
            return isFull;
        }
        if (bgItemStr.toLowerCase().indexOf("=bgitem") >= 0) {
            Set<String> srcNumbers = schemeHelper.getSrcNumbers();
            String itemFormula = BgNTemplateHelper.get6ParematerItemFormula(bgItemStr);
            String[] param = BgNFSHelper.parseFormulaPara(null, itemFormula);
            if (param != null && param.length == 6) {
                String strItemCombi = param[0];
                if (isCheckNes) {
                    for (int i = 1; i < param.length; ++i) {
                        if (!StringUtils.isEmpty((String)param[i])) continue;
                        return false;
                    }
                }
                if (!StringUtils.isEmpty((String)strItemCombi)) {
                    String[] items = DimensionFormulaHelper.splitCombinations(strItemCombi);
                    if (srcNumbers.size() != items.length) {
                        return false;
                    }
                }
            }
        }
        return isFull;
    }

    public static void checkDeleteCells(BgFormInfo bgFormInfo) throws Exception {
        if (bgFormInfo == null || bgFormInfo.getZipData() == null) {
            return;
        }
        Book book = bgFormInfo.getBook();
    }

    public static void reLockCellAfterInsert(Sheet sheet) {
        if (sheet == null) {
            return;
        }
        Range lockRange = null;
        Cell cell = null;
        int maxRowIndex = sheet.getMaxRowIndex();
        int maxColIndex = sheet.getMaxColIndex();
        boolean lockCellByFormula = BgParamCHelper.isLockCellByFormula();
        for (int r = 0; r < maxRowIndex; ++r) {
            for (int c = 0; c < maxColIndex; ++c) {
                cell = sheet.getCell(r, c, false);
                if (cell == null) continue;
                boolean hasExpression = BgNFSHelper.checkHasExpression(cell);
                if (Boolean.FALSE.equals(BgNFSHelper.getCellData(cell, "BGDATA_CAN_UPDATE"))) {
                    if (lockRange == null) {
                        lockRange = cell.getSheet().getRange(cell);
                        continue;
                    }
                    lockRange.addAll((SortedCellBlockArray)cell.getSheet().getRange(cell));
                    continue;
                }
                if (!hasExpression || !lockCellByFormula || cell.isLocked()) continue;
                BgNFSHelper.setCellExtData(cell, "BGDATA_EXPRESS_LOCK", "BGDATA_EXPRESS_LOCK");
                BgNFSHelper.setCellExtData(cell, "CELL_LOCK", BgNConstants.FALSE_UPDATE);
                if (lockRange == null) {
                    lockRange = cell.getSheet().getRange(cell);
                    continue;
                }
                lockRange.addAll((SortedCellBlockArray)cell.getSheet().getRange(cell));
            }
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setLocked(true);
        if (lockRange != null) {
            lockRange.setIgnoreProtected(true);
            lockRange.setStyle(sa, Styles.getEmptySA());
        }
    }
}

