/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.mbg.BgCommonException;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.IDimensionFormulaFacade;
import com.kingdee.eas.ma.mbg.IMbgMemberFacade;
import com.kingdee.eas.ma.mbg.MbgMemberFacadeFactory;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgExpressionsParseHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNLockProtectHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgNTemplateHelper {
    public static final Logger logger = Logger.getLogger((String)BgNTemplateHelper.class.getName());
    public static final String SOURCE_STR = "com.kingdee.eas.ma.mbg.client.BgNFormResource";
    public static final String STRRESOURCE = "com.kingdee.eas.ma.mbg.BgTemplateResource";

    public static void getItemFormulaMap(String orgUnitId, String formulaLine, Map formulaMap, Map formualParamMap) throws EASBizException, BOSException {
        DimensionFormulaHelper.getItemFormulaMap(orgUnitId, formulaLine, formulaMap, formualParamMap);
    }

    public static void setFormulaEditOfCell(Cell cell, boolean editable, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        ItemFormula itemFormula = BgNTemplateHelper.getItemFormula(cell, isCanUndo);
        if (itemFormula != null) {
            if (editable) {
                itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.TRUE_UPDATE);
            } else {
                itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.FALSE_UPDATE);
            }
        }
    }

    public static void setFormulaOfCell(Cell cell, String formulaStr, boolean isCreate, boolean isCanUndo) {
        if (cell == null || StringUtils.isEmpty((String)formulaStr)) {
            return;
        }
        if (isCanUndo) {
            Object obj = null;
            ItemFormula itemFormula = null;
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            obj = cell.getUserObjectValue("ITEM");
            if (obj != null && obj instanceof ItemFormula) {
                itemFormula = (ItemFormula)obj;
                itemFormula.putExt("13", formulaStr);
            } else if (isCreate) {
                itemFormula = new ItemFormula(formulaStr);
                range.setUserObject("ITEM", (Object)itemFormula);
            }
        } else {
            Object obj = null;
            ItemFormula itemFormula = null;
            obj = cell.getUserObjectValue("ITEM");
            if (obj != null && obj instanceof ItemFormula) {
                itemFormula = (ItemFormula)obj;
                itemFormula.putExt("13", formulaStr);
            } else if (isCreate) {
                itemFormula = new ItemFormula(formulaStr);
                cell.setUserObject("ITEM", (Object)itemFormula);
            }
        }
        if (cell != null && BgNFSHelper.checkHasFormulaOfCell(cell)) {
            BgNFSHelper.clearCurrencyInfo(cell);
            BgNFSHelper.clearBgPeriodInfo(cell);
            BgNFSHelper.clearBgElementInfo(cell);
            BgNFSHelper.clearBgItemInfo(cell);
            BgNFSHelper.clearBgScenarioInfo(cell);
        }
    }

    public static void clearAll(Cell cell, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        BgNTemplateHelper.clearFormulaOfCell(cell, isCanUndo);
        BgNTemplateHelper.clearBgaDataValue(cell, isCanUndo);
        BgNTemplateHelper.clearCellCtrlValue(cell, isCanUndo);
        cell.setFormula(null);
        BgNTemplateHelper.setValue(cell, null, isCanUndo);
    }

    public static void clearFormulaOfCell(Cell cell, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            range.setUserObject("ITEM", null);
        } else {
            cell.removeUserObject("ITEM");
        }
    }

    public static void setValue(Cell cell, Object value, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            if (value != null) {
                range.setValue(new Variant(value));
            } else {
                range.setValue(Variant.nullVariant);
            }
        } else if (value != null) {
            cell.setValue(new Variant(value));
        } else {
            cell.setValue(Variant.nullVariant);
        }
    }

    public static void clearBgaDataValue(Cell cell, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            Object obj = range.getUserObject("CELL_DATA");
            if (obj != null) {
                BgNFSHelper.objClear(obj);
            }
            range.setUserObject("CELL_DATA", null);
        } else {
            Object obj = cell.getUserObjectValue("CELL_DATA");
            if (obj != null) {
                BgNFSHelper.objClear(obj);
            }
            cell.removeUserObject("CELL_DATA");
        }
    }

    public static void clearCellCtrlValue(Cell cell, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            Object obj = range.getUserObject("CELL_DATA_EXT");
            if (obj != null) {
                BgNFSHelper.objClear(obj);
            }
            range.setUserObject("CELL_DATA_EXT", null);
        } else {
            Object obj = cell.getUserObjectValue("CELL_DATA_EXT");
            if (obj != null) {
                BgNFSHelper.objClear(obj);
            }
            cell.removeUserObject("CELL_DATA_EXT");
        }
    }

    public static String getBgDataValue(Cell cell, String key) {
        Map _tmpMap;
        if (cell == null) {
            return null;
        }
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey(key)) {
            return (String)_tmpMap.get(key);
        }
        return null;
    }

    public static void removeDataValue(Cell cell, String key, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            Object obj = range.getUserObject("CELL_DATA");
            if (obj != null && obj instanceof Map) {
                Map _tmpMap = (Map)obj;
                if (_tmpMap.containsKey(key)) {
                    _tmpMap.remove(key);
                }
                if (_tmpMap.isEmpty()) {
                    range.setUserObject("CELL_DATA", null);
                } else {
                    range.setUserObject("CELL_DATA", (Object)_tmpMap);
                }
            }
        } else {
            Object obj = cell.getUserObjectValue("CELL_DATA");
            if (obj != null && obj instanceof Map) {
                Map _tmpMap = (Map)obj;
                if (_tmpMap.containsKey(key)) {
                    _tmpMap.remove(key);
                }
                if (_tmpMap.isEmpty()) {
                    cell.removeUserObject("CELL_DATA");
                }
            }
        }
    }

    public static void setBgDataValue(Cell cell, String key, Object value, boolean isCanUndo) {
        Range range;
        if (cell == null || value == null) {
            return;
        }
        if ("bgFillValue".equals(key)) {
            range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            StyleAttributes sa = Styles.getEmptySA();
            StyleAttributes sa1 = Styles.getEmptySA();
            range.getStyle(sa, sa1);
            sa.setNumberFormat("@");
            range.setStyle(sa, sa1);
        }
        if (isCanUndo) {
            range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            HashMap obj = range.getUserObject("CELL_DATA");
            Map<String, Object> _tmpMap = null;
            if (obj == null || !(obj instanceof Map)) {
                _tmpMap = new HashMap();
                obj = _tmpMap;
            }
            _tmpMap = obj;
            _tmpMap.put(key, value);
            range.setUserObject("CELL_DATA", obj);
        } else {
            HashMap<String, Object> _tmpMap = null;
            String keyW2 = null;
            if (cell.getUserObjectValue("CELL_DATA") != null && cell.getUserObjectValue("CELL_DATA") instanceof Map) {
                Map tmpMap = (Map)cell.getUserObjectValue("CELL_DATA");
                _tmpMap = new HashMap();
                for (String keyW2 : tmpMap.keySet()) {
                    _tmpMap.put(keyW2, tmpMap.get(keyW2));
                }
            } else {
                _tmpMap = new HashMap<String, Object>();
                cell.setUserObject("CELL_DATA", _tmpMap);
            }
            _tmpMap.put(key, value);
            cell.setUserObject("CELL_DATA", _tmpMap);
        }
    }

    public static ItemFormula getItemFormula(Cell cell, boolean isCanUndo) {
        if (cell == null) {
            return null;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            Object obj = range.getUserObject("ITEM");
            if (obj != null && obj instanceof ItemFormula) {
                return (ItemFormula)obj;
            }
        } else {
            Object obj = cell.getUserObjectValue("ITEM");
            if (obj != null && obj instanceof ItemFormula) {
                return (ItemFormula)obj;
            }
        }
        return null;
    }

    public static void setCellCtrlValue(Cell cell, String key, Object value, boolean isCanUndo) {
        if (cell == null || value == null) {
            return;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            HashMap obj = range.getUserObject("CELL_DATA_EXT");
            Map<String, Object> _tmpMap = null;
            if (obj == null || !(obj instanceof Map)) {
                _tmpMap = new HashMap();
                obj = _tmpMap;
                range.setUserObject("CELL_DATA_EXT", obj);
            }
            _tmpMap = obj;
            _tmpMap.put(key, value);
        } else {
            HashMap obj = cell.getUserObjectValue("CELL_DATA_EXT");
            Map<String, Object> _tmpMap = null;
            if (obj == null || !(obj instanceof Map)) {
                _tmpMap = new HashMap();
                obj = _tmpMap;
                cell.setUserObject("CELL_DATA_EXT", obj);
            }
            _tmpMap = obj;
            _tmpMap.put(key, value);
        }
    }

    public static void removeCellCtrlValue(Cell cell, String key, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            Object obj = range.getUserObject("CELL_DATA_EXT");
            if (obj != null && obj instanceof Map) {
                Map _tmpMap = (Map)obj;
                if (_tmpMap.containsKey(key)) {
                    _tmpMap.remove(key);
                }
                if (_tmpMap.isEmpty()) {
                    range.setUserObject("CELL_DATA_EXT", null);
                }
            }
        } else {
            Object obj = cell.getUserObjectValue("CELL_DATA_EXT");
            if (obj != null && obj instanceof Map) {
                Map _tmpMap = (Map)obj;
                if (_tmpMap.containsKey(key)) {
                    _tmpMap.remove(key);
                }
                if (_tmpMap.isEmpty()) {
                    // empty if block
                }
            }
        }
    }

    public static String getCellCtrlValue(Cell cell, String key) {
        Map _tmpMap;
        if (cell == null) {
            return null;
        }
        Object obj = cell.getUserObjectValue("CELL_DATA_EXT");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey(key)) {
            return (String)_tmpMap.get(key);
        }
        return null;
    }

    public static void dealWith(Book book, String orgUnitId, Map itemFormulaMap, boolean isFromTemplate, boolean isDealItemFormula, boolean needItemVariable, boolean isEnumForm, Context ctx, BgSchemeDimensionHelper schemeHelper, boolean isMustAllDim) throws BOSException, EASBizException {
        BgNTemplateHelper.dealWith(book, orgUnitId, itemFormulaMap, isFromTemplate, isDealItemFormula, null, needItemVariable, isEnumForm, ctx, schemeHelper, isMustAllDim, null);
    }

    public static void dealWith(Book book, String orgUnitId, Map itemFormulaMap, boolean isFromTemplate, boolean isDealItemFormula, boolean needItemVariable, boolean isEnumForm, Context ctx, BgSchemeDimensionHelper schemeHelper, boolean isMustAllDim, Map<String, Set<String>> filterValueMap) throws BOSException, EASBizException {
        BgNTemplateHelper.dealWith(book, orgUnitId, itemFormulaMap, isFromTemplate, isDealItemFormula, null, needItemVariable, isEnumForm, ctx, schemeHelper, isMustAllDim, filterValueMap);
    }

    public static void dealWith(Book book, String orgUnitId, Map itemFormulaMap, boolean isFromTemplate, boolean isDealItemFormula, String currFormulaType, boolean needItemVariable, boolean isEnumForm, Context ctx, BgSchemeDimensionHelper schemeHelper, boolean isMustAllDim, Map<String, Set<String>> filterValueMap) throws BOSException, EASBizException {
        BgNTemplateHelper.dealWith(book, orgUnitId, itemFormulaMap, isFromTemplate, isDealItemFormula, currFormulaType, needItemVariable, isEnumForm, ctx, schemeHelper, isMustAllDim, filterValueMap, true, true);
    }

    public static void dealWith(Book book, String orgUnitId, Map itemFormulaMap, boolean isFromTemplate, boolean isDealItemFormula, String currFormulaType, boolean needItemVariable, boolean isEnumForm, Context ctx, BgSchemeDimensionHelper schemeHelper, boolean isMustAllDim, Map<String, Set<String>> filterValueMap, boolean isElementRequired, boolean isScenarioRequired) throws BOSException, EASBizException {
        if (book == null) {
            return;
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        Sheet _sheet = null;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            ranges.add(_sheet.getSheetRange());
        }
        BgNTemplateHelper.dealWith(ranges, orgUnitId, itemFormulaMap, isFromTemplate, isDealItemFormula, currFormulaType, needItemVariable, isEnumForm, ctx, schemeHelper, isMustAllDim, filterValueMap, isElementRequired, isScenarioRequired);
    }

    public static void dealWith(List<Range> ranges, String orgUnitId, Map itemFormulaMap, boolean isFromTemplate, boolean isDealItemFormula, String currFormulaType, boolean needItemVariable, boolean isEnumForm, Context ctx, BgSchemeDimensionHelper schemeHelper, boolean isMustAllDim, Map<String, Set<String>> filterValueMap, boolean isElementRequired, boolean isScenarioRequired) throws BOSException, EASBizException {
        if (ranges == null) {
            return;
        }
        Range range = null;
        Sheet _sheet = null;
        Cell _cell = null;
        CellBlock block = null;
        int rSize = ranges.size();
        for (int rIndex = 0; rIndex < rSize; ++rIndex) {
            range = ranges.get(rIndex);
            if (range == null) continue;
            _sheet = range.getRangeSheets().getSheet(0);
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            int bSize = range.size();
            for (int bIndex = 0; bIndex < bSize; ++bIndex) {
                block = range.getBlock(bIndex);
                for (int rowIndex = block.getRow(); rowIndex <= Math.min(block.getRow2(), rowCount); ++rowIndex) {
                    for (int colIndex = block.getCol(); colIndex <= Math.min(block.getCol2(), colCount); ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        if (_cell == null || !BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                        BgNFSHelper.clearCurrencyInfo(_cell);
                        BgNFSHelper.clearBgPeriodInfo(_cell);
                        BgNFSHelper.clearBgElementInfo(_cell);
                        BgNFSHelper.clearBgItemInfo(_cell);
                        BgNFSHelper.clearBgScenarioInfo(_cell);
                    }
                }
            }
        }
        HashMap bgItemCombinMap = new HashMap();
        int rSize2 = ranges.size();
        for (int rIndex = 0; rIndex < rSize2; ++rIndex) {
            range = ranges.get(rIndex);
            if (range == null) continue;
            _sheet = range.getRangeSheets().getSheet(0);
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            int bSize = range.size();
            for (int bIndex = 0; bIndex < bSize; ++bIndex) {
                block = range.getBlock(bIndex);
                for (int rowIndex = block.getRow(); rowIndex <= Math.min(block.getRow2(), rowCount); ++rowIndex) {
                    for (int colIndex = block.getCol(); colIndex <= Math.min(block.getCol2(), colCount); ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        if (_cell == null) continue;
                        BgNTemplateHelper.collectBgItemCombin(_cell, bgItemCombinMap, schemeHelper, isMustAllDim, isFromTemplate ? filterValueMap : null, isElementRequired, isScenarioRequired, isFromTemplate);
                    }
                }
            }
        }
        Map dimMembersMap = null;
        Map segMembersMap = null;
        if (isMustAllDim) {
            IMbgMemberFacade iMbgMemberFacade = null;
            iMbgMemberFacade = ctx == null ? MbgMemberFacadeFactory.getRemoteInstance() : MbgMemberFacadeFactory.getLocalInstance(ctx);
            Map[] memberMap = iMbgMemberFacade.getMember(BOSUuid.read((String)schemeHelper.getBgSchemeId()), false);
            if (memberMap.length >= 2) {
                segMembersMap = memberMap[0];
                dimMembersMap = memberMap[1];
            }
        }
        IDimensionFormulaFacade iBgF = null;
        iBgF = ctx == null ? DimensionFormulaFacadeFactory.getRemoteInstance() : DimensionFormulaFacadeFactory.getLocalInstance(ctx);
        bgItemCombinMap = (HashMap)iBgF.batchParseItemCombination(bgItemCombinMap, orgUnitId);
        int rSize3 = ranges.size();
        for (int rIndex = 0; rIndex < rSize3; ++rIndex) {
            range = ranges.get(rIndex);
            if (range == null) continue;
            _sheet = range.getRangeSheets().getSheet(0);
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            int bSize = range.size();
            for (int bIndex = 0; bIndex < bSize; ++bIndex) {
                block = range.getBlock(bIndex);
                for (int rowIndex = block.getRow(); rowIndex <= Math.min(block.getRow2(), rowCount); ++rowIndex) {
                    for (int colIndex = block.getCol(); colIndex <= Math.min(block.getCol2(), colCount); ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        if (_cell == null) continue;
                        if (dimMembersMap != null) {
                            BgNTemplateHelper.checkCellItemFormula(ctx, _cell, dimMembersMap, segMembersMap, orgUnitId, schemeHelper);
                        }
                        BgNTemplateHelper.dealWith(_cell, bgItemCombinMap, itemFormulaMap, isFromTemplate, isDealItemFormula, needItemVariable, currFormulaType, isEnumForm);
                        BgNTemplateHelper.resetExpression(_cell, currFormulaType);
                    }
                }
            }
        }
        Object key2 = null;
        if (bgItemCombinMap == null || bgItemCombinMap.isEmpty()) {
            return;
        }
        for (Object key2 : bgItemCombinMap.keySet()) {
            if ("@".equals(StringUtils.cnulls(key2))) {
                throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"886_AggregateConnotSetAt")});
            }
            if (bgItemCombinMap.get(key2) == null || !(bgItemCombinMap.get(key2) instanceof Object[])) continue;
            Object[] obj = (Object[])bgItemCombinMap.get(key2);
            if (StringUtils.cnulls(key2).indexOf(":") < 0) {
                String msg = null;
                msg = ctx == null ? EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"4_BgActualRecordNewFacadeControllerBean") : ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"4_BgActualRecordNewFacadeControllerBean", (Locale)ctx.getLocale());
                throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{msg});
            }
            if (obj.length < 2 || obj[1] == null || !((Boolean)obj[1]).booleanValue()) continue;
            throw new BgCommonException(BgCommonException.EXISTSAMEITEMGROUP);
        }
    }

    public static void resetExpression(Cell _cell, String formulaType) {
        String expression;
        if (BgNFSHelper.checkHasExpression(_cell) && (StringUtils.isEmpty((String)(expression = BgNTemplateHelper.getFormula(_cell))) || expression.charAt(0) != '=')) {
            return;
        }
    }

    public static void collectBgItemCombin(Cell cell, HashMap bgItemCombinMap, BgSchemeDimensionHelper schemeHelper, boolean isMustAllDim, Map<String, Set<String>> filterValueMap, boolean isElementRequired, boolean isScenarioRequired, boolean isFromTemplate) throws BgTemplateException {
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            cell.setDiagonalHeader(null);
            String itemFormula = BgNFSHelper.getFormulaOfCell(cell);
            if (StringUtils.isEmpty((String)itemFormula)) {
                return;
            }
            if ((itemFormula = BgNTemplateHelper.get6ParematerItemFormula(itemFormula)) != null) {
                List list = new ArrayList();
                FunctionExpr funExpr = null;
                try {
                    Expression expr = ExcelFormulaPaserHelper.parse((String)itemFormula);
                    if (expr instanceof FunctionExpr) {
                        funExpr = (FunctionExpr)expr;
                        list = ((FunctionExpr)expr).parameters;
                    }
                }
                catch (ParserException e1) {
                    logger.error((Object)e1);
                    return;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return;
                }
                if (list == null || list.isEmpty()) {
                    return;
                }
                if (list.size() == 6 && funExpr.funcionName.equalsIgnoreCase("BgItem") && list.get(0) != null) {
                    String strItemCombi = ((StringExpr)list.get((int)0)).value;
                    if (schemeHelper != null) {
                        schemeHelper.checkCombination(strItemCombi, isMustAllDim, true, cell, filterValueMap);
                    }
                    bgItemCombinMap.put(strItemCombi, null);
                    if (isFromTemplate && !isElementRequired && !StringUtils.isEmpty((String)BgNFSHelper.replaceAlter(((StringExpr)list.get((int)2)).value))) {
                        throw new BgTemplateException(BgTemplateException.BGELEMETINSPECIAL);
                    }
                    if (isFromTemplate && !isScenarioRequired && !StringUtils.isEmpty((String)BgNFSHelper.replaceAlter(((StringExpr)list.get((int)3)).value))) {
                        throw new BgTemplateException(BgTemplateException.BGSCHEMEINSPECIAL);
                    }
                }
                if (isElementRequired && (list.size() <= 2 || StringUtils.isEmpty((String)((StringExpr)list.get((int)2)).value))) {
                    throw new BgTemplateException(BgTemplateException.NOBGELEMENT);
                }
                if (isScenarioRequired && (list.size() <= 3 || StringUtils.isEmpty((String)((StringExpr)list.get((int)3)).value))) {
                    throw new BgTemplateException(BgTemplateException.NOBGSCENARIO);
                }
            } else {
                throw new BgTemplateException(BgTemplateException.PARSEBGITEMFORMULAERROR);
            }
        }
        if (BgNTemplateHelper.getFormula(cell) != null) {
            String formula = BgNTemplateHelper.getFormula(cell);
            cell.setDiagonalHeader(null);
            try {
                Expression expr = ExcelFormulaPaserHelper.parse((String)formula);
                BgExpressionsParseHelper.processBgItemCombine(expr, bgItemCombinMap);
            }
            catch (ParserException e1) {
                logger.error((Object)e1);
                return;
            }
            catch (Exception e) {
                logger.error((Object)e);
                logger.error((Object)cell);
                return;
            }
        }
    }

    private static void dealWith(Cell cell, HashMap bgItemCombinMap, Map itemFormulaMap, boolean isFromTemplate, boolean isDealItemFormula, boolean needItemVariable, String currFormulaType, boolean isEnumForm) {
        if (cell == null) {
            return;
        }
        if (bgItemCombinMap == null) {
            bgItemCombinMap = new HashMap();
        }
        if (itemFormulaMap == null) {
            itemFormulaMap = new HashMap<String, String>();
        }
        if (!BgNFSHelper.checkCanEditFormulaOfCell(cell) && !"false".equals(itemFormulaMap.get("FIXEDFORM"))) {
            return;
        }
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            String itemFormula = BgNFSHelper.getFormulaOfCell(cell);
            if ((itemFormula = BgNTemplateHelper.get6ParematerItemFormula(itemFormula)) != null) {
                FunctionExpr funExpr = null;
                try {
                    Expression expr = ExcelFormulaPaserHelper.parse((String)itemFormula);
                    if (expr instanceof FunctionExpr) {
                        funExpr = (FunctionExpr)expr;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return;
                }
                if (funExpr == null) {
                    return;
                }
                String[] params = BgNFSHelper.parseFormulaPara(itemFormula);
                ItemFormula item = (ItemFormula)cell.getUserObjectValue("ITEM");
                if (params.length == 6 && funExpr.funcionName.equalsIgnoreCase("BgItem")) {
                    String strItemCombi = params[0];
                    params[2] = BgNFSHelper.replaceAlter(params[2]);
                    params[3] = BgNFSHelper.replaceAlter(params[3]);
                    String _strItemCombi = null;
                    Object[] obj = (Object[])bgItemCombinMap.get(strItemCombi);
                    if (obj != null && obj.length >= 2 && obj[1] != null && !((Boolean)obj[1]).booleanValue()) {
                        _strItemCombi = (String)obj[0];
                    }
                    if (_strItemCombi == null) {
                        item.FormulaToObject("=BgItem(\"\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[3] + "\",true,\"" + params[5] + "\")");
                        if (isDealItemFormula && isFromTemplate && itemFormulaMap != null) {
                            itemFormulaMap.put(itemFormula, "=BgItem(\"\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[3] + "\",\"" + params[5] + "\")");
                        }
                        itemFormula = "=BgItem(\"\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[3] + "\",true,\"" + params[5] + "\")";
                        BgNFSHelper.setFormulaOfCell(cell, itemFormula);
                        return;
                    }
                    StringBuilder bgItemBuilder = new StringBuilder();
                    bgItemBuilder.append("=BgItem(").append("\"").append(_strItemCombi).append("\",\"").append(params[1]).append("\",\"").append(params[2]).append("\",\"").append(params[3]).append("\",true,\"").append(params[5]).append("\")");
                    itemFormula = bgItemBuilder.toString();
                    if (isDealItemFormula && isFromTemplate && itemFormulaMap != null) {
                        itemFormulaMap.put(itemFormula, "=BgItem(\"" + _strItemCombi + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[3] + "\",\"" + params[5] + "\")");
                    }
                    BgNFSHelper.setFormulaOfCell(cell, itemFormula);
                }
            }
        }
        String expressions = null;
        String _expressions = null;
        if (BgNFSHelper.checkHasExpression(cell)) {
            expressions = BgNFSHelper.getExpression(cell);
            HashMap convertMap = new HashMap();
            Boolean convertResult = (Boolean)convertMap.get("CONVERT_RESULT");
            if (convertResult != null && !convertResult.booleanValue()) {
                BgNFSHelper.clearExpression(cell);
            } else if (!StringUtils.isEmpty(_expressions)) {
                BgNFSHelper.setExpression(cell, _expressions);
            }
        }
    }

    public static boolean CheckTemplateHaveDataFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        return BgNTemplateHelper.getFormula(cell) != null && BgNTemplateHelper.getFormula(cell).trim().length() > 0;
    }

    public static void initAliasObjectTem(Book book, boolean isEnum) {
        if (book == null) {
            return;
        }
        Sheet sheet = null;
        Column col = null;
        Row row = null;
        int bookCount = book.getSheetCount();
        for (int i = 0; i < bookCount; ++i) {
            sheet = book.getSheet(i);
            boolean check = true;
            HashMap aliMap = new HashMap();
            int j = 0;
            for (int maxRowIndex = sheet.getMaxRowIndex(); j <= maxRowIndex; --maxRowIndex) {
                row = sheet.getRow(maxRowIndex, true);
                boolean isEmpty = BgNFSHelper.checkIsEmptyRow(row, true);
                if (check && isEmpty) {
                    BgNFSHelper.removeRowSign(row);
                } else {
                    check = false;
                    if (!BgNFSHelper.checkHasSign(row)) {
                        BgNFSHelper.setRowSign(row);
                        if (isEnum && isEmpty) {
                            BgNFSHelper.setRowNullSign(row);
                        }
                    } else if (BgNFSHelper.checkHasNullSign(row) && !isEmpty) {
                        BgNFSHelper.setRowSign(row);
                        BgNFSHelper.removeNullRowSign(row);
                        BgNFSHelper.setRowSource(row, "DATA_SOURCE_EDIT");
                    } else if (isEnum && BgNFSHelper.checkHasSign(row) && isEmpty) {
                        BgNFSHelper.setRowNullSign(row);
                    }
                }
                if (BgNFSHelper.getRowSource(row) != null) continue;
                BgNFSHelper.setRowSource(row, "DATA_SOURCE_EDIT");
            }
            int maxColIndex = sheet.getMaxColIndex();
            for (j = 0; j <= maxColIndex; ++j) {
                col = sheet.getColumn(j, true);
                if (col == null) continue;
                if (aliMap.containsKey(String.valueOf(j))) {
                    if (!BgNFSHelper.checkHasSign(col)) {
                        BgNFSHelper.setColSign(col);
                    }
                    if (BgNFSHelper.getColObject(col, "SIGN_DATA_SOURCE") != null) continue;
                    BgNFSHelper.setColObject(col, "SIGN_DATA_SOURCE", "DATA_SOURCE_EDIT");
                    continue;
                }
                if (BgNFSHelper.checkHasSign(col)) continue;
                BgNFSHelper.setColSign(col);
            }
            if (!BgNFSHelper.checkHasSign(sheet)) {
                BgNFSHelper.setSheetSign(sheet);
            }
            BgNFSHelper.setSheetObject(sheet, "SIGN_DATA_SOURCE", "DATA_SOURCE_EDIT");
        }
    }

    public static void setStyleAttributesCell(Cell cell, StyleAttributes ssaOuter, StyleAttributes ssaInter) {
        if (cell == null) {
            return;
        }
        Range range = cell.getSheet().getRange(cell);
        range.setIgnoreProtected(true);
        range.setStyle(ssaOuter, ssaInter);
    }

    public static void setStyleAttributesCell(Cell cell, StyleAttributes ssa) {
        if (cell == null) {
            return;
        }
        Range range = cell.getSheet().getRange(cell);
        range.setIgnoreProtected(true);
        range.setStyle(ssa, Styles.getEmptySA());
    }

    public static boolean checkCanEditFormulaOfCell(Cell cell) {
        if (cell == null) {
            return true;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            if (itemFormula.getExt("BGFORMULA_CANUPDATE") == null) {
                itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.TRUE_UPDATE);
                return true;
            }
            if (itemFormula.getExt("BGFORMULA_CANUPDATE").equals(BgNConstants.FALSE_UPDATE)) {
                return false;
            }
            if (itemFormula.getExt("BGFORMULA_CANUPDATE").equals(BgNConstants.TRUE_UPDATE)) {
                return true;
            }
        }
        return true;
    }

    public static String getItemFormulaObject(Cell cell, String key) {
        if (cell == null) {
            return null;
        }
        if (!BgNFSHelper.checkHasFormulaOfCell(cell)) {
            return null;
        }
        ItemFormula item = BgNTemplateHelper.getItemFormula(cell, false);
        return item.getExt(key);
    }

    public static Object getBgFillValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        return BgNTemplateHelper.getBgDataValue(cell, "bgFillValue");
    }

    public static Object getBgFillType(Cell cell) {
        if (cell == null) {
            return null;
        }
        return BgNTemplateHelper.getBgDataValue(cell, "bgFillType");
    }

    public static boolean checkHaveBgFillType(Cell cell) {
        return BgNTemplateHelper.getBgFillType(cell) != null && BgNTemplateHelper.getBgFillType(cell).toString().trim().length() > 0;
    }

    public static boolean checkHaveBgFillValue(Cell cell) {
        return BgNTemplateHelper.getBgFillValue(cell) != null && BgNTemplateHelper.getBgFillValue(cell).toString().trim().length() > 0;
    }

    public static void checkCanEdit(Sheet sheet) throws Exception {
        if (sheet == null) {
            return;
        }
        Range range = sheet.getSelectionRange();
        range.setIgnoreProtected(true);
        int num = range.size();
        if (num <= 0) {
            return;
        }
        Protection pro = sheet.getSheetOption().getProtection(false);
        boolean isPro = false;
        if (pro != null && pro.isProtected() && !pro.allowEditObjects()) {
            isPro = true;
        }
        Cell cell = null;
        int maxRow = sheet.getMaxRowIndex();
        int maxCol = sheet.getMaxColIndex();
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            for (int j = block.getRow(); j <= Math.min(maxRow, block.getRow2()); ++j) {
                for (int k = block.getCol(); k <= Math.min(maxCol, block.getCol2()); ++k) {
                    cell = sheet.getCell(j, k, false);
                    if (cell == null) continue;
                    if (!BgNTemplateHelper.checkCanEditFormulaOfCell(cell)) {
                        throw new BgTemplateException(BgTemplateException.ITEMFORMUL_NOT_EDIT);
                    }
                    if (!isPro || !BgNLockProtectHelper.isCellLocked(cell)) continue;
                    throw new BgTemplateException(BgTemplateException.CELL_LOCK);
                }
            }
        }
    }

    public static Map getSelectCells(Sheet activeSheet) {
        Range range = activeSheet.getSelectionRange();
        range.setIgnoreProtected(true);
        int num = range.size();
        if (num <= 0) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        int maxRow = activeSheet.getMaxRowIndex();
        int maxCol = activeSheet.getMaxColIndex();
        for (int i = 0; i < num; ++i) {
            CellBlock block = range.getBlock(i);
            for (int j = block.getRow(); j <= Math.min(maxRow, block.getRow2()); ++j) {
                for (int k = block.getCol(); k <= Math.min(maxCol, block.getCol2()); ++k) {
                    map.put(j + "-" + k, null);
                }
            }
        }
        return map;
    }

    public static String get6ParematerItemFormula(String formula) {
        FunctionExpr funExpr = null;
        try {
            Expression expr = ExcelFormulaPaserHelper.parse((String)formula);
            if (expr instanceof FunctionExpr) {
                funExpr = (FunctionExpr)expr;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
        if (funExpr == null) {
            return null;
        }
        String[] params = BgNFSHelper.parseFormulaPara(formula);
        if ((params.length != 6 || !funExpr.funcionName.equalsIgnoreCase("BgItem")) && params.length == 5 && funExpr.funcionName.equalsIgnoreCase("BgItem")) {
            formula = "=BgItem(\"" + params[0] + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[3] + "\",true,\"" + params[4] + "\")";
        }
        return formula;
    }

    public static String getFormula(Cell cell) {
        return BgNFSHelper.getExpression(cell);
    }

    public static void checkFormulaIsEctype(List formulas, Locale locale) throws EASBizException {
        int index;
        if (formulas == null || formulas.isEmpty()) {
            return;
        }
        String formulaString = null;
        String checkString = null;
        String sheetString = null;
        StringBuffer msg = null;
        String[] parameter = null;
        HashMap checkMap = new HashMap();
        int count = formulas.size();
        for (index = 0; index < count; ++index) {
            parameter = (String[])formulas.get(index);
            if (parameter == null || parameter[0] == null || parameter[1] == null || parameter[2] == null || parameter[3] == null) continue;
            formulaString = parameter[1];
            if (checkMap.containsKey(formulaString)) {
                checkString = formulaString;
                break;
            }
            checkMap.put(formulaString, null);
        }
        try {
            if (checkString != null) {
                msg = new StringBuffer(1024);
                count = formulas.size();
                for (index = 0; index < count; ++index) {
                    parameter = (String[])formulas.get(index);
                    if (parameter == null || parameter[0] == null || parameter[1] == null || parameter[2] == null || parameter[3] == null || !(formulaString = parameter[1]).equals(checkString)) continue;
                    if (sheetString == null || !sheetString.equals(parameter[0])) {
                        sheetString = parameter[0];
                        msg.append(BgNTemplateHelper.getMessage("left", locale) + sheetString + BgNTemplateHelper.getMessage("right", locale) + BgNTemplateHelper.getMessage("checkFormulade", locale));
                    }
                    msg.append(TableToolkit.xy2range((int)Integer.valueOf(parameter[3]), (int)Integer.valueOf(parameter[2])) + BgNTemplateHelper.getMessage("andtwo", locale));
                }
                msg.delete(msg.length() - 1, msg.length());
                msg.append(BgNTemplateHelper.getMessage("checkFormula", locale) + BgNTemplateHelper.getMessage("left", locale) + checkString.replaceAll(",\"BgData\",true", "") + BgNTemplateHelper.getMessage("right", locale) + BgNTemplateHelper.getMessage("checkFormulaEctype", locale));
                throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{msg.toString()});
            }
        }
        catch (EASBizException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        finally {
            checkMap.clear();
        }
    }

    public static String getMessage(String msg, Locale locale) {
        return ResourceBase.getString((String)STRRESOURCE, (String)msg, (Locale)locale);
    }

    public static void mergeCol(Sheet sheet, int colindex, int start, int end) {
        boolean isBeginMerge = false;
        int startMerge = start;
        int endMerge = start;
        Range range = null;
        String formula = null;
        String fillType = null;
        String fillValue = null;
        Object value = null;
        String formulaOld = null;
        String fillTypeOld = null;
        String fillValueOld = null;
        Object valueOld = null;
        Column col = sheet.getColumn(colindex, false);
        if (col == null) {
            return;
        }
        for (int i = start; i < end + 1; ++i) {
            Cell cell = sheet.getCell(i, colindex, false);
            if (cell == null) {
                if (!isBeginMerge) continue;
                if (endMerge > startMerge) {
                    range = sheet.getRange(startMerge, colindex, endMerge, colindex);
                    range.setIgnoreProtected(true);
                    range.merge();
                }
                startMerge = i;
                endMerge = i;
                isBeginMerge = false;
                formulaOld = null;
                valueOld = null;
                fillTypeOld = null;
                fillValueOld = null;
                continue;
            }
            formula = BgNFSHelper.getExpression(cell);
            if (formulaOld == null) {
                formulaOld = formula;
            }
            value = BgNFSHelper.getValue(cell);
            if (valueOld == null) {
                valueOld = value;
            }
            fillType = (String)BgNTemplateHelper.getBgFillType(cell);
            if (fillTypeOld == null) {
                fillTypeOld = fillType;
            }
            fillValue = (String)BgNTemplateHelper.getBgFillValue(cell);
            if (fillValueOld == null) {
                fillValueOld = fillValue;
            }
            if (!isBeginMerge) {
                isBeginMerge = true;
                endMerge = i;
                continue;
            }
            boolean isAllSame = true;
            if (!StringUtils.equals((String)formula, (String)formulaOld)) {
                isAllSame = false;
            }
            if (isAllSame && value == null && valueOld != null || valueOld != null && value == null || !value.equals(valueOld)) {
                isAllSame = false;
            }
            if (isAllSame && fillType == null && fillTypeOld != null || fillTypeOld != null && fillType == null || !fillType.equals(fillTypeOld)) {
                isAllSame = false;
            }
            if (isAllSame && fillValue == null && fillValueOld != null || fillValueOld != null && fillValue == null || !fillValue.equals(fillValueOld)) {
                isAllSame = false;
            }
            if (!isAllSame) {
                if (endMerge > startMerge) {
                    range = sheet.getRange(startMerge, colindex, endMerge, colindex);
                    range.setIgnoreProtected(true);
                    range.merge();
                }
                startMerge = i;
                endMerge = i;
                isBeginMerge = true;
                formulaOld = formula;
                valueOld = value;
                fillTypeOld = fillType;
                fillValueOld = fillValue;
                continue;
            }
            endMerge = i;
        }
    }

    public static void updateSheetName(Context ctx, Connection conn, String bgTemId, Book book) throws BOSException, EASBizException {
        if (conn == null || bgTemId == null || book == null) {
            return;
        }
        String _Sign = "A1B2C3D4";
        String _sheetId = null;
        String _sheetName = null;
        PreparedStatement pstmt = null;
        Sheet _sheet = null;
        ResultSet rst = null;
        try {
            try {
                pstmt = conn.prepareStatement("delete from T_MBg_BgTemSheet where FBgTemplateID = ?");
                pstmt.setString(1, bgTemId);
                pstmt.executeUpdate();
            }
            catch (SQLException ex) {
                throw ex;
            }
            finally {
                SQLUtils.cleanup((Statement)pstmt);
            }
            pstmt = conn.prepareStatement("Insert Into T_MBg_BgTemSheet (FID, FBgTemplateID, FSheetIndex, FSheetID, FSheetName) values (?, ?, ?, ?, ?)");
            int in = book.getSheetCount();
            for (int i = 0; i < in; ++i) {
                _sheet = book.getSheet(i);
                _sheetId = BgNFSHelper.getSheetSign(_sheet);
                _sheetName = _sheet.getSheetName();
                pstmt.setString(1, BOSUuid.create((String)_Sign).toString());
                pstmt.setString(2, bgTemId);
                pstmt.setInt(3, i);
                pstmt.setString(4, _sheetId);
                pstmt.setString(5, _sheetName);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
    }

    public static boolean hasForceLock(Cell cell) {
        return BgNTemplateHelper.getForceLockLongNumber(cell) != null;
    }

    public static boolean setForceLock(Cell cell, String orgLongnumber) {
        boolean flag = false;
        if (cell == null || orgLongnumber == null) {
            return flag;
        }
        String value = BgNTemplateHelper.getForceLockLongNumber(cell);
        if (value == null || value.indexOf(orgLongnumber) == 0) {
            cell.setUserObject("force_lock_org_longnumber", (Object)orgLongnumber);
            flag = true;
        }
        return flag;
    }

    public static boolean removeForceLock(Cell cell, String orgLongnumber) {
        boolean flag = true;
        String value = BgNTemplateHelper.getForceLockLongNumber(cell);
        if (value != null) {
            if (value.equals(orgLongnumber)) {
                BgNTemplateHelper.removeForceLock(cell);
            } else {
                flag = false;
            }
        }
        return flag;
    }

    public static void removeForceLock(Cell cell) {
        if (cell != null) {
            Range r = cell.getSheet().getRange(cell);
            r.setIgnoreProtected(true);
            r.setCellLocked(false);
            cell.removeUserObject("force_lock_org_longnumber");
        }
    }

    public static boolean canEditForForceLock(Cell cell, String orgLongnumber) {
        boolean flag = true;
        if (cell != null) {
            String value = BgNTemplateHelper.getForceLockLongNumber(cell);
            flag = value == null || value.equals(orgLongnumber);
        }
        return flag;
    }

    public static String getForceLockLongNumber(Cell cell) {
        if (cell != null) {
            return (String)cell.getUserObjectValue("force_lock_org_longnumber");
        }
        return null;
    }

    public static void showForceLock(Book book) {
        if (book != null) {
            int sheetIndex = 0;
            int sheetSize = book.getSheetCount();
            for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                Sheet sheet = book.getSheet(sheetIndex);
                BgNTemplateHelper.showForceLock(sheet);
            }
        }
    }

    public static boolean canEditByForceLock(Cell cell) {
        boolean unlock = true;
        if (cell != null) {
            String orgLongnumber = SysContext.getSysContext().getCurrentOrgUnit().castToFullOrgUnitInfo().getLongNumber();
            if (BgNTemplateHelper.hasForceLock(cell) && !BgNTemplateHelper.canEditForForceLock(cell, orgLongnumber)) {
                unlock = false;
            }
        }
        return unlock;
    }

    public static void showForceLock(Sheet sheet) {
        if (sheet == null) {
            return;
        }
        String orgLongnumber = SysContext.getSysContext().getCurrentOrgUnit().castToFullOrgUnitInfo().getLongNumber();
        Range rangeUnlock = null;
        Range rangeLock = null;
        Cell cell = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        boolean isLockCellByFormula = BgParamCHelper.isLockCellByFormula();
        long st = System.currentTimeMillis();
        logger.error((Object)("start showForceLock: " + sheet.getSheetName()));
        for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, false);
                if (cell == null || !BgNTemplateHelper.hasForceLock(cell)) continue;
                if (BgNTemplateHelper.canEditForForceLock(cell, orgLongnumber) && !Boolean.FALSE.equals(BgNFSHelper.getCellData(cell, "BGDATA_CAN_UPDATE"))) {
                    if (rangeUnlock == null) {
                        rangeUnlock = cell.getSheet().getRange(cell);
                        if (!cell.hasFormula() || !isLockCellByFormula) continue;
                        if (rangeLock == null) {
                            rangeLock = cell.getSheet().getRange(cell);
                            continue;
                        }
                        rangeLock.addAll((SortedCellBlockArray)cell.getSheet().getRange(cell));
                        continue;
                    }
                    rangeUnlock.addAll((SortedCellBlockArray)cell.getSheet().getRange(cell));
                    if (!cell.hasFormula() || !isLockCellByFormula) continue;
                    if (rangeLock == null) {
                        rangeLock = cell.getSheet().getRange(cell);
                        continue;
                    }
                    rangeLock.addAll((SortedCellBlockArray)cell.getSheet().getRange(cell));
                    continue;
                }
                if (rangeLock == null) {
                    rangeLock = cell.getSheet().getRange(cell);
                    continue;
                }
                rangeLock.addAll((SortedCellBlockArray)cell.getSheet().getRange(cell));
            }
        }
        if (rangeUnlock != null) {
            StyleAttributes saUnlock = Styles.getEmptySA();
            saUnlock.setLocked(false);
            rangeUnlock.setIgnoreProtected(true);
            rangeUnlock.setStyle(saUnlock, Styles.getEmptySA());
        }
        if (rangeLock != null) {
            StyleAttributes saLock = Styles.getEmptySA();
            saLock.setLocked(true);
            rangeLock.setIgnoreProtected(true);
            rangeLock.setStyle(saLock, Styles.getEmptySA());
        }
        logger.error((Object)("end showForceLock: " + sheet.getSheetName() + " " + (System.currentTimeMillis() - st) + " ms"));
    }

    private static void checkCellItemFormula(Context ctx, Cell cell, Map<String, Map<String, String[]>> membersMap, Map<String, Map<String, Map<String, String[]>>> segMembersMap, String orgUnitId, BgSchemeDimensionHelper schemeHelper) throws BOSException, EASBizException {
        if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell) || !BgNFSHelper.checkCanEditFormulaOfCell(cell) || membersMap.isEmpty() || schemeHelper == null) {
            return;
        }
        String itemFormula = BgNFSHelper.getFormulaOfCell(cell);
        itemFormula = BgNTemplateHelper.get6ParematerItemFormula(itemFormula);
        HashMap<String, String> dimSrcNums = new HashMap<String, String>();
        List<String> dimNumbers = schemeHelper.getAllDim();
        for (int i = 0; i < dimNumbers.size(); ++i) {
            if (membersMap.containsKey(dimNumbers.get(i))) {
                dimSrcNums.put(schemeHelper.getSrcNumber(dimNumbers.get(i)), dimNumbers.get(i));
            }
            if (segMembersMap == null || segMembersMap.isEmpty() || !segMembersMap.containsKey(dimNumbers.get(i))) continue;
            dimSrcNums.put(schemeHelper.getSrcNumber(dimNumbers.get(i)), dimNumbers.get(i));
        }
        if (itemFormula != null) {
            FunctionExpr funExpr = null;
            try {
                Expression expr = ExcelFormulaPaserHelper.parse((String)itemFormula);
                if (expr instanceof FunctionExpr) {
                    funExpr = (FunctionExpr)expr;
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                return;
            }
            if (funExpr == null) {
                return;
            }
            String sheetName = cell.getSheet().getSheetName();
            String cellName = cell.getName(false, false);
            String msg = null;
            String[] params = BgNFSHelper.parseFormulaPara(itemFormula);
            if (params.length == 6 && funExpr.funcionName.equalsIgnoreCase("BgItem")) {
                String strItemCombi = params[0];
                String strPeriod = params[1];
                String strElement = BgNFSHelper.replaceAlter(params[2]);
                String strScenario = BgNFSHelper.replaceAlter(params[3]);
                String strCurrency = params[5];
                if (!StringUtils.isEmpty((String)strItemCombi)) {
                    if (strItemCombi.contains(BgBaseConstants.SEP_THR_STR)) {
                        String[] strItem = strItemCombi.split(BgBaseConstants.SEP_THR_STR);
                        for (int index = 0; index < strItem.length; ++index) {
                            boolean match = false;
                            String itemNum = strItem[index];
                            if (StringUtils.isEmpty((String)itemNum) || !itemNum.contains(BgBaseConstants.SEP_FOUR_STR)) continue;
                            String[] srtArr = itemNum.split(BgBaseConstants.SEP_FOUR_STR);
                            if (srtArr.length == 2 && dimSrcNums.containsKey(srtArr[0])) {
                                if (membersMap.containsKey(dimSrcNums.get(srtArr[0])) && membersMap.get(dimSrcNums.get(srtArr[0])).containsKey(srtArr[1])) {
                                    match = true;
                                    continue;
                                }
                                if (segMembersMap != null && !segMembersMap.isEmpty() && segMembersMap.containsKey(dimSrcNums.get(srtArr[0]))) {
                                    Map<String, Map<String, String[]>> tmpMap = segMembersMap.get(dimSrcNums.get(srtArr[0]));
                                    for (String orgId : tmpMap.keySet()) {
                                        if (!tmpMap.get(orgId).containsKey(srtArr[1])) continue;
                                        match = true;
                                    }
                                }
                            }
                            if (match) continue;
                            msg = ctx == null ? EASResource.getString((String)STRRESOURCE, (String)"checkItemByMbgDim", (Object[])new String[]{sheetName, cellName}) : ResourceBase.getString((String)STRRESOURCE, (String)"checkItemByMbgDim", (Locale)ctx.getLocale(), (Object[])new String[]{sheetName, cellName});
                            throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{msg});
                        }
                    } else if (!StringUtils.isEmpty((String)strItemCombi) && strItemCombi.contains(BgBaseConstants.SEP_FOUR_STR)) {
                        String[] srtArr = strItemCombi.split(BgBaseConstants.SEP_FOUR_STR);
                        if (!membersMap.containsKey(DimensionConstants.DEF_ACCOUNT_NUMBER) || !membersMap.get(DimensionConstants.DEF_ACCOUNT_NUMBER).containsKey(srtArr[1])) {
                            msg = ctx == null ? EASResource.getString((String)STRRESOURCE, (String)"checkItemByMember", (Object[])new String[]{sheetName, cellName, DimensionConstants.DEF_ACCOUNT_MAME}) : ResourceBase.getString((String)STRRESOURCE, (String)"checkItemByMember", (Locale)ctx.getLocale(), (Object[])new String[]{sheetName, cellName, DimensionConstants.DEF_ACCOUNT_MAME});
                            throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{msg});
                        }
                    }
                }
                if (!(StringUtils.isEmpty((String)strPeriod) || strPeriod.contains(BgBaseConstants.SEP_ONE_STR) || membersMap.containsKey(DimensionConstants.DEF_PERIOD_NUMBER) && membersMap.get(DimensionConstants.DEF_PERIOD_NUMBER).containsKey(strPeriod))) {
                    msg = ctx == null ? EASResource.getString((String)STRRESOURCE, (String)"checkItemByMember", (Object[])new String[]{sheetName, cellName, DimensionConstants.DEF_PERIOD_NAME}) : ResourceBase.getString((String)STRRESOURCE, (String)"checkItemByMember", (Locale)ctx.getLocale(), (Object[])new String[]{sheetName, cellName, DimensionConstants.DEF_PERIOD_NAME});
                    throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{msg});
                }
                if (!(StringUtils.isEmpty((String)strElement) || membersMap.containsKey(DimensionConstants.DEF_ELEMENT_NUMBER) && membersMap.get(DimensionConstants.DEF_ELEMENT_NUMBER).containsKey(strElement))) {
                    msg = ctx == null ? EASResource.getString((String)STRRESOURCE, (String)"checkItemByMember", (Object[])new String[]{sheetName, cellName, DimensionConstants.DEF_ELEMENT_NAME}) : ResourceBase.getString((String)STRRESOURCE, (String)"checkItemByMember", (Locale)ctx.getLocale(), (Object[])new String[]{sheetName, cellName, DimensionConstants.DEF_ELEMENT_NAME});
                    throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{msg});
                }
                if (!(StringUtils.isEmpty((String)strScenario) || membersMap.containsKey(DimensionConstants.DEF_SCENARIO_NUMBER) && membersMap.get(DimensionConstants.DEF_SCENARIO_NUMBER).containsKey(strScenario))) {
                    msg = ctx == null ? EASResource.getString((String)STRRESOURCE, (String)"checkItemByMember", (Object[])new String[]{sheetName, cellName, DimensionConstants.DEF_SCENARIO_NAME}) : ResourceBase.getString((String)STRRESOURCE, (String)"checkItemByMember", (Locale)ctx.getLocale(), (Object[])new String[]{sheetName, cellName, DimensionConstants.DEF_SCENARIO_NAME});
                    throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{msg});
                }
                if (!(StringUtils.isEmpty((String)strCurrency) || membersMap.containsKey(DimensionConstants.DEF_CURRENCY_NUMBER) && membersMap.get(DimensionConstants.DEF_CURRENCY_NUMBER).containsKey(strCurrency))) {
                    msg = ctx == null ? EASResource.getString((String)STRRESOURCE, (String)"checkItemByMember", (Object[])new String[]{sheetName, cellName, DimensionConstants.DEF_CURRENCY_NAME}) : ResourceBase.getString((String)STRRESOURCE, (String)"checkItemByMember", (Locale)ctx.getLocale(), (Object[])new String[]{sheetName, cellName, DimensionConstants.DEF_CURRENCY_NAME});
                    throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{msg});
                }
            }
        }
    }
}

