/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.NodeFactory;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.IBgOrgView;
import com.kingdee.eas.ma.mbg.utils.BgOrgDataHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BgOrgTreeHelper {
    public static final String VIRROOT = "Virroot";
    private static Color disableColor = new Color(77, 77, 77);

    public static TreeModel clipAndCloneTreeModel(TreeModel model, String value, boolean isBgOrgUnitNode) {
        DefaultTreeModel treeModel = (DefaultTreeModel)BgOrgTreeHelper.deepCloneTreeModel(model);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        if (root.getUserObject() != null && root != null) {
            if (isBgOrgUnitNode) {
                BgOrgTreeHelper.disableTreeNodeByFilterCondition(root, value);
            } else {
                BgOrgTreeHelper.disableTreeNodeByFilterForCostCenter(root, value);
            }
            OrgF7InnerUtils.clipTreeNodeByColor((DefaultKingdeeTreeNode)root);
        }
        return treeModel;
    }

    private static TreeModel deepCloneTreeModel(TreeModel model) {
        DefaultKingdeeTreeNode newRoot = null;
        if (model.getRoot() != null) {
            newRoot = BgOrgTreeHelper.cloneTreeNode((DefaultKingdeeTreeNode)model.getRoot());
        }
        return new DefaultTreeModel((TreeNode)newRoot);
    }

    private static DefaultKingdeeTreeNode cloneTreeNode(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode(node.getUserObject());
        DefaultKingdeeTreeNode childNode = null;
        DefaultKingdeeTreeNode newChildNode = null;
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            newChildNode = BgOrgTreeHelper.cloneTreeNode(childNode);
            newNode.add((MutableTreeNode)newChildNode);
        }
        return newNode;
    }

    private static void disableTreeNodeByFilterCondition(DefaultKingdeeTreeNode root, String value) {
        if (root == null || StringUtils.isEmpty((String)value)) {
            return;
        }
        BgOrgUnitInfo unitInfo = null;
        DefaultKingdeeTreeNode node = null;
        String number = null;
        String name = null;
        int numberIndex = 0;
        int nameIndex = 0;
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            if (node.getUserObject() instanceof BgOrgUnitInfo) {
                unitInfo = (BgOrgUnitInfo)node.getUserObject();
                number = unitInfo.getNumber();
                name = unitInfo.getName();
                numberIndex = StringUtils.isEmpty((String)number) ? 0 : number.indexOf(value);
                int n = nameIndex = StringUtils.isEmpty((String)name) ? 0 : name.indexOf(value);
                if (numberIndex != -1 || nameIndex != -1 || unitInfo.getOrgUnitID() == null) continue;
                OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)node);
                continue;
            }
            if (!(node.getUserObject() instanceof OrgStructureInfo)) continue;
            OrgStructureInfo orgStructureInfo = (OrgStructureInfo)node.getUserObject();
            FullOrgUnitInfo fullOrgUnitInfo = orgStructureInfo.getUnit();
            number = fullOrgUnitInfo.getNumber();
            name = fullOrgUnitInfo.getName();
            numberIndex = StringUtils.isEmpty((String)number) ? 0 : number.indexOf(value);
            int n = nameIndex = StringUtils.isEmpty((String)name) ? 0 : name.indexOf(value);
            if (numberIndex != -1 || nameIndex != -1) continue;
            OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)node);
        }
    }

    private static void disableTreeNodeByFilterForCostCenter(DefaultKingdeeTreeNode root, String value) {
        if (root == null || StringUtils.isEmpty((String)value)) {
            return;
        }
        OrgStructureInfo structureInfo = null;
        FullOrgUnitInfo unitInfo = null;
        DefaultKingdeeTreeNode node = null;
        String number = null;
        String name = null;
        int numberIndex = 0;
        int nameIndex = 0;
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            structureInfo = (OrgStructureInfo)node.getUserObject();
            if (structureInfo == null) continue;
            unitInfo = structureInfo.getUnit();
            number = unitInfo.getNumber();
            name = unitInfo.getName();
            numberIndex = StringUtils.isEmpty((String)number) ? 0 : number.indexOf(value);
            int n = nameIndex = StringUtils.isEmpty((String)name) ? 0 : name.indexOf(value);
            if (numberIndex != -1 || nameIndex != -1) continue;
            BgOrgTreeHelper.disableTreeNode(node);
        }
    }

    public static void disableTreeNode(DefaultKingdeeTreeNode treeNode) {
        treeNode.setTextColor(disableColor);
    }

    public static void selectAllSubNode(DefaultKingdeeTreeNode parentNode, boolean checked) {
        if (parentNode == null) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        Enumeration nodeEnum = parentNode.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            if (!BgOrgTreeHelper.canTheNodeBeSelected(node)) continue;
            node.setChecked(checked);
        }
    }

    public static void selectLeafOrgUnit(DefaultKingdeeTreeNode parentNode, boolean checked) {
        if (parentNode == null) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        Enumeration nodeEnum = parentNode.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            Object userObject = node.getUserObject();
            if (!BgOrgTreeHelper.canTheNodeBeSelected(node) || !(userObject instanceof BgOrgUnitInfo) || !((BgOrgUnitInfo)userObject).isIsLeaf()) continue;
            node.setChecked(checked);
        }
    }

    public static void selectDirectOrgUnit(DefaultKingdeeTreeNode root, boolean selected) {
        if (root == null) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        Enumeration directChildEnum = root.children();
        HashSet<DefaultKingdeeTreeNode> directChildSet = new HashSet<DefaultKingdeeTreeNode>();
        directChildSet.add(root);
        while (directChildEnum.hasMoreElements()) {
            directChildSet.add((DefaultKingdeeTreeNode)directChildEnum.nextElement());
        }
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            if (!BgOrgTreeHelper.canTheNodeBeSelected(node)) continue;
            node.setChecked(directChildSet.contains(node));
        }
    }

    public static void selectAllPerformed(KDTree kdTree, boolean isSelectAll, boolean chkIncludeChildren) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)kdTree.getModel().getRoot();
        Class<?> _class = null;
        Method _method = null;
        OrgViewType _viewType = OrgViewType.COSTCENTER;
        _class = Class.forName("com.kingdee.eas.ma.mbg.client.utils.BgNSchemeDispatchClientHelper");
        Class[] classes = new Class[]{Boolean.TYPE, DefaultKingdeeTreeNode.class, Boolean.TYPE, KDTree.class};
        _method = _class.getMethod("setNodeSelect", classes);
        Object[] objs = new Object[]{isSelectAll, root, chkIncludeChildren, kdTree};
        _method.invoke(_class, objs);
    }

    public static TreeModel buildTreeModel(List<BgOrgUnitInfo> fulOrgCol) throws Exception {
        return BgOrgTreeHelper.buildTreeModel(BgOrgTreeHelper.buildBgOrgTreeByCol(fulOrgCol));
    }

    public static TreeModel buildMultiTreeModel2(List<BgOrgUnitInfo> fulOrgCol) throws Exception {
        DefaultKingdeeTreeNode node = BgOrgTreeHelper.buildMultiBgOrgTreeByCol(fulOrgCol);
        DefaultKingdeeTreeNode nextNode = (DefaultKingdeeTreeNode)node.getNextNode();
        if (((BgOrgUnitInfo)node.getUserObject()).getParent() == null) {
            return BgOrgTreeHelper.buildTreeModel(nextNode);
        }
        return BgOrgTreeHelper.buildTreeModel(node);
    }

    public static TreeModel buildMultiTreeModel(List<BgOrgUnitInfo> fulOrgCol) throws Exception {
        return BgOrgTreeHelper.buildTreeModel(BgOrgTreeHelper.buildMultiBgOrgTreeByCol(fulOrgCol));
    }

    public static TreeModel buildMultiTreeModel(String bgOrgViewId) throws Exception {
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            return null;
        }
        EntityViewInfo bgOrgEntityInfo = BgOrgUnitHelper.getBgOrgEntityViewInfo(bgOrgViewId);
        BgOrgUnitCollection orgUnitColl = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(bgOrgEntityInfo);
        BgOrgUnitInfo bgOrginfo = null;
        ArrayList<BgOrgUnitInfo> bgOrgList = new ArrayList<BgOrgUnitInfo>();
        int size = orgUnitColl.size();
        for (int i = 0; i < size; ++i) {
            bgOrginfo = orgUnitColl.get(i);
            bgOrgList.add(bgOrginfo);
        }
        return BgOrgTreeHelper.buildTreeModel(BgOrgTreeHelper.buildMultiBgOrgTreeByCol(bgOrgList));
    }

    public static TreeModel buildTreeModel(DefaultKingdeeTreeNode selectedNode) throws Exception {
        return new DefaultTreeModel((TreeNode)selectedNode){

            @Override
            public boolean isLeaf(Object node) {
                return BgOrgTreeHelper.isLeaf((DefaultKingdeeTreeNode)node);
            }
        };
    }

    public static DefaultKingdeeTreeNode buildBgOrgTreeByCol(List<BgOrgUnitInfo> fulOrgCol) throws BOSException {
        return BgOrgTreeHelper.buildBgOrgTreeByCol(fulOrgCol, new NodeFactory(){

            public DefaultKingdeeTreeNode create(Object obj) {
                return new DefaultKingdeeTreeNode(obj);
            }
        });
    }

    public static DefaultKingdeeTreeNode buildMultiBgOrgTreeByCol(List<BgOrgUnitInfo> fulOrgCol) throws BOSException {
        return BgOrgTreeHelper.buildMultiBgOrgTreeByCol(fulOrgCol, new NodeFactory(){

            public DefaultKingdeeTreeNode create(Object obj) {
                return new DefaultKingdeeTreeNode(obj);
            }
        });
    }

    public static DefaultKingdeeTreeNode buildBgOrgTreeByCol(List<BgOrgUnitInfo> fulOrgCol, NodeFactory nodeFactory) throws BOSException {
        if (fulOrgCol == null) {
            return null;
        }
        if (fulOrgCol.size() == 0) {
            return nodeFactory.create(null);
        }
        BgOrgUnitInfo curBgUnitInfo = null;
        BgOrgUnitInfo parentUnitInfo = null;
        DefaultKingdeeTreeNode rootTreeNode = null;
        DefaultKingdeeTreeNode subTreeNode = null;
        DefaultKingdeeTreeNode parentNode = null;
        String parentID = null;
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        for (int i = 0; i < fulOrgCol.size(); ++i) {
            curBgUnitInfo = fulOrgCol.get(i);
            if (rootTreeNode == null) {
                rootTreeNode = nodeFactory.create((Object)curBgUnitInfo);
                nodeMap.put(curBgUnitInfo.getId().toString(), rootTreeNode);
                continue;
            }
            subTreeNode = nodeFactory.create((Object)curBgUnitInfo);
            parentUnitInfo = curBgUnitInfo.getParent();
            if (parentUnitInfo != null && parentUnitInfo.getId() != null && nodeMap.containsKey(parentID = parentUnitInfo.getId().toString())) {
                parentNode = (DefaultKingdeeTreeNode)nodeMap.get(parentID);
                parentUnitInfo = (BgOrgUnitInfo)parentNode.getUserObject();
                parentUnitInfo.setIsLeaf(false);
                parentNode.add((MutableTreeNode)subTreeNode);
                curBgUnitInfo.setBoolean("isChildLoaded", true);
            }
            nodeMap.put(curBgUnitInfo.getId().toString(), subTreeNode);
        }
        return rootTreeNode;
    }

    public static DefaultKingdeeTreeNode buildMultiBgOrgTreeByCol(List<BgOrgUnitInfo> fulOrgCol, NodeFactory nodeFactory) throws BOSException {
        int i;
        if (fulOrgCol == null) {
            return null;
        }
        if (fulOrgCol.size() == 0) {
            return nodeFactory.create(null);
        }
        Object parentUnitInfo = null;
        DefaultKingdeeTreeNode rootTreeNode = null;
        Object subTreeNode = null;
        Object parentNode = null;
        Object parentID = null;
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        TreeMap levelMap = new TreeMap();
        BgOrgUnitInfo rootBgUnitInfo = new BgOrgUnitInfo();
        BOSUuid rootId = BOSUuid.create((BOSObjectType)rootBgUnitInfo.getBOSType());
        rootBgUnitInfo.setId(rootId);
        rootBgUnitInfo.setIsLeaf(true);
        rootTreeNode = nodeFactory.create((Object)rootBgUnitInfo);
        nodeMap.put(rootBgUnitInfo.getId().toString(), rootTreeNode);
        BgOrgTreeHelper.dealWithSeqShowLevelSort(fulOrgCol);
        int curLevel = -1;
        Object sameLevelNodesSet = null;
        DefaultKingdeeTreeNode curTreeNode = null;
        DefaultKingdeeTreeNode pNode = null;
        BgOrgUnitInfo curBgUnitInfo = null;
        HashMap<BOSUuid, DefaultKingdeeTreeNode> bgOrgUnitMap = new HashMap<BOSUuid, DefaultKingdeeTreeNode>();
        for (i = 0; i < fulOrgCol.size(); ++i) {
            curBgUnitInfo = fulOrgCol.get(i);
            bgOrgUnitMap.put(curBgUnitInfo.getId(), nodeFactory.create((Object)curBgUnitInfo));
        }
        for (i = 0; i < fulOrgCol.size(); ++i) {
            curBgUnitInfo = fulOrgCol.get(i);
            curTreeNode = (DefaultKingdeeTreeNode)bgOrgUnitMap.get(curBgUnitInfo.getId());
            if (curBgUnitInfo.getParent() == null) {
                rootTreeNode.add((MutableTreeNode)curTreeNode);
                continue;
            }
            pNode = (DefaultKingdeeTreeNode)bgOrgUnitMap.get(curBgUnitInfo.getParent().getId());
            if (pNode == null) continue;
            pNode.add((MutableTreeNode)curTreeNode);
        }
        return rootTreeNode;
    }

    private static void dealWithSeqShowLevelSort(List<BgOrgUnitInfo> fulOrgCol) {
        Collections.sort(fulOrgCol, new Comparator<BgOrgUnitInfo>(){

            @Override
            public int compare(BgOrgUnitInfo o1, BgOrgUnitInfo o2) {
                if (o1.getShowLevel() == o2.getShowLevel()) {
                    return o1.getLongNumber().compareTo(o2.getLongNumber());
                }
                return o1.getShowLevel() - o2.getShowLevel();
            }
        });
    }

    public static DefaultKingdeeTreeNode createNewNode(BgOrgUnitInfo info, NodeFactory nodeFactory) {
        if (info == null || nodeFactory == null) {
            return null;
        }
        return nodeFactory.create((Object)info);
    }

    public static DefaultKingdeeTreeNode createNewNode(BgOrgUnitInfo info) {
        if (info == null) {
            return null;
        }
        return BgOrgTreeHelper.createNewNode(info, new NodeFactory(){

            public DefaultKingdeeTreeNode create(Object obj) {
                BgOrgUnitInfo _orgUnit;
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode(obj);
                if (obj instanceof BgOrgUnitInfo && (_orgUnit = (BgOrgUnitInfo)obj).isIsVirtual()) {
                    node.setText(_orgUnit.getName() + "(s)");
                }
                return node;
            }
        });
    }

    public static List<BgOrgUnitInfo> getAllCostCenterNodeToBgOrg(KDTree tree, String bgOrgViewId, BgOrgDataHelper helper) {
        ArrayList<BgOrgUnitInfo> setNode = new ArrayList<BgOrgUnitInfo>();
        if (tree == null || tree.getModel() == null || tree.getModel().getRoot() == null) {
            return setNode;
        }
        Object root = tree.getModel().getRoot();
        DefaultKingdeeTreeNode nodeTarget = null;
        OrgStructureInfo structInfo = null;
        OrgStructureInfo parentStructInfo = null;
        BgOrgUnitInfo bgOrgUnitInfo = null;
        BgOrgUnitInfo parentUnitInfo = null;
        String structID = null;
        String parentStructID = null;
        HashMap<String, BgOrgUnitInfo> structID2CostCenter = new HashMap<String, BgOrgUnitInfo>();
        if (root != null && root instanceof DefaultKingdeeTreeNode) {
            Enumeration enumTarget = ((DefaultKingdeeTreeNode)root).breadthFirstEnumeration();
            while (enumTarget.hasMoreElements()) {
                nodeTarget = (DefaultKingdeeTreeNode)enumTarget.nextElement();
                structInfo = (OrgStructureInfo)nodeTarget.getUserObject();
                if (structInfo == null) continue;
                bgOrgUnitInfo = BgOrgTreeHelper.createNewBgOrg(nodeTarget, bgOrgViewId);
                structID = structInfo.getId().toString();
                parentStructInfo = structInfo.getParent();
                String string = parentStructID = parentStructInfo == null ? null : parentStructInfo.getId().toString();
                if (parentStructID != null && structID2CostCenter.containsKey(parentStructID)) {
                    parentUnitInfo = (BgOrgUnitInfo)structID2CostCenter.get(parentStructID);
                    if (parentUnitInfo.isIsLeaf()) {
                        parentUnitInfo.setIsLeaf(false);
                    }
                    bgOrgUnitInfo.setParent(parentUnitInfo);
                }
                structID2CostCenter.put(structID, bgOrgUnitInfo);
                setNode.add(bgOrgUnitInfo);
            }
        }
        return setNode;
    }

    public static BgOrgUnitInfo createNewBgOrgForDesignated(DefaultKingdeeTreeNode node, String bgOrgViewId, BgOrgDataHelper helper, BgOrgUnitInfo parentInfo) {
        if (node == null || parentInfo == null) {
            return null;
        }
        OrgStructureInfo structureInfo = (OrgStructureInfo)node.getUserObject();
        FullOrgUnitInfo orgInfo = structureInfo.getUnit();
        String orgUnitId = orgInfo.getId().toString();
        BgOrgUnitInfo bgOrgUnitInfo = new BgOrgUnitInfo();
        String newLongNumber = parentInfo.getLongNumber() + "!" + orgInfo.getNumber();
        bgOrgUnitInfo.setId(BOSUuid.create((BOSObjectType)bgOrgUnitInfo.getBOSType()));
        bgOrgUnitInfo.setViewID(bgOrgViewId);
        bgOrgUnitInfo.setOrgUnitID(orgUnitId);
        bgOrgUnitInfo.setNumber(orgInfo.getNumber());
        bgOrgUnitInfo.setName(orgInfo.getName());
        bgOrgUnitInfo.setIsLeaf(true);
        bgOrgUnitInfo.setLongNumber(newLongNumber);
        bgOrgUnitInfo.setParent(parentInfo);
        bgOrgUnitInfo.setLevel(parentInfo.getLevel() + 1);
        bgOrgUnitInfo.setIsOUSealUp(orgInfo.isIsOUSealUp());
        if (parentInfo.isIsLeaf()) {
            parentInfo.setIsLeaf(false);
            helper.addOpt(parentInfo);
        }
        return bgOrgUnitInfo;
    }

    public static BgOrgUnitInfo createNewBgOrg(DefaultKingdeeTreeNode node, String bgOrgViewId) {
        if (node == null) {
            return null;
        }
        OrgStructureInfo structureInfo = (OrgStructureInfo)node.getUserObject();
        FullOrgUnitInfo fullOrgUnitInfo = structureInfo.getUnit();
        String orgUnitId = fullOrgUnitInfo.getId().toString();
        boolean isRootID = orgUnitId.equalsIgnoreCase("00000000-0000-0000-0000-000000000000CCE7AED4");
        BgOrgUnitInfo bgOrgUnitInfo = new BgOrgUnitInfo();
        bgOrgUnitInfo.setId(BOSUuid.create((BOSObjectType)bgOrgUnitInfo.getBOSType()));
        bgOrgUnitInfo.setViewID(bgOrgViewId);
        bgOrgUnitInfo.setOrgUnitID(orgUnitId);
        bgOrgUnitInfo.setNumber(fullOrgUnitInfo.getNumber());
        bgOrgUnitInfo.setName(fullOrgUnitInfo.getName());
        bgOrgUnitInfo.setLongNumber(fullOrgUnitInfo.getLongNumber());
        bgOrgUnitInfo.setLevel(structureInfo.getLevel());
        bgOrgUnitInfo.setIsLeaf(!isRootID);
        bgOrgUnitInfo.setIsOUSealUp(fullOrgUnitInfo.isIsOUSealUp());
        bgOrgUnitInfo.setSimpleName(fullOrgUnitInfo.getSimpleName());
        bgOrgUnitInfo.setCode(fullOrgUnitInfo.getCode());
        bgOrgUnitInfo.setDescription(fullOrgUnitInfo.getDescription());
        return bgOrgUnitInfo;
    }

    public static Set<DefaultKingdeeTreeNode> getSelectedCSTreeNodes(Component component, KDTree tree, String bgOrgViewId) {
        boolean isNull;
        LinkedHashSet<DefaultKingdeeTreeNode> setNode = new LinkedHashSet<DefaultKingdeeTreeNode>();
        boolean bl = isNull = tree == null || tree.getModel() == null;
        if (isNull || tree.getModel().getRoot() == null) {
            return setNode;
        }
        DefaultKingdeeTreeNode node = null;
        Enumeration enumeration = ((DefaultKingdeeTreeNode)tree.getModel().getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)enumeration.nextElement();
            if (node == null || !node.isChecked() || node.getUserObject() == null) continue;
            setNode.add(node);
        }
        if (setNode.isEmpty()) {
            String msg = BgOrgUnitHelper.getBgOrgMsg("selectOrg");
            BgOrgUnitHelper.showWarningAndAbort(component, msg);
        }
        return setNode;
    }

    public static DefaultKingdeeTreeNode[] getSelectedTreeNodes(Component component, KDTree tree) {
        if (tree == null) {
            return new DefaultKingdeeTreeNode[0];
        }
        TreePath[] treePaths = tree.getSelectionPaths();
        if (treePaths == null) {
            String msg = BgOrgUnitHelper.getBgOrgMsg("selectOrgFromView");
            BgOrgUnitHelper.showWarningAndAbort(component, msg);
        }
        int length = treePaths.length;
        DefaultKingdeeTreeNode[] treeNodes = new DefaultKingdeeTreeNode[length];
        for (int i = 0; i < length; ++i) {
            treeNodes[i] = (DefaultKingdeeTreeNode)treePaths[i].getLastPathComponent();
        }
        return treeNodes;
    }

    public static Set<BgOrgUnitInfo> getAllLeafNodeUserObject(KDTree bgOrgTree) {
        boolean isNull;
        HashSet<BgOrgUnitInfo> setNode = new HashSet<BgOrgUnitInfo>();
        boolean bl = isNull = bgOrgTree == null || bgOrgTree.getModel() == null || bgOrgTree.getModel().getRoot() == null;
        if (isNull) {
            return setNode;
        }
        DefaultKingdeeTreeNode node = null;
        DefaultKingdeeTreeNode rootNode = null;
        BgOrgUnitInfo bgOrgUnitInfo = null;
        rootNode = (DefaultKingdeeTreeNode)bgOrgTree.getModel().getRoot();
        if (rootNode.getChildCount() == 0) {
            return setNode;
        }
        Enumeration enumeration = rootNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)enumeration.nextElement();
            bgOrgUnitInfo = (BgOrgUnitInfo)node.getUserObject();
            if (node == null || bgOrgUnitInfo == null || bgOrgUnitInfo.getOrgUnitID() == null) continue;
            setNode.add((BgOrgUnitInfo)node.getUserObject());
        }
        return setNode;
    }

    public static Set<BgOrgUnitInfo> getAllChildLeafNodeUserObject(DefaultKingdeeTreeNode node) {
        HashSet<BgOrgUnitInfo> setNode = new HashSet<BgOrgUnitInfo>();
        Enumeration enumeration = node.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)enumeration.nextElement();
            if (node == null || !node.isLeaf()) continue;
            setNode.add((BgOrgUnitInfo)node.getUserObject());
        }
        return setNode;
    }

    public static TreeModel getOrgUnitTreeModel(KDTree orgUnitTree, String orgId, boolean isContainSealUp) throws Exception {
        orgUnitTree.setShowCheckBox(true);
        TreeModel treeModel = BgOrgTreeHelper.getFullTreeModel(orgId, isContainSealUp);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        root.setCheckBoxVisible(true);
        orgUnitTree.setModel(treeModel);
        if (orgUnitTree.getModel() != null) {
            orgUnitTree.expandAllNodes(true, (TreeNode)orgUnitTree.getModel().getRoot());
        }
        return treeModel;
    }

    public static TreeModel getFullTreeModel(String orgUnitId, boolean isContainSealUp) throws Exception {
        if (StringUtils.isEmpty((String)orgUnitId)) {
            return null;
        }
        TreeModel _model = null;
        Class<?> _class = null;
        Method _method = null;
        OrgViewType _viewType = OrgViewType.COSTCENTER;
        _class = Class.forName("com.kingdee.eas.basedata.org.NewOrgUtils");
        Class[] classes = new Class[]{OrgViewType.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, Boolean.TYPE, HashMap.class, Integer.TYPE, Boolean.TYPE, IMetaDataPK.class, IMetaDataPK.class};
        _method = _class.getMethod("getTreeModel", classes);
        Object[] objs = new Object[]{_viewType, null, false, false, isContainSealUp, orgUnitId, false, null, new Integer(0), true, null, null};
        _model = (TreeModel)_method.invoke(_class, objs);
        BgOrgTreeHelper.processOrgTreeModel(_model);
        return _model;
    }

    public static boolean isLeaf(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode tmpNode = node;
        if (tmpNode.getChildCount() > 0) {
            return false;
        }
        BgOrgUnitInfo info = (BgOrgUnitInfo)tmpNode.getUserObject();
        return info == null || info.isIsLeaf();
    }

    public static DefaultKingdeeTreeNode getBgOrgTreeSelectNode(Component component, KDTree kDBgOrgUnitTree) {
        TreePath[] bgOrgUnittreePaths = kDBgOrgUnitTree.getSelectionPaths();
        String msg = null;
        if (bgOrgUnittreePaths == null) {
            msg = BgOrgUnitHelper.getBgOrgMsg("selectOrgFromView");
            BgOrgUnitHelper.showWarningAndAbort(component, msg);
        } else if (bgOrgUnittreePaths.length >= 2) {
            msg = BgOrgUnitHelper.getBgOrgMsg("selectSingleBgOrgUnit");
            BgOrgUnitHelper.showWarningAndAbort(component, msg);
        }
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)bgOrgUnittreePaths[0].getLastPathComponent();
        return selectedNode;
    }

    public static void removeNodes(KDTree tree, DefaultKingdeeTreeNode[] treeNodes, BgOrgDataHelper helper) throws EASBizException, BOSException {
        if (tree == null || EmptyUtil.isEmpty((Object[])treeNodes)) {
            return;
        }
        HashSet<String> hasData = new HashSet<String>();
        HashSet<String> hasRelation = new HashSet<String>();
        HashSet<String> hasTemplate = new HashSet<String>();
        BgOrgUnitInfo parentInfo = null;
        boolean canRemove = true;
        DefaultKingdeeTreeNode foundNode = null;
        DefaultKingdeeTreeNode parent = null;
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        Map<String, Set<String>> tempMap = BgOrgTreeHelper.checkHasRelationOrTemplate(treeNodes);
        Set<String> checkHasRelation = tempMap.get("hasRelation");
        Set<String> chckHasTemplate = tempMap.get("hasTemplate");
        int length = treeNodes.length;
        for (int i = 0; i < length; ++i) {
            canRemove = true;
            foundNode = treeNodes[i];
            if (foundNode == null) continue;
            BgOrgUnitInfo self = (BgOrgUnitInfo)foundNode.getUserObject();
            if (helper.getRefBgDataOrgMap().containsKey(self.getId().toString())) {
                hasData.add(self.getName().toString());
                canRemove = false;
                continue;
            }
            canRemove = BgOrgTreeHelper.checkLeafHasData(foundNode, helper, hasData);
            if (!canRemove) continue;
            if (checkHasRelation.contains(self.getId().toString())) {
                hasRelation.add(self.getName().toString());
                canRemove = false;
                continue;
            }
            if (chckHasTemplate.contains(self.getId().toString())) {
                hasTemplate.add(self.getName().toString());
                canRemove = false;
                continue;
            }
            if (!canRemove) continue;
            DefaultKingdeeTreeNode defaultKingdeeTreeNode = parent = foundNode.getParent() == null ? null : (DefaultKingdeeTreeNode)foundNode.getParent();
            if (foundNode == root) {
                BgOrgTreeHelper.deleteRootNode(root, helper);
                break;
            }
            if (self.isIsVirtual()) {
                Set<DefaultKingdeeTreeNode> virtualNodes = BgOrgTreeHelper.checkHasVirtualSiblings(tree, foundNode);
                if (virtualNodes.size() > 1) {
                    int re = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgOrgUnitReource", (String)"deleteSiblingsAndDescsForS"));
                    if (re == 0) {
                        Iterator<DefaultKingdeeTreeNode> it = virtualNodes.iterator();
                        while (it.hasNext()) {
                            BgOrgTreeHelper.removeNode(tree, it.next(), helper);
                        }
                    }
                } else {
                    BgOrgTreeHelper.removeNode(tree, foundNode, helper);
                }
            } else {
                BgOrgTreeHelper.removeNode(tree, foundNode, helper);
            }
            if (parent == null || parent.getChildCount() != 0) continue;
            parentInfo = (BgOrgUnitInfo)parent.getUserObject();
            if (!parentInfo.isIsLeaf()) {
                parentInfo.setIsLeaf(true);
                helper.addOpt(parentInfo);
            }
            BgOrgTreeHelper.updateVirtualParentByBasePar(helper, parentInfo, tree);
        }
        if (root == null) {
            ((DefaultTreeModel)tree.getModel()).setRoot(null);
        }
        StringBuffer message = new StringBuffer();
        BgOrgTreeHelper.buildMessage(message, "NodeHasData", hasData);
        BgOrgTreeHelper.buildMessage(message, "NodeHasRelation", hasRelation);
        BgOrgTreeHelper.buildMessage(message, "NodeHasTemplate", hasTemplate);
        if (message.length() > 0) {
            MsgBox.showWarning((String)message.toString());
        }
    }

    private static void buildMessage(StringBuffer message, String msgKey, Set<String> checkSet) {
        if (checkSet == null || checkSet.isEmpty()) {
            return;
        }
        StringBuffer names = new StringBuffer();
        for (String name : checkSet) {
            if (names.length() > 0) {
                names.append("\u3001\r");
            }
            names.append(name);
        }
        if (message.length() > 0) {
            message.append("\r\n");
        }
        message.append(MessageFormat.format(BgOrgUnitHelper.getBgOrgMsg(msgKey), names));
    }

    private static Map<String, Set<String>> checkHasRelationOrTemplate(DefaultKingdeeTreeNode[] treeNodes) throws EASBizException, BOSException {
        HashSet<String> bgOrgUnitIds = new HashSet<String>();
        int length = treeNodes.length;
        for (int i = 0; i < length; ++i) {
            BgOrgUnitInfo self = (BgOrgUnitInfo)treeNodes[i].getUserObject();
            if (self == null || self.getId() == null) continue;
            bgOrgUnitIds.add(self.getId().toString());
        }
        return BgOrgUnitFactory.getRemoteInstance().checkHasRelationOrTemplate(bgOrgUnitIds);
    }

    private static void updateVirtualParentByBasePar(BgOrgDataHelper helper, BgOrgUnitInfo parentInfo, KDTree tree) {
        String basePaeOrgId = parentInfo.getOrgUnitID();
        DefaultKingdeeTreeNode nodeTarget = null;
        BgOrgUnitInfo curOrgUnitInfo = null;
        Enumeration enumTarget = ((DefaultKingdeeTreeNode)tree.getModel().getRoot()).breadthFirstEnumeration();
        while (enumTarget.hasMoreElements()) {
            nodeTarget = (DefaultKingdeeTreeNode)enumTarget.nextElement();
            curOrgUnitInfo = (BgOrgUnitInfo)nodeTarget.getUserObject();
            if (curOrgUnitInfo.getOrgUnitID() == null || !basePaeOrgId.equals(curOrgUnitInfo.getOrgUnitID()) || !curOrgUnitInfo.isIsVirtual()) continue;
            curOrgUnitInfo.setIsLeaf(true);
            helper.addOpt(curOrgUnitInfo);
        }
    }

    private static Set<DefaultKingdeeTreeNode> checkHasVirtualSiblings(KDTree tree, DefaultKingdeeTreeNode foundNode) {
        Object root = tree == null || tree.getModel() == null ? null : tree.getModel().getRoot();
        DefaultKingdeeTreeNode nodeTarget = null;
        BgOrgUnitInfo orgUnitInfo = (BgOrgUnitInfo)foundNode.getUserObject();
        BgOrgUnitInfo curOrgUnitInfo = null;
        BgOrgUnitInfo parentUnitInfo = null;
        HashSet<DefaultKingdeeTreeNode> deleteNodeSet = new HashSet<DefaultKingdeeTreeNode>();
        int deleteNodeLevel = orgUnitInfo.getLevel();
        int curNodeLevel = -1;
        boolean isSelf = false;
        boolean isParVirtual = false;
        if (root != null) {
            Enumeration enumTarget = null;
            nodeTarget = (DefaultKingdeeTreeNode)foundNode.getParent();
            if (nodeTarget != null) {
                parentUnitInfo = (BgOrgUnitInfo)nodeTarget.getUserObject();
                isParVirtual = parentUnitInfo.isIsVirtual();
                if (!isParVirtual) {
                    return deleteNodeSet;
                }
                enumTarget = ((BgOrgUnitInfo)nodeTarget.getUserObject()).getOrgUnitID() != null ? ((DefaultKingdeeTreeNode)foundNode.getParent()).breadthFirstEnumeration() : foundNode.breadthFirstEnumeration();
                while (enumTarget.hasMoreElements()) {
                    nodeTarget = (DefaultKingdeeTreeNode)enumTarget.nextElement();
                    curOrgUnitInfo = (BgOrgUnitInfo)nodeTarget.getUserObject();
                    curNodeLevel = curOrgUnitInfo.getLevel();
                    if (curOrgUnitInfo.getOrgUnitID() == null || deleteNodeLevel != curNodeLevel || !curOrgUnitInfo.isIsVirtual()) continue;
                    deleteNodeSet.add(nodeTarget);
                }
            }
        }
        return deleteNodeSet;
    }

    private static void deleteRootNode(DefaultKingdeeTreeNode root, BgOrgDataHelper helper) {
        root = null;
        helper.getNewBgOrgMap().clear();
        helper.getUpdateBgOrgMap().clear();
        helper.getCurOrgUnitMap().clear();
        helper.getDelBgOrgMap().clear();
        helper.getDelBgOrgMap().putAll(helper.getInitalBgOrgMap());
    }

    private static boolean checkLeafHasData(DefaultKingdeeTreeNode foundNode, BgOrgDataHelper helper, Set<String> cantRemove) {
        Set<Object> leafSet = new HashSet();
        boolean canRemove = true;
        leafSet = BgOrgTreeHelper.getAllChildLeafNodeUserObject(foundNode);
        BgOrgUnitInfo self = (BgOrgUnitInfo)foundNode.getUserObject();
        if (leafSet.size() > 0) {
            for (BgOrgUnitInfo bgOrgUnitInfo : leafSet) {
                if (!helper.getRefBgDataOrgMap().containsKey(bgOrgUnitInfo.getId().toString())) continue;
                cantRemove.add(self.getName().toString());
                canRemove = false;
                break;
            }
        }
        return canRemove;
    }

    public static void removeNode(KDTree tree, DefaultKingdeeTreeNode treeNode, BgOrgDataHelper helper) {
        if (tree == null || treeNode == null) {
            return;
        }
        DefaultKingdeeTreeNode childNode = null;
        int childCount = treeNode.getChildCount();
        DefaultKingdeeTreeNode[] childNodes = new DefaultKingdeeTreeNode[childCount];
        for (int i = 0; i < childCount; ++i) {
            childNodes[i] = childNode = (DefaultKingdeeTreeNode)treeNode.getChildAt(i);
        }
        for (DefaultKingdeeTreeNode node : childNodes) {
            if (node == null) continue;
            if (node.getChildCount() == 0) {
                BgOrgTreeHelper.removeNodeFromParent(tree, node, helper, treeNode);
                continue;
            }
            BgOrgTreeHelper.removeNode(tree, node, helper);
        }
        BgOrgTreeHelper.removeNodeFromParent(tree, treeNode, helper, treeNode);
    }

    private static void removeNodeFromParent(KDTree tree, DefaultKingdeeTreeNode treeNode, BgOrgDataHelper helper, DefaultKingdeeTreeNode selectedNode) {
        if (treeNode == null || treeNode.getParent() == null) {
            return;
        }
        ((DefaultTreeModel)tree.getModel()).removeNodeFromParent((MutableTreeNode)treeNode);
        BgOrgTreeHelper.deleteAllVirtualNodeByTreeNode(tree, treeNode, helper, selectedNode);
        helper.removeOpt((BgOrgUnitInfo)treeNode.getUserObject());
    }

    private static void deleteAllVirtualNodeByTreeNode(KDTree tree, DefaultKingdeeTreeNode treeNode, BgOrgDataHelper helper, DefaultKingdeeTreeNode selectedNode) {
        Object root = tree == null || tree.getModel() == null ? null : tree.getModel().getRoot();
        DefaultKingdeeTreeNode nodeTarget = null;
        DefaultKingdeeTreeNode iteratorNode = null;
        BgOrgUnitInfo orgUnitInfo = (BgOrgUnitInfo)treeNode.getUserObject();
        BgOrgUnitInfo curOrgUnitInfo = null;
        if (root != null) {
            iteratorNode = orgUnitInfo.isIsVirtual() ? selectedNode : (DefaultKingdeeTreeNode)root;
            Enumeration enumTarget = iteratorNode.breadthFirstEnumeration();
            while (enumTarget.hasMoreElements()) {
                nodeTarget = (DefaultKingdeeTreeNode)enumTarget.nextElement();
                curOrgUnitInfo = (BgOrgUnitInfo)nodeTarget.getUserObject();
                if (curOrgUnitInfo.getOrgUnitID() == null || !curOrgUnitInfo.getOrgUnitID().equals(orgUnitInfo.getOrgUnitID()) || !curOrgUnitInfo.isIsVirtual()) continue;
                helper.removeOpt((BgOrgUnitInfo)nodeTarget.getUserObject());
                BgOrgTreeHelper.removeNode(tree, nodeTarget, helper);
            }
        }
    }

    public static boolean isRootNodeFromBgOrgTree(DefaultKingdeeTreeNode treeNode) {
        if (treeNode == null || treeNode.getParent() != null) {
            return false;
        }
        BgOrgUnitInfo info = (BgOrgUnitInfo)treeNode.getUserObject();
        return info != null && info.getOrgUnitID().equals("00000000-0000-0000-0000-000000000000CCE7AED4");
    }

    public static Set<String> getAllSubNodeUserObject(DefaultKingdeeTreeNode node) {
        HashSet<String> orgUnitIds = new HashSet<String>();
        Enumeration enumeration = node.breadthFirstEnumeration();
        OrgStructureInfo structureInfo = null;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        BgOrgUnitInfo bgOrgUnitInfo = null;
        String orgUnitId = null;
        while (enumeration.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)enumeration.nextElement();
            if (node.getUserObject() instanceof BgOrgUnitInfo) {
                bgOrgUnitInfo = (BgOrgUnitInfo)node.getUserObject();
                orgUnitId = bgOrgUnitInfo.getOrgUnitID();
            } else if (node.getUserObject() instanceof OrgStructureInfo) {
                structureInfo = (OrgStructureInfo)node.getUserObject();
                fullOrgUnitInfo = structureInfo.getUnit();
                orgUnitId = fullOrgUnitInfo.getId().toString();
            }
            if (node == null) continue;
            orgUnitIds.add(orgUnitId);
        }
        return orgUnitIds;
    }

    public static void selectOrgUnitByIds(DefaultKingdeeTreeNode root, Set<String> selOrgIds) {
        if (root == null || selOrgIds == null) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        BgOrgUnitInfo tmpUnit = null;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        String orgUnitId = null;
        Enumeration elements = root.breadthFirstEnumeration();
        while (elements.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)elements.nextElement();
            if (node.getUserObject() instanceof OrgStructureInfo) {
                oui = (OrgStructureInfo)node.getUserObject();
                fullOrgUnitInfo = oui.getUnit();
                String string = orgUnitId = fullOrgUnitInfo == null ? null : fullOrgUnitInfo.getId().toString();
                if (!BgOrgTreeHelper.canTheNodeBeSelected(node)) continue;
                node.setChecked(orgUnitId != null && selOrgIds.contains(orgUnitId));
                continue;
            }
            if (!(node.getUserObject() instanceof BgOrgUnitInfo)) continue;
            tmpUnit = (BgOrgUnitInfo)node.getUserObject();
            if (!BgOrgTreeHelper.canTheNodeBeSelected(node)) continue;
            node.setChecked(selOrgIds.contains(tmpUnit.getOrgUnitID()));
        }
    }

    public static void afterMoveOrBuildKDTreeNode(KDTree tree, BgOrgDataHelper helper) {
        Object root;
        Object object = root = tree == null || tree.getModel() == null ? null : tree.getModel().getRoot();
        if (root == null) {
            return;
        }
        DefaultKingdeeTreeNode nodeTarget = null;
        OrgStructureInfo structureInfo = null;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        String orgUnitId = null;
        if (root != null && root instanceof DefaultKingdeeTreeNode) {
            Enumeration enumTarget = ((DefaultKingdeeTreeNode)root).breadthFirstEnumeration();
            while (enumTarget.hasMoreElements()) {
                nodeTarget = (DefaultKingdeeTreeNode)enumTarget.nextElement();
                structureInfo = (OrgStructureInfo)nodeTarget.getUserObject();
                if (structureInfo == null) continue;
                fullOrgUnitInfo = structureInfo.getUnit();
                orgUnitId = fullOrgUnitInfo.getId().toString();
                nodeTarget.setChecked(false);
                if (helper.getCurOrgUnitMap().containsKey(orgUnitId)) {
                    if (!nodeTarget.isCheckBoxEnabled()) continue;
                    nodeTarget.setCheckBoxEnabled(false);
                    nodeTarget.setTextColor(Color.gray);
                    continue;
                }
                if (nodeTarget.isCheckBoxEnabled()) continue;
                nodeTarget.setCheckBoxEnabled(true);
                nodeTarget.setTextColor(Color.black);
            }
        }
        tree.repaint();
    }

    public static void expandAllNodes(KDTree tree, DefaultKingdeeTreeNode srcNode) {
        if (srcNode == null) {
            return;
        }
        tree.expandAllNodes(true, (TreeNode)srcNode);
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)srcNode.getParent();
        if (parentNode != null) {
            BgOrgTreeHelper.expandAllNodes(tree, parentNode);
        }
    }

    public static DefaultKingdeeTreeNode findRootNodeForAdd(KDTree tree, BgOrgUnitInfo bgOrgUnitInfo) {
        Object root;
        Object object = root = tree == null || tree.getModel() == null ? null : tree.getModel().getRoot();
        if (root == null || bgOrgUnitInfo == null) {
            return null;
        }
        DefaultKingdeeTreeNode nodeTarget = null;
        OrgStructureInfo structureInfo = null;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        String orgUnitId = null;
        String bgOrgUnitID = bgOrgUnitInfo.getOrgUnitID();
        if (root != null && root instanceof DefaultKingdeeTreeNode) {
            Enumeration enumTarget = ((DefaultKingdeeTreeNode)root).breadthFirstEnumeration();
            while (enumTarget.hasMoreElements()) {
                nodeTarget = (DefaultKingdeeTreeNode)enumTarget.nextElement();
                structureInfo = (OrgStructureInfo)nodeTarget.getUserObject();
                fullOrgUnitInfo = structureInfo.getUnit();
                orgUnitId = fullOrgUnitInfo.getId().toString();
                if (!orgUnitId.equals(bgOrgUnitID)) continue;
                return nodeTarget;
            }
        }
        return null;
    }

    public static DefaultKingdeeTreeNode findSubCostCenterBy(KDTree tree, BgOrgUnitInfo bgOrgUnitInfo) {
        Object root;
        Object object = root = tree == null || tree.getModel() == null ? null : tree.getModel().getRoot();
        if (root == null || bgOrgUnitInfo == null) {
            return null;
        }
        DefaultKingdeeTreeNode nodeTarget = null;
        OrgStructureInfo structureInfo = null;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        String orgUnitId = null;
        String bgOrgUnitID = bgOrgUnitInfo.getOrgUnitID();
        if (root != null && root instanceof DefaultKingdeeTreeNode) {
            Enumeration enumTarget = ((DefaultKingdeeTreeNode)root).breadthFirstEnumeration();
            while (enumTarget.hasMoreElements()) {
                nodeTarget = (DefaultKingdeeTreeNode)enumTarget.nextElement();
                structureInfo = (OrgStructureInfo)nodeTarget.getUserObject();
                fullOrgUnitInfo = structureInfo.getUnit();
                orgUnitId = fullOrgUnitInfo.getId().toString();
                if (!orgUnitId.equals(bgOrgUnitID)) continue;
                return nodeTarget;
            }
        }
        return null;
    }

    public static List<DefaultKingdeeTreeNode> findForAllExtendNode(DefaultKingdeeTreeNode root, List<String> nodeOrgIDList) {
        ArrayList<DefaultKingdeeTreeNode> returnList = new ArrayList<DefaultKingdeeTreeNode>();
        if (root == null || EmptyUtil.isEmpty(nodeOrgIDList)) {
            return returnList;
        }
        List<DefaultKingdeeTreeNode> findNodeList = BgOrgTreeHelper.findNode(root, nodeOrgIDList);
        if (EmptyUtil.isEmpty(nodeOrgIDList)) {
            return returnList;
        }
        HashMap<String, DefaultKingdeeTreeNode> map = new HashMap<String, DefaultKingdeeTreeNode>();
        for (DefaultKingdeeTreeNode node : findNodeList) {
            BgOrgTreeHelper.findIncludeAllParentNode(node, map);
        }
        for (DefaultKingdeeTreeNode node : map.values()) {
            returnList.add(node);
        }
        return returnList;
    }

    public static void findIncludeAllParentNode(DefaultKingdeeTreeNode node, Map<String, DefaultKingdeeTreeNode> map) {
        DefaultKingdeeTreeNode parentNode;
        if (node == null || map == null) {
            return;
        }
        String unitID = null;
        unitID = BgOrgTreeHelper.getBgOrgIDFromTreeNode(node);
        if (!map.containsKey(unitID)) {
            map.put(unitID, node);
        }
        if ((parentNode = (DefaultKingdeeTreeNode)node.getParent()) != null) {
            BgOrgTreeHelper.findIncludeAllParentNode(parentNode, map);
        }
    }

    public static List<DefaultKingdeeTreeNode> findNode(DefaultKingdeeTreeNode node, List<String> nodeOrgIDList) {
        ArrayList<DefaultKingdeeTreeNode> returnList = new ArrayList<DefaultKingdeeTreeNode>();
        if (node == null || EmptyUtil.isEmpty(nodeOrgIDList)) {
            return returnList;
        }
        DefaultKingdeeTreeNode nodeTarget = null;
        String unitID = null;
        Enumeration enumTarget = node.breadthFirstEnumeration();
        while (enumTarget.hasMoreElements()) {
            nodeTarget = (DefaultKingdeeTreeNode)enumTarget.nextElement();
            unitID = BgOrgTreeHelper.getBgOrgIDFromTreeNode(nodeTarget);
            if (StringUtils.isEmpty((String)unitID) || !nodeOrgIDList.contains(unitID)) continue;
            returnList.add(nodeTarget);
        }
        return returnList;
    }

    public static String getBgOrgIDFromTreeNode(DefaultKingdeeTreeNode node) {
        BgOrgUnitInfo unitInfo = (BgOrgUnitInfo)node.getUserObject();
        return unitInfo == null ? null : unitInfo.getOrgUnitID();
    }

    public static String getOrgIDFromTreeNode(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return null;
        }
        OrgStructureInfo structureInfo = (OrgStructureInfo)node.getUserObject();
        return structureInfo.getUnit().getId().toString();
    }

    public static FilterInfo getBgOrgViewFilter(String orgUnitId) {
        FilterInfo filter = new FilterInfo();
        if (orgUnitId != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)("Select FViewID FROM T_MBG_BgOrgUnit Where FOrgUnitID = '" + orgUnitId + "'"), CompareType.INNER));
            filter.setMaskString("#0 OR #1");
        }
        return filter;
    }

    public static void processOrgTreeModel(TreeModel model) throws Exception {
        DefaultKingdeeTreeNode curNode = (DefaultKingdeeTreeNode)model.getRoot();
        HashSet<String> orgStructureID = new HashSet<String>();
        BgOrgTreeHelper.parseTree(orgStructureID, curNode);
        HashMap<String, FullOrgUnitInfo> orgUnitProp = new HashMap<String, FullOrgUnitInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", orgStructureID, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgOrgTreeHelper.getBgOrgPropSelector());
        CoreBaseCollection col = FullOrgUnitFactory.getRemoteInstance().getCollection(view);
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)col.get(i);
            orgUnitProp.put(orgUnit.getId().toString(), orgUnit);
        }
        BgOrgTreeHelper.fillOrgStructureProp(orgUnitProp, curNode);
    }

    private static void parseTree(Set<String> orgStructureID, DefaultKingdeeTreeNode curNode) {
        if (curNode.getUserObject() == null) {
            return;
        }
        orgStructureID.add(((OrgStructureInfo)curNode.getUserObject()).getUnit().getId().toString());
        int n = curNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            BgOrgTreeHelper.parseTree(orgStructureID, (DefaultKingdeeTreeNode)curNode.getChildAt(i));
        }
    }

    private static void fillOrgStructureProp(Map<String, FullOrgUnitInfo> orgUnitProp, DefaultKingdeeTreeNode curNode) throws Exception {
        if (curNode.getUserObject() == null) {
            return;
        }
        OrgStructureInfo orgStructure = (OrgStructureInfo)curNode.getUserObject();
        String orgUnitID = orgStructure.getUnit().getId().toString();
        FullOrgUnitInfo orgUnit = orgUnitProp.get(orgUnitID);
        FullOrgUnitInfo parentOrgUnit = null;
        if (orgUnit != null) {
            orgStructure.getUnit().setSimpleName(orgUnit.getSimpleName());
            orgStructure.getUnit().setCode(orgUnit.getCode());
            orgStructure.getUnit().setDescription(orgUnit.getDescription());
            parentOrgUnit = new FullOrgUnitInfo();
            if (orgUnit.getParent() != null) {
                parentOrgUnit.setId(orgUnit.getParent().getId());
                parentOrgUnit.setNumber(orgUnit.getParent().getNumber());
                parentOrgUnit.setLongNumber(orgUnit.getParent().getLongNumber());
                orgStructure.getUnit().setParent(parentOrgUnit);
            }
        }
        int n = curNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            BgOrgTreeHelper.fillOrgStructureProp(orgUnitProp, (DefaultKingdeeTreeNode)curNode.getChildAt(i));
        }
    }

    private static SelectorItemCollection getBgOrgPropSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("code");
        sic.add("simpleName");
        sic.add("description");
        sic.add("parent.id");
        sic.add("parent.number");
        sic.add("parent.longnumber");
        return sic;
    }

    public static boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    public static void resetAction(KDTreeView treeView, ActionListener beforeAction) {
        if (treeView == null || treeView.getTree() == null) {
            return;
        }
        KDWorkButton btn = null;
        for (int i = 0; i < treeView.getControlPane().getComponentCount(); ++i) {
            if (!(treeView.getControlPane().getComponent(i) instanceof KDWorkButton)) continue;
            btn = (KDWorkButton)treeView.getControlPane().getComponent(i);
            if (EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"752_BgOrgTreeHelper").equals(btn.getActionCommand()) || "actopenall".equals(btn.getActionCommand())) break;
            btn = null;
        }
        if (btn != null) {
            btn.removeActionListener((ActionListener)treeView);
            btn.addActionListener(beforeAction);
        }
    }

    public static void setOrgTreeVisibleAndEnable(DefaultKingdeeTreeNode root, boolean visible, boolean enabled, String curOrgId, Set<String> userSet) {
        if (root == null) {
            return;
        }
        BgOrgUnitInfo info = (BgOrgUnitInfo)root.getUserObject();
        root.setCheckBoxEnabled(enabled);
        root.setCheckBoxVisible(visible);
        if (curOrgId.equals(info.getOrgUnitID())) {
            root.setCheckBoxEnabled(!enabled);
            root.setCheckBoxVisible(!visible);
        }
        if (info.isIsVirtual()) {
            root.setCheckBoxEnabled(!enabled);
            root.setCheckBoxVisible(!visible);
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            info = (BgOrgUnitInfo)node.getUserObject();
            node.setCheckBoxVisible(visible);
            node.setCheckBoxEnabled(enabled);
            if (curOrgId.equals(info.getOrgUnitID())) {
                node.setCheckBoxEnabled(!enabled);
                node.setCheckBoxVisible(!visible);
            }
            if (info.isIsVirtual()) {
                node.setCheckBoxEnabled(!enabled);
                node.setCheckBoxVisible(!visible);
            }
            if (node.isLeaf()) continue;
            BgOrgTreeHelper.setOrgTreeVisibleAndEnable(node, visible, enabled, curOrgId, userSet);
        }
    }

    public static TreeModel buildMultiTreeModel(KDTree kdtree, String bgOrgViewId, String orgUnitId, boolean isPermsionFilter, boolean isSealUp, boolean isShowVirtualOrg) throws Exception {
        return BgOrgTreeHelper.buildMultiTreeModel(kdtree, bgOrgViewId, orgUnitId, isPermsionFilter, isSealUp, isShowVirtualOrg, false);
    }

    public static TreeModel buildMultiTreeModel(KDTree kdtree, final String bgOrgViewId, String orgUnitId, final boolean isPermsionFilter, final boolean isSealUp, final boolean isShowVirtualOrg, final boolean isOnlyNoLeaf) throws Exception {
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            throw new BOSException("BgOrgViewId is null!!!");
        }
        kdtree.setRootVisible(false);
        boolean checkHasOrg = BgOrgViewFactory.getRemoteInstance().checkHasOrg(BOSUuid.read((String)bgOrgViewId));
        if (!checkHasOrg) {
            throw new BOSException("BgOrgViewId has not OrgUnit !!!");
        }
        TreeModel model = BgOrgTreeHelper.buildMultiTreeModelByOrg(null, orgUnitId, bgOrgViewId, isPermsionFilter, isSealUp, isShowVirtualOrg, isOnlyNoLeaf);
        if (model != null) {
            kdtree.addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                    DefaultKingdeeTreeNode curSelectednode = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
                    if (curSelectednode == null || curSelectednode.getChildCount() > 0) {
                        return;
                    }
                    try {
                        CoreBaseInfo orgInfo = (CoreBaseInfo)curSelectednode.getUserObject();
                        if (orgInfo == null || orgInfo.getBoolean("isChildLoaded")) {
                            return;
                        }
                        BgOrgTreeHelper.addChildNode(curSelectednode, bgOrgViewId, isSealUp, isPermsionFilter, isShowVirtualOrg, isOnlyNoLeaf);
                        orgInfo.setBoolean("isChildLoaded", true);
                    }
                    catch (Exception ex) {
                        ExceptionHandler.handle((String)"", (Throwable)ex);
                    }
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                }
            });
        }
        return model;
    }

    public static TreeModel buildMultiTreeModelNoListener(KDTree kdtree, String bgOrgViewId, String orgUnitId, boolean isPermsionFilter, boolean isSealUp, boolean isShowVirtualOrg, boolean isOnlyNoLeaf) throws Exception {
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            throw new BOSException("BgOrgViewId is null!!!");
        }
        kdtree.setRootVisible(false);
        boolean checkHasOrg = BgOrgViewFactory.getRemoteInstance().checkHasOrg(BOSUuid.read((String)bgOrgViewId));
        if (!checkHasOrg) {
            // empty if block
        }
        TreeModel model = BgOrgTreeHelper.buildMultiTreeModelByOrg(null, orgUnitId, bgOrgViewId, isPermsionFilter, isSealUp, isShowVirtualOrg, isOnlyNoLeaf);
        return model;
    }

    public static void addChildNode(DefaultKingdeeTreeNode root, String bgOrgViewId, boolean isSealUp, boolean isPermsionFilter, boolean isShowVirtualOrg) throws EASBizException, BOSException {
        BgOrgTreeHelper.addChildNode(root, bgOrgViewId, isSealUp, isPermsionFilter, isShowVirtualOrg, false);
    }

    public static void addChildNode(DefaultKingdeeTreeNode root, String bgOrgViewId, boolean isSealUp, boolean isPermsionFilter, boolean isShowVirtualOrg, boolean isOnlyNoLeaf) throws EASBizException, BOSException {
        int i;
        if (root == null) {
            return;
        }
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            throw new BOSException("BgOrgUnitUtils.addChildNode error : BgOrgViewId is Null !!!!!");
        }
        BgOrgUnitCollection orgUnitColl = null;
        BgOrgUnitInfo bgOrgUnitInfo = null;
        DefaultKingdeeTreeNode node = null;
        root.removeAllChildren();
        DefaultKingdeeTreeNode _root = BgOrgTreeHelper.getMultiDirectChildNodes(root, null, bgOrgViewId, true, true, true, isOnlyNoLeaf);
        bgOrgUnitInfo = (BgOrgUnitInfo)root.getUserObject();
        orgUnitColl = (BgOrgUnitCollection)BgOrgTreeHelper.getBgOrgViewInterface().getDirectOrgUnits(bgOrgViewId, bgOrgUnitInfo.getId().toString(), isSealUp, false, isPermsionFilter, isShowVirtualOrg, isOnlyNoLeaf);
        root.removeAllChildren();
        ArrayList<BgOrgUnitInfo> childNodes = new ArrayList<BgOrgUnitInfo>();
        for (i = 0; i < orgUnitColl.size(); ++i) {
            childNodes.add(orgUnitColl.get(i));
        }
        root = NewOrgViewHelper.buildTreeByList((DefaultKingdeeTreeNode)root, childNodes);
        int in = root.getChildCount();
        for (i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (!(node.getUserObject() instanceof BgOrgUnitInfo) || !(bgOrgUnitInfo = (BgOrgUnitInfo)node.getUserObject()).isIsVirtual()) continue;
            node.setText(bgOrgUnitInfo.getName() + "(s)");
        }
    }

    private static TreeModel buildMultiTreeModelByOrg(DefaultKingdeeTreeNode selectedNode, String orgUnitId, String bgOrgViewId, boolean isPermsionFilter, boolean isSealUp, boolean isShowVirtualOrg, boolean isOnlyNoLeaf) throws Exception {
        selectedNode = BgOrgTreeHelper.getMultiDirectChildNodes(selectedNode, orgUnitId, bgOrgViewId, isPermsionFilter, isSealUp, isShowVirtualOrg, isOnlyNoLeaf);
        TreeModel model = BgOrgTreeHelper.buildTreeModel(selectedNode);
        return model;
    }

    private static DefaultKingdeeTreeNode getMultiDirectChildNodes(DefaultKingdeeTreeNode selectNode, String orgUnitId, String bgOrgViewId, Boolean isUserPermissionFilter, boolean isNeedAddSealUp, boolean isShowVirtualOrg, boolean isOnlyNoLeaf) throws EASBizException, BOSException {
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        CoreBaseInfo userObject = null;
        String parentID = null;
        List<String> parendIds = null;
        BgOrgUnitCollection bgOrgRootCols = null;
        BgOrgUnitCollection orgUnitColl = null;
        DefaultKingdeeTreeNode rootTreeNode = null;
        if (selectNode == null) {
            int i;
            rootTreeNode = BgOrgTreeHelper.createVirtualNode();
            bgOrgRootCols = (BgOrgUnitCollection)BgOrgUnitFactory.getRemoteInstance().getRootPermisionOrg(bgOrgViewId, orgUnitId, isUserPermissionFilter, isNeedAddSealUp, null, isShowVirtualOrg, true);
            parendIds = BgOrgTreeHelper.getRootIdsByCols(bgOrgRootCols);
            orgUnitColl = (BgOrgUnitCollection)BgOrgTreeHelper.getBgOrgViewInterface().getMultiDirectOrgUnits(bgOrgViewId, parendIds, isNeedAddSealUp, true, isUserPermissionFilter, isShowVirtualOrg, isOnlyNoLeaf);
            nodeMap.put(((BgOrgUnitInfo)rootTreeNode.getUserObject()).getId().toString(), rootTreeNode);
            BgOrgUnitInfo curBgUnitInfo = null;
            BgOrgUnitInfo parentUnitInfo = null;
            DefaultKingdeeTreeNode subTreeNode = null;
            DefaultKingdeeTreeNode parentNode = null;
            for (i = 0; i < bgOrgRootCols.size(); ++i) {
                curBgUnitInfo = bgOrgRootCols.get(i);
                parentUnitInfo = curBgUnitInfo.getParent();
                if (parentUnitInfo != null && parentUnitInfo.getId() != null) continue;
                parentNode = BgOrgTreeHelper.createNewNode(curBgUnitInfo);
                ((DefaultKingdeeTreeNode)nodeMap.get(((BgOrgUnitInfo)rootTreeNode.getUserObject()).getId().toString())).add((MutableTreeNode)parentNode);
                nodeMap.put(curBgUnitInfo.getId().toString(), parentNode);
            }
            for (i = 0; i < orgUnitColl.size(); ++i) {
                curBgUnitInfo = orgUnitColl.get(i);
                if (nodeMap.containsKey(curBgUnitInfo.getId().toString())) continue;
                subTreeNode = BgOrgTreeHelper.createNewNode(curBgUnitInfo);
                parentUnitInfo = curBgUnitInfo.getParent();
                if (parentUnitInfo != null && parentUnitInfo.getId() != null && nodeMap.containsKey(parentID = parentUnitInfo.getId().toString())) {
                    parentNode = (DefaultKingdeeTreeNode)nodeMap.get(parentID);
                    parentUnitInfo = (BgOrgUnitInfo)parentNode.getUserObject();
                    parentUnitInfo.setIsLeaf(false);
                    parentNode.add((MutableTreeNode)subTreeNode);
                }
                nodeMap.put(curBgUnitInfo.getId().toString(), subTreeNode);
            }
            return rootTreeNode;
        }
        userObject = (CoreBaseInfo)selectNode.getUserObject();
        parentID = userObject.getId().toString();
        orgUnitColl = (BgOrgUnitCollection)BgOrgTreeHelper.getBgOrgViewInterface().getDirectOrgUnits(bgOrgViewId, parentID, isNeedAddSealUp, false, isUserPermissionFilter, isShowVirtualOrg, isOnlyNoLeaf);
        ArrayList<BgOrgUnitInfo> childNodes = new ArrayList<BgOrgUnitInfo>();
        for (int i = 0; i < orgUnitColl.size(); ++i) {
            childNodes.add(orgUnitColl.get(i));
        }
        selectNode = NewOrgViewHelper.buildTreeByList((DefaultKingdeeTreeNode)selectNode, childNodes);
        return selectNode;
    }

    public static List<String> getRootIdsByCols(BgOrgUnitCollection bgOrgRootCols) {
        ArrayList<String> parendIds = new ArrayList<String>();
        if (!bgOrgRootCols.isEmpty()) {
            for (int i = 0; i < bgOrgRootCols.size(); ++i) {
                if (bgOrgRootCols.get(i).getId() == null) continue;
                parendIds.add(bgOrgRootCols.get(i).getId().toString());
            }
        }
        return parendIds;
    }

    protected static IBgOrgView getBgOrgViewInterface() throws BOSException {
        return BgOrgViewFactory.getRemoteInstance();
    }

    private static DefaultKingdeeTreeNode createVirtualNode() {
        DefaultKingdeeTreeNode rootTreeNode = null;
        BgOrgUnitInfo rootBgUnitInfo = new BgOrgUnitInfo();
        BOSUuid rootId = BOSUuid.read((String)"000000000000000000000000000=");
        rootBgUnitInfo.setId(rootId);
        rootBgUnitInfo.setIsLeaf(false);
        rootBgUnitInfo.setLevel(0);
        rootTreeNode = BgOrgTreeHelper.createNewNode(rootBgUnitInfo);
        rootTreeNode.setText(VIRROOT);
        return rootTreeNode;
    }

    public static void resetKDTreeNode(KDTree tree) {
        Object root;
        Object object = root = tree == null || tree.getModel() == null ? null : tree.getModel().getRoot();
        if (root == null) {
            return;
        }
        DefaultKingdeeTreeNode nodeTarget = null;
        if (root != null && root instanceof DefaultKingdeeTreeNode) {
            Enumeration enumTarget = ((DefaultKingdeeTreeNode)root).breadthFirstEnumeration();
            while (enumTarget.hasMoreElements()) {
                nodeTarget = (DefaultKingdeeTreeNode)enumTarget.nextElement();
                nodeTarget.setChecked(false);
            }
        }
        tree.repaint();
    }

    public static void addChildNode(DefaultKingdeeTreeNode root, String bgOrgViewId, Set canDisplayNumbers) throws EASBizException, BOSException {
        if (root == null) {
            return;
        }
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            throw new BOSException("BgOrgUnitUtils.addChildNode error : BgOrgViewId is Null !!!!!");
        }
        int childCount = root.getChildCount();
        if (childCount >= 1) {
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)root.getChildAt(0);
            if (tempNode.getUserObject() != null) {
                return;
            }
        } else if ((root = BgOrgTreeHelper.getMultiDirectChildNodes(root, null, bgOrgViewId, true, true, false, false)) != null && root.getChildCount() > 0) {
            int count = root.getChildCount();
            for (int index = count - 1; index >= 0; --index) {
                DefaultKingdeeTreeNode aChild = (DefaultKingdeeTreeNode)root.getChildAt(index);
                if (canDisplayNumbers == null || canDisplayNumbers.contains(((DataBaseInfo)aChild.getUserObject()).getNumber())) continue;
                root.remove((MutableTreeNode)aChild);
            }
        }
    }

    public static void resetLeaf(DefaultKingdeeTreeNode node, Set<String> noLeafIds) {
        if (node == null || noLeafIds == null) {
            return;
        }
        String orgId = null;
        if (node.getUserObject() instanceof BgOrgUnitInfo) {
            orgId = ((BgOrgUnitInfo)node.getUserObject()).getOrgUnitID();
        } else if (node.getUserObject() instanceof TreeBaseInfo) {
            orgId = ((TreeBaseInfo)node.getUserObject()).getId().toString();
        }
        if (orgId != null && !noLeafIds.contains(orgId)) {
            node.removeAllChildren();
        }
        DefaultKingdeeTreeNode node1 = null;
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            node1 = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (node1.getUserObject() instanceof TreeBaseInfo && ((TreeBaseInfo)node1.getUserObject()).isIsLeaf()) {
                node.remove(i);
                continue;
            }
            BgOrgTreeHelper.resetLeaf(node1, noLeafIds);
        }
    }

    public static Set<String> getAllLeafBgOrgIds(Context ctx, String bgOrgViewId) throws BOSException {
        IBgOrgUnit iOrg = null;
        iOrg = ctx == null ? BgOrgUnitFactory.getRemoteInstance() : BgOrgUnitFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("id");
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId));
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)("Select FOrgUnitId FROM T_MBG_BgOrgUnit Where FIsVirtual = 0 AND FIsLeaf = 1 AND FViewId = '" + bgOrgViewId + "'"), CompareType.INNER));
        BgOrgUnitCollection col = iOrg.getBgOrgUnitCollection(view);
        HashSet<String> ids = new HashSet<String>();
        ids.addAll(BgCommHelper.transeToMap((IObjectCollection)col).keySet());
        return ids;
    }
}

