/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.ma.base.utils.BgPeriodVariable;
import com.kingdee.eas.ma.mbg.formula.IMbgFormulaConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class BgPeriodNExprSetterHelper
implements IMbgFormulaConstants {
    private static final Logger logger = Logger.getLogger(BgPeriodNExprSetterHelper.class);
    public static final String ACCT_STR = "ACCT";

    public static String checkExpression(Cell cell, String expressions, final BgPeriodVariable bgPeriodVariable) {
        if (StringUtils.isEmpty((String)expressions)) {
            return null;
        }
        String _expressions = null;
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)expressions);
            if (cell != null && expression instanceof FunctionExpr) {
                BgPeriodNExprSetterHelper.checkFuncionName((FunctionExpr)expression, cell);
            }
            if (expression instanceof Ref3DExpr) {
                return expressions;
            }
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    return BgPeriodNExprSetterHelper.checkExpression(expr, bgPeriodVariable);
                }
            });
            _expressions = '=' + expression.toString();
        }
        catch (Exception ex) {
            logger.error((Object)expressions);
            logger.error((Object)ex);
        }
        return _expressions;
    }

    private static void checkFuncionName(FunctionExpr expr, Cell cell) {
        String obj;
        if (expr == null || cell == null) {
            return;
        }
        String funcionName = expr.funcionName;
        if (("RPTDATE".equalsIgnoreCase(funcionName) || "BGRPTDATE".equalsIgnoreCase(funcionName) || "MbgGetOrgNum".equalsIgnoreCase(funcionName)) && ((obj = cell.getStyle().getNumberFormat()) == null || !"@".equals(obj))) {
            BgNFSHelper.setNumberFormat(cell, "@");
        }
    }

    private static Expression checkExpression(Expression expression, BgPeriodVariable bgPeriodVariable) {
        if (expression instanceof FunctionExpr) {
            expression = BgPeriodNExprSetterHelper.checkFunctionExpr((FunctionExpr)expression, bgPeriodVariable);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = BgPeriodNExprSetterHelper.checkBinaryOperationExpr((BinaryOperationExpr)expression, bgPeriodVariable);
        } else if (expression instanceof UnaryOperationExpr) {
            expression = BgPeriodNExprSetterHelper.checkUnaryOperationExpr((UnaryOperationExpr)expression, bgPeriodVariable);
        }
        return expression;
    }

    private static Expression checkFunctionExpr(FunctionExpr funExpr, BgPeriodVariable bgPeriodVariable) {
        String funcionName = funExpr.funcionName;
        try {
            if ("MbgAggregate".equalsIgnoreCase(funcionName) || "MbgFormula".equalsIgnoreCase(funcionName) || "MbgActuals".equalsIgnoreCase(funcionName) || "MbgRefBgTem".equalsIgnoreCase(funcionName) || "Mbgadjust".equalsIgnoreCase(funcionName) || "MbgAvlBal".equalsIgnoreCase(funcionName) || "MbgActualExt".equalsIgnoreCase(funcionName) || "MbgControl".equalsIgnoreCase(funcionName) || "MbgBgAvlBal".equalsIgnoreCase(funcionName) || "MbgCorUnit".equalsIgnoreCase(funcionName) || "MbgCsl".equalsIgnoreCase(funcionName)) {
                FunctionExpr _expression = funExpr;
                if (_expression instanceof FunctionExpr) {
                    BgPeriodNExprSetterHelper.checkExpressionParam(_expression, bgPeriodVariable);
                }
                return _expression;
            }
            BgPeriodNExprSetterHelper.checkExpressionParam(funExpr, bgPeriodVariable);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return funExpr;
    }

    private static BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr, BgPeriodVariable bgPeriodVariable) {
        boExpr.left = BgPeriodNExprSetterHelper.checkExpression(boExpr.left, bgPeriodVariable);
        boExpr.right = BgPeriodNExprSetterHelper.checkExpression(boExpr.right, bgPeriodVariable);
        return boExpr;
    }

    private static UnaryOperationExpr checkUnaryOperationExpr(UnaryOperationExpr boExpr, BgPeriodVariable bgPeriodVariable) {
        return boExpr;
    }

    private static void checkExpressionParam(FunctionExpr funExpr, BgPeriodVariable bgPeriodVariable) {
        String funcionName = funExpr.funcionName;
        if ("MbgFormula".equalsIgnoreCase(funcionName) || "MbgAggregate".equalsIgnoreCase(funcionName) || "MbgActuals".equalsIgnoreCase(funcionName) || "Mbgadjust".equalsIgnoreCase(funcionName) || "MbgControl".equalsIgnoreCase(funcionName) || "MbgBgAvlBal".equalsIgnoreCase(funcionName)) {
            BgPeriodNExprSetterHelper.checkBgFormulaParam(funExpr.parameters, bgPeriodVariable);
        } else if ("MbgRefBgTem".equalsIgnoreCase(funcionName)) {
            BgPeriodNExprSetterHelper.checkBgRefBgTemplateParam(funExpr.parameters, bgPeriodVariable);
        } else if ("MbgCsl".equalsIgnoreCase(funcionName)) {
            BgPeriodNExprSetterHelper.checkBgCSLFormulaParam(funExpr.parameters, bgPeriodVariable);
        } else if ("MbgCorUnit".equalsIgnoreCase(funcionName)) {
            BgPeriodNExprSetterHelper.checkMbgCorUnitFormulaParam(funExpr.parameters, bgPeriodVariable);
        }
    }

    private static void checkMbgCorUnitFormulaParam(List parameter, BgPeriodVariable bgPeriodVariable) {
        if (parameter == null || parameter.size() < 8) {
            return;
        }
        StringExpr param6 = (StringExpr)parameter.get(6);
        StringExpr param7 = (StringExpr)parameter.get(7);
        param6.value = BgPeriodVariable.getBgPeriodParam((String)param6.value, (BgPeriodVariable)bgPeriodVariable);
        param7.value = BgPeriodVariable.getBgPeriodParam((String)param7.value, (BgPeriodVariable)bgPeriodVariable);
    }

    private static void checkBgRefBgTemplateParam(List parameter, BgPeriodVariable bgPeriodVariable) {
        if (parameter == null || parameter.size() != 10 && parameter.size() != 9) {
            return;
        }
        StringExpr param3 = (StringExpr)parameter.get(3);
        param3.value = BgPeriodVariable.getBgPeriodParam((String)param3.value, (BgPeriodVariable)bgPeriodVariable);
    }

    private static void checkBgFormulaParam(List parameter, BgPeriodVariable bgPeriodVariable) {
        if (parameter == null || parameter.size() < 7) {
            return;
        }
        StringExpr param4 = (StringExpr)parameter.get(4);
        StringExpr param5 = (StringExpr)parameter.get(5);
        param4.value = BgPeriodVariable.getBgPeriodParam((String)param4.value, (BgPeriodVariable)bgPeriodVariable);
        param5.value = BgPeriodVariable.getBgPeriodParam((String)param5.value, (BgPeriodVariable)bgPeriodVariable);
    }

    private static void checkBgCSLFormulaParam(List parameter, BgPeriodVariable bgPeriodVariable) {
        if (parameter == null || parameter.size() < 7) {
            return;
        }
        StringExpr param5 = (StringExpr)parameter.get(5);
        StringExpr param6 = (StringExpr)parameter.get(6);
        param5.value = BgPeriodVariable.getBgPeriodParam((String)param5.value, (BgPeriodVariable)bgPeriodVariable);
        param6.value = BgPeriodVariable.getBgPeriodParam((String)param6.value, (BgPeriodVariable)bgPeriodVariable);
    }
}

