/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.ctrl.common.util.SectionByteOutputStream;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.excel.io.PrintHelper;
import com.kingdee.bos.ctrl.excel.model.struct.PrintSetup;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.util.KDSDataInputStream;
import com.kingdee.bos.ctrl.excel.util.KDSDataOutputStream;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class BgPrintHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgPrintHelper.class);
    static final byte ID_SO_PrintSetup = 6;
    static final byte PrintFlag_Head = 1;
    static final byte PrintFlag_Col_Head = 2;
    static final byte PrintFlag_Grid = 4;
    static final byte PrintFlag_BlackWhite = 8;
    static final byte PrintFlag_RowFirst = 16;
    static final byte PrintFlag_LandScape = 32;
    private static final String KDSBinary = "###KDSpread2.0###";

    public static void writePrintSetup(PrintSetup ps, KDSDataOutputStream out) throws IOException {
        if (ps == null) {
            return;
        }
        boolean isLandScape = ps.isLandScape();
        boolean isRowFirst = ps.isRowFirst();
        boolean isBlackWhite = ps.isBlackWhite();
        boolean hasGrid = ps.hasGrid();
        boolean hasHead = ps.hasRowHead();
        boolean hasColHead = ps.hasColHead();
        int flags = 0;
        flags = (byte)(flags | (hasColHead ? 2 : 0));
        flags = (byte)(flags | (hasHead ? 1 : 0));
        flags = (byte)(flags | (hasGrid ? 4 : 0));
        flags = (byte)(flags | (isBlackWhite ? 8 : 0));
        flags = (byte)(flags | (isRowFirst ? 16 : 0));
        flags = (byte)(flags | (isLandScape ? 32 : 0));
        out.write(flags);
        int centerHori = ps.getCenterHorizontal();
        out.writeInt(centerHori);
        int centerVert = ps.getCenterVertical();
        out.writeInt(centerVert);
        float topMargin = ps.getTopMargin();
        out.writeInt(Float.floatToIntBits(topMargin));
        float bottomMargin = ps.getBottomMargin();
        out.writeInt(Float.floatToIntBits(bottomMargin));
        float leftMargin = ps.getLeftMargin();
        out.writeInt(Float.floatToIntBits(leftMargin));
        float rightMargin = ps.getRightMargin();
        out.writeInt(Float.floatToIntBits(rightMargin));
        int pageSizeIndex = ps.getPagesizeIndex();
        out.writeInt(pageSizeIndex);
        float pageSizeX = ps.getPagesizeX();
        out.writeInt(Float.floatToIntBits(pageSizeX));
        float pageSizeY = ps.getPagesizeY();
        out.writeInt(Float.floatToIntBits(pageSizeY));
        boolean autoFit = ps.isAutoFit();
        out.writeBoolean(autoFit);
        int scale = ps.getScale();
        out.writeInt(scale);
        int autoFitWidth = ps.getAutoFitWidth();
        out.writeInt(autoFitWidth);
        int autoFitHeight = ps.getAutoFitHeight();
        out.writeInt(autoFitHeight);
        float headMargin = ps.getHeadMargin();
        out.writeInt(Float.floatToIntBits(headMargin));
        String headData = PrintHelper.getHeadFootString((List)ps.getHeadData(), (boolean)true);
        out.writeString(headData);
        int footAlign = ps.getFootAlign();
        out.writeInt(footAlign);
        int headAlign = ps.getHeadAlign();
        out.writeInt(headAlign);
        float footMargin = ps.getFootMargin();
        out.writeInt(Float.floatToIntBits(footMargin));
        String footData = PrintHelper.getHeadFootString((List)ps.getFootData(), (boolean)true);
        out.writeString(footData);
        out.writeString(ps.getBackGroundUrl());
    }

    public static String encodePrintSetup(Sheet sheet) {
        if (sheet == null) {
            return null;
        }
        SectionByteOutputStream os = new SectionByteOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream((OutputStream)os);
        PrintSetup ps = sheet.getSheetOption().getPrintSetup(false);
        byte[] packBytes = null;
        try {
            BgPrintHelper.writePrintSetup(ps, out);
            packBytes = ZipUtil.pack((SectionByteOutputStream)os, (String)KDSBinary);
        }
        catch (IOException e) {
            logger.error((Object)("getEncodePrintSetup error" + e.getMessage()));
        }
        return BgAnalyseHelper.encode(packBytes);
    }

    public static void decodePrintSetup(Sheet sheet, String setting) {
        if (StringUtils.isEmpty((String)setting)) {
            return;
        }
        byte[] unPackBytes = null;
        unPackBytes = BgAnalyseHelper.decode(setting);
        KDSDataInputStream in = null;
        try {
            in = new KDSDataInputStream(ZipUtil.unpack((byte[])unPackBytes));
            BgPrintHelper.readPrintSetup(sheet, in, new HashMap());
        }
        catch (IOException e) {
            logger.error((Object)("decodePrintSetup error" + e.getMessage()));
        }
    }

    private static void readPrintSetup(Sheet sheet, KDSDataInputStream is, HashMap styles) throws IOException {
        PrintSetup ps = sheet.getSheetOption().getPrintSetup(true);
        byte flags = is.readByte();
        ps.setLandScape(BgPrintHelper.touchFlag(flags, 32));
        ps.setRowFirst(BgPrintHelper.touchFlag(flags, 16));
        ps.setBlackWhite(BgPrintHelper.touchFlag(flags, 8));
        ps.setHasGrid(BgPrintHelper.touchFlag(flags, 4));
        ps.setHasRowHead(BgPrintHelper.touchFlag(flags, 1));
        ps.setHasColHead(BgPrintHelper.touchFlag(flags, 2));
        ps.setCenterHorizontal(is.readInt());
        ps.setCenterVertical(is.readInt());
        ps.setTopMargin(Float.intBitsToFloat(is.readInt()));
        ps.setBottomMargin(Float.intBitsToFloat(is.readInt()));
        ps.setLeftMargin(Float.intBitsToFloat(is.readInt()));
        ps.setRightMargin(Float.intBitsToFloat(is.readInt()));
        ps.setPagesizeIndex(is.readInt());
        ps.setPagesizeX(Float.intBitsToFloat(is.readInt()));
        ps.setPagesizeY(Float.intBitsToFloat(is.readInt()));
        ps.setAutoFit(is.readBoolean());
        ps.setScale(is.readInt());
        ps.setAutoFitWidth(is.readInt());
        ps.setAutoFitHeight(is.readInt());
        ps.setHeadMargin(Float.intBitsToFloat(is.readInt()));
        ps.setHeadData(PrintHelper.genHeaderFootList((String)is.readString(), (HashMap)styles, (boolean)true));
        ps.setFootAlign(is.readInt());
        ps.setHeadAlign(is.readInt());
        ps.setFootMargin(Float.intBitsToFloat(is.readInt()));
        ps.setFootData(PrintHelper.genHeaderFootList((String)is.readString(), (HashMap)styles, (boolean)true));
        String path = is.readString();
        ps.setBackGroundUrl(path);
        if (!StringUtils.isEmpty((String)path)) {
            ps.setBackGround(KDPrinterUtils.createImageFromFile(null, (File)new File(path)));
        }
    }

    private static boolean touchFlag(int flags, int thisflag) {
        return (flags & thisflag) != 0;
    }
}

