/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgRefDimMemberFactory;
import com.kingdee.eas.ma.base.BgRefDimMemberInfo;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.MbgMemberNodeCollection;
import com.kingdee.eas.ma.base.MbgMemberNodeFactory;
import com.kingdee.eas.ma.base.MbgMemberNodeInfo;
import com.kingdee.eas.ma.base.MbgViewCollection;
import com.kingdee.eas.ma.base.MbgViewFactory;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.MemberSegregationRuleEnum;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTemplateNodeInfo;
import com.kingdee.eas.ma.mbg.IBgTemplate;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchConstants;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgSchemeDispatchUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchUtils");
    public static final String RESOURCE_STR = "com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource";
    private static int MSGLENGTH = 7;

    public static BgTemplateCollection getBgTemplateColls(String bgSchemeId, String orgUnitId) throws BOSException {
        return BgSchemeDispatchUtils.getBgTemplateColls(null, bgSchemeId, orgUnitId);
    }

    public static BgTemplateCollection getBgTemplateColls(Context ctx, String bgSchemeId, String orgUnitId) throws BOSException {
        BgTemplateCollection colls = new BgTemplateCollection();
        if (StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)orgUnitId)) {
            return colls;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)("Select FBgTemplateId FROM T_MBg_BgTemplateNode Where FOrgUnitId = '" + orgUnitId + "'"), CompareType.INNER));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgSchemeDispatchUtils.getSelectBgTemplate());
        view.getSorter().add(new SorterItemInfo("number"));
        IBgTemplate iBgTemplate = null;
        iBgTemplate = ctx == null ? BgTemplateFactory.getRemoteInstance() : BgTemplateFactory.getLocalInstance(ctx);
        return iBgTemplate.getBgTemplateCollection(view);
    }

    public static SelectorItemCollection getSelectBgTemplate() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgScheme.id");
        sic.add("id");
        sic.add("templateStatus");
        sic.add("number");
        sic.add("name");
        sic.add("temType");
        sic.add("root.id");
        sic.add("createtime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("creator.number");
        sic.add("lastupdatetime");
        sic.add("lastupdateuser.id");
        sic.add("lastupdateuser.name");
        sic.add("lastupdateuser.number");
        return sic;
    }

    public static CompanyOrgUnitCollection getCompanyOrgUnit() throws BOSException {
        return BgSchemeDispatchUtils.getCompanyOrgUnit(null);
    }

    public static CompanyOrgUnitCollection getCompanyOrgUnit(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add("id");
        view.getSelector().add("number");
        ICompanyOrgUnit iCompany = null;
        iCompany = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        return iCompany.getCompanyOrgUnitCollection(view);
    }

    public static SelectorItemCollection getSelectElimTemplate() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgScheme.id");
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("createtime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("creator.number");
        return sic;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<BOSUuid> dispatchCheckRefBgForm(Context ctx, BOSUuid bgSchemeId, BOSUuid bgTemplateRootId, List<String> orgUnitIds) throws BOSException, EASBizException {
        HashSet<BOSUuid> refBgTemplateIdSet = new HashSet<BOSUuid>();
        if (ctx == null) return refBgTemplateIdSet;
        if (bgTemplateRootId == null) return refBgTemplateIdSet;
        if (orgUnitIds == null) {
            return refBgTemplateIdSet;
        }
        String _bgTemplateRootId = bgTemplateRootId.toString();
        int index = 0;
        int size = orgUnitIds.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select f.FOrgUnitId from T_MBG_BgForm f where f.FBgTemplateId = ? and f.FOrgUnitId IN (");
        for (int i = 1; i < 50; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                pstmt.setString(1, _bgTemplateRootId);
                for (int k = 2; k <= 51; ++k, ++pos) {
                    if (pos < size) {
                        pstmt.setString(k, orgUnitIds.get(pos));
                        continue;
                    }
                    pstmt.setString(k, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    refBgTemplateIdSet.add(BOSUuid.read((String)rst.getString("FOrgUnitId")));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)"dispatchCheckRefBgForm Error: ", (Throwable)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"dispatchCheckRefBgForm Error: ", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return refBgTemplateIdSet;
    }

    public static List<String[]> dispatchTemplate(Context ctx, BgSchemeInfo bgScheme, BgTemplateInfo bgTemplate, List<String> orgUnitIds, Map<String, FullOrgUnitInfo> orgUnitMap) throws BOSException, EASBizException {
        if (ctx == null || bgScheme == null || bgTemplate == null || orgUnitIds == null || orgUnitIds.isEmpty() || orgUnitMap == null) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        FullOrgUnitInfo orgUnit = null;
        String _bgSchemeId = bgScheme.getId().toString();
        String _bgTemplateId = bgTemplate.getId().toString();
        Object _dispTemplateId = null;
        BOSObjectType type = new BgTemplateNodeInfo().getBOSType();
        ArrayList<String[]> paramList = null;
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer("Select FOrgUnitId FROM T_MBg_BgTemplateNode Where FBgTemplateId IN (Select FID FROM T_MBg_BgTemplate Where FNumber = ? AND FID <> ? AND FBgSchemeId = ?) AND FOrgUnitId IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            paramList = MbgSqlHelper.getBatchParams((Object[])new Object[]{bgTemplate.getNumber(), _bgTemplateId, _bgSchemeId}, (Object[])orgUnitIds.toArray(), (int)50);
            List orgNumberRepeat = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)paramList);
            HashMap memMap = null;
            HashMap orgMap = null;
            HashMap<String, MbgViewInfo> viewIdMap = null;
            if (8 == bgTemplate.getFormType().getValue() || 0 == bgTemplate.getFormType().getValue()) {
                EntityViewInfo viewinfo = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("baseDataID");
                viewinfo.setSelector(sic);
                viewinfo.setFilter(new FilterInfo());
                viewinfo.getFilter().getFilterItems().add(new FilterItemInfo("refID", (Object)_bgTemplateId, CompareType.EQUALS));
                viewinfo.getFilter().getFilterItems().add(new FilterItemInfo("bgSchemeID", (Object)_bgSchemeId, CompareType.EQUALS));
                viewinfo.getFilter().getFilterItems().add(new FilterItemInfo("refType", (Object)1, CompareType.EQUALS));
                CoreBaseCollection refcolls = BgRefDimMemberFactory.getLocalInstance((Context)ctx).getCollection(viewinfo);
                BgRefDimMemberInfo refInfo = null;
                HashSet<String> memberId = new HashSet<String>();
                for (int i = 0; i < refcolls.size(); ++i) {
                    refInfo = (BgRefDimMemberInfo)refcolls.get(i);
                    if (!refInfo.getBaseDataID().getType().equals((Object)new MbgMemberInfo().getBOSType())) continue;
                    memberId.add(refInfo.getBaseDataID().toString());
                }
                if (!memberId.isEmpty()) {
                    memMap = new HashMap();
                    viewinfo = new EntityViewInfo();
                    sic = new SelectorItemCollection();
                    sic.add("name");
                    sic.add("number");
                    sic.add("longnumber");
                    sic.add("viewId");
                    viewinfo.setSelector(sic);
                    viewinfo.setFilter(new FilterInfo());
                    viewinfo.getFilter().getFilterItems().add(new FilterItemInfo("id", memberId, CompareType.INCLUDE));
                    viewinfo.getFilter().getFilterItems().add(new FilterItemInfo("isSystemDefault", (Object)0, CompareType.EQUALS));
                    MbgMemberCollection memberColl = MbgMemberFactory.getLocalInstance((Context)ctx).getMbgMemberCollection(viewinfo);
                    MbgMemberInfo memInfo = null;
                    for (int i = 0; i < memberColl.size(); ++i) {
                        memInfo = memberColl.get(i);
                        if (memMap.containsKey(memInfo.getViewId().toString())) {
                            ((Set)memMap.get(memInfo.getViewId().toString())).add(memInfo.getId().toString());
                            continue;
                        }
                        HashSet<String> memSet = new HashSet<String>();
                        memSet.add(memInfo.getId().toString());
                        memMap.put(memInfo.getViewId().toString(), memSet);
                    }
                    viewIdMap = new HashMap<String, MbgViewInfo>();
                    viewinfo = new EntityViewInfo();
                    sic = new SelectorItemCollection();
                    sic.add("segregationRule");
                    sic.add("name");
                    sic.add("number");
                    sic.add("id");
                    viewinfo.setSelector(sic);
                    viewinfo.setFilter(new FilterInfo());
                    viewinfo.getFilter().getFilterItems().add(new FilterItemInfo("id", memMap.keySet(), CompareType.INCLUDE));
                    MbgViewCollection viewColl = MbgViewFactory.getLocalInstance((Context)ctx).getMbgViewCollection(viewinfo);
                    for (int i = 0; i < viewColl.size(); ++i) {
                        if (viewColl.get(i).getSegregationRule().equals((Object)MemberSegregationRuleEnum.SEGREGATEORG)) {
                            viewIdMap.put(viewColl.get(i).getId().toString(), viewColl.get(i));
                            continue;
                        }
                        if (!viewColl.get(i).getSegregationRule().equals((Object)MemberSegregationRuleEnum.SEGREGATEEQUALS)) continue;
                    }
                    if (!viewIdMap.isEmpty()) {
                        orgMap = new HashMap();
                        viewinfo = new EntityViewInfo();
                        sic = new SelectorItemCollection();
                        sic.add("orgUnit.id");
                        sic.add("mbgMember.id");
                        sic.add("mbgMember.viewId");
                        viewinfo.setSelector(sic);
                        viewinfo.setFilter(new FilterInfo());
                        viewinfo.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", new HashSet<String>(orgUnitIds), CompareType.INCLUDE));
                        viewinfo.getFilter().getFilterItems().add(new FilterItemInfo("mbgMember.viewId", viewIdMap.keySet(), CompareType.INCLUDE));
                        MbgMemberNodeCollection nodeColl = MbgMemberNodeFactory.getLocalInstance((Context)ctx).getMbgMemberNodeCollection(viewinfo);
                        MbgMemberNodeInfo nodeInfo = null;
                        for (int i = 0; i < nodeColl.size(); ++i) {
                            nodeInfo = nodeColl.get(i);
                            if (orgMap.containsKey(nodeInfo.getOrgUnit().getId().toString())) {
                                if (((Map)orgMap.get(nodeInfo.getOrgUnit().getId().toString())).containsKey(nodeInfo.getMbgMember().getViewId().toString())) {
                                    ((Set)((Map)orgMap.get(nodeInfo.getOrgUnit().getId().toString())).get(nodeInfo.getMbgMember().getViewId().toString())).add(nodeInfo.getMbgMember().getId().toString());
                                    continue;
                                }
                                HashSet<String> memSet = new HashSet<String>();
                                memSet.add(nodeInfo.getMbgMember().getId().toString());
                                ((Map)orgMap.get(nodeInfo.getOrgUnit().getId().toString())).put(nodeInfo.getMbgMember().getViewId().toString(), memSet);
                                continue;
                            }
                            HashMap memMaps = new HashMap();
                            HashSet<String> memSet = new HashSet<String>();
                            memSet.add(nodeInfo.getMbgMember().getId().toString());
                            memMaps.put(nodeInfo.getMbgMember().getViewId().toString(), memSet);
                            orgMap.put(nodeInfo.getOrgUnit().getId().toString(), memMaps);
                        }
                        viewinfo = new EntityViewInfo();
                        sic = new SelectorItemCollection();
                        sic.add("orgUnit.id");
                        sic.add("id");
                        sic.add("viewId");
                        viewinfo.setSelector(sic);
                        viewinfo.setFilter(new FilterInfo());
                        viewinfo.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", new HashSet<String>(orgUnitIds), CompareType.INCLUDE));
                        viewinfo.getFilter().getFilterItems().add(new FilterItemInfo("isSystemDefault", (Object)0, CompareType.EQUALS));
                        viewinfo.getFilter().getFilterItems().add(new FilterItemInfo("viewId", viewIdMap.keySet(), CompareType.INCLUDE));
                        viewinfo.getFilter().setMaskString("#0 and #1 and #2");
                        MbgMemberCollection memColl = MbgMemberFactory.getLocalInstance((Context)ctx).getMbgMemberCollection(viewinfo);
                        MbgMemberInfo memberInfo = null;
                        for (int i = 0; i < memColl.size(); ++i) {
                            memberInfo = memColl.get(i);
                            if (orgMap.containsKey(memberInfo.getOrgunit().getId().toString())) {
                                if (((Map)orgMap.get(memberInfo.getOrgunit().getId().toString())).containsKey(memberInfo.getViewId().toString())) {
                                    ((Set)((Map)orgMap.get(memberInfo.getOrgunit().getId().toString())).get(memberInfo.getViewId().toString())).add(memberInfo.getId().toString());
                                    continue;
                                }
                                HashSet<String> memSet = new HashSet<String>();
                                memSet.add(memberInfo.getId().toString());
                                ((Map)orgMap.get(memberInfo.getOrgunit().getId().toString())).put(memberInfo.getViewId().toString(), memSet);
                                continue;
                            }
                            HashMap memMaps = new HashMap();
                            HashSet<String> memSet = new HashSet<String>();
                            memSet.add(memberInfo.getId().toString());
                            memMaps.put(memberInfo.getViewId().toString(), memSet);
                            orgMap.put(memberInfo.getOrgunit().getId().toString(), memMaps);
                        }
                    }
                }
            }
            paramList = new ArrayList<String[]>();
            for (String _orgUnitId : orgUnitIds) {
                orgUnit = orgUnitMap.get(_orgUnitId);
                if (orgUnit == null) continue;
                if (orgNumberRepeat.contains(_orgUnitId)) {
                    result.add(BgSchemeDispatchUtils.getDispatchResult(bgTemplate, (OrgUnitInfo)orgUnit, false, BgSchemeDispatchConstants.DISPATCH_FAIL_NUMBER));
                    continue;
                }
                StringBuffer msg = new StringBuffer();
                if (viewIdMap != null && !viewIdMap.isEmpty() && memMap != null && !memMap.isEmpty()) {
                    if (orgMap != null) {
                        if (!orgMap.isEmpty() && orgMap.containsKey(_orgUnitId)) {
                            if (orgMap.get(_orgUnitId) != null) {
                                for (String key : ((Map)orgMap.get(_orgUnitId)).keySet()) {
                                    if (((Set)((Map)orgMap.get(_orgUnitId)).get(key)).containsAll((Collection)memMap.get(key))) continue;
                                    msg.append(((MbgViewInfo)viewIdMap.get(key)).getNumber() + "(" + ((MbgViewInfo)viewIdMap.get(key)).getName() + ")\u3001");
                                }
                            } else {
                                for (String key : viewIdMap.keySet()) {
                                    msg.append(((MbgViewInfo)viewIdMap.get(key)).getNumber() + "(" + ((MbgViewInfo)viewIdMap.get(key)).getName() + ")\u3001");
                                }
                            }
                        }
                    } else {
                        for (String key : viewIdMap.keySet()) {
                            msg.append(((MbgViewInfo)viewIdMap.get(key)).getNumber() + "(" + ((MbgViewInfo)viewIdMap.get(key)).getName() + ")\u3001");
                        }
                    }
                }
                if (msg.length() > 0) {
                    result.add(BgSchemeDispatchUtils.getDispatchResult(bgTemplate, (OrgUnitInfo)orgUnit, false, BgSchemeDispatchConstants.DISPATCH_FAIL_DIMMEMBER, msg.substring(0, msg.length() - 1).toString()));
                    continue;
                }
                paramList.add(new String[]{BOSUuid.create((BOSObjectType)type).toString(), _orgUnitId, _bgTemplateId, _bgTemplateId, _orgUnitId});
                result.add(BgSchemeDispatchUtils.getDispatchResult(bgTemplate, (OrgUnitInfo)orgUnit, true, BgSchemeDispatchConstants.DISPATCH_SUCCESS));
            }
            if (!paramList.isEmpty()) {
                MbgSqlHelper.executeBatch((Connection)conn, (String)"Insert Into T_MBg_BgTemplateNode(FID, FBgTemplateId, FOrgUnitId) Select ?, FID, ? FROM T_MBg_BgTemplate Where FID = ? AND NOT EXISTS (Select FID FROM T_MBg_BgTemplateNode Where FBgTemplateId = ? AND FOrgUnitId = ?)", paramList);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return result;
    }

    public static SelectorItemCollection getBgSchemeSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("dateFrom");
        sic.add("dateTo");
        sic.add("period");
        sic.add("isFormal");
        sic.add("refDims.id");
        sic.add("refDims.bgDimName");
        sic.add("refDims.bgDimNumber");
        return sic;
    }

    public static SelectorItemCollection getBgTemplateSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("isAllowChange");
        sic.add("data");
        sic.add("canModify");
        sic.add("templateStatus");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgTemplate.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("defaultMeasureUnit.id");
        sic.add("defaultMeasureUnit.name");
        sic.add("defaultMeasureUnit.number");
        sic.add("defaultMeasureUnit.coefficient");
        sic.add("parent.id");
        sic.add("root.id");
        sic.add("formType");
        sic.add("bgScenario.id");
        return sic;
    }

    public static Map<String, FullOrgUnitInfo> getOrgUnitInfo(Context ctx, List<String> orgUnitIds) throws BOSException, EASBizException {
        if (orgUnitIds == null || orgUnitIds.isEmpty()) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        HashMap<String, FullOrgUnitInfo> orgUnitMap = new HashMap<String, FullOrgUnitInfo>();
        FullOrgUnitInfo _unitInfo = null;
        int index = 0;
        int size = orgUnitIds.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _id = null;
        String _cuId = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FId, FName_" + ctx.getLocale() + ", FNumber, FControlUnitId from T_ORG_CostCenter where FId IN (");
        for (int i = 1; i < 50; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= 50) {
                    if (pos < size) {
                        pstmt.setString(k, orgUnitIds.get(pos));
                    } else {
                        pstmt.setString(k, "#");
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _id = rst.getString("FId");
                    _cuId = rst.getString("FControlUnitId");
                    _unitInfo = new FullOrgUnitInfo();
                    _unitInfo.setId(BOSUuid.read((String)_id));
                    _unitInfo.setName(rst.getString(2));
                    _unitInfo.setNumber(rst.getString("FNumber"));
                    _unitInfo.setCU(new CtrlUnitInfo());
                    _unitInfo.getCU().setId(BOSUuid.read((String)_cuId));
                    orgUnitMap.put(_id, _unitInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return orgUnitMap;
    }

    public static String[] getDispatchResult(BgTemplateInfo template, OrgUnitInfo orgUnit, boolean isSuccess, String resultStr, String param) {
        String[] result = new String[MSGLENGTH];
        result[0] = String.valueOf(isSuccess);
        result[1] = resultStr;
        result[2] = template.getNumber();
        result[3] = template.getName();
        result[4] = orgUnit.getNumber();
        result[5] = orgUnit.getName();
        result[6] = param;
        return result;
    }

    public static String[] getDispatchResult(BgTemplateInfo template, OrgUnitInfo orgUnit, boolean isSuccess, String resultStr) {
        String[] result = new String[MSGLENGTH];
        result[0] = String.valueOf(isSuccess);
        result[1] = resultStr;
        result[2] = template.getNumber();
        result[3] = template.getName();
        result[4] = orgUnit.getNumber();
        result[5] = orgUnit.getName();
        return result;
    }

    public static String[] getDispatchResult(BgTemplateInfo template, boolean isSuccess, String resultStr) {
        String[] result = new String[MSGLENGTH];
        result[0] = String.valueOf(isSuccess);
        result[1] = resultStr;
        result[2] = template.getNumber();
        result[3] = template.getName();
        return result;
    }

    public static String[] getDispatchResult(boolean isSuccess, String resultStr) {
        String[] result = new String[MSGLENGTH];
        result[0] = String.valueOf(isSuccess);
        result[1] = resultStr;
        return result;
    }
}

