/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.FiscalYearEnum;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgRollPartEnum;
import com.kingdee.eas.ma.mbg.BgRollRuleInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IDimensionColumn;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBGRowData;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewManagerImpl;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.RelationUtils;
import com.kingdee.eas.ma.mbg.utils.BgFormHelper;
import com.kingdee.eas.ma.mbg.utils.BgItemObject;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class BgViewHelper {
    private static final Logger logger = Logger.getLogger((String)BgViewHelper.class.getName());
    private static final String orgNumber = "DefaultOrgNumber";
    public static final String VIEWLAYOUT = "view";
    public static final String PAGELAYOUT = "page";
    public static final String COLLAYOUT = "col";
    public static final String ROWLAYOUT = "row";
    public static final String HIDELAYOUT = "hide";
    public static final String BGITEM = "BGITEM";
    public static final String CURRENCY = "CURRENCY";
    public static final String BGPERIOD = "BGPERIOD";
    public static final String BGELEMENT = "BGELEMENT";
    public static final String ORGUNIT = "ORGUNIT";
    public static final String ROWADDMEMBER = "rowAddMember";
    public static final String DIMENSION = "DIMENSION";
    public static final String ENCODING = "UTF-8";
    public static final String DOCUMENT_VIEW = "view";
    public static final String DOCUMENT_PAGE = "page";
    public static final String DOCUMENT_ROW = "row";
    public static final String DOCUMENT_COL = "col";
    public static final String DOCUMENT_HIDE = "hide";
    public static final String DOCUMENT_DIMENSION = "dimension";
    public static final String DOCUMENT_MEMBER = "member";
    public static final String DOCUMENT_CONFIG = "config";
    public static final String DOCUMENT_TYPE = "type";
    public static final String DOCUMENT_VALUE = "value";
    public static final String DOCUMENT_ATTRIBUTE = "attribute";
    public static final String DOCUMENT_LAYOUT = "layout";
    public static final String DOCUMENT_SHOW_TYPE = "showType";
    public static final String DOCUMENT_ALIAS = "alias";
    public static final String DOCUMENT_MAP = "map";
    public static final String DOCUMENT_LEFT = "left";
    public static final String DOCUMENT_RIGHT = "right";

    public static void removeEditHelper(KDTable table) {
        BgCommHelper.removeEditHelper((KDTable)table);
    }

    public static void writeStyle(OutputStream os, IBgDimensionManager bm) {
        if (os == null || bm == null) {
            return;
        }
        Document doc = BgViewHelper.buildStyleDocument(bm);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(ENCODING);
        XMLWriter writer = null;
        try {
            writer = new XMLWriter(os, format);
            writer.write(doc);
            writer.close();
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private static Document buildStyleDocument(IBgDimensionManager bm) {
        if (bm == null) {
            return null;
        }
        Document doc = DocumentHelper.createDocument();
        Element view = doc.addElement("view");
        BgViewHelper.buildStyleDocument(view, "page", bm.getPageDisplayDimension());
        BgViewHelper.buildStyleDocument(view, "col", bm.getColDisplayDimension());
        BgViewHelper.buildStyleDocument(view, "row", bm.getRowDisplayDimension());
        BgViewHelper.buildStyleDocument(view, "hide", bm.getHideDisplayDimension());
        return doc;
    }

    private static void buildStyleDocument(Element parent, String type, List dimens) {
        if (parent == null || StringUtils.isEmpty((String)type) || dimens == null || dimens.isEmpty()) {
            return;
        }
        Element sub = parent.addElement(type);
        for (int i = 0; i < dimens.size(); ++i) {
            BgDimensionInfo dimen = (BgDimensionInfo)dimens.get(i);
            Element dimElement = sub.addElement(DOCUMENT_DIMENSION);
            dimElement.addElement(DOCUMENT_TYPE).setText(dimen.getType());
            dimElement.addElement(DOCUMENT_ATTRIBUTE).setText(dimen.getAttribute());
        }
    }

    public static void addElementText(Element element, String key, Object value) {
        if (value != null && !StringUtils.isEmpty((String)value.toString()) && !StringUtils.isEmpty((String)key) && element != null) {
            element.addElement(key).setText(value.toString());
        }
    }

    public static String getElementValue(Element element, String key) {
        if (element != null && !StringUtils.isEmpty((String)key)) {
            return element.elementText(key);
        }
        return null;
    }

    public static String getElementAttr(Element element, String attrName) {
        if (element != null && !StringUtils.isEmpty((String)attrName)) {
            return element.attributeValue(attrName);
        }
        return null;
    }

    public static List getCurrPageMember(List f7List, List pageDimension) {
        ArrayList<BgDimensionMember> list = new ArrayList<BgDimensionMember>();
        if (f7List != null && !f7List.isEmpty() && pageDimension != null && !pageDimension.isEmpty()) {
            BgDimensionBaseInfo dimen;
            HashMap<String, BgDimensionBaseInfo> dimens = new HashMap<String, BgDimensionBaseInfo>();
            for (int i = 0; i < pageDimension.size(); ++i) {
                dimen = (BgDimensionBaseInfo)pageDimension.get(i);
                dimens.put(dimen.getNumber(), dimen);
            }
            String name = "";
            for (int i = 0; i < f7List.size(); ++i) {
                Component componet = (Component)f7List.get(i);
                Object data = null;
                if (componet instanceof KDPromptBox) {
                    data = ((KDPromptBox)componet).getData();
                    name = componet.getName();
                } else if (componet instanceof KDComboBox) {
                    data = ((KDComboBox)componet).getSelectedItem();
                    name = componet.getName();
                } else if (componet instanceof KDLabelContainer) {
                    data = ((KDPromptBox)((KDLabelContainer)componet).getBoundEditor()).getData();
                    name = ((KDLabelContainer)componet).getBoundEditor().getName();
                }
                if (data instanceof List) {
                    data = ((List)data).size() > 0 ? ((List)data).get(0) : null;
                }
                if ((dimen = (BgDimensionBaseInfo)dimens.get(name)) == null) continue;
                if (data instanceof BgDimensionMember) {
                    list.add((BgDimensionMember)data);
                    continue;
                }
                String number = BgViewHelper.getNumber(data);
                boolean find = false;
                for (int m = 0; m < dimen.getMember().size(); ++m) {
                    BgDimensionMember member = (BgDimensionMember)dimen.getMember().get(m);
                    if (!member.getNumber().equals(number)) continue;
                    list.add(member);
                    find = true;
                    break;
                }
                if (find) continue;
                if (data instanceof OrgUnitInfo) {
                    OrgUnitInfo org = (OrgUnitInfo)data;
                    BgDimensionMember orgDimensionMember = new BgDimensionMember(dimen.getNumber(), org.getId().toString(), org.getName(), org.getNumber());
                    orgDimensionMember.setSimpleName(org.getSimpleName());
                    orgDimensionMember.setLongName(org.getDisplayName());
                    list.add(orgDimensionMember);
                    continue;
                }
                list.add(new BgDimensionMember(null, null, null, null));
            }
        }
        return list;
    }

    public static String getNumber(Object obj) {
        if (obj instanceof BgDimensionMember) {
            return ((BgDimensionMember)obj).getNumber();
        }
        if (obj instanceof IObjectValue) {
            return String.valueOf(((IObjectValue)obj).get("number"));
        }
        if (obj instanceof BgItemObject) {
            return ((BgItemObject)obj).getResult().get(0).getNumber();
        }
        return null;
    }

    public static String getName(Object obj) {
        if (obj instanceof BgDimensionMember) {
            return ((BgDimensionMember)obj).getName();
        }
        if (obj instanceof IObjectValue) {
            return String.valueOf(((IObjectValue)obj).get("name"));
        }
        if (obj instanceof BgItemObject) {
            return ((BgItemObject)obj).getResult().get(0).getName();
        }
        return null;
    }

    public static BigDecimal getNumeric(Cell cell, BigDecimal defaultValue) {
        if (cell != null && cell.getValue() != Variant.nullVariant) {
            if (cell.getValue().getValue() instanceof BigDecimal) {
                return (BigDecimal)cell.getValue().getValue();
            }
            try {
                return new BigDecimal(String.valueOf(cell.getValue().getValue()).trim().replaceAll(",", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean checkHasRoll(BgFormInfo bgFormInfo) {
        return bgFormInfo.getBgPeriod() != null && bgFormInfo.getBgRollPeriod() != null && !bgFormInfo.getBgPeriod().getNumber().equalsIgnoreCase(bgFormInfo.getBgRollPeriod().getNumber());
    }

    public static List getViewOperation(Context ctx) {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        sheetOperation.add(new Integer(2));
        sheetOperation.add(new Integer(4));
        try {
            if (!BgNSHelper.isProtectionRowAndCol(ctx)) {
                sheetOperation.add(new Integer(8));
                sheetOperation.add(new Integer(16));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        sheetOperation.add(new Integer(65536));
        sheetOperation.add(new Integer(16384));
        return sheetOperation;
    }

    public static Map getSubMap(Map parent, String key, boolean create) {
        if (parent == null) {
            return null;
        }
        if (parent.containsKey(key)) {
            return (Map)parent.get(key);
        }
        if (create) {
            parent.put(key, new HashMap());
            return (Map)parent.get(key);
        }
        return null;
    }

    public static void retainAll(Map source, Map rel) {
        if (source != null) {
            if (rel == null || rel.isEmpty()) {
                source.clear();
            } else {
                Iterator it = source.keySet().iterator();
                while (it.hasNext()) {
                    if (rel.containsKey(it.next())) continue;
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map getSubMap(Map parent, Object key, boolean isCreate, Object defaultKey) {
        void var4_7;
        if (parent == null || key == null) {
            return null;
        }
        Object var4_4 = null;
        if (parent.get(key) == null) {
            if (!isCreate) return BgViewHelper.getSubMap(parent, defaultKey, false, null);
            HashMap hashMap = new HashMap();
            parent.put(key, hashMap);
            return var4_7;
        } else {
            if (!(parent.get(key) instanceof Map)) return var4_7;
            Map map = (Map)parent.get(key);
        }
        return var4_7;
    }

    public static void setLocked(boolean isLocked, Range r) {
        if (r != null) {
            StyleAttributes s1 = Styles.getEmptySA();
            StyleAttributes s2 = Styles.getEmptySA();
            r.getStyle(s1, s2);
            s1.setLocked(isLocked);
            r.setIgnoreProtected(true);
            r.setStyle(s1, s2);
        }
    }

    public static void setLocked(boolean isLocked, Range r, boolean isPainColor) {
        if (r != null) {
            StyleAttributes s1 = Styles.getEmptySA();
            StyleAttributes s2 = Styles.getEmptySA();
            r.getStyle(s1, s2);
            s1.setLocked(isLocked);
            if (isPainColor) {
                if (isLocked) {
                    s1.setBackground(BgNConstants.LOCK_COLOR);
                } else {
                    s1.setBackground(BgNConstants.BASE_COLOR);
                }
            }
            r.setIgnoreProtected(true);
            r.setStyle(s1, s2);
        }
    }

    public static int getBeginRowIndex(IBgDimensionManager dm) {
        if (BgViewHelper.isShowMeasure(dm)) {
            return 2;
        }
        return 0;
    }

    public static boolean isShowMeasure(IBgDimensionManager dm) {
        return dm != null && dm.getDefaultMeasureUnit() != null && dm.getMeasureMap().isEmpty();
    }

    public static void setLockedAndBackgroud(boolean isLocked, Range r) {
        long ct = System.currentTimeMillis();
        if (r != null) {
            StyleAttributes s1 = Styles.getEmptySA();
            StyleAttributes s2 = Styles.getEmptySA();
            r.getStyle(s1, s2);
            s1.setLocked(isLocked);
            if (isLocked) {
                s1.setBackground(BgNConstants.LOCK_COLOR);
            }
            r.setIgnoreProtected(true);
            r.setStyle(s1, s2);
        }
        logger.info((Object)("setLockedAndBackgroud:" + (System.currentTimeMillis() - ct) + "ms"));
    }

    public static String parseItemFormula(String bgElement, String currency, String bgPeriod, String scenriao, Map bgItems) {
        StringBuffer f = new StringBuffer();
        if (bgItems != null && !bgItems.isEmpty()) {
            Object[] reffields = bgItems.keySet().toArray();
            Arrays.sort(reffields);
            for (int i = 0; i < reffields.length; ++i) {
                if (bgItems.get(reffields[i]) == null) continue;
                if (f.length() > 0) {
                    f.append(",");
                }
                f.append(bgItems.get(reffields[i]));
            }
        }
        return BgNFSHelper.getFormulaFromParam(f.toString(), bgPeriod, bgElement, currency, scenriao);
    }

    public static boolean applyMutex(Context ctx, String id, String userID) throws BOSException {
        if (id == null || userID == null) {
            return false;
        }
        boolean isRequest = false;
        IMutexServiceControl imsc = null;
        imsc = ctx != null ? MutexServiceControlFactory.getLocalInstance((Context)ctx) : MutexServiceControlFactory.getRemoteInstance();
        isRequest = imsc.requestObjIDForUpdate(id, userID);
        return isRequest;
    }

    public static void releaseMutex(Context ctx, String id) throws BOSException {
        if (id == null) {
            return;
        }
        IMutexServiceControl imsc = null;
        imsc = ctx != null ? MutexServiceControlFactory.getLocalInstance((Context)ctx) : MutexServiceControlFactory.getRemoteInstance();
        imsc.releaseObjIDForUpdate(id);
    }

    public static void converPeriodToRPT(BgFormInfo report) {
        BgPeriodInfo period = report.getBgPeriod();
        if (period != null) {
            BgPeriodEnum periodType = period.getPeriodType();
            int year = period.getYear();
            int halfYear = period.getHalfYear();
            int month = period.getMonth();
            int quart = period.getQuarter();
            if (periodType != null) {
                if (periodType.getValue() == 1) {
                    report.setPeriodType(RptPeriodTypeEnum.YEARLY);
                    report.setYear(year);
                    report.setPeriod((short)1);
                } else if (periodType.getValue() == 2) {
                    report.setPeriodType(RptPeriodTypeEnum.SEMIYEARLY);
                    report.setYear(year);
                    report.setPeriod((short)halfYear);
                } else if (periodType.getValue() == 3) {
                    report.setPeriodType(RptPeriodTypeEnum.QUARTERLY);
                    report.setYear(year);
                    report.setPeriod((short)quart);
                } else if (periodType.getValue() == 4) {
                    report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                    report.setYear(year);
                    report.setPeriod((short)month);
                } else if (periodType.getValue() == 5 || periodType.getValue() == 6) {
                    report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                    report.setYear(year);
                    report.setPeriod((short)month);
                }
            }
        }
    }

    public static StringBuffer convertArray(Object[] obj, StringBuffer str) {
        if (obj == null || obj.length == 0) {
            return str;
        }
        if (str == null) {
            str = new StringBuffer();
        }
        for (int i = 0; i < obj.length; ++i) {
            if (i != 0) {
                str.append(", ");
            }
            str.append(obj[i]);
        }
        return str;
    }

    public static StringBuffer convertList(Object obj, StringBuffer str) {
        if (str == null) {
            str = new StringBuffer();
        }
        if (obj instanceof List) {
            return BgViewHelper.convertArray(((List)obj).toArray(), str);
        }
        return str.append(obj == null ? "" : obj);
    }

    public static void additionalForViewManager(BgFormInfo curBgForm, Map cacheMap, IMbgViewManager viewManager) throws EASBizException {
        viewManager.setDefaultMeasureUnit(curBgForm.getMeasureUnit());
        viewManager.getMeasureMap().clear();
        if (!curBgForm.getBgMeasureUnit().isEmpty()) {
            for (int i = 0; i < curBgForm.getBgMeasureUnit().size(); ++i) {
                if (null == curBgForm.getBgMeasureUnit().get(i).getBgElement()) continue;
                viewManager.getMeasureMap().put(curBgForm.getBgMeasureUnit().get(i).getBgElement().getNumber(), curBgForm.getBgMeasureUnit().get(i).getMeasureUnit());
            }
        }
        Map subCacheMap = null;
        IBgDimensionManager bm = null;
        for (int sheetIndex = 0; sheetIndex < viewManager.getSheetManagers().size(); ++sheetIndex) {
            bm = viewManager.getSheetManagers().get(sheetIndex).getDimensionManager();
            bm.setDefaultMeasureUnit(curBgForm.getMeasureUnit());
            if (cacheMap.get(sheetIndex) == null) continue;
            subCacheMap = (Map)cacheMap.get(sheetIndex);
            Map currMap = (Map)subCacheMap.get(CURRENCY);
            if (currMap != null) {
                bm.getCurrencyMap().putAll(currMap);
            }
            BgViewHelper.fillDimensionMember(bm, subCacheMap, false, curBgForm.getOrgUnit().getId().toString(), curBgForm.getBgPeriod(), curBgForm.getCurrency(), curBgForm.getBgVersion(), false, curBgForm.getBgTemplate().getBgRollRule());
        }
    }

    public static void fillDimensionMember(IBgDimensionManager bm, Map resMap, boolean isBg063, String orgId, BgPeriodInfo bgPeriod, CurrencyInfo currency, BgVersionInfo bgVersion, boolean isCurOrg, BgRollRuleInfo rollRuleInfo) throws EASBizException {
        if (bm == null || resMap == null || resMap.isEmpty()) {
            return;
        }
        Map orgMap = (Map)resMap.get(ORGUNIT);
        Map bgPeriodMap = (Map)resMap.get(BGPERIOD);
        for (int i = 0; i < bm.getDimension().size(); ++i) {
            BgDimensionInfo dimen = (BgDimensionInfo)bm.getDimension().get(i);
            if (MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(dimen.getNumber())) {
                BgViewHelper.fillOrgDimensionMember(dimen, BgViewHelper.filterMap(orgMap, orgId, isCurOrg), orgId);
            } else if (MBGLayoutConstants.BG_PERIOD.equalsIgnoreCase(dimen.getNumber())) {
                BgRollPartEnum rollPart = null;
                if (rollRuleInfo != null) {
                    rollPart = rollRuleInfo.getRollPart();
                }
                BgViewHelper.fillBgPeriodDimensionMember(dimen, bgPeriodMap, bgPeriod, rollPart);
            } else if (MBGLayoutConstants.BG_CURRENCY.equalsIgnoreCase(dimen.getNumber())) {
                BgViewHelper.fillCurrencyDimensionMember(dimen, currency);
            } else if (MBGLayoutConstants.BG_VERSION.equalsIgnoreCase(dimen.getNumber())) {
                BgViewHelper.fillVersionDimensionMember(dimen, bgVersion);
            } else if (MBGLayoutConstants.BG_ELEMENT.equalsIgnoreCase(dimen.getNumber()) || BGITEM.equalsIgnoreCase(dimen.getNumber())) {
                // empty if block
            }
            if (MBGLayoutConstants.BG_PERIOD.equalsIgnoreCase(dimen.getNumber()) || MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(dimen.getNumber()) || MBGLayoutConstants.BG_INDEX.equalsIgnoreCase(dimen.getNumber())) continue;
            dimen.sortMember();
        }
    }

    public static void additionalForViewListManager(Context ctx, BgFormInfo curBgForm, Map cacheMap, MbgViewListManager viewManager) throws EASBizException {
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            MbgViewListDimensionManager bm = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager();
            BgViewHelper.fillViewListDimensionMember(ctx, bm, cacheMap, curBgForm.getOrgUnit().getId().toString(), curBgForm.getBgPeriod(), curBgForm.getCurrency(), curBgForm.getBgVersion(), false, curBgForm.getBgTemplate().getBgRollRule());
        }
    }

    public static void fillViewListDimensionMember(Context ctx, MbgViewListDimensionManager bm, Map resMap, String orgId, BgPeriodInfo bgPeriod, CurrencyInfo currency, BgVersionInfo bgVersion, boolean isCurOrg) throws EASBizException {
        BgViewHelper.fillViewListDimensionMember(ctx, bm, resMap, orgId, bgPeriod, currency, bgVersion, isCurOrg, null);
    }

    public static void fillViewListDimensionMember(Context ctx, MbgViewListDimensionManager bm, Map resMap, String orgId, BgPeriodInfo bgPeriod, CurrencyInfo currency, BgVersionInfo bgVersion, boolean isCurOrg, BgRollRuleInfo rollRuleInfo) throws EASBizException {
        if (bm == null || resMap == null || resMap.isEmpty()) {
            return;
        }
        Map orgMap = (Map)resMap.get(ORGUNIT);
        Map bgPeriodMap = (Map)resMap.get(BGPERIOD);
        List<MbgViewListDimensionInfo> allDimensions = bm.getAllDimensions();
        for (int i = 0; i < allDimensions.size(); ++i) {
            BgDimensionBaseInfo dimen = allDimensions.get(i);
            if (DimensionMemberValueModeEnum.Null == dimen.getMemberValueType() && dimen.getMember().isEmpty() && !DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimen.getNumber())) continue;
            BgViewHelper.fillViewListCurrentMembers(ctx, dimen, orgMap, bgPeriodMap, orgId, bgPeriod, currency, bgVersion, isCurOrg, rollRuleInfo);
        }
        BgViewHelper.fillRelationPeriod(bm, bgPeriodMap, bgPeriod);
    }

    public static void fillRelationPeriod(MbgViewListDimensionManager bm, Map bgPeriodMap, BgPeriodInfo bgPeriod) throws EASBizException {
        List<MbgRelationMap> pageRelationMaps = bm.getPageRelationMaps();
        BgViewHelper.fillRelationPeriod(pageRelationMaps, bgPeriodMap, bgPeriod);
        List<IMbgViewListObject> rowCols = bm.getRowCols();
        MbgViewListRowCol rowCol = null;
        if (rowCols != null && !rowCols.isEmpty()) {
            for (int i = 0; i < rowCols.size(); ++i) {
                if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
                rowCol = (MbgViewListRowCol)rowCols.get(i);
                BgViewHelper.fillRelationPeriod(rowCol.getRelationMaps(), bgPeriodMap, bgPeriod);
            }
        }
    }

    public static void fillRelationPeriod(List<MbgRelationMap> relationMaps, Map bgPeriodMap, BgPeriodInfo bgPeriod) throws EASBizException {
        MbgRelationMap relationMap = null;
        DimensionRelationshipCollection relationShips = null;
        DimensionRelationshipInfo dimensionRelationshipInfo = null;
        String dimensionNumber = null;
        String dimensionName = null;
        if (relationMaps != null && !relationMaps.isEmpty()) {
            for (int j = 0; j < relationMaps.size(); ++j) {
                relationMap = relationMaps.get(j);
                if (relationMap.getRelationShips() == null || relationMap.getRelationShips().isEmpty()) continue;
                relationShips = relationMap.getRelationShips();
                DimensionRelationshipCollection newRelationShips = new DimensionRelationshipCollection();
                HashSet<String> checkRepeat = new HashSet<String>();
                String newDimensionNumber = null;
                String newDimensionName = null;
                for (int s = 0; s < relationShips.size(); ++s) {
                    dimensionRelationshipInfo = relationShips.get(s);
                    dimensionNumber = dimensionRelationshipInfo.getDimensionNumber();
                    dimensionName = dimensionRelationshipInfo.getDimensionName();
                    newDimensionNumber = dimensionNumber;
                    if (!StringUtils.isEmpty((String)dimensionNumber)) {
                        String[] arrayStrs = dimensionNumber.split(",");
                        for (int index = 0; index < arrayStrs.length; ++index) {
                            String memberNum = arrayStrs[index];
                            if (memberNum.indexOf(":") <= 0) continue;
                            String[] arr = memberNum.split(":");
                            String srcNum = arr[0];
                            String num = arr[1];
                            if (!DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(srcNum) || !BgPeriodNVariableHelper.checkCanConvert((String)num)) continue;
                            int targetPeriodType = bgPeriod.getPeriodType().getValue();
                            String targetPeriodNumber = bgPeriod.getNumber();
                            String newNumber = BgPeriodNVariableHelper.getBgPeriodByN((String)targetPeriodNumber, (String)num, (int)targetPeriodType);
                            newDimensionNumber = dimensionNumber.replace(memberNum, DimensionConstants.DEF_PERIOD_SRCNUMBER + ":" + newNumber);
                            dimensionRelationshipInfo.setDimensionNumber(newDimensionNumber);
                            if (!bgPeriodMap.containsKey(newNumber) || !(bgPeriodMap.get(newNumber) instanceof BgPeriodInfo)) continue;
                            newDimensionName = dimensionName.replace(num, ((BgPeriodInfo)bgPeriodMap.get(newNumber)).getName());
                        }
                    }
                    if (checkRepeat.contains(newDimensionNumber)) continue;
                    checkRepeat.add(newDimensionNumber);
                    newRelationShips.add(dimensionRelationshipInfo);
                }
                if (newRelationShips.isEmpty()) continue;
                relationMap.getRelationShips().clear();
                relationMap.getRelationShips().addObjectCollection((IObjectCollection)newRelationShips);
            }
        }
    }

    public static void fillDimensionMember(Context ctx, MbgViewListDimensionManager bm, Map resMap, String orgId, BgPeriodInfo bgPeriod, CurrencyInfo currency, BgVersionInfo bgVersion, boolean isCurOrg) throws EASBizException {
        BgViewHelper.fillDimensionMember(ctx, bm, resMap, orgId, bgPeriod, currency, bgVersion, isCurOrg, null);
    }

    public static void fillDimensionMember(Context ctx, MbgViewListDimensionManager bm, Map resMap, String orgId, BgPeriodInfo bgPeriod, CurrencyInfo currency, BgVersionInfo bgVersion, boolean isCurOrg, BgRollRuleInfo rollRuleInfo) throws EASBizException {
        if (bm == null || resMap == null || resMap.isEmpty()) {
            return;
        }
        Map orgMap = (Map)resMap.get(ORGUNIT);
        Map bgPeriodMap = (Map)resMap.get(BGPERIOD);
        List<MbgViewListDimensionInfo> allDimensions = bm.getAllDimensions();
        for (int i = 0; i < allDimensions.size(); ++i) {
            BgDimensionBaseInfo dimen = allDimensions.get(i);
            if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimen.getNumber())) continue;
            BgViewHelper.fillViewListCurrentMembers(ctx, dimen, orgMap, bgPeriodMap, orgId, bgPeriod, currency, bgVersion, isCurOrg, rollRuleInfo);
        }
        BgViewHelper.fillRelationPeriod(bm, bgPeriodMap, bgPeriod);
    }

    public static void fillViewListCurrentMembers(Context ctx, BgDimensionBaseInfo dimen, Map orgMap, Map bgPeriodMap, String orgId, BgPeriodInfo bgPeriod, CurrencyInfo currency, BgVersionInfo bgVersion, boolean isCurOrg, BgRollRuleInfo rollRuleInfo) throws BgFormException, BgPeriodException {
        if (MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(dimen.getNumber())) {
            BgViewHelper.fillOrgDimensionMember(dimen, BgViewHelper.filterMap(orgMap, orgId, isCurOrg), orgId);
        } else if (MBGLayoutConstants.BG_PERIOD.equalsIgnoreCase(dimen.getNumber())) {
            BgRollPartEnum rollPart = null;
            if (rollRuleInfo != null) {
                rollPart = rollRuleInfo.getRollPart();
            }
            BgViewHelper.fillBgPeriodDimensionMember(dimen, bgPeriodMap, bgPeriod, rollPart);
            BgViewHelper.fillPeriodSelectMembers(ctx, dimen);
        } else if (MBGLayoutConstants.BG_CURRENCY.equalsIgnoreCase(dimen.getNumber())) {
            BgViewHelper.fillCurrencyDimensionMember(dimen, currency);
        } else if (MBGLayoutConstants.BG_VERSION.equalsIgnoreCase(dimen.getNumber())) {
            BgViewHelper.fillVersionDimensionMember(dimen, bgVersion);
        }
    }

    private static void fillPeriodSelectMembers(Context ctx, BgDimensionBaseInfo dimen) {
        if (dimen instanceof MbgViewListDimensionInfo && !((MbgViewListDimensionInfo)dimen).getSelectMembers().isEmpty()) {
            HashSet<String> periodNumbers = new HashSet<String>();
            List selectMembers = ((MbgViewListDimensionInfo)dimen).getSelectMembers();
            for (int index = 0; index < selectMembers.size(); ++index) {
                if (!(selectMembers.get(index) instanceof BgPeriodInfo)) continue;
                periodNumbers.add(((BgPeriodInfo)selectMembers.get(index)).getNumber());
            }
            if (!periodNumbers.isEmpty()) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("id");
                evi.getSelector().add("bgPeriod.id");
                evi.getSelector().add("number");
                evi.getSelector().add("name");
                evi.getSelector().add(DOCUMENT_ALIAS);
                evi.getSelector().add("longNumber");
                evi.getSelector().add("periodType");
                evi.getSelector().add("showlevel");
                evi.getSelector().add("isLeaf");
                evi.getSelector().add("type.*");
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", periodNumbers, CompareType.INCLUDE));
                try {
                    BgPeriodDispCollection col = BgPeriodDispFactory.getLocalInstance((Context)ctx).getBgPeriodDispCollection(evi);
                    if (col != null && !col.isEmpty()) {
                        BgPeriodInfo period;
                        Object[] result = BgNPeriodHelper.checkPeriodType((BgPeriodDispCollection)col);
                        boolean hasFiscalYear = (Boolean)result[1];
                        Set bothYears = (Set)result[2];
                        HashMap<String, BgPeriodInfo> periodMap = new HashMap<String, BgPeriodInfo>();
                        for (int i = 0; i < col.size(); ++i) {
                            BgPeriodDispInfo dsperiod = col.get(i);
                            if (!(hasFiscalYear && FiscalYearEnum.STRIDEYEAR.equals((Object)dsperiod.getType().getFiscalYear()) || !hasFiscalYear && FiscalYearEnum.STANDARDYEAR.equals((Object)dsperiod.getType().getFiscalYear())) && !BgPeriodHelper.checkPersonal((BgPeriodEnum)dsperiod.getPeriodType())) continue;
                            period = dsperiod.toBgPeriodInfo();
                            periodMap.put(period.getNumber(), period);
                        }
                        for (int index = 0; index < selectMembers.size(); ++index) {
                            if (!(selectMembers.get(index) instanceof BgPeriodInfo) || !StringUtils.isEmpty((String)(period = (BgPeriodInfo)selectMembers.get(index)).getDisplayName())) continue;
                            period.setDisplayName(((BgPeriodInfo)periodMap.get(period.getNumber())).getDisplayName());
                        }
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
    }

    public static Map filterMap(Map orgMap, String orgid, boolean flag) {
        if (flag) {
            HashMap tempOrgMap = new HashMap();
            for (Object id : orgMap.keySet()) {
                if (!id.equals(orgid)) continue;
                tempOrgMap.put(id, orgMap.get(id));
            }
            return tempOrgMap;
        }
        return orgMap;
    }

    public static void fillOrgDimensionMember(BgDimensionBaseInfo dimen, Map orgMap, String orgId) {
        if (dimen != null && orgMap != null) {
            HashMap<String, OrgUnitInfo> newOrgMap = new HashMap<String, OrgUnitInfo>();
            for (OrgUnitInfo org : orgMap.values()) {
                newOrgMap.put(org.getNumber(), org);
            }
            LinkedHashSet<String> orgNumbers = new LinkedHashSet<String>();
            if (dimen.getMember().isEmpty()) {
                if (orgMap.containsKey(orgId)) {
                    orgNumbers.add(((OrgUnitInfo)orgMap.get(orgId)).getNumber());
                }
            } else {
                for (int i = 0; i < dimen.getMember().size(); ++i) {
                    orgNumbers.add(((BgDimensionMember)dimen.getMember().get(i)).getNumber());
                }
            }
            dimen.getMember().clear();
            if (orgNumbers != null && !orgNumbers.isEmpty()) {
                for (String orgNumber : orgNumbers) {
                    OrgUnitInfo org;
                    org = (OrgUnitInfo)newOrgMap.get(orgNumber);
                    if (org == null) continue;
                    BgDimensionMember member = new BgDimensionMember(dimen.getNumber(), org.getId().toString(), org.getName(), org.getNumber());
                    member.setLevel(org.getLevel());
                    member.setSortValue((Comparable)((Object)org.getLongNumber()));
                    member.setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
                    member.setSimpleName(org.getSimpleName());
                    member.setLongName(org.getDisplayName());
                    member.setLeaf(org.isIsLeaf());
                    if (dimen instanceof MbgViewListDimensionInfo) {
                        dimen.getMember().add(MbgViewListDimensionMember.getInstance(member));
                        if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimen.getNumber())) continue;
                        if (((MbgViewListDimensionInfo)dimen).getSelectMembers().isEmpty()) {
                            ((MbgViewListDimensionInfo)dimen).getSelectMembers().add(MbgViewListDimensionMember.getInstance(member));
                            continue;
                        }
                        for (int k = 0; k < ((MbgViewListDimensionInfo)dimen).getSelectMembers().size(); ++k) {
                            BgDimensionMember sMember;
                            if (!(((MbgViewListDimensionInfo)dimen).getSelectMembers().get(k) instanceof BgDimensionMember) || StringUtils.isEmpty((String)(sMember = (BgDimensionMember)((MbgViewListDimensionInfo)dimen).getSelectMembers().get(k)).getAttribute()) || !sMember.getAttribute().equals(member.getAttribute()) || sMember.getNumber().equals(member.getNumber())) continue;
                            sMember.setNumber(member.getNumber());
                        }
                        continue;
                    }
                    dimen.getMember().add(member);
                }
            }
        }
    }

    public static void fillBgPeriodDimensionMember(BgDimensionBaseInfo dimen, Map bgPeriodMap, BgPeriodInfo bgPeriod, BgRollPartEnum rollPart) throws BgFormException, BgPeriodException {
        if (dimen == null) {
            return;
        }
        if (dimen instanceof BgDimensionInfo && StringUtils.isEmpty((String)dimen.getValue())) {
            dimen.getMember().clear();
            BgDimensionMember member = new BgDimensionMember(dimen.getNumber(), bgPeriod.getId().toString(), bgPeriod.getName(), bgPeriod.getNumber());
            if (bgPeriodMap.containsKey(bgPeriod.getNumber())) {
                bgPeriod = (BgPeriodInfo)bgPeriodMap.get(bgPeriod.getNumber());
            }
            member.setNumber(bgPeriod.getNumber());
            member.setAttribute(bgPeriod.getId().toString());
            member.setName(bgPeriod.getName());
            member.setAlias(bgPeriod.getDisplayName());
            member.setLevel(bgPeriod.getLevel());
            member.setSortValue(Integer.valueOf(bgPeriod.getShowLevel()));
            dimen.getMember().add(member);
        } else if (dimen instanceof MbgViewListDimensionInfo && dimen.getMember().isEmpty() && DimensionMemberValueModeEnum.Null.equals((Object)dimen.getMemberValueType())) {
            dimen.getMember().clear();
            ((MbgViewListDimensionInfo)dimen).getSelectMembers().clear();
            BgDimensionMember member = new BgDimensionMember(dimen.getNumber(), bgPeriod.getId().toString(), bgPeriod.getName(), bgPeriod.getNumber());
            if (bgPeriodMap.containsKey(bgPeriod.getNumber())) {
                bgPeriod = (BgPeriodInfo)bgPeriodMap.get(bgPeriod.getNumber());
            }
            member.setNumber(bgPeriod.getNumber());
            member.setAttribute(bgPeriod.getId().toString());
            member.setName(bgPeriod.getName());
            member.setAlias(bgPeriod.getDisplayName());
            member.setLevel(bgPeriod.getLevel());
            member.setSortValue(Integer.valueOf(bgPeriod.getShowLevel()));
            dimen.getMember().add(MbgViewListDimensionMember.getInstance(member));
            ((MbgViewListDimensionInfo)dimen).getSelectMembers().add(MbgViewListDimensionMember.getInstance(member));
        } else {
            ArrayList<String> notExistPeriodNum = new ArrayList<String>();
            ArrayList<BgDimensionMember> newMember = new ArrayList<BgDimensionMember>();
            if (dimen instanceof BgDimensionInfo) {
                for (int i = 0; i < dimen.getMember().size(); ++i) {
                    String number;
                    BgDimensionMember member = (BgDimensionMember)dimen.getMember().get(i);
                    int targetPeriodType = bgPeriod.getPeriodType().getValue();
                    String targetPeriodNumber = bgPeriod.getNumber();
                    if (BgRollPartEnum.month_quarterRoll.equals((Object)rollPart)) {
                        targetPeriodNumber = BgFormHelper.getFirstMontPeriod(targetPeriodNumber, rollPart);
                        targetPeriodType = 4;
                    }
                    if (bgPeriodMap.containsKey(number = BgPeriodNVariableHelper.getBgPeriodByN((String)targetPeriodNumber, (String)member.getNumber(), (int)targetPeriodType))) {
                        BgPeriodInfo p = (BgPeriodInfo)bgPeriodMap.get(number);
                        member.setNumber(p.getNumber());
                        member.setAttribute(p.getId().toString());
                        member.setLevel(p.getLevel());
                        member.setName(p.getName());
                        member.setAlias(p.getDisplayName());
                        member.setSortValue(Integer.valueOf(p.getShowLevel()));
                        member.setLeaf(p.isIsLeaf());
                        newMember.add(member);
                        continue;
                    }
                    if (BgPeriodNVariableHelper.checkIsDay((String)number)) continue;
                    notExistPeriodNum.add(number);
                }
            } else if (dimen instanceof MbgViewListDimensionInfo) {
                ((MbgViewListDimensionInfo)dimen).getSelectMembers().clear();
                HashSet<String> checkRepeat = new HashSet<String>();
                for (int i = 0; i < dimen.getMember().size(); ++i) {
                    String number;
                    BgDimensionMember member = (BgDimensionMember)dimen.getMember().get(i);
                    int targetPeriodType = bgPeriod.getPeriodType().getValue();
                    String targetPeriodNumber = bgPeriod.getNumber();
                    if (BgRollPartEnum.month_quarterRoll.equals((Object)rollPart)) {
                        targetPeriodNumber = BgFormHelper.getFirstMontPeriod(targetPeriodNumber, rollPart);
                        targetPeriodType = 4;
                    }
                    if (bgPeriodMap.containsKey(number = BgPeriodNVariableHelper.getBgPeriodByN((String)targetPeriodNumber, (String)member.getNumber(), (int)targetPeriodType))) {
                        if (checkRepeat.contains(number)) continue;
                        checkRepeat.add(number);
                        BgPeriodInfo p = (BgPeriodInfo)bgPeriodMap.get(number);
                        member.setNumber(p.getNumber());
                        member.setAttribute(p.getId().toString());
                        member.setLevel(p.getLevel());
                        member.setName(p.getName());
                        member.setAlias(p.getDisplayName());
                        member.setSortValue(Integer.valueOf(p.getShowLevel()));
                        member.setLeaf(p.isIsLeaf());
                        newMember.add(MbgViewListDimensionMember.getInstance(member));
                        ((MbgViewListDimensionInfo)dimen).getSelectMembers().add(MbgViewListDimensionMember.getInstance(member));
                        continue;
                    }
                    if (BgPeriodNVariableHelper.checkIsDay((String)number)) continue;
                    notExistPeriodNum.add(number);
                }
            }
            if (notExistPeriodNum.size() > 0) {
                throw new BgPeriodException(BgPeriodException.NOEXISTDETAIL, new Object[]{((Object)notExistPeriodNum).toString()});
            }
            dimen.getMember().clear();
            dimen.getMember().addAll(newMember);
        }
    }

    public static void fillCurrencyDimensionMember(BgDimensionBaseInfo dimen, CurrencyInfo currency) {
        if (dimen == null) {
            return;
        }
        if (dimen instanceof BgDimensionInfo && StringUtils.isEmpty((String)dimen.getValue())) {
            dimen.getMember().clear();
            BgDimensionMember member = new BgDimensionMember(dimen.getNumber(), currency.getId().toString(), currency.getName(), currency.getNumber());
            dimen.getMember().add(member);
        } else if (dimen instanceof MbgViewListDimensionInfo && dimen.getMember().isEmpty() && DimensionMemberValueModeEnum.Null.equals((Object)dimen.getMemberValueType())) {
            dimen.getMember().clear();
            ((MbgViewListDimensionInfo)dimen).getSelectMembers().clear();
            BgDimensionMember member = new BgDimensionMember(dimen.getNumber(), currency.getId().toString(), currency.getName(), currency.getNumber());
            dimen.getMember().add(MbgViewListDimensionMember.getInstance(member));
            ((MbgViewListDimensionInfo)dimen).getSelectMembers().add(MbgViewListDimensionMember.getInstance(member));
        }
    }

    public static void fillVersionDimensionMember(BgDimensionBaseInfo dimen, BgVersionInfo bgVersion) {
        if (dimen == null) {
            return;
        }
        if (dimen instanceof BgDimensionInfo && StringUtils.isEmpty((String)dimen.getValue()) && DimensionMemberValueModeEnum.Null.equals((Object)dimen.getMemberValueType())) {
            dimen.getMember().clear();
            BgDimensionMember member = new BgDimensionMember(dimen.getNumber(), bgVersion.getId().toString(), bgVersion.getName(), bgVersion.getNumber());
            member.setSrcNumber(DimensionConstants.DEF_VERSION_SRCNUMBER);
            dimen.getMember().add(member);
        } else if (dimen instanceof MbgViewListDimensionInfo && dimen.getMember().isEmpty() && DimensionMemberValueModeEnum.Null.equals((Object)dimen.getMemberValueType())) {
            dimen.getMember().clear();
            ((MbgViewListDimensionInfo)dimen).getSelectMembers().clear();
            BgDimensionMember member = new BgDimensionMember(dimen.getNumber(), bgVersion.getId().toString(), bgVersion.getName(), bgVersion.getNumber());
            member.setSrcNumber(DimensionConstants.DEF_VERSION_SRCNUMBER);
            dimen.getMember().add(MbgViewListDimensionMember.getInstance(member));
            ((MbgViewListDimensionInfo)dimen).getSelectMembers().add(MbgViewListDimensionMember.getInstance(member));
        }
    }

    public static Set<String> buildFormula(IMbgViewManager viewManager, String checkRelationGroupId, BgSchemeDimensionHelper schemeHelper) {
        final HashSet<String> formulas = new HashSet<String>();
        final HashMap clone = new HashMap();
        IFormulaProcessor processor = new IFormulaProcessor(){

            @Override
            public void process(String formula, String versionNumber, String scenarioNumber) {
                if (!StringUtils.isEmpty((String)formula)) {
                    formulas.add(formula);
                }
            }

            @Override
            public Map<Integer, String> getCloneMap() {
                return clone;
            }
        };
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            BgViewHelper.buildFormula(viewManager.getSheetManagers().get(s), processor, checkRelationGroupId, schemeHelper);
        }
        return formulas;
    }

    public static Set<String> buildFormula(IMbgSheetManager sheetManager, String checkRelationGroupId, BgSchemeDimensionHelper schemeHelper) {
        final HashSet<String> formulas = new HashSet<String>();
        final HashMap clone = new HashMap();
        IFormulaProcessor processor = new IFormulaProcessor(){

            @Override
            public void process(String formula, String versionNumber, String scenarioNumber) {
                if (!StringUtils.isEmpty((String)formula)) {
                    formulas.add(formula);
                }
            }

            @Override
            public Map<Integer, String> getCloneMap() {
                return clone;
            }
        };
        BgViewHelper.buildFormula(sheetManager, processor, checkRelationGroupId, schemeHelper);
        return formulas;
    }

    public static void buildFormula(IMbgSheetManager sheetManager, IFormulaProcessor processor, String checkRelationGroupId, BgSchemeDimensionHelper schemeHelper) {
        RelationUtils utils;
        List<String[]> combinas;
        if (processor == null) {
            return;
        }
        if (!StringUtils.isEmpty((String)checkRelationGroupId)) {
            boolean hasRelation = false;
            block0: for (int d = 0; d < sheetManager.getDimensionManager().getDimension().size(); ++d) {
                BgDimensionInfo dimension = (BgDimensionInfo)sheetManager.getDimensionManager().getDimension().get(d);
                if (!DimensionMemberValueModeEnum.RelationMapping.equals((Object)dimension.getMemberValueType())) continue;
                for (int r = 0; r < dimension.getMappingList().size(); ++r) {
                    if (!checkRelationGroupId.equals(dimension.getMappingList().get(r).getId().toString())) continue;
                    hasRelation = true;
                    break block0;
                }
            }
            if (!hasRelation) {
                return;
            }
        }
        if ((combinas = (utils = RelationUtils.getInstance(schemeHelper)).queryRelation(sheetManager.getViewManager().getRelationMaps(), sheetManager)) != null && combinas.size() == 1) {
            return;
        }
        HashMap<Integer, String> refNumber = new HashMap<Integer, String>();
        BgViewHelper.processDimension(sheetManager, 0, combinas, refNumber, processor);
    }

    private static void processDimension(IMbgSheetManager sheetManager, int index, List<String[]> combinas, Map<Integer, String> refNumber, IFormulaProcessor processor) {
        if (combinas != null && combinas.size() == 1) {
            return;
        }
        if (index >= sheetManager.getDimensionManager().getDimension().size()) {
            BgViewHelper.buildFormula(combinas, refNumber, processor);
        } else {
            BgDimensionInfo dimension = (BgDimensionInfo)sheetManager.getDimensionManager().getDimension().get(index);
            if (dimension.getMember().isEmpty()) {
                return;
            }
            if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) {
                String refField = dimension.getAttribute();
                if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
                    refField = DimensionConstants.DEF_CURRENCY_FIELD;
                } else if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
                    refField = DimensionConstants.DEF_PERIOD_FIELD;
                } else if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
                    refField = DimensionConstants.DEF_ELEMENT_FIELD;
                }
                boolean inRelation = false;
                if (combinas != null && combinas.size() > 1) {
                    String[] refFields = combinas.get(0);
                    for (int r = 0; r < refFields.length; ++r) {
                        if (!refField.equals(refFields[r])) continue;
                        inRelation = true;
                        break;
                    }
                }
                if (!inRelation) {
                    for (int m = 0; m < dimension.getMember().size(); ++m) {
                        BgDimensionMember member = (BgDimensionMember)dimension.getMember().get(m);
                        refNumber.put(DimensionCommonHelper.getField(refField), DimensionFormulaHelper.getCombination(member.getSrcNumberHasDefault(), member.getNumber()));
                        BgViewHelper.processDimension(sheetManager, index + 1, combinas, refNumber, processor);
                    }
                } else {
                    BgViewHelper.processDimension(sheetManager, index + 1, combinas, refNumber, processor);
                }
            } else {
                BgViewHelper.processDimension(sheetManager, index + 1, combinas, refNumber, processor);
            }
        }
    }

    private static void buildFormula(List<String[]> combinas, Map<Integer, String> refNumber, IFormulaProcessor processor) {
        if (combinas != null && combinas.size() > 1) {
            String[] refFields = combinas.get(0);
            for (int c = 1; c < combinas.size(); ++c) {
                String[] items = combinas.get(c);
                for (int r = 0; r < items.length; ++r) {
                    refNumber.put(DimensionCommonHelper.getField(refFields[r]), items[r]);
                }
                BgViewHelper.buildFormula(refNumber, processor);
            }
        } else {
            BgViewHelper.buildFormula(refNumber, processor);
        }
    }

    public static void buildFormula(Map<Integer, String> refNumber, IFormulaProcessor processor) {
        HashMap<Integer, String> clone = new HashMap<Integer, String>();
        clone.putAll(refNumber);
        String bgPeriodNumber = BgViewHelper.getMemberNumber((String)clone.remove(DimensionCommonHelper.getField(DimensionConstants.DEF_PERIOD_FIELD)));
        String bgElementNumber = BgViewHelper.getMemberNumber((String)clone.remove(DimensionCommonHelper.getField(DimensionConstants.DEF_ELEMENT_FIELD)));
        String currencyNumber = BgViewHelper.getMemberNumber((String)clone.remove(DimensionCommonHelper.getField(DimensionConstants.DEF_CURRENCY_FIELD)));
        String scenarioNumber = BgViewHelper.getMemberNumber((String)clone.remove(DimensionCommonHelper.getField(DimensionConstants.DEF_SCENARIO_FIELD)));
        String versionNumber = BgViewHelper.getMemberNumber((String)clone.remove(DimensionCommonHelper.getField(DimensionConstants.DEF_VERSION_FIELD)));
        String formula = BgViewHelper.parseItemFormula(bgElementNumber, currencyNumber, bgPeriodNumber, scenarioNumber, clone);
        processor.process(formula, versionNumber, scenarioNumber);
    }

    private static String getMemberNumber(String number) {
        if (StringUtils.isEmpty((String)number)) {
            return number;
        }
        if (number.indexOf(":") < 0) {
            return number;
        }
        return DimensionFormulaHelper.getMemberNumber(number);
    }

    public static String getBgFormName(CtrlUnitInfo cu, FullOrgUnitInfo orgUnit, BgTemplateInfo bgTemplateInfo, BgPeriodInfo bgPeriodInfo, BgVersionInfo bgVersionInfo, int maxLangth) {
        String name = null;
        name = new StringBuffer(bgPeriodInfo.getName()).append("-").append(bgTemplateInfo.getName()).append("-").append(bgVersionInfo.getName()).toString().trim();
        return name.length() > maxLangth ? name.substring(1, maxLangth) : name;
    }

    public static void replaceRelationVersion(List<MbgRelationMap> relationMaps, String sourceVersion, String targetVersion) {
        HashMap<String, String> replaceMembers = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)targetVersion)) {
            replaceMembers.put(DimensionConstants.DEF_VERSION_SRCNUMBER, targetVersion);
        }
        HashMap<String, String> sourceMembers = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)sourceVersion)) {
            sourceMembers.put(DimensionConstants.DEF_VERSION_SRCNUMBER, sourceVersion);
        }
        BgViewHelper.replaceRelation(relationMaps, sourceMembers, replaceMembers);
    }

    public static void replaceRelationCurrency(List<MbgRelationMap> relationMaps, String sourceCurrency, String targetCurrency) {
        HashMap<String, String> replaceMembers = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)targetCurrency)) {
            replaceMembers.put(DimensionConstants.DEF_CURRENCY_SRCNUMBER, targetCurrency);
        }
        HashMap<String, String> sourceMembers = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)sourceCurrency)) {
            sourceMembers.put(DimensionConstants.DEF_CURRENCY_SRCNUMBER, sourceCurrency);
        }
        BgViewHelper.replaceRelation(relationMaps, sourceMembers, replaceMembers);
    }

    public static void replaceRelation(List<MbgRelationMap> relationMaps, String versionNumber, String scenarioNumber) {
        HashMap<String, String> replaceMembers = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)versionNumber)) {
            replaceMembers.put(DimensionConstants.DEF_VERSION_SRCNUMBER, versionNumber);
        }
        if (!StringUtils.isEmpty((String)scenarioNumber)) {
            replaceMembers.put(DimensionConstants.DEF_SCENARIO_SRCNUMBER, scenarioNumber);
        }
        BgViewHelper.replaceRelation(relationMaps, null, replaceMembers);
    }

    public static void replaceRelation(List<MbgRelationMap> relationMaps, Map<String, String> sourceMembers, Map<String, String> replaceMembers) {
        if (relationMaps == null || relationMaps.isEmpty() || replaceMembers == null || replaceMembers.isEmpty()) {
            return;
        }
        if (sourceMembers == null) {
            sourceMembers = new HashMap<String, String>();
        }
        HashSet<String> relasions = new HashSet<String>();
        StringBuffer itemCom = new StringBuffer();
        for (int i = 0; i < relationMaps.size(); ++i) {
            MbgRelationMap relationMap = relationMaps.get(i);
            relasions.clear();
            for (int s = relationMap.getRelationShips().size() - 1; s >= 0; --s) {
                DimensionRelationshipInfo r = relationMap.getRelationShips().get(s);
                String item = r.getDimensionNumber();
                itemCom.setLength(0);
                String[] items = item.split(",");
                for (int m = 0; m < items.length; ++m) {
                    String srcNumber = DimensionFormulaHelper.getSrcNumber(items[m]);
                    String number = DimensionFormulaHelper.getMemberNumber(items[m]);
                    if (replaceMembers.containsKey(srcNumber)) {
                        if (!sourceMembers.containsKey(srcNumber) || number.equals(sourceMembers.get(srcNumber))) {
                            DimensionFormulaHelper.addItem(itemCom, srcNumber, replaceMembers.get(srcNumber));
                            continue;
                        }
                        DimensionFormulaHelper.addItem(itemCom, items[m]);
                        continue;
                    }
                    DimensionFormulaHelper.addItem(itemCom, items[m]);
                }
                if (relasions.contains(itemCom.toString())) {
                    relationMap.getRelationShips().removeObject(s);
                    continue;
                }
                r.setDimensionNumber(itemCom.toString());
                relasions.add(itemCom.toString());
            }
        }
    }

    public static void buildFormula(MbgViewListManager viewManager, IFormulaProcessor processor, BgSchemeDimensionHelper schemeHelper, BgDimensionMember queryMember) throws BOSException, EASBizException {
        if (processor == null || viewManager == null || schemeHelper == null) {
            return;
        }
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            BgViewHelper.buildFormula((MbgViewListSheetManager)viewManager.getSheetManagers().get(s), processor, schemeHelper, queryMember);
        }
    }

    public static void buildFormula(MbgViewListSheetManager sheetManager, IFormulaProcessor processor, BgSchemeDimensionHelper schemeHelper, BgDimensionMember queryMember) throws BOSException {
        if (processor == null) {
            return;
        }
        MbgViewListSheetManager sheet = DimensionCommonHelper.cloneSheetManager(sheetManager);
        if (queryMember != null) {
            BgViewHelper.filterMember(sheet, queryMember);
        }
        if (BgViewHelper.checkEmpty(sheet, schemeHelper)) {
            return;
        }
        HashMap<String, MBGRowData> mbgRowDatas = new HashMap<String, MBGRowData>();
        DimensionMemberRelationShipHelper.loadEffectiveItemCombin(orgNumber, sheetManager, schemeHelper, mbgRowDatas, true, false, false);
        ArrayList<Set<String>> membersList = new ArrayList<Set<String>>();
        HashMap<String, String> src_Numbers = new HashMap<String, String>();
        HashMap<String, String> src_refFields = new HashMap<String, String>();
        List<String> addDims = schemeHelper.getAllDim();
        String dimNumber2 = null;
        for (String dimNumber2 : addDims) {
            src_refFields.put(schemeHelper.getSrcNumber(dimNumber2), schemeHelper.getRefField(dimNumber2));
        }
        ArrayList<MbgViewListDimensionInfo> pageView = new ArrayList<MbgViewListDimensionInfo>();
        ArrayList<MbgViewListDimensionInfo> tempDims = new ArrayList<MbgViewListDimensionInfo>();
        pageView.addAll(sheet.getDimensionManager().getPageDimension());
        pageView.addAll(sheet.getDimensionManager().getViewDimension());
        if (sheetManager.getDimensionManager().getPageRelationMaps() != null && !sheetManager.getDimensionManager().getPageRelationMaps().isEmpty()) {
            HashSet<String> pageViewMembers = new HashSet<String>();
            BgViewHelper.buildDimMember(pageViewMembers, pageView, src_Numbers, schemeHelper, src_refFields, mbgRowDatas, "page", 0);
            BgViewHelper.addMembersToList(membersList, pageViewMembers);
        } else {
            for (int i = 0; i < pageView.size(); ++i) {
                HashSet<String> pageViewMembers = new HashSet<String>();
                tempDims.clear();
                tempDims.add((MbgViewListDimensionInfo)pageView.get(i));
                BgViewHelper.buildDimMember(pageViewMembers, tempDims, src_Numbers, schemeHelper, src_refFields, mbgRowDatas, "page", 0);
                BgViewHelper.addMembersToList(membersList, pageViewMembers);
            }
        }
        HashSet<String> rowMembers = new HashSet<String>();
        HashSet<String> colMembers = new HashSet<String>();
        BgViewHelper.buildRowCol(rowMembers, sheet.getDimensionManager().getRows(), src_Numbers, schemeHelper, src_refFields, mbgRowDatas, "row");
        BgViewHelper.buildRowCol(colMembers, sheet.getDimensionManager().getColumns(), src_Numbers, schemeHelper, src_refFields, mbgRowDatas, "col");
        BgViewHelper.addMembersToList(membersList, rowMembers);
        BgViewHelper.addMembersToList(membersList, colMembers);
        src_Numbers.clear();
        if (processor instanceof IViewListGroupProcessor) {
            ((IViewListGroupProcessor)processor).process(membersList, src_Numbers, src_refFields);
        } else {
            BgViewHelper.buildFormula(membersList, 0, src_Numbers, BgViewHelper.getDimSrcNumbers(schemeHelper), processor);
        }
    }

    private static void filterMember(MbgViewListSheetManager sheet, BgDimensionMember queryMember) {
        if (BgViewHelper.filterMember(sheet.getDimensionManager().getPageDimension(), queryMember)) {
            return;
        }
        if (BgViewHelper.filterMember(sheet.getDimensionManager().getViewDimension(), queryMember)) {
            return;
        }
        if (BgViewHelper.filterMember(sheet.getDimensionManager().getRowDimension(), sheet.getDimensionManager().getRows(), queryMember)) {
            return;
        }
        if (BgViewHelper.filterMember(sheet.getDimensionManager().getRowDimension(), sheet.getDimensionManager().getRows(), queryMember)) {
            return;
        }
    }

    private static boolean filterMember(List dimensions, List<IMbgViewListObject> rowCols, BgDimensionMember queryMember) {
        if (DimensionCommonHelper.searchDimension(queryMember.getType(), dimensions) == null) {
            return false;
        }
        IMbgViewListObject obj = null;
        MbgViewListRowCol rowCol = null;
        Iterator<IMbgViewListObject> it = rowCols.iterator();
        while (it.hasNext()) {
            obj = it.next();
            if (obj instanceof MbgViewListRowCol) {
                rowCol = (MbgViewListRowCol)obj;
                if (rowCol.isCombin()) {
                    BgViewHelper.filterCombinMember(rowCol.getCombinMembers(), queryMember);
                    if (!rowCol.getCombinMembers().isEmpty()) continue;
                    it.remove();
                    continue;
                }
                BgViewHelper.filterMember(rowCol.getDimensions(), queryMember);
                if (!BgViewHelper.checkEmpty(rowCol.getDimensions())) continue;
                it.remove();
                continue;
            }
            it.remove();
        }
        return true;
    }

    private static void filterCombinMember(List<BgDimensionMember> combinMembers, BgDimensionMember queryMember) {
        BgDimensionMember member = null;
        String[] srcNumbers = null;
        String[] numbers = null;
        String[] longNumbers = null;
        int index = -1;
        Iterator<BgDimensionMember> it = combinMembers.iterator();
        while (it.hasNext()) {
            member = it.next();
            index = -1;
            if (index < 0) {
                srcNumbers = DimensionFormulaHelper.splitCombinations(member.getSrcNumberHasDefault());
                for (int s = 0; s < srcNumbers.length; ++s) {
                    if (!srcNumbers[s].equals(queryMember.getSrcNumberHasDefault())) continue;
                    index = s;
                    break;
                }
            }
            if (index < 0 || (numbers = DimensionFormulaHelper.splitCombinations(member.getNumber()))[index].equals(queryMember.getNumber()) || (longNumbers = DimensionFormulaHelper.splitCombinations((String)((Object)member.getSortValue())))[index] != null && longNumbers[index].startsWith(queryMember.getSortValue() + "!")) continue;
            it.remove();
        }
    }

    private static boolean filterMember(List dimensions, BgDimensionMember queryMember) {
        String dimNumber = queryMember.getType();
        BgDimensionBaseInfo dimension = DimensionCommonHelper.searchDimension(dimNumber, dimensions);
        if (dimension != null) {
            BgViewHelper.filterMember(dimension, queryMember);
            return true;
        }
        return false;
    }

    private static void filterMember(BgDimensionBaseInfo dimension, BgDimensionMember queryMember) {
        BgDimensionMember member = null;
        Iterator it = dimension.getMember().iterator();
        while (it.hasNext()) {
            member = (BgDimensionMember)it.next();
            if (member.getNumber().equals(queryMember.getNumber()) || ((String)((Object)member.getSortValue())).startsWith(queryMember.getSortValue() + "!")) continue;
            it.remove();
        }
    }

    private static void addMembersToList(List<Set<String>> membersList, Set<String> members) {
        if (members != null && !members.isEmpty()) {
            membersList.add(members);
        }
    }

    private static boolean checkEmpty(MbgViewListSheetManager sheet, BgSchemeDimensionHelper schemeHelper) {
        if (BgViewHelper.checkEmpty(sheet.getDimensionManager().getPageDimension())) {
            return true;
        }
        if (BgViewHelper.checkEmpty(sheet.getDimensionManager().getViewDimension())) {
            return true;
        }
        if (BgViewHelper.checkRowColEmpty(sheet.getDimensionManager().getRows())) {
            return true;
        }
        return BgViewHelper.checkRowColEmpty(sheet.getDimensionManager().getColumns());
    }

    private static void buildDimMember(Set<String> members, List<MbgViewListDimensionInfo> dimensions, Map<String, String> src_Numbers, BgSchemeDimensionHelper schemeHelper, Map<String, String> src_refFields, Map<String, MBGRowData> mbgRowDatas, String layout, int layoutIndex) {
        BgViewHelper.buildDimMember(members, dimensions, 0, src_Numbers, schemeHelper, src_refFields, mbgRowDatas, layout, layoutIndex);
    }

    private static void buildDimMember(Set<String> members, List<MbgViewListDimensionInfo> dimensions, int index, Map<String, String> src_Numbers, BgSchemeDimensionHelper schemeHelper, Map<String, String> src_refFields, Map<String, MBGRowData> mbgRowDatas, String layout, int layoutIndex) {
        if (dimensions.isEmpty()) {
            return;
        }
        MbgViewListDimensionInfo dimension = dimensions.get(index);
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) {
            if (dimensions.size() == index + 1) {
                BgViewHelper.buildDimMemberItem(members, dimensions, src_Numbers, schemeHelper, src_refFields, mbgRowDatas, layout, layoutIndex);
            } else {
                BgViewHelper.buildDimMember(members, dimensions, index + 1, src_Numbers, schemeHelper, src_refFields, mbgRowDatas, layout, layoutIndex);
            }
        } else {
            BgDimensionMember member = null;
            for (int m = 0; m < dimension.getMember().size(); ++m) {
                member = (BgDimensionMember)dimension.getMember().get(m);
                src_Numbers.put(member.getSrcNumberHasDefault(), member.getNumber());
                if (dimensions.size() == index + 1) {
                    BgViewHelper.buildDimMemberItem(members, dimensions, src_Numbers, schemeHelper, src_refFields, mbgRowDatas, layout, layoutIndex);
                    continue;
                }
                BgViewHelper.buildDimMember(members, dimensions, index + 1, src_Numbers, schemeHelper, src_refFields, mbgRowDatas, layout, layoutIndex);
            }
        }
    }

    private static void buildDimMemberItem(Set<String> members, List<MbgViewListDimensionInfo> dimensions, Map<String, String> src_Numbers, BgSchemeDimensionHelper schemeHelper, Map<String, String> src_refFields, Map<String, MBGRowData> mbgRowDatas, String layout, int layoutIndex) {
        MBGRowData rowData = mbgRowDatas.get(DimensionMemberRelationShipHelper.getKey(orgNumber, layout, layoutIndex));
        if (rowData != null && rowData.hasRelation()) {
            String[] aMember = new String[src_Numbers.size()];
            String[] aReffield = new String[src_Numbers.size()];
            int index = 0;
            String srcNumber2 = null;
            for (String srcNumber2 : src_Numbers.keySet()) {
                aMember[index] = DimensionFormulaHelper.getCombination(srcNumber2, src_Numbers.get(srcNumber2));
                aReffield[index] = src_refFields.get(srcNumber2);
                ++index;
            }
            if (!rowData.isInRalation(aMember, aReffield)) {
                return;
            }
        }
        StringBuffer itemCom = new StringBuffer();
        for (int i = 0; i < dimensions.size(); ++i) {
            if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimensions.get(i).getNumber())) continue;
            if (itemCom.length() > 0) {
                itemCom.append(",");
            }
            itemCom.append(DimensionFormulaHelper.getCombination(schemeHelper.getSrcNumber(dimensions.get(i).getNumber()), src_Numbers.get(schemeHelper.getSrcNumber(dimensions.get(i).getNumber()))));
        }
        if (itemCom.length() > 0) {
            members.add(itemCom.toString());
        }
    }

    private static void buildRowCol(Set<String> members, List<IMbgViewListObject> rows, Map<String, String> src_Numbers, BgSchemeDimensionHelper schemeHelper, Map<String, String> src_refFields, Map<String, MBGRowData> mbgRowDatas, String layout) {
        MbgViewListRowCol row = null;
        StringBuffer newcombins = new StringBuffer();
        String[] combins = null;
        for (int i = 0; i < rows.size(); ++i) {
            if (!(rows.get(i) instanceof MbgViewListRowCol)) continue;
            row = (MbgViewListRowCol)rows.get(i);
            if (row.isCombin()) {
                for (int m = 0; m < row.getCombinMembers().size(); ++m) {
                    if (StringUtils.isEmpty((String)row.getCombinMembers().get(m).getCombNumber()) || row.getCombinMembers().get(m).getCombNumber().split(",").length != row.getDimensions().size()) continue;
                    if (row.getCombinMembers().get(m).getCombNumber().indexOf(DimensionFormulaHelper.getCombination(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, "")) >= 0) {
                        combins = DimensionFormulaHelper.splitCombinations(row.getCombinMembers().get(m).getCombNumber());
                        newcombins.setLength(0);
                        if (combins.length <= 1) continue;
                        for (int c = 0; c < combins.length; ++c) {
                            if (DimensionConstants.DEF_ORGUNIT_SRCNUMBER.equals(DimensionFormulaHelper.getSrcNumber(combins[c]))) continue;
                            if (newcombins.length() > 0) {
                                newcombins.append(",");
                            }
                            newcombins.append(combins[c]);
                        }
                        members.add(newcombins.toString());
                        continue;
                    }
                    members.add(row.getCombinMembers().get(m).getCombNumber());
                }
                continue;
            }
            BgViewHelper.buildDimMember(members, row.getDimensions(), src_Numbers, schemeHelper, src_refFields, mbgRowDatas, layout, row.getIndex());
        }
    }

    private static void buildFormula(List<Set<String>> membersList, int index, Map<String, String> src_Numbers, String[] srcNumbers, IFormulaProcessor processor) {
        if (membersList.isEmpty()) {
            return;
        }
        Set<String> members = membersList.get(index);
        Iterator<String> it = members.iterator();
        while (it.hasNext()) {
            String[] itemCom = null;
            itemCom = DimensionFormulaHelper.splitCombinations(it.next());
            for (int i = 0; i < itemCom.length; ++i) {
                src_Numbers.put(DimensionFormulaHelper.getSrcNumber(itemCom[i]), DimensionFormulaHelper.getMemberNumber(itemCom[i]));
            }
            if (membersList.size() == index + 1) {
                BgViewHelper.buildFormula(src_Numbers, srcNumbers, processor);
                continue;
            }
            BgViewHelper.buildFormula(membersList, index + 1, src_Numbers, srcNumbers, processor);
        }
    }

    private static void buildFormula(Map<String, String> src_Numbers, String[] srcNumbers, IFormulaProcessor processor) {
        String periodNumber = src_Numbers.get(DimensionConstants.DEF_PERIOD_SRCNUMBER);
        String elementNumber = src_Numbers.get(DimensionConstants.DEF_ELEMENT_SRCNUMBER);
        String currencyNumber = src_Numbers.get(DimensionConstants.DEF_CURRENCY_SRCNUMBER);
        String scenarioNumber = src_Numbers.get(DimensionConstants.DEF_SCENARIO_SRCNUMBER);
        String versionNumber = src_Numbers.get(DimensionConstants.DEF_VERSION_SRCNUMBER);
        StringBuffer itemNumber = new StringBuffer();
        for (int i = 0; i < srcNumbers.length; ++i) {
            if (itemNumber.length() > 0) {
                itemNumber.append(",");
            }
            itemNumber.append(DimensionFormulaHelper.getCombination(srcNumbers[i], src_Numbers.get(srcNumbers[i])));
        }
        processor.process(BgNFSHelper.getFormulaFromParam(itemNumber.toString(), periodNumber, elementNumber, currencyNumber, scenarioNumber), versionNumber, scenarioNumber);
    }

    public static String[] getDimSrcNumbers(BgSchemeDimensionHelper schemeHelper) {
        List<String> refFields = schemeHelper.getRefDims();
        ArrayList<Integer> intFields = new ArrayList<Integer>();
        for (int i = 0; i < refFields.size(); ++i) {
            intFields.add(DimensionCommonHelper.getField(refFields.get(i)));
        }
        Collections.sort(intFields);
        String[] srcNumbers = new String[intFields.size()];
        for (int i = 0; i < intFields.size(); ++i) {
            srcNumbers[i] = schemeHelper.getSrcNumberByRefField("F" + intFields.get(i));
        }
        return srcNumbers;
    }

    private static boolean checkRowColEmpty(List<IMbgViewListObject> rowCols) {
        return rowCols.isEmpty();
    }

    private static boolean checkEmpty(List dimensions) {
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!(dimensions.get(i) instanceof BgDimensionBaseInfo) || DimensionConstants.DEF_ORGUNIT_NUMBER.equals(((BgDimensionBaseInfo)dimensions.get(i)).getNumber()) || !((BgDimensionBaseInfo)dimensions.get(i)).getMember().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static void convertNPeriod(IMbgViewBase viewManager, BgPeriodInfo bgFormPeriod) throws BgPeriodException {
        if (viewManager == null || bgFormPeriod == null) {
            return;
        }
        BgDimensionBaseInfo periodDim = null;
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            periodDim = viewManager.getSheetManagers().get(s).getDimensionManager().searchDimension(DimensionConstants.DEF_PERIOD_NUMBER);
            if (periodDim == null) continue;
            for (int i = 0; i < periodDim.getMember().size(); ++i) {
                BgDimensionMember member = (BgDimensionMember)periodDim.getMember().get(i);
                String number = BgPeriodNVariableHelper.getBgPeriodByN((String)bgFormPeriod.getNumber(), (String)member.getNumber(), (int)bgFormPeriod.getPeriodType().getValue());
                member.setNumber(number);
            }
        }
    }

    public static void convertRelationNPeriod(IMbgViewBase viewManager, BgPeriodInfo bgPeriod) throws BgPeriodException {
        if (viewManager == null || bgPeriod == null) {
            return;
        }
        Object periodDim = null;
        if (viewManager instanceof MbgViewManagerImpl && ((MbgViewManagerImpl)viewManager).getRelationMaps() != null && !((MbgViewManagerImpl)viewManager).getRelationMaps().isEmpty()) {
            List<MbgRelationMap> relationMaps = ((MbgViewManagerImpl)viewManager).getRelationMaps();
            MbgRelationMap mbgRelationMap = null;
            for (int i = 0; i < relationMaps.size(); ++i) {
                mbgRelationMap = relationMaps.get(i);
                DimensionRelationshipCollection relationShips = mbgRelationMap.getRelationShips();
                String dimensionNumber = null;
                String dimensionName = null;
                DimensionRelationshipInfo dimensionRelationshipInfo = null;
                DimensionRelationshipCollection newRelationShips = new DimensionRelationshipCollection();
                HashSet<String> checkRepeat = new HashSet<String>();
                String newDimensionNumber = null;
                Object newDimensionName = null;
                for (int s = 0; s < relationShips.size(); ++s) {
                    dimensionRelationshipInfo = relationShips.get(s);
                    dimensionNumber = dimensionRelationshipInfo.getDimensionNumber();
                    dimensionName = dimensionRelationshipInfo.getDimensionName();
                    newDimensionNumber = dimensionNumber;
                    if (!StringUtils.isEmpty((String)dimensionNumber)) {
                        String[] arrayStrs = dimensionNumber.split(",");
                        for (int index = 0; index < arrayStrs.length; ++index) {
                            String memberNum = arrayStrs[index];
                            if (memberNum.indexOf(":") <= 0) continue;
                            String[] arr = memberNum.split(":");
                            String srcNum = arr[0];
                            String num = arr[1];
                            if (!DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(srcNum) || !BgPeriodNVariableHelper.checkCanConvert((String)num)) continue;
                            int targetPeriodType = bgPeriod.getPeriodType().getValue();
                            String targetPeriodNumber = bgPeriod.getNumber();
                            String newNumber = BgPeriodNVariableHelper.getBgPeriodByN((String)targetPeriodNumber, (String)num, (int)targetPeriodType);
                            newDimensionNumber = dimensionNumber.replace(memberNum, DimensionConstants.DEF_PERIOD_SRCNUMBER + ":" + newNumber);
                            dimensionRelationshipInfo.setDimensionNumber(newDimensionNumber);
                        }
                    }
                    if (checkRepeat.contains(newDimensionNumber)) continue;
                    checkRepeat.add(newDimensionNumber);
                    newRelationShips.add(dimensionRelationshipInfo);
                }
                if (newRelationShips.isEmpty()) continue;
                mbgRelationMap.getRelationShips().clear();
                mbgRelationMap.getRelationShips().addObjectCollection((IObjectCollection)newRelationShips);
            }
        }
    }

    public static void setPermission(IMbgViewManager viewManager, String permissionNumber) {
        if (viewManager != null && !StringUtils.isEmpty((String)permissionNumber)) {
            for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
                viewManager.getSheetManagers().get(s).getDimensionManager().setPermissionNumber(permissionNumber);
            }
        }
    }

    public static Map getOnOrgDataMap(Map bgDataMap) {
        Object[] objs;
        if (bgDataMap != null && bgDataMap.size() == 1 && (objs = bgDataMap.values().toArray())[0] instanceof Map) {
            return (Map)objs[0];
        }
        return bgDataMap;
    }

    public static void movePageDimensionsToRow(MbgViewListManager viewManager, boolean isMoveOrgFromPage) {
        if (viewManager == null) {
            return;
        }
        List sheetManagers = viewManager.getSheetManagers();
        for (int s = 0; s < sheetManagers.size(); ++s) {
            MbgViewListSheetManager sheetManager = (MbgViewListSheetManager)sheetManagers.get(s);
            BgViewHelper.movePageDimensionsToRow(sheetManager, isMoveOrgFromPage);
        }
    }

    public static void movePageDimensionsToRow(MbgViewListSheetManager sheetManager, boolean isMoveOrgFromPage) {
        if (sheetManager == null) {
            return;
        }
        HashSet<String> checkRepeat = new HashSet<String>();
        MbgViewListDimensionInfo dim = null;
        List<IMbgViewListObject> rows = sheetManager.getDimensionManager().getRows();
        List pageDimensions = sheetManager.getDimensionManager().getPageDimension();
        List rowDimensions = sheetManager.getDimensionManager().getRowDimension();
        if (!pageDimensions.isEmpty()) {
            ArrayList<MbgViewListDimensionInfo> newDims = null;
            MbgViewListDimensionInfo cloneDim = null;
            for (int i = 0; i < rows.size(); ++i) {
                int d;
                if (rows.get(i) instanceof MbgViewListRowCol) {
                    MbgViewListRowCol rowObj = (MbgViewListRowCol)rows.get(i);
                    newDims = new ArrayList<MbgViewListDimensionInfo>();
                    for (int j = 0; j < pageDimensions.size(); ++j) {
                        dim = (MbgViewListDimensionInfo)pageDimensions.get(j);
                        if (dim == null) continue;
                        cloneDim = dim.clone();
                        cloneDim.getMember().clear();
                        cloneDim.getMember().addAll(dim.getMember());
                        newDims.add(cloneDim);
                    }
                    rowObj.getDimensions().addAll(newDims);
                }
                if (newDims == null) continue;
                for (d = newDims.size() - 1; d >= 0; --d) {
                    dim = (MbgViewListDimensionInfo)newDims.get(d);
                    if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber()) || checkRepeat.contains(dim.getNumber())) continue;
                    checkRepeat.add(dim.getNumber());
                    rowDimensions.add(0, dim);
                }
                for (d = newDims.size() - 1; d >= 0; --d) {
                    dim = (MbgViewListDimensionInfo)newDims.get(d);
                    if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber()) || checkRepeat.contains(dim.getNumber())) continue;
                    checkRepeat.add(dim.getNumber());
                    rowDimensions.add(0, dim);
                }
                newDims.clear();
            }
            for (int k = pageDimensions.size() - 1; k >= 0; --k) {
                dim = (MbgViewListDimensionInfo)pageDimensions.get(k);
                if (isMoveOrgFromPage) {
                    if (dim == null || !DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) continue;
                    pageDimensions.remove(dim);
                    continue;
                }
                if (dim == null || DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) continue;
                pageDimensions.remove(dim);
            }
        }
    }

    public static void movePageDimensionsToRow(IMbgViewManager curMbgViewManager, boolean isMoveDimension) {
        List<IMbgSheetManager> sheetManagers = curMbgViewManager.getSheetManagers();
        int pvCount = -1;
        int orgIndex = -1;
        ArrayList<IDimensionColumn> otherColumns = new ArrayList<IDimensionColumn>();
        IDimensionColumn otherColumn = null;
        for (int index = 0; index < sheetManagers.size(); ++index) {
            IMbgSheetManager sheetManager = sheetManagers.get(index);
            IBgDimensionManager dimensionManager = sheetManager.getDimensionManager();
            pvCount = dimensionManager.getViewDisplayDimension().size() + dimensionManager.getPageDisplayDimension().size();
            orgIndex = -1;
            ArrayList viewDisplayDimension = new ArrayList(dimensionManager.getViewDisplayDimension());
            ArrayList pageDisplayDimension = new ArrayList(dimensionManager.getPageDisplayDimension());
            ArrayList rowDisplayDimension = new ArrayList(dimensionManager.getRowDisplayDimension());
            dimensionManager.getPageDisplayDimension().clear();
            dimensionManager.getRowDisplayDimension().clear();
            dimensionManager.getRowDisplayDimension().addAll(viewDisplayDimension);
            dimensionManager.getRowDisplayDimension().addAll(pageDisplayDimension);
            dimensionManager.getRowDisplayDimension().addAll(rowDisplayDimension);
            List newRows = dimensionManager.getRowDisplayDimension();
            BgDimensionInfo info = null;
            for (int i = newRows.size() - 1; i >= 0; --i) {
                info = (BgDimensionInfo)newRows.get(i);
                if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(info.getNumber()) || isMoveDimension) continue;
                newRows.remove(info);
                orgIndex = i;
                dimensionManager.getViewDisplayDimension().add(info);
            }
            otherColumns.clear();
            otherColumns.addAll(dimensionManager.getAttributeCol());
            otherColumns.addAll(dimensionManager.getCalcuteCol());
            otherColumns.addAll(dimensionManager.getDescriptionCol());
            for (int o = 0; o < otherColumns.size(); ++o) {
                if (!(otherColumns.get(o) instanceof IDimensionColumn)) continue;
                otherColumn = (IDimensionColumn)otherColumns.get(o);
                otherColumn.setIndex(otherColumn.getIndex() + pvCount);
                if (orgIndex < 0 || otherColumn.getIndex() <= orgIndex) continue;
                otherColumn.setIndex(otherColumn.getIndex() - 1);
            }
        }
    }

    public static interface IViewListGroupProcessor
    extends IFormulaProcessor {
        public void process(List<Set<String>> var1, Map<String, String> var2, Map<String, String> var3) throws BOSException;
    }

    public static interface IFormulaProcessor {
        public void process(String var1, String var2, String var3);

        public Map<Integer, String> getCloneMap();
    }
}

