/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.utils.BgElementCollObject;
import com.kingdee.eas.ma.base.utils.BgElementHelper;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.client.MBGFormProcessUI;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormProvider;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BudgetDisplayValueProvider
implements IDisplayValueProvider {
    private static final Logger logger = Logger.getLogger(BudgetDisplayValueProvider.class);
    private static String BGFORMULA = "bgformula";
    private static String BGACTUALS = "bgactuals";
    private static String BGBALANCE = "bgbal";
    private static String BGRPTDATE = "=bgRptDate";
    private static String RPTDATE = "=rptDate";
    protected Component ui = null;
    private Map measureUnitMap = null;
    private Map currencyMap = null;
    private Map formulaMap = null;
    private BigDecimal coefficient = null;
    private int precision = -1;
    private int displayMode = 0;
    private Map<String, BgElementInfo> elementObjMap = null;

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(int displayMode) {
        this.displayMode = displayMode;
    }

    private BudgetDisplayValueProvider() {
    }

    public BudgetDisplayValueProvider(Component component) {
        this.ui = component;
    }

    public BigDecimal getCoefficient() {
        if (this.coefficient != null) {
            return this.coefficient;
        }
        if (this.ui != null) {
            Method method = null;
            try {
                method = this.ui.getClass().getMethod("getEditData", null);
                if (method != null) {
                    MeasureUnitInfo mu;
                    IObjectValue model = (IObjectValue)method.invoke((Object)this.ui, null);
                    if (model != null && model instanceof BgFormInfo) {
                        MeasureUnitInfo mu2 = ((BgFormInfo)model).getMeasureUnit();
                        if (mu2 != null) {
                            this.coefficient = mu2.getCoefficient();
                            return this.coefficient;
                        }
                    } else if (model != null && model instanceof BgActualRecordInfo && (mu = ((BgActualRecordInfo)model).getMeasureUnit()) != null) {
                        this.coefficient = mu.getCoefficient();
                        return this.coefficient;
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
        return BgNConstants.ONE;
    }

    public void setCoefficient(BigDecimal coefficient) {
        this.coefficient = coefficient;
    }

    public int getPrecision() {
        if (this.precision != -1) {
            return this.precision;
        }
        this.precision = 3;
        if (this.ui != null) {
            Method method = null;
            try {
                IObjectValue model;
                method = this.ui.getClass().getMethod("getEditData", null);
                if (method != null && (model = (IObjectValue)method.invoke((Object)this.ui, null)) != null && model instanceof BgFormInfo) {
                    this.precision = ((BgFormInfo)model).getCurrency().getPrecision();
                }
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
        return this.precision;
    }

    public Map getMeasureUnitMap() {
        if (this.measureUnitMap != null) {
            return this.measureUnitMap;
        }
        if (this.ui != null) {
            Method method = null;
            try {
                method = this.ui.getClass().getMethod("getMeasureUnitMap", null);
                if (method != null) {
                    this.measureUnitMap = (Map)method.invoke((Object)this.ui, null);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
        if (this.measureUnitMap == null) {
            this.measureUnitMap = new HashMap();
        }
        return this.measureUnitMap;
    }

    public Map getCurrencyMap() {
        if (this.currencyMap != null) {
            return this.currencyMap;
        }
        if (this.ui != null) {
            Method method = null;
            try {
                method = this.ui.getClass().getMethod("getCurrencyMap", null);
                if (method != null) {
                    this.currencyMap = (Map)method.invoke((Object)this.ui, null);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
        if (this.currencyMap == null) {
            this.currencyMap = new HashMap();
        }
        return this.currencyMap;
    }

    public Map getFormulaMap() {
        if (this.formulaMap != null) {
            return this.formulaMap;
        }
        if (this.ui != null) {
            Method method = null;
            try {
                method = this.ui.getClass().getMethod("getFormulaMap", null);
                if (method != null) {
                    this.formulaMap = (Map)method.invoke((Object)this.ui, null);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
        if (this.formulaMap == null) {
            this.formulaMap = new HashMap();
        }
        return this.formulaMap;
    }

    public Map<String, BgElementInfo> getElementObjMap() {
        if (this.elementObjMap == null) {
            try {
                this.elementObjMap = BgElementHelper.getElementoObjMap();
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        return this.elementObjMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getDisplayValue(Cell cell, int viewMode) {
        if (cell == null) return null;
        StyleAttributes sa = Styles.getEmptySA();
        cell.getSheet().getRange(cell).getStyle(sa);
        if (sa.isHided()) {
            return "";
        }
        if (viewMode == 0) {
            if (BgNFSHelper.checkIsEmptyValue(cell)) return null;
            if (cell.getValue().getValue() instanceof GregorianCalendar) {
                return cell.getText();
            }
            String _text = cell.getText();
            Object obj = cell.getValue().getValue();
            if (StringUtils.isEmpty((String)_text)) return null;
            if (obj instanceof SyntaxErrorException) {
                Object obj1 = cell.getSheet().getBook().getUserObjectValue("ERRORHANDLER");
                if (!(obj1 instanceof ReportCalculateErrorProvider)) return _text;
                ReportCalculateErrorProvider rcep = (ReportCalculateErrorProvider)obj1;
                if (((SyntaxErrorException)((Object)obj)).getErrorCode() == 2L) {
                    return rcep.getZeroDivDisplayAs();
                }
                if (((SyntaxErrorException)((Object)obj)).getErrorCode() != 128L) return _text;
                return rcep.getExceptionReplacer();
            }
            if (BgNFSHelper.checkHasPercentage(cell)) {
                String text = cell.getText();
                if (text == null || text.endsWith("%") || BgNFSHelper.checkHasFormulaOfCell(cell)) return cell.getText();
                int precision = BgNFSHelper.getDigitOfNumber(cell, 0);
                BigDecimal textVal = null;
                try {
                    textVal = new BigDecimal(text);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (textVal == null) {
                    return cell.getText();
                }
                String numberFormat = null;
                numberFormat = precision == 0 ? "0" + BgNFSHelper.getNumberFormat("0", precision) + "%" : "0." + BgNFSHelper.getNumberFormat("0", precision) + "%";
                DecimalFormat format = new DecimalFormat(numberFormat);
                return format.format(textVal);
            }
            if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                String _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                if (!this.getMeasureUnitMap().isEmpty()) return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
            }
            if (BgNFSHelper.checkHasGatFormulaOfCell(cell)) {
                String _formulaStr = BgNFSHelper.getGatFormulaOfCell(cell);
                if (!this.getMeasureUnitMap().isEmpty()) return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
            }
            if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                String showStr;
                if (obj instanceof String) {
                    return _text;
                }
                if ("0".equals(obj) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
                    return showStr;
                }
                if (cell.hasFormula() && (cell.getFormula().startsWith(BGRPTDATE) || cell.getFormula().startsWith(RPTDATE))) {
                    return this.getFormulaMeasureUnitDisplayValue(cell, obj);
                }
                int _precision = BgNFSHelper.getDigitOfNumber(cell, this.getPrecision());
                if (!MBgTemplateHelper.isSubTotalRow(cell.getSheet().getRow(cell.getRow(), false)) && !MBgTemplateHelper.isDimTotalRow(cell.getSheet().getRow(cell.getRow(), false))) return this.getDisplayValue(obj, this.getCoefficient(), _precision);
                BigDecimal coefficient = this.getCoefficientBySubRow(cell);
                if (coefficient != null) return this.getDisplayValue(obj, coefficient, _precision);
                coefficient = this.getCoefficient();
                return this.getDisplayValue(obj, coefficient, _precision);
            }
            if (!(StringUtils.isEmpty((String)BgNFSHelper.getExpression(cell)) || BgNFSHelper.getExpression(cell).toUpperCase().indexOf("MBGRPTDATE") <= 0 && BgNFSHelper.getExpression(cell).toUpperCase().indexOf("MBGCREATEDATE") <= 0 && BgNFSHelper.getExpression(cell).toUpperCase().indexOf("RPTDATE") <= 0)) {
                if (obj instanceof String) {
                    return _text;
                }
                if (!(obj instanceof BigDecimal)) return null;
                return this.getDefMeasureUnitDisplayValue(cell, obj);
            }
            if (BgNTemplateHelper.getBgDataValue(cell, "bgFillType") == null || !BgNFSHelper.checkHasTextOfCell(cell)) return this.getDefMeasureUnitDisplayValue(cell, obj);
            return _text;
        }
        if (viewMode == 1) {
            Object obj;
            if (cell.hasFormula()) {
                return cell.getFormula();
            }
            if (BgNFSHelper.checkIsEmptyValue(cell) || (obj = cell.getValue().getValue()) == null) return null;
            if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                String _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                if (!this.getMeasureUnitMap().isEmpty()) return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
            }
            if (!BgNFSHelper.checkHasGatFormulaOfCell(cell)) return this.getDefMeasureUnitDisplayValue(cell, obj);
            String _formulaStr = BgNFSHelper.getGatFormulaOfCell(cell);
            if (!this.getMeasureUnitMap().isEmpty()) return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
            return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
        }
        if (viewMode != 10) return null;
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            return BgNFSHelper.getDisplayFormula(BgNFSHelper.getFormulaOfCell(cell), this.getFormulaMap());
        }
        if (BgNFSHelper.checkIsEmptyValue(cell)) return null;
        Object obj = cell.getValue().getValue();
        if (!BgNFSHelper.checkHasExpression(cell)) return this.getDefMeasureUnitDisplayValue(cell, obj);
        return this.getFormulaMeasureUnitDisplayValue(cell, obj);
    }

    private BigDecimal getCoefficientBySubRow(Cell cell) {
        if (cell == null || !(this.ui instanceof MBGFormProcessUI)) {
            return null;
        }
        MBGFormProcessUI processUi = (MBGFormProcessUI)((Object)this.ui);
        MBGFormProvider provider = (MBGFormProvider)processUi.getContextManager().getProvider();
        String bgElementNumber = null;
        List<KDPromptBox> f7Page = provider.getBookParseHelper().getPageF7List(cell.getSheet().getSheetIndex());
        List<KDPromptBox> f7View = provider.getBookParseHelper().getViewF7List(cell.getSheet().getSheetIndex());
        ArrayList<KDPromptBox> f7s = new ArrayList<KDPromptBox>();
        if (f7Page != null) {
            f7s.addAll(f7Page);
        }
        if (f7View != null) {
            f7s.addAll(f7View);
        }
        for (int i = 0; i < f7s.size(); ++i) {
            BgElementCollObject obj;
            if (((KDPromptBox)f7s.get(i)).getData() instanceof BgElementInfo) {
                bgElementNumber = ((BgElementInfo)((KDPromptBox)f7s.get(i)).getData()).getNumber();
                break;
            }
            if (!(((KDPromptBox)f7s.get(i)).getData() instanceof BgElementCollObject) || (obj = (BgElementCollObject)((KDPromptBox)f7s.get(i)).getData()).getResult().isEmpty()) continue;
            bgElementNumber = obj.getResult().get(0).getNumber();
        }
        if (bgElementNumber == null) {
            Column col;
            List _obj;
            ArrayList members = new ArrayList();
            Row row = cell.getSheet().getRow(cell.getRow(), false);
            List list = _obj = row == null ? null : (List)row.getUserObjectValue("DIMENSION");
            if (_obj != null) {
                members.addAll(_obj);
            }
            List list2 = _obj = (col = cell.getSheet().getColumn(cell.getCol(), false)) == null ? null : (List)col.getUserObjectValue("DIMENSION");
            if (_obj != null) {
                members.addAll(_obj);
            }
            for (int i = 0; i < members.size(); ++i) {
                if (!DimensionConstants.DEF_ELEMENT_NUMBER.equals(((BgDimensionMember)members.get(i)).getType())) continue;
                bgElementNumber = ((BgDimensionMember)members.get(i)).getNumber();
                break;
            }
        }
        if (bgElementNumber != null && this.getMeasureUnitMap().containsKey(bgElementNumber)) {
            return this.getCoefficent(this.getMeasureUnitMap().get(bgElementNumber));
        }
        return this.getCoefficient();
    }

    protected Object getMeasureUnitDisplayValue(Cell cell, String formulaStr, Object obj, boolean useMeasureUnit) {
        String showStr;
        if ("0".equals(obj.toString()) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
            return showStr;
        }
        String[] _parameter = null;
        CurrencyInfo _currencyInfo = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        String cellStyle = cell.getDisplayStyle().getNumberFormat();
        _parameter = BgNFSHelper.parseFormulaPara(this.getFormulaMap(), formulaStr);
        if (_parameter != null) {
            if (_parameter.length == 6) {
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = this.getCoefficent(this.getMeasureUnitMap().get(_parameter[2]));
                }
                if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                    _precision = _currencyInfo.getPrecision();
                }
            } else if (_parameter.length == 4) {
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = this.getCoefficent(this.getMeasureUnitMap().get(_parameter[2]));
                }
                if (!StringUtils.isEmpty((String)_parameter[4]) && this.getCurrencyMap().containsKey(_parameter[4])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[4]);
                    _precision = _currencyInfo.getPrecision();
                }
            }
        }
        _precision = BgNFSHelper.getDigitOfNumber(cell, _precision);
        return this.getDisplayValue(cellStyle, obj, _coefficient, _precision);
    }

    public Object getMeasureUnitDisplayValue(ICell cell, String formulaStr, Object obj, boolean useMeasureUnit, String bgAccountNumber) {
        if (cell == null || StringUtils.isEmpty((String)formulaStr) || obj == null) {
            return null;
        }
        String[] _parameter = null;
        CurrencyInfo _currencyInfo = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        _parameter = BgNFSHelper.parseFormulaPara(formulaStr);
        if (_parameter != null) {
            if (_parameter.length == 6) {
                BgElementInfo eleInfo;
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = this.getCoefficent(this.getMeasureUnitMap().get(_parameter[2]));
                }
                if (!StringUtils.isEmpty((String)_parameter[2]) && this.getElementObjMap().containsKey(_parameter[2]) && (eleInfo = this.getElementObjMap().get(_parameter[2])).getDataType().getValue() == 3) {
                    _coefficient = BgNConstants.ONE;
                }
                if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                    _precision = _currencyInfo.getPrecision();
                }
            } else if (_parameter.length == 4) {
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = this.getCoefficent(this.getMeasureUnitMap().get(_parameter[2]));
                }
                if (!StringUtils.isEmpty((String)_parameter[4]) && this.getCurrencyMap().containsKey(_parameter[4])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[4]);
                    _precision = _currencyInfo.getPrecision();
                }
            }
        }
        return this.getDisplayValue(obj, _coefficient, _precision);
    }

    public BigDecimal getCoefficent(Object measureUnit) {
        if (measureUnit instanceof BigDecimal) {
            return (BigDecimal)measureUnit;
        }
        if (measureUnit instanceof MeasureUnitInfo) {
            return ((MeasureUnitInfo)measureUnit).getCoefficient();
        }
        return BgNConstants.ONE;
    }

    protected Object getFormulaMeasureUnitDisplayValue(Cell cell, Object obj) {
        String showStr;
        if ("0".equals(obj) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
            return showStr;
        }
        Expression _expression = null;
        Object _obj = null;
        String _expressions = BgNFSHelper.getExpression(cell);
        try {
            _expression = ExcelFormulaPaserHelper.parse((String)_expressions);
        }
        catch (Exception ex) {
            _obj = obj;
        }
        _obj = this.getFormulaMeasureUnitDisplayValue(_expression, cell, obj);
        if (_obj == null) {
            _obj = this.getDefMeasureUnitDisplayValue(cell, obj);
        }
        return _obj;
    }

    protected Object getFormulaMeasureUnitDisplayValue(Expression expression, Cell cell, Object obj) {
        if (expression == null) {
            return null;
        }
        Object _obj = null;
        CurrencyInfo _currencyInfo = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        if (expression instanceof FunctionExpr) {
            String _funcionName = ((FunctionExpr)expression).funcionName;
            if (BGFORMULA.equalsIgnoreCase(_funcionName) || BGACTUALS.equalsIgnoreCase(_funcionName) || BGBALANCE.equalsIgnoreCase(_funcionName)) {
                StringExpr _bgelement = (StringExpr)((FunctionExpr)expression).parameters.get(2);
                StringExpr _currency = (StringExpr)((FunctionExpr)expression).parameters.get(4);
                if (this.getMeasureUnitMap().containsKey(_bgelement.value)) {
                    _coefficient = this.getCoefficent(this.getMeasureUnitMap().get(_bgelement.value));
                }
                if (this.getCurrencyMap().containsKey(_currency.value)) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_currency.value);
                    _precision = _currencyInfo.getPrecision();
                }
                _obj = this.getDisplayValue(obj, _coefficient, _precision);
            }
        } else if (expression instanceof BinaryOperationExpr) {
            _obj = this.getFormulaMeasureUnitDisplayValue(((BinaryOperationExpr)expression).left, cell, obj);
            if (obj == null) {
                _obj = this.getFormulaMeasureUnitDisplayValue(((BinaryOperationExpr)expression).right, cell, obj);
            }
        }
        return _obj;
    }

    protected Object getDefMeasureUnitDisplayValue(Cell cell, Object obj) {
        String showStr;
        if (!BgNFSHelper.checkHasNumbericOfCell(cell) || !BgNFSHelper.checkIsNumericOfCell(cell)) {
            return cell.getText();
        }
        if ("0".equals(obj.toString()) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
            return showStr;
        }
        String cellStyle = cell.getDisplayStyle().getNumberFormat();
        String _text = null;
        int _precision = this.getPrecision();
        try {
            _precision = BgNFSHelper.getDigitOfNumber(cell, _precision);
            _text = this.getDisplayValue(cellStyle, obj, this.getCoefficient(), _precision);
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }

    protected String getDisplayValue(Object obj, BigDecimal coefficient, int precision) {
        String _text = null;
        BigDecimal _value = null;
        DecimalFormat _decFormat = null;
        try {
            _value = new BigDecimal(obj.toString().trim().replaceAll(",", "")).divide(coefficient, precision, 4);
            _decFormat = precision != 0 ? new DecimalFormat("#,##0." + BgNFSHelper.getNumberFormat("0", precision)) : new DecimalFormat("#,##0");
            _text = _decFormat.format(_value.doubleValue());
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }

    protected String getDisplayValue(String cellStyle, Object obj, BigDecimal coefficient, int precision) {
        String _text = null;
        BigDecimal _value = null;
        DecimalFormat _decFormat = null;
        Object nf = null;
        try {
            String coefficientStyle = "0\".\"0";
            boolean flag = cellStyle != null && cellStyle.contains(coefficientStyle);
            _value = !flag ? this.dealValueWithDispalyMode(obj, coefficient, precision) : new BigDecimal(obj.toString());
            if (cellStyle != null) {
                try {
                    _text = Formats.getFormat((String)cellStyle).format(new Variant((Object)_value)).toString();
                }
                catch (Exception e) {
                    _decFormat = BgNationalFormatUIUtil.getDecimalFormat((int)precision);
                    _text = _decFormat.format(_value.doubleValue());
                }
            } else {
                _decFormat = precision != 0 ? new DecimalFormat("#,##0." + BgNFSHelper.getNumberFormat("0", precision)) : new DecimalFormat("#,##0");
                _text = _decFormat.format(_value.doubleValue());
            }
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        _text = this.dealUnitWithDispalyMode(_text);
        return _text;
    }

    protected BigDecimal dealValueWithDispalyMode(Object obj, BigDecimal coefficient, int precision) {
        BigDecimal _value = null;
        switch (this.displayMode) {
            case 1: 
            case 2: {
                _value = new BigDecimal(obj.toString().trim().replaceAll(",", "")).divide(new BigDecimal(1000), precision, 4);
                break;
            }
            case 3: 
            case 4: {
                _value = new BigDecimal(obj.toString().trim().replaceAll(",", "")).divide(new BigDecimal(10000), precision, 4);
                break;
            }
            default: {
                _value = new BigDecimal(obj.toString().trim().replaceAll(",", "")).divide(coefficient, precision, 4);
            }
        }
        return _value;
    }

    protected String dealUnitWithDispalyMode(String _text) {
        String text = null;
        switch (this.displayMode) {
            case 1: {
                String thousand = EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"thousand");
                if (_text.contains(thousand)) break;
                text = _text + "(" + EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"thousand") + ")";
                break;
            }
            case 3: {
                String tenThousand = EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"tenThousand");
                if (_text.contains(tenThousand)) break;
                text = _text + "(" + EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"tenThousand") + ")";
                break;
            }
            default: {
                text = _text;
            }
        }
        return text;
    }
}

