/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MetaDataFacadeFactory;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgLocaleHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormEntryFactory;
import com.kingdee.eas.ma.mbg.BgFormEntryInfo;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgViewDimensionFactory;
import com.kingdee.eas.ma.mbg.BgViewDimensionInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.DimensionSourceCollection;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.app.utils.MbgViewListFormServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IDimensionColumn;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class DimensionCommonHelper {
    private static Logger logger = Logger.getLogger((String)DimensionCommonHelper.class.getName());
    public static final String DIM_NUMBER = "dimNumber";
    public static final String DIM_NAME = "dimName";
    public static final String resource = "com.kingdee.eas.ma.mbg.DimensionCommonResource";
    public static final String DEFAULT_PROPERTY_NUMBER = "P01";
    public static final String DEFAULT_PROPERTY_NAME = "P02";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String GeneralAsstActType = "GeneralAsstActType";
    private static Map clientResource = null;

    public static String getDefaultProperty(String properNumber) {
        if (DEFAULT_PROPERTY_NUMBER.equals(properNumber)) {
            return NUMBER;
        }
        if (DEFAULT_PROPERTY_NAME.equals(properNumber)) {
            return NAME;
        }
        return null;
    }

    public static String getDefaultProperty(String entityName, String properNumber) {
        if (DEFAULT_PROPERTY_NUMBER.equals(properNumber)) {
            if (GeneralAsstActType.equalsIgnoreCase(entityName)) {
                return "longnumber";
            }
            return NUMBER;
        }
        if (DEFAULT_PROPERTY_NAME.equals(properNumber)) {
            return NAME;
        }
        return null;
    }

    public static String getString(Context ctx, String key, Locale locale) throws BOSException, EASBizException {
        if (ctx == null) {
            if (clientResource == null) {
                HashSet<String> keys = new HashSet<String>();
                keys.add(DEFAULT_PROPERTY_NUMBER);
                keys.add(DEFAULT_PROPERTY_NAME);
                clientResource = MetaDataFacadeFactory.getRemoteInstance().getString(resource, keys, BgLocaleHelper.locales);
            }
            if (locale == null) {
                locale = SysContext.getSysContext().getLocale();
            }
            if (clientResource.containsKey(key + "_" + locale)) {
                return (String)clientResource.get(key + "_" + locale);
            }
            return EASResource.getString((String)resource, (String)key);
        }
        if (locale == null) {
            locale = ctx.getLocale();
        }
        return ResourceBase.getString((String)resource, (String)key, (Locale)locale);
    }

    public static boolean isEmpty(Object obj) {
        return BgCommHelper.isEmpty((Object)obj);
    }

    public static BufferedImage readImage(String fileName) throws IOException {
        BufferedImage image = null;
        try (InputStream is = null;){
            is = DimensionCommonHelper.class.getClassLoader().getResourceAsStream(fileName);
            image = ImageIO.read(is);
        }
        return image;
    }

    public static Integer getField(String refField) {
        if (StringUtils.isEmpty((String)refField)) {
            return null;
        }
        return Integer.valueOf(refField.substring(1));
    }

    public static IMbgViewBase getBgFormView(Context ctx, BgFormInfo bgFormInfo) throws BOSException, EASBizException {
        IMbgViewBase view = null;
        CoreBaseCollection col = null;
        BgTemFormTypeEnum formType = null;
        if (bgFormInfo.getBgTemplate() != null) {
            BgTemplateInfo bgTemplateInfo = null;
            bgTemplateInfo = ctx != null ? BgTemplateFactory.getLocalInstance(ctx).getBgTemplateInfo("select id, formType where id = '" + bgFormInfo.getBgTemplate().getId().toString() + "'") : BgTemplateFactory.getRemoteInstance().getBgTemplateInfo("select id, formType where id = '" + bgFormInfo.getBgTemplate().getId().toString() + "'");
            if (bgTemplateInfo != null) {
                formType = bgTemplateInfo.getFormType();
            }
        }
        if (formType == null) {
            col = ctx != null ? BgFormFactory.getLocalInstance(ctx).getCollection("select bgTemplate.formType where id = '" + bgFormInfo.getId() + "'") : BgFormFactory.getRemoteInstance().getCollection("select bgTemplate.formType where id = '" + bgFormInfo.getId() + "'");
            if (col == null || col.isEmpty()) {
                return null;
            }
            formType = ((BgFormInfo)col.get(0)).getBgTemplate().getFormType();
        }
        byte[] bytes = null;
        byte[] sBytes = null;
        col = ctx != null ? BgFormEntryFactory.getLocalInstance(ctx).getCollection("select dimensionData, dimensionStyle where bgForm.id = '" + bgFormInfo.getId() + "'") : BgFormEntryFactory.getRemoteInstance().getCollection("select dimensionData, dimensionStyle where bgForm.id = '" + bgFormInfo.getId() + "'");
        if (col != null && !col.isEmpty()) {
            bytes = ((BgFormEntryInfo)col.get(0)).getDimensionData();
            sBytes = ((BgFormEntryInfo)col.get(0)).getDimensionStyle();
        } else {
            col = ctx != null ? BgViewDimensionFactory.getLocalInstance(ctx).getCollection("select data where template.id = '" + bgFormInfo.getBgTemplate().getId() + "'") : BgViewDimensionFactory.getRemoteInstance().getCollection("select data where template.id = '" + bgFormInfo.getBgTemplate().getId() + "'");
            if (col != null && !col.isEmpty()) {
                bytes = ((BgViewDimensionInfo)col.get(0)).getData();
            }
        }
        try {
            if (BgTemFormTypeEnum.VIEWFORM.equals((Object)formType) || BgTemFormTypeEnum.FIXEDFORM.equals((Object)formType) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)formType)) {
                view = new MbgXMLParser(ctx).parse(bytes, sBytes);
                DimensionCommonHelper.fillDefaultMembers(bgFormInfo.getCurrency(), bgFormInfo.getBgPeriod(), bgFormInfo.getBgVersion(), (IMbgViewManager)view, formType);
                DimensionCommonHelper.convertPeriodNParam(bgFormInfo.getBgPeriod(), (IMbgViewManager)view);
                if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)formType)) {
                    DimensionCommonHelper.putSpecialDimsToPageView(ctx, bgFormInfo, (IMbgViewManager)view);
                } else if (BgTemFormTypeEnum.FIXEDFORM.equals((Object)formType)) {
                    IBgDimensionManager dimManager = null;
                    BgDimensionInfo dimension = null;
                    ArrayList<BgDimensionInfo> dimensions = new ArrayList<BgDimensionInfo>();
                    for (int s = 0; s < view.getSheetManagers().size(); ++s) {
                        dimManager = (IBgDimensionManager)view.getSheetManagers().get(s).getDimensionManager();
                        dimensions.clear();
                        dimensions.addAll(dimManager.getDimension());
                        for (int d = 0; d < dimensions.size(); ++d) {
                            if (!(dimensions.get(d) instanceof BgDimensionInfo) || (dimension = (BgDimensionInfo)dimensions.get(d)).getMember().size() <= 1 || !"page".equals(dimension.getLayout()) && !"view".equals(dimension.getLayout())) continue;
                            dimension.setLayout("col");
                        }
                        dimManager.clear();
                        dimManager.addDimensionCol(dimensions);
                        dimManager.reloadDefaultDisplayDimension();
                    }
                }
            } else {
                view = new MbgViewListXMLParser(ctx).parse(bytes);
                DimensionCommonHelper.fillDefaultMembers(bgFormInfo.getCurrency(), bgFormInfo.getBgPeriod(), bgFormInfo.getBgVersion(), (MbgViewListManager)view);
                DimensionCommonHelper.convertPeriodNParam(bgFormInfo.getBgPeriod(), (MbgViewListManager)view);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (view == null) {
            return null;
        }
        return view;
    }

    public static void convertPeriodNParam(BgPeriodInfo bgPeriod, IMbgViewManager view) throws EASBizException {
        if (view == null) {
            return;
        }
        for (int i = 0; i < view.getSheetManagers().size(); ++i) {
            IBgDimensionManager dimension = view.getSheetManagers().get(i).getDimensionManager();
            for (int d = 0; d < dimension.getDimension().size(); ++d) {
                BgDimensionInfo dim = (BgDimensionInfo)dimension.getDimension().get(d);
                if (!DimensionConstants.DEF_PERIOD_NUMBER.equals(dim.getNumber())) continue;
                for (int m = 0; m < dim.getMember().size(); ++m) {
                    BgDimensionMember member = (BgDimensionMember)dim.getMember().get(m);
                    if (!BgPeriodNVariableHelper.checkCanConvert((String)member.getNumber())) continue;
                    member.setNumber(BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriod.getNumber(), (String)member.getNumber(), (int)bgPeriod.getPeriodType().getValue()));
                }
            }
        }
    }

    public static void convertPeriodNParam(BgPeriodInfo bgPeriod, MbgViewListManager view) throws EASBizException {
        ArrayList<MbgViewListDimensionInfo> dimensions = new ArrayList<MbgViewListDimensionInfo>();
        for (int s = 0; s > view.getSheetManagers().size(); ++s) {
            dimensions.addAll(((MbgViewListSheetManager)view.getSheetManagers().get(s)).getDimensionManager().getAllDimensions());
        }
        for (int d = 0; d < dimensions.size(); ++d) {
            MbgViewListDimensionInfo dim = (MbgViewListDimensionInfo)dimensions.get(d);
            if (!DimensionConstants.DEF_PERIOD_NUMBER.equals(dim.getNumber())) continue;
            for (int m = 0; m < dim.getMember().size(); ++m) {
                BgDimensionMember member = (BgDimensionMember)dim.getMember().get(m);
                if (!BgPeriodNVariableHelper.checkCanConvert((String)member.getNumber())) continue;
                member.setNumber(BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriod.getNumber(), (String)member.getNumber(), (int)bgPeriod.getPeriodType().getValue()));
            }
        }
    }

    public static void fillDefaultMembers(CurrencyInfo currency, BgPeriodInfo bgPeriod, BgVersionInfo bgVersion, IMbgViewManager view) {
        if (view == null) {
            return;
        }
        for (int i = 0; i < view.getSheetManagers().size(); ++i) {
            IBgDimensionManager dimension = view.getSheetManagers().get(i).getDimensionManager();
            for (int d = 0; d < dimension.getDimension().size(); ++d) {
                BgDimensionMember member;
                BgDimensionInfo dim = (BgDimensionInfo)dimension.getDimension().get(d);
                if (!dim.getMember().isEmpty() || !DimensionMemberValueModeEnum.Null.equals((Object)dim.getMemberValueType())) continue;
                if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dim.getNumber())) {
                    member = new BgDimensionMember(dim.getNumber(), dim.getAttribute(), currency.getName(), currency.getNumber());
                    dim.getMember().add(member);
                    continue;
                }
                if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dim.getNumber())) {
                    member = new BgDimensionMember(dim.getNumber(), dim.getAttribute(), bgPeriod.getName(), bgPeriod.getNumber());
                    dim.getMember().add(member);
                    continue;
                }
                if (!DimensionConstants.DEF_VERSION_NUMBER.equals(dim.getNumber())) continue;
                member = new BgDimensionMember(dim.getNumber(), dim.getAttribute(), bgVersion.getName(), bgVersion.getNumber());
                dim.getMember().add(member);
            }
        }
    }

    public static void fillDefaultMembers(CurrencyInfo currency, BgPeriodInfo bgPeriod, BgVersionInfo bgVersion, IMbgViewManager view, BgTemFormTypeEnum formType) {
        if (view == null) {
            return;
        }
        for (int i = 0; i < view.getSheetManagers().size(); ++i) {
            IBgDimensionManager dimension = view.getSheetManagers().get(i).getDimensionManager();
            for (int d = 0; d < dimension.getDimension().size(); ++d) {
                BgDimensionMember member;
                BgDimensionInfo dim = (BgDimensionInfo)dimension.getDimension().get(d);
                if (dim.getMember().isEmpty() && DimensionMemberValueModeEnum.Null.equals((Object)dim.getMemberValueType())) {
                    if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dim.getNumber())) {
                        member = new BgDimensionMember(dim.getNumber(), dim.getAttribute(), currency.getName(), currency.getNumber());
                        dim.getMember().add(member);
                    } else if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dim.getNumber())) {
                        member = new BgDimensionMember(dim.getNumber(), dim.getAttribute(), bgPeriod.getName(), bgPeriod.getNumber());
                        dim.getMember().add(member);
                    } else if (DimensionConstants.DEF_VERSION_NUMBER.equals(dim.getNumber())) {
                        member = new BgDimensionMember(dim.getNumber(), dim.getAttribute(), bgVersion.getName(), bgVersion.getNumber());
                        dim.getMember().add(member);
                    }
                }
                if (!DimensionConstants.DEF_VERSION_NUMBER.equals(dim.getNumber()) || !BgTemFormTypeEnum.FIXEDFORM.equals((Object)formType) && !BgTemFormTypeEnum.SPECIALFORM.equals((Object)formType)) continue;
                dim.getMember().clear();
                member = new BgDimensionMember(dim.getNumber(), dim.getAttribute(), bgVersion.getName(), bgVersion.getNumber());
                dim.getMember().add(member);
            }
        }
    }

    public static void fillDefaultMembers(CurrencyInfo currency, BgPeriodInfo bgPeriod, BgVersionInfo bgVersion, MbgViewListManager view) {
        if (view == null) {
            return;
        }
        ArrayList<MbgViewListDimensionInfo> dimensions = new ArrayList<MbgViewListDimensionInfo>();
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            dimensions.addAll(((MbgViewListSheetManager)view.getSheetManagers().get(s)).getDimensionManager().getAllDimensions());
        }
        for (int d = 0; d < dimensions.size(); ++d) {
            MbgViewListDimensionMember member;
            MbgViewListDimensionInfo dim = (MbgViewListDimensionInfo)dimensions.get(d);
            if (!dim.getMember().isEmpty() || !DimensionMemberValueModeEnum.Null.equals((Object)dim.getMemberValueType())) continue;
            if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dim.getNumber())) {
                member = new MbgViewListDimensionMember(dim.getNumber(), dim.getAttribute(), currency.getName(), currency.getNumber());
                dim.getMember().add(member);
                continue;
            }
            if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dim.getNumber())) {
                member = new MbgViewListDimensionMember(dim.getNumber(), dim.getAttribute(), bgPeriod.getName(), bgPeriod.getNumber());
                dim.getMember().add(member);
                continue;
            }
            if (!DimensionConstants.DEF_VERSION_NUMBER.equals(dim.getNumber())) continue;
            member = new MbgViewListDimensionMember(dim.getNumber(), dim.getAttribute(), bgVersion.getName(), bgVersion.getNumber());
            dim.getMember().add(member);
        }
    }

    public static void fillViewListDefaultMember(CurrencyInfo currency, BgPeriodInfo bgPeriod, BgVersionInfo bgVersion, MbgViewListManager view, MbgViewListManager canMemberView) {
        if (view == null) {
            return;
        }
        ArrayList<MbgViewListDimensionInfo> dimensions = new ArrayList<MbgViewListDimensionInfo>();
        ArrayList<MbgViewListDimensionInfo> canDimensions = new ArrayList<MbgViewListDimensionInfo>();
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            dimensions.addAll(((MbgViewListSheetManager)view.getSheetManagers().get(s)).getDimensionManager().getAllDimensions());
            canDimensions.addAll(((MbgViewListSheetManager)canMemberView.getSheetManagers().get(s)).getDimensionManager().getAllDimensions());
        }
        MbgViewListDimensionInfo dim = null;
        MbgViewListDimensionInfo canDim = null;
        for (int d = 0; d < dimensions.size(); ++d) {
            dim = (MbgViewListDimensionInfo)dimensions.get(d);
            canDim = (MbgViewListDimensionInfo)canDimensions.get(d);
            if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dim.getNumber())) {
                DimensionCommonHelper.fillViewListDefaultMember(dim, canDim, (DataBaseInfo)currency);
                continue;
            }
            if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dim.getNumber())) {
                DimensionCommonHelper.fillViewListDefaultMember(dim, canDim, (DataBaseInfo)bgPeriod);
                continue;
            }
            if (!DimensionConstants.DEF_VERSION_NUMBER.equals(dim.getNumber())) continue;
            DimensionCommonHelper.fillViewListDefaultMember(dim, canDim, (DataBaseInfo)bgVersion);
        }
    }

    private static void fillViewListDefaultMember(MbgViewListDimensionInfo dim, MbgViewListDimensionInfo canDim, DataBaseInfo dataBaseInfo) {
        if (dim == null || dataBaseInfo == null) {
            return;
        }
        if (!DimensionMemberValueModeEnum.Null.equals((Object)dim.getMemberValueType()) || !BgMemberSelectTypeEnum.Member.equals((Object)dim.getMemberType())) {
            return;
        }
        String number = dataBaseInfo.getNumber();
        String memberNumber = null;
        for (int i = 0; i < dim.getSelectMembers().size(); ++i) {
            memberNumber = BgViewHelper.getNumber(dim.getSelectMembers().get(i));
            if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dim.getNumber()) && BgPeriodNVariableHelper.checkCanConvert((String)memberNumber)) {
                return;
            }
            if (!number.equals(memberNumber)) continue;
            return;
        }
        HashSet<String> canAdd = new HashSet<String>();
        for (int i = 0; i < canDim.getCanAddMember().size(); ++i) {
            canAdd.add(BgViewHelper.getNumber(canDim.getCanAddMember().get(i)));
        }
        if (!dim.getCanAddMember().isEmpty() && !canAdd.contains(number)) {
            return;
        }
        dim.getSelectMembers().add(new BgDimensionMember(dim.getNumber(), dim.getAttribute(), dataBaseInfo.getName(), number));
    }

    public static void loadSourceNameInfo(Context ctx, DimensionSourceCollection sources) throws EASBizException, BOSException {
        if (sources != null) {
            DimensionCommonHelper.loadSourceNameInfo(ctx, sources.toArray());
        }
    }

    public static void loadSourceNameInfo(Context ctx, List<DimensionSourceInfo> sources) throws EASBizException, BOSException {
        if (sources != null) {
            DimensionCommonHelper.loadSourceNameInfo(ctx, sources.toArray());
        }
    }

    private static void loadSourceNameInfo(Context ctx, Object[] sources) throws EASBizException, BOSException {
        if (sources != null) {
            HashSet<String> bosTypes = new HashSet<String>();
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < sources.length; ++i) {
                if (!(sources[i] instanceof DimensionSourceInfo)) {
                    return;
                }
                DimensionSourceInfo source = (DimensionSourceInfo)sources[i];
                if (source.getAlias() != null) continue;
                int value = source.getSrcType().getValue();
                if (value == 0) {
                    bosTypes.add(source.getSrcID());
                    continue;
                }
                if (value == 1) {
                    ids.add(source.getSrcID());
                    continue;
                }
                if (value != 3) continue;
                ids.add(source.getSrcID());
            }
            Map sourceInfos = null;
            sourceInfos = ctx == null ? MetaDataFacadeFactory.getRemoteInstance().getDimensionSrcInfo(bosTypes, ids) : MetaDataFacadeFactory.getLocalInstance((Context)ctx).getDimensionSrcInfo(bosTypes, ids);
            for (int i = 0; i < sources.length; ++i) {
                if (!(sources[i] instanceof DimensionSourceInfo)) {
                    return;
                }
                DimensionSourceInfo source = (DimensionSourceInfo)sources[i];
                if (sourceInfos == null || sourceInfos.get(source.getSrcID()) == null) continue;
                source.setAlias((String)sourceInfos.get(source.getSrcID()));
            }
        }
    }

    public static BgDimensionBaseInfo searchDimension(String dimNumber, List dimension) {
        if (StringUtils.isEmpty((String)dimNumber) || dimension == null) {
            return null;
        }
        for (int d = 0; d < dimension.size(); ++d) {
            if (!(dimension.get(d) instanceof BgDimensionBaseInfo) || !dimNumber.equals(((BgDimensionBaseInfo)dimension.get(d)).getNumber())) continue;
            return (BgDimensionBaseInfo)dimension.get(d);
        }
        return null;
    }

    public static List<Map<String, String>> getSysDefaultDimension() throws EASBizException, BOSException {
        ArrayList<Map<String, String>> defDimList = new ArrayList<Map<String, String>>();
        HashMap<String, String> temMap = null;
        temMap = new HashMap<String, String>();
        temMap.put(DIM_NUMBER, DimensionConstants.DEF_ORGUNIT_NUMBER);
        temMap.put(DIM_NAME, DimensionConstants.DEF_ORGUNIT_NAME);
        defDimList.add(temMap);
        temMap = new HashMap();
        temMap.put(DIM_NUMBER, DimensionConstants.DEF_SCENARIO_NUMBER);
        temMap.put(DIM_NAME, DimensionConstants.DEF_SCENARIO_NAME);
        defDimList.add(temMap);
        temMap = new HashMap();
        temMap.put(DIM_NUMBER, DimensionConstants.DEF_ACCOUNT_NUMBER);
        temMap.put(DIM_NAME, DimensionConstants.DEF_ACCOUNT_MAME);
        defDimList.add(temMap);
        temMap = new HashMap();
        temMap.put(DIM_NUMBER, DimensionConstants.DEF_PERIOD_NUMBER);
        temMap.put(DIM_NAME, DimensionConstants.DEF_PERIOD_NAME);
        defDimList.add(temMap);
        temMap = new HashMap();
        temMap.put(DIM_NUMBER, DimensionConstants.DEF_VERSION_NUMBER);
        temMap.put(DIM_NAME, DimensionConstants.DEF_VERSION_NAME);
        defDimList.add(temMap);
        temMap = new HashMap();
        temMap.put(DIM_NUMBER, DimensionConstants.DEF_CURRENCY_NUMBER);
        temMap.put(DIM_NAME, DimensionConstants.DEF_CURRENCY_NAME);
        defDimList.add(temMap);
        temMap = new HashMap();
        temMap.put(DIM_NUMBER, DimensionConstants.DEF_ELEMENT_NUMBER);
        temMap.put(DIM_NAME, DimensionConstants.DEF_ELEMENT_NAME);
        defDimList.add(temMap);
        return defDimList;
    }

    public static Set<String> getDefDimNumber() {
        HashSet<String> dimNumber = new HashSet<String>();
        dimNumber.add(DimensionConstants.DEF_ORGUNIT_NUMBER);
        dimNumber.add(DimensionConstants.DEF_SCENARIO_NUMBER);
        dimNumber.add(DimensionConstants.DEF_ACCOUNT_NUMBER);
        dimNumber.add(DimensionConstants.DEF_PERIOD_NUMBER);
        dimNumber.add(DimensionConstants.DEF_VERSION_NUMBER);
        dimNumber.add(DimensionConstants.DEF_CURRENCY_NUMBER);
        dimNumber.add(DimensionConstants.DEF_ELEMENT_NUMBER);
        return dimNumber;
    }

    public static int compare(Comparable c1, Comparable c2) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        return c1.compareTo(c2);
    }

    public static boolean isEquals(Object c1, Object c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null) {
            return false;
        }
        if (c2 == null) {
            return false;
        }
        return c1.equals(c2);
    }

    public static boolean isEqualsPrmt(Object newValue, Object oldValue) {
        if (newValue != null && oldValue != null) {
            if (newValue.equals(oldValue)) {
                return true;
            }
            Object[] newValues = DimensionCommonHelper.getValues(newValue);
            Object[] oldValues = DimensionCommonHelper.getValues(oldValue);
            if (newValues != null && oldValues != null) {
                if (newValues.length != oldValues.length) {
                    return false;
                }
                for (int i = 0; i < newValues.length; ++i) {
                    if (!(newValues[i] instanceof IObjectValue && oldValues[i] instanceof IObjectValue ? !BgCommCHelper.isEqualsPK((IObjectValue)((IObjectValue)newValues[i]), (IObjectValue)((IObjectValue)oldValues[i])) : !newValues[i].equals(oldValues[i]))) continue;
                    return false;
                }
                return true;
            }
            return DimensionCommonHelper.isEquals(newValues, oldValues);
        }
        return DimensionCommonHelper.isEquals(newValue, oldValue);
    }

    public static boolean isMulti(Object value) {
        Object[] values = DimensionCommonHelper.getValues(value);
        return values != null && values.length > 1;
    }

    public static boolean isSingle(Object value) {
        Object[] values = DimensionCommonHelper.getValues(value);
        return values != null && values.length == 1;
    }

    public static Object getSingleValue(Object value) {
        Object[] values = DimensionCommonHelper.getValues(value);
        if (values != null && values.length == 1) {
            return values[0];
        }
        return null;
    }

    public static Set<String> getIds(Object infos) {
        return DimensionCommonHelper.getIds(DimensionCommonHelper.getValues(infos));
    }

    public static Set<String> getIds(Object[] infos) {
        HashSet<String> ids = new HashSet<String>();
        if (infos == null || infos.length == 0) {
            return ids;
        }
        for (Object bgTemplate : infos) {
            if (!(bgTemplate instanceof CoreBaseInfo)) continue;
            ids.add(((CoreBaseInfo)bgTemplate).getId().toString());
        }
        return ids;
    }

    public static Object[] getValues(Object newValue) {
        ArrayList<Object> objs = new ArrayList<Object>();
        if (newValue instanceof Object[]) {
            Object[] os = (Object[])newValue;
            for (int i = 0; i < os.length; ++i) {
                if (os[i] == null) continue;
                objs.add(os[i]);
            }
        } else if (newValue instanceof IObjectCollection) {
            IObjectCollection oc = (IObjectCollection)newValue;
            for (int i = 0; i < oc.size(); ++i) {
                if (oc.getObject(i) == null) continue;
                objs.add(oc.getObject(i));
            }
        } else if (newValue instanceof Collection) {
            objs.addAll((Collection)newValue);
        } else if (newValue != null) {
            objs.add(newValue);
        }
        if (objs.isEmpty()) {
            return null;
        }
        return objs.toArray();
    }

    public static LinkedHashSet<String> getNumbers(Object value) {
        LinkedHashSet<String> numbers = new LinkedHashSet<String>();
        Object[] values = DimensionCommonHelper.getValues(value);
        if (values != null) {
            for (Object obj : values) {
                numbers.add(BgViewHelper.getNumber(obj));
            }
        }
        return numbers;
    }

    public static Set<Integer> getItemFields(IMbgSheetBase sheet) {
        HashSet<Integer> fields = new HashSet<Integer>();
        fields.add(DimensionCommonHelper.getField(DimensionConstants.DEF_BGINDEX_FIELD));
        for (int d = 0; d < sheet.getDimensionManager().getDimension().size(); ++d) {
            BgDimensionBaseInfo dim;
            if (!(sheet.getDimensionManager().getDimension().get(d) instanceof BgDimensionBaseInfo) || DimensionConstants.necessary.contains((dim = (BgDimensionBaseInfo)sheet.getDimensionManager().getDimension().get(d)).getNumber())) continue;
            fields.add(DimensionCommonHelper.getField(dim.getRefField()));
        }
        return fields;
    }

    public static List<BgDimensionBaseInfo> getDimLstByDimManager(IBgDimensionManagerBase dimManager) {
        LinkedList<BgDimensionBaseInfo> dims = new LinkedList<BgDimensionBaseInfo>();
        dims.addAll(dimManager.getViewDisplayDimension());
        dims.addAll(dimManager.getPageDisplayDimension());
        if (dimManager instanceof IBgDimensionManager) {
            dims.addAll(dimManager.getRowDisplayDimension());
            dims.addAll(dimManager.getColDisplayDimension());
        } else if (dimManager instanceof MbgViewListDimensionManager) {
            MbgViewListDimensionInfo dimensionInfo2 = null;
            List<IMbgViewListObject> rowCols = ((MbgViewListDimensionManager)dimManager).getRowCols();
            LinkedHashMap<String, MbgViewListDimensionInfo> dimMap = new LinkedHashMap<String, MbgViewListDimensionInfo>();
            MbgViewListDimensionInfo cloneDimensionInfo = null;
            for (int r = 0; r < rowCols.size(); ++r) {
                if (!(rowCols.get(r) instanceof MbgViewListRowCol)) continue;
                MbgViewListRowCol object = (MbgViewListRowCol)rowCols.get(r);
                List<MbgViewListDimensionInfo> dimens = object.getDimensions();
                for (int d = 0; d < dimens.size(); ++d) {
                    if (!(dimens.get(d) instanceof MbgViewListDimensionInfo)) continue;
                    dimensionInfo2 = dimens.get(d);
                    if (!dimMap.containsKey(dimensionInfo2.getNumber())) {
                        cloneDimensionInfo = dimensionInfo2.clone();
                        dimMap.put(dimensionInfo2.getNumber(), cloneDimensionInfo);
                        continue;
                    }
                    for (int m = 0; m < dimensionInfo2.getMember().size(); ++m) {
                        if (((MbgViewListDimensionInfo)dimMap.get(dimensionInfo2.getNumber())).getMember().contains(dimensionInfo2.getMember().get(m))) continue;
                        ((MbgViewListDimensionInfo)dimMap.get(dimensionInfo2.getNumber())).getMember().add(dimensionInfo2.getMember().get(m));
                    }
                }
            }
            if (!dimMap.isEmpty()) {
                HashSet<String> dimNumbers = new HashSet<String>();
                String number = null;
                for (MbgViewListDimensionInfo dimensionInfo2 : dimMap.values()) {
                    dims.add(dimensionInfo2);
                    dimNumbers.clear();
                    Iterator itM = dimensionInfo2.getMember().iterator();
                    while (itM.hasNext()) {
                        number = BgViewHelper.getNumber(itM.next());
                        if (!dimNumbers.contains(number)) {
                            dimNumbers.add(number);
                            continue;
                        }
                        itM.remove();
                    }
                }
            }
        }
        return dims;
    }

    public static BgDimensionBaseInfo searchDimension(String dimNumber, IBgDimensionManagerBase dimManager) {
        if (StringUtils.isEmpty((String)dimNumber) || dimManager == null) {
            return null;
        }
        List<BgDimensionBaseInfo> lst = DimensionCommonHelper.getDimLstByDimManager(dimManager);
        int size = lst.size();
        for (int index = 0; index < size; ++index) {
            if (!(lst.get(index) instanceof BgDimensionBaseInfo) || !dimNumber.equals(lst.get(index).getNumber())) continue;
            return lst.get(index);
        }
        return null;
    }

    public static Object[] searchViewListLayout(MbgViewListSheetManager sheet, MbgViewListDimensionInfo dimension) {
        String layout = null;
        int layoutIndex = -1;
        if (DimensionCommonHelper.searchDimension(dimension.getNumber(), sheet.getDimensionManager().getPageDimension()) != null) {
            layout = "page";
        } else {
            layoutIndex = DimensionCommonHelper.searchLayout(dimension, sheet.getDimensionManager().getRows());
            if (layoutIndex >= 0) {
                layout = "row";
            } else {
                layout = "col";
                layoutIndex = DimensionCommonHelper.searchLayout(dimension, sheet.getDimensionManager().getColumns());
            }
        }
        return new Object[]{layout, layoutIndex};
    }

    private static int searchLayout(MbgViewListDimensionInfo dimension, List<IMbgViewListObject> rowCols) {
        MbgViewListRowCol rowObj = null;
        for (int i = 0; i < rowCols.size(); ++i) {
            if (!(rowCols.get(i) instanceof MbgViewListRowCol) || (rowObj = (MbgViewListRowCol)rowCols.get(i)) == null || rowObj.getDimensions() == null || !rowObj.getDimensions().contains(dimension)) continue;
            return i;
        }
        return -1;
    }

    public static MbgViewListSheetManager cloneSheetManager(MbgViewListSheetManager sheetManager) {
        if (sheetManager == null) {
            return null;
        }
        int sheetIndex = sheetManager.getView().getSheetManagers().indexOf(sheetManager);
        if (sheetIndex < 0) {
            sheetIndex = sheetManager.getSheetIndex();
        }
        MbgViewListManager viewManager = DimensionCommonHelper.deepclone(sheetManager.getView());
        return (MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetIndex);
    }

    public static MbgViewListManager cloneViewManager(MbgViewListManager viewManager) {
        return DimensionCommonHelper.deepclone(viewManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T deepclone(T object) {
        Object obj = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            bis = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bis);
            obj = ois.readObject();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException iOException) {}
        }
        return (T)((Serializable)obj);
    }

    public static void putSpecialDimsToPageView(BgFormInfo bgFormInfo, IMbgViewManager view) throws EASBizException, BOSException {
        DimensionCommonHelper.putSpecialDimsToPageView(null, bgFormInfo, view);
    }

    public static void putSpecialDimsToPageView(Context ctx, BgFormInfo bgFormInfo, IMbgViewManager view) throws EASBizException, BOSException {
        List<BgDimensionInfo> specialDims;
        if (bgFormInfo == null || view == null) {
            return;
        }
        if (bgFormInfo.getBgSpecialItems().isEmpty() && bgFormInfo.getBgTemplate().getFormType().equals((Object)BgTemFormTypeEnum.SPECIALFORM)) {
            BgFormInfo _bgFormInfo = null;
            _bgFormInfo = ctx != null ? BgFormFactory.getLocalInstance(ctx).getBgFormInfo("select bgSpecialItems.* where id = '" + bgFormInfo.getId() + "'") : BgFormFactory.getRemoteInstance().getBgFormInfo("select bgSpecialItems.* where id = '" + bgFormInfo.getId() + "'");
            if (_bgFormInfo != null && !_bgFormInfo.getBgSpecialItems().isEmpty()) {
                BgSpecialItemsInfo bgSpecialItemsInfo = _bgFormInfo.getBgSpecialItems().get(0);
                bgFormInfo.getBgSpecialItems().add(bgSpecialItemsInfo);
            }
        }
        if ((specialDims = DimensionCommonHelper.getSpecialDimsByForm(ctx, bgFormInfo)) != null && !specialDims.isEmpty()) {
            HashMap<String, BgDimensionInfo> specialDimsMap = new HashMap<String, BgDimensionInfo>();
            for (BgDimensionInfo specialDim : specialDims) {
                specialDimsMap.put(specialDim.getNumber(), specialDim);
            }
            for (int s = 0; s < view.getSheetManagers().size(); ++s) {
                IBgDimensionManager dimManager = view.getSheetManagers().get(s).getDimensionManager();
                boolean isAddSpecialDimsToPage = false;
                for (int d = 0; d < dimManager.getDimension().size(); ++d) {
                    BgDimensionInfo dim = (BgDimensionInfo)dimManager.getDimension().get(d);
                    if (!specialDimsMap.keySet().contains(dim.getNumber())) continue;
                    isAddSpecialDimsToPage = true;
                    break;
                }
                if (isAddSpecialDimsToPage) continue;
                for (BgDimensionInfo specialDim : specialDims) {
                    specialDim.setDimensionManager(dimManager);
                    specialDim.setLayout("page");
                    specialDim.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
                    specialDim.setShow(true);
                    dimManager.addDimensionInfo(specialDim);
                }
            }
        }
    }

    public static List<BgDimensionInfo> getSpecialDimsByForm(Context ctx, BgFormInfo bgFormInfo) throws EASBizException, BOSException {
        ArrayList<BgDimensionInfo> bgDimensions = new ArrayList<BgDimensionInfo>();
        if (bgFormInfo.getBgSpecialItems() != null && !bgFormInfo.getBgSpecialItems().isEmpty()) {
            BgSchemeDimensionHelper schemeHelper = ctx != null ? new BgSchemeDimensionHelper(ctx, bgFormInfo.getBgScheme().getId().toString()) : new BgSchemeDimensionHelper(bgFormInfo.getBgScheme().getId().toString());
            BgSpecialItemsInfo bgSpecialItemsInfo = bgFormInfo.getBgSpecialItems().get(0);
            if (bgSpecialItemsInfo == null || schemeHelper == null) {
                return bgDimensions;
            }
            if (bgSpecialItemsInfo.getId() != null && bgSpecialItemsInfo.getDimensionNumber() == null) {
                BgFormInfo _bgFormInfo = null;
                _bgFormInfo = ctx != null ? BgFormFactory.getLocalInstance(ctx).getBgFormInfo("select bgSpecialItems.* where id = '" + bgFormInfo.getId() + "'") : BgFormFactory.getRemoteInstance().getBgFormInfo("select bgSpecialItems.* where id = '" + bgFormInfo.getId() + "'");
                if (_bgFormInfo != null && !_bgFormInfo.getBgSpecialItems().isEmpty()) {
                    bgSpecialItemsInfo = _bgFormInfo.getBgSpecialItems().get(0);
                }
            }
            String dimensionNumber = bgSpecialItemsInfo.getDimensionNumber();
            String memberName = bgSpecialItemsInfo.getMemberDisplayName();
            Map<String, BgDimensionInfo> srcNumAndDimensonMap = schemeHelper.getDimensionBySrcNumber();
            String[] numbers = dimensionNumber.split(DimensionConstants.COMMA_SEPARATOR);
            String[] names = !StringUtils.isEmpty((String)memberName) ? DimensionCommonHelper.splitName(memberName, ",") : DimensionCommonHelper.splitName(bgSpecialItemsInfo.getMemberName(), DimensionConstants.TICK_SEPARATOR);
            BgDimensionInfo bgDimensionInfo = null;
            BgDimensionMember bgDimensionMember = null;
            String mNumber = null;
            String meName = null;
            String srcNum = null;
            int length = numbers.length;
            for (int index = 0; index < length; ++index) {
                srcNum = numbers[index].split(":")[0];
                mNumber = numbers[index].split(":")[1];
                String string = meName = names != null && names.length >= index ? names[index] : null;
                if (!srcNumAndDimensonMap.containsKey(srcNum)) continue;
                bgDimensionInfo = srcNumAndDimensonMap.get(srcNum);
                if ("#".equals(mNumber)) {
                    bgDimensionMember = null;
                } else {
                    bgDimensionMember = new BgDimensionMember(bgDimensionInfo.getNumber(), bgDimensionInfo.getRefField(), meName, mNumber);
                    bgDimensionMember.setSrcNumber(srcNum);
                    bgDimensionInfo.getMember().add(bgDimensionMember);
                }
                bgDimensions.add(bgDimensionInfo);
            }
        }
        return bgDimensions;
    }

    public static String[] splitName(String name, String split) {
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)split)) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        int start = 0;
        int pos = 0;
        while (start < name.length()) {
            pos = name.indexOf(split, start);
            if (start == pos) {
                resultList.add("");
            } else if (pos > 0) {
                resultList.add(name.substring(start, pos));
            } else {
                pos = name.length();
                resultList.add(name.substring(start, pos));
            }
            start = pos + 1;
        }
        if (name.endsWith(split)) {
            resultList.add("");
        }
        return resultList.toArray(new String[0]);
    }

    public static Boolean isOrgTreeDimension(BgDimensionBaseInfo dimension) {
        Boolean isOrgTreeDim = false;
        if (dimension.getRefField() != null && dimension.getRefField().equals(DimensionBaseConstants.DEF_ORGUNIT_FIELD) && !StringUtils.isEmpty((String)dimension.getViewId()) && BOSUuid.getBOSObjectType((String)dimension.getViewId(), (boolean)true).equals((Object)new OrgTreeInfo().getBOSType())) {
            isOrgTreeDim = true;
        }
        return isOrgTreeDim;
    }

    public static boolean isDifference(IMbgViewBase view1, IMbgViewBase view2, int curSheetIndex) {
        if (view1 == null && view2 == null) {
            return false;
        }
        if (view1 == null || view2 == null) {
            return true;
        }
        IBgDimensionManagerBase dimManager1 = null;
        IBgDimensionManagerBase dimManager2 = null;
        for (int s = 0; s < view1.getSheetManagers().size(); ++s) {
            if (curSheetIndex >= 0 && curSheetIndex != s) continue;
            if (view2.getSheetManagers().size() <= s) {
                return true;
            }
            dimManager1 = view1.getSheetManagers().get(s).getDimensionManager();
            dimManager2 = view2.getSheetManagers().get(s).getDimensionManager();
            if (!(MBgTemplateHelper.isOrgOnPageOrView(dimManager1) ? !MBgTemplateHelper.isOrgOnPageOrView(dimManager2) : DimensionCommonHelper.isDifference(dimManager1.getRowDisplayDimension(), dimManager2.getRowDisplayDimension()) || DimensionCommonHelper.isDifference(dimManager1.getColDisplayDimension(), dimManager2.getColDisplayDimension()))) continue;
            return true;
        }
        return false;
    }

    private static boolean isDifference(List dimension1, List dimension2) {
        dimension1 = DimensionCommonHelper.filterNoDim(dimension1);
        dimension2 = DimensionCommonHelper.filterNoDim(dimension2);
        if (dimension1.size() != dimension2.size()) {
            return true;
        }
        BgDimensionBaseInfo d1 = null;
        BgDimensionBaseInfo d2 = null;
        for (int d = 0; d < dimension1.size(); ++d) {
            d1 = (BgDimensionBaseInfo)dimension1.get(d);
            d2 = (BgDimensionBaseInfo)dimension2.get(d);
            if (d1.getNumber().equals(d2.getNumber())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDifferenceNotOrder(IMbgViewBase view1, IMbgViewBase view2, int curSheetIndex) {
        if (view1 == null && view2 == null) {
            return false;
        }
        if (view1 == null || view2 == null) {
            return true;
        }
        if (view1.getSheetManagers().size() != view2.getSheetManagers().size()) {
            return true;
        }
        IBgDimensionManagerBase dimManager1 = null;
        IBgDimensionManagerBase dimManager2 = null;
        for (int s = 0; s < view1.getSheetManagers().size(); ++s) {
            if (curSheetIndex >= 0 && curSheetIndex != s) continue;
            if (view2.getSheetManagers().size() <= s) {
                return true;
            }
            dimManager1 = view1.getSheetManagers().get(s).getDimensionManager();
            dimManager2 = view2.getSheetManagers().get(s).getDimensionManager();
            if (dimManager1 instanceof MbgViewListDimensionManager && dimManager2 instanceof MbgViewListDimensionManager) {
                List<IMbgViewListObject> rows1 = ((MbgViewListDimensionManager)dimManager1).getRows();
                List<IMbgViewListObject> rows2 = ((MbgViewListDimensionManager)dimManager2).getRows();
                List<IMbgViewListObject> cols1 = ((MbgViewListDimensionManager)dimManager1).getColumns();
                List<IMbgViewListObject> cols2 = ((MbgViewListDimensionManager)dimManager2).getColumns();
                if (rows1 == null || rows2 == null || cols1 == null || cols2 == null) {
                    return true;
                }
                if (DimensionCommonHelper.isDiff2RowCol(rows1, rows2) || DimensionCommonHelper.isDiff2RowCol(cols1, cols2)) {
                    return true;
                }
            }
            if (!DimensionCommonHelper.isDifferenceNotOrder(dimManager1.getRowDimension(), dimManager2.getRowDimension()) && !DimensionCommonHelper.isDifferenceNotOrder(dimManager1.getColDimension(), dimManager2.getColDimension()) && !DimensionCommonHelper.isDifferenceNotOrder(dimManager1.getPageDimension(), dimManager2.getPageDimension()) && !DimensionCommonHelper.isDifferenceNotOrder(dimManager1.getViewDimension(), dimManager2.getViewDimension())) continue;
            return true;
        }
        return false;
    }

    private static boolean isDiff2RowCol(List<IMbgViewListObject> sourceRowCol, List<IMbgViewListObject> targetRowCol) {
        List<IMbgViewListObject> rowCol1 = DimensionCommonHelper.getRowCol(sourceRowCol);
        List<IMbgViewListObject> rowCol2 = DimensionCommonHelper.getRowCol(targetRowCol);
        return rowCol1.size() != rowCol2.size();
    }

    private static List<IMbgViewListObject> getRowCol(List<IMbgViewListObject> rowCols) {
        ArrayList<IMbgViewListObject> returnRowCols = new ArrayList<IMbgViewListObject>();
        for (IMbgViewListObject iMbgViewListObject : rowCols) {
            if (!(iMbgViewListObject instanceof MbgViewListRowCol)) continue;
            returnRowCols.add(iMbgViewListObject);
        }
        return returnRowCols;
    }

    private static boolean isDifferenceNotOrder(List dimension1, List dimension2) {
        int d;
        dimension1 = DimensionCommonHelper.filterNoDim(dimension1);
        dimension2 = DimensionCommonHelper.filterNoDim(dimension2);
        if (dimension1.size() != dimension2.size()) {
            return true;
        }
        BgDimensionBaseInfo d1 = null;
        BgDimensionBaseInfo d2 = null;
        HashMap<String, BgDimensionBaseInfo> map1 = new HashMap<String, BgDimensionBaseInfo>();
        HashMap<String, BgDimensionBaseInfo> map2 = new HashMap<String, BgDimensionBaseInfo>();
        for (d = 0; d < dimension1.size(); ++d) {
            d1 = (BgDimensionBaseInfo)dimension1.get(d);
            if (d1 == null || StringUtils.isEmpty((String)d1.getNumber()) || map1.containsKey(d1.getNumber())) continue;
            map1.put(d1.getNumber(), d1);
        }
        for (d = 0; d < dimension2.size(); ++d) {
            d2 = (BgDimensionBaseInfo)dimension2.get(d);
            if (d2 == null || StringUtils.isEmpty((String)d2.getNumber()) || map2.containsKey(d2.getNumber())) continue;
            map2.put(d2.getNumber(), d2);
        }
        if (map2.isEmpty() && map1.isEmpty()) {
            return false;
        }
        if (map2.size() != map1.size()) {
            return true;
        }
        Iterator iterator = map1.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!map2.containsKey(entry.getKey())) {
                return true;
            }
            return DimensionCommonHelper.isDiff2Members((BgDimensionBaseInfo)entry.getValue(), (BgDimensionBaseInfo)map2.get(entry.getKey()));
        }
        return true;
    }

    private static boolean isDiff2Members(BgDimensionBaseInfo value1, BgDimensionBaseInfo value2) {
        return value1 == null || value2 == null || !value1.getMemberValueType().equals((Object)value2.getMemberValueType());
    }

    private static List filterNoDim(List dims) {
        ArrayList newList = new ArrayList();
        for (int i = 0; i < dims.size(); ++i) {
            if (!(dims.get(i) instanceof BgDimensionBaseInfo)) continue;
            newList.add(dims.get(i));
        }
        return newList;
    }

    public static ArrayList cloneViewListObject(List sourceList) throws CloneNotSupportedException {
        ArrayList<Object> target = new ArrayList<Object>();
        for (int i = 0; i < sourceList.size(); ++i) {
            if (sourceList.get(i) instanceof IMbgViewListObject) {
                target.add(((IMbgViewListObject)sourceList.get(i)).clone());
                continue;
            }
            if (sourceList.get(i) instanceof BgDimensionBaseInfo) {
                target.add(((BgDimensionBaseInfo)sourceList.get(i)).clone());
                continue;
            }
            target.add(sourceList.get(i));
        }
        return target;
    }

    public static Set<String> getInitOrgNums(MbgViewListManager viewManager, FullOrgUnitInfo orgUnitInfo) {
        HashSet<String> orgNumbers = new HashSet<String>();
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            DimensionCommonHelper.getInitOrgNums(orgNumbers, viewManager, s, orgUnitInfo);
        }
        return orgNumbers;
    }

    public static void getInitOrgNums(Set<String> orgNums, MbgViewListManager viewManager, int sheetIndex, FullOrgUnitInfo orgUnitInfo) {
        MbgViewListDimensionManager dimManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetIndex)).getDimensionManager();
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(dimManager);
        if (isorgOnPageOrView) {
            orgNums.add(orgUnitInfo.getNumber());
        } else {
            int i;
            ArrayList<MbgViewListDimensionInfo> dimens = new ArrayList<MbgViewListDimensionInfo>();
            List<IMbgViewListObject> rowCols = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetIndex)).getDimensionManager().getRowCols();
            for (i = 0; i < rowCols.size(); ++i) {
                if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
                dimens.addAll(((MbgViewListRowCol)rowCols.get(i)).getDimensions());
            }
            for (i = 0; i < dimens.size(); ++i) {
                if (!(dimens.get(i) instanceof BgDimensionBaseInfo) || !((BgDimensionBaseInfo)dimens.get(i)).getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) || ((BgDimensionBaseInfo)dimens.get(i)).getMember().isEmpty()) continue;
                for (int m = 0; m < ((BgDimensionBaseInfo)dimens.get(i)).getMember().size(); ++m) {
                    orgNums.add(((BgDimensionMember)((BgDimensionBaseInfo)dimens.get(i)).getMember().get(m)).getNumber());
                }
            }
            if (orgNums.isEmpty()) {
                orgNums.add(orgUnitInfo.getNumber());
            }
        }
    }

    public static boolean isDecompose(BgProcessEnum processType) {
        return BgProcessEnum.C02.equals((Object)processType) || BgProcessEnum.C03.equals((Object)processType) || BgProcessEnum.C04.equals((Object)processType);
    }

    public static int getDataType(BgProcessEnum processType) {
        if (BgProcessEnum.C02.equals((Object)processType)) {
            return 256;
        }
        if (BgProcessEnum.C03.equals((Object)processType)) {
            return 512;
        }
        if (BgProcessEnum.C04.equals((Object)processType)) {
            return 1024;
        }
        if (BgProcessEnum.C01.equals((Object)processType)) {
            return 1;
        }
        return -1;
    }

    public static boolean isDecompose(int dataType) {
        return 256 == dataType || 512 == dataType || 1024 == dataType;
    }

    public static BgProcessEnum getProcessEnum(int dataType) {
        if (256 == dataType) {
            return BgProcessEnum.C02;
        }
        if (512 == dataType) {
            return BgProcessEnum.C03;
        }
        if (1024 == dataType) {
            return BgProcessEnum.C04;
        }
        if (1 == dataType) {
            return BgProcessEnum.C01;
        }
        return BgProcessEnum.C01;
    }

    public static <T extends CoreBaseInfo> T createNewObject(Class<T> objectClass, String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        return DimensionCommonHelper.createNewObject(objectClass, BOSUuid.read((String)id));
    }

    public static <T extends CoreBaseInfo> T createNewObject(Class<T> objectClass, BOSUuid id) {
        if (id == null) {
            return null;
        }
        CoreBaseInfo value = null;
        try {
            value = (CoreBaseInfo)objectClass.newInstance();
            value.setId(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)value;
    }

    public static <T extends CoreBaseInfo> T[] createNewObjectArray(Class<T> objectClass, List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        CoreBaseInfo[] arrays = (CoreBaseInfo[])Array.newInstance(objectClass, ids.size());
        for (int i = 0; i < ids.size(); ++i) {
            arrays[i] = DimensionCommonHelper.createNewObject(objectClass, ids.get(i));
        }
        return arrays;
    }

    public static void sortRefField(List<String> refDims) {
        Collections.sort(refDims, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return DimensionCommonHelper.getField(o1).compareTo(DimensionCommonHelper.getField(o2));
            }
        });
    }

    public static void getOrgNumsForCurViewManager(MbgViewListManager viewManager, Set<String> orgNums) {
        DimensionCommonHelper.getOrgNumsForCurViewManager(viewManager, orgNums, true);
    }

    public static void getOrgNumsForCurViewManager(MbgViewListManager viewManager, Set<String> orgNums, boolean isOnlyRowCol) {
        if (viewManager == null || orgNums == null) {
            return;
        }
        for (int sheetIndex = 0; sheetIndex < viewManager.getSheetManagers().size(); ++sheetIndex) {
            boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetIndex)).getDimensionManager());
            if (isOnlyRowCol && isorgOnPageOrView) continue;
            ArrayList<MbgViewListDimensionInfo> dimensions = new ArrayList<MbgViewListDimensionInfo>();
            dimensions.addAll(((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetIndex)).getDimensionManager().getDimension());
            List<IMbgViewListObject> rowCols = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetIndex)).getDimensionManager().getRowCols();
            for (int i = 0; i < rowCols.size(); ++i) {
                if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
                dimensions.addAll(((MbgViewListRowCol)rowCols.get(i)).getDimensions());
            }
            DimensionCommonHelper.getOrgMembers(orgNums, dimensions);
        }
    }

    public static void getOrgMembers(Set<String> orgNums, List dimensions) {
        for (int i = 0; i < dimensions.size(); ++i) {
            BgDimensionBaseInfo dim;
            if (!(dimensions.get(i) instanceof BgDimensionBaseInfo) || !MBGLayoutConstants.BG_ORGANIZATION.equals((dim = (BgDimensionBaseInfo)dimensions.get(i)).getNumber())) continue;
            for (int j = 0; j < dim.getMember().size(); ++j) {
                orgNums.add(((BgDimensionMember)dim.getMember().get(j)).getNumber());
            }
        }
    }

    public static void movePageDimensionsToRow(IMbgViewManager curMbgViewManager) {
        List<IMbgSheetManager> sheetManagers = curMbgViewManager.getSheetManagers();
        int pvCount = -1;
        int orgIndex = -1;
        ArrayList<IDimensionColumn> otherColumns = new ArrayList<IDimensionColumn>();
        IDimensionColumn otherColumn = null;
        for (int index = 0; index < sheetManagers.size(); ++index) {
            IMbgSheetManager sheetManager = sheetManagers.get(index);
            IBgDimensionManager dimensionManager = sheetManager.getDimensionManager();
            pvCount = dimensionManager.getViewDisplayDimension().size() + dimensionManager.getPageDisplayDimension().size();
            orgIndex = -1;
            ArrayList viewDisplayDimension = new ArrayList(dimensionManager.getViewDisplayDimension());
            ArrayList pageDisplayDimension = new ArrayList(dimensionManager.getPageDisplayDimension());
            ArrayList rowDisplayDimension = new ArrayList(dimensionManager.getRowDisplayDimension());
            dimensionManager.getPageDisplayDimension().clear();
            dimensionManager.getRowDisplayDimension().clear();
            dimensionManager.getRowDisplayDimension().addAll(viewDisplayDimension);
            dimensionManager.getRowDisplayDimension().addAll(pageDisplayDimension);
            dimensionManager.getRowDisplayDimension().addAll(rowDisplayDimension);
            List newRows = dimensionManager.getRowDisplayDimension();
            BgDimensionInfo info = null;
            for (int i = newRows.size() - 1; i >= 0; --i) {
                info = (BgDimensionInfo)newRows.get(i);
                if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(info.getNumber())) continue;
                newRows.remove(info);
                orgIndex = i;
                dimensionManager.getViewDisplayDimension().add(info);
            }
            otherColumns.clear();
            otherColumns.addAll(dimensionManager.getAttributeCol());
            otherColumns.addAll(dimensionManager.getCalcuteCol());
            otherColumns.addAll(dimensionManager.getDescriptionCol());
            for (int o = 0; o < otherColumns.size(); ++o) {
                if (!(otherColumns.get(o) instanceof IDimensionColumn)) continue;
                otherColumn = (IDimensionColumn)otherColumns.get(o);
                otherColumn.setIndex(otherColumn.getIndex() + pvCount);
                if (orgIndex < 0 || otherColumn.getIndex() <= orgIndex) continue;
                otherColumn.setIndex(otherColumn.getIndex() - 1);
            }
        }
    }

    public static void movePageDimensionsToRow(IMbgViewBase viewManager) {
        if (viewManager instanceof MbgViewListManager) {
            DimensionCommonHelper.movePageDimensionsToRow((MbgViewListManager)viewManager);
        } else if (viewManager instanceof IMbgViewManager) {
            DimensionCommonHelper.movePageDimensionsToRow((IMbgViewManager)viewManager);
        }
    }

    public static void movePageDimensionsToRow(MbgViewListManager viewManager) {
        if (viewManager == null) {
            return;
        }
        List sheetManagers = viewManager.getSheetManagers();
        for (int s = 0; s < sheetManagers.size(); ++s) {
            MbgViewListSheetManager sheetManager = (MbgViewListSheetManager)sheetManagers.get(s);
            DimensionCommonHelper.movePageDimensionsToRow(sheetManager);
        }
    }

    public static void movePageDimensionsToRow(MbgViewListSheetManager sheetManager) {
        if (sheetManager == null) {
            return;
        }
        MbgViewListDimensionInfo dim = null;
        List<IMbgViewListObject> rows = sheetManager.getDimensionManager().getRows();
        List pageDimensions = sheetManager.getDimensionManager().getPageDimension();
        List rowDimensions = sheetManager.getDimensionManager().getRowDimension();
        HashMap nodimensionMap = new HashMap();
        for (int i = 0; i < rowDimensions.size(); ++i) {
            if (rowDimensions.get(i) instanceof MbgViewListDimensionInfo) {
                dim = (MbgViewListDimensionInfo)rowDimensions.get(i);
                continue;
            }
            String dimNumber = "000000000000000000000000000=";
            if (dim != null) {
                dimNumber = dim.getNumber();
            }
            if (!nodimensionMap.containsKey(dimNumber)) {
                nodimensionMap.put(dimNumber, new ArrayList());
            }
            ((List)nodimensionMap.get(dimNumber)).add(rowDimensions.get(i));
        }
        if (!pageDimensions.isEmpty()) {
            ArrayList<MbgViewListDimensionInfo> newDims = null;
            MbgViewListDimensionInfo cloneDim = null;
            for (int i = 0; i < rows.size(); ++i) {
                if (rows.get(i) instanceof MbgViewListRowCol) {
                    MbgViewListRowCol rowObj = (MbgViewListRowCol)rows.get(i);
                    newDims = new ArrayList<MbgViewListDimensionInfo>();
                    for (int j = 0; j < pageDimensions.size(); ++j) {
                        dim = (MbgViewListDimensionInfo)pageDimensions.get(j);
                        if (dim == null || DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) continue;
                        cloneDim = dim.clone();
                        cloneDim.getMember().clear();
                        cloneDim.getMember().addAll(dim.getMember());
                        newDims.add(cloneDim);
                    }
                    newDims.addAll(rowObj.getDimensions());
                    rowObj.getDimensions().clear();
                    rowObj.getDimensions().addAll(newDims);
                }
                if (newDims == null) continue;
                rowDimensions.clear();
                if (nodimensionMap.containsKey("000000000000000000000000000=")) {
                    rowDimensions.addAll((Collection)nodimensionMap.get("000000000000000000000000000="));
                }
                for (int d = 0; d < newDims.size(); ++d) {
                    dim = (MbgViewListDimensionInfo)newDims.get(d);
                    rowDimensions.add(dim);
                    if (!nodimensionMap.containsKey(dim.getNumber())) continue;
                    rowDimensions.addAll((Collection)nodimensionMap.get(dim.getNumber()));
                }
            }
            for (int k = pageDimensions.size() - 1; k >= 0; --k) {
                dim = (MbgViewListDimensionInfo)pageDimensions.get(k);
                if (dim == null || DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) continue;
                pageDimensions.remove(dim);
            }
        }
    }

    public static BgDimensionMember getCombinMemberByDimMember(BgDimensionMember[] rowMembers) {
        BgDimensionMember newMember = null;
        if (rowMembers == null) {
            return newMember;
        }
        int length = rowMembers.length;
        if (length > 0) {
            Object[] numbers = new String[length];
            Object[] srcNumbers = new String[length];
            Object[] names = new String[length];
            Object[] types = new String[length];
            Object[] attributes = new String[length];
            for (int l = 0; l < length; ++l) {
                if (rowMembers[l] == null) continue;
                numbers[l] = rowMembers[l].getNumber();
                srcNumbers[l] = rowMembers[l].getSrcNumber();
                names[l] = rowMembers[l].getName();
                types[l] = rowMembers[l].getType();
                attributes[l] = rowMembers[l].getAttribute();
            }
            String number = BgNFSHelper.arrayToString(numbers, DimensionConstants.COMMA_SEPARATOR);
            String srcNumber = BgNFSHelper.arrayToString(srcNumbers, DimensionConstants.COMMA_SEPARATOR);
            String name = BgNFSHelper.arrayToString(names, DimensionConstants.TICK_SEPARATOR);
            String type = BgNFSHelper.arrayToString(types, DimensionConstants.COMMA_SEPARATOR);
            String attribute = BgNFSHelper.arrayToString(attributes, DimensionConstants.COMMA_SEPARATOR);
            newMember = new BgDimensionMember(type, attribute, name, number);
            newMember.setSrcNumber(srcNumber);
        }
        return newMember;
    }

    public static List<Object[]> getDimMembersByCombinMembers(MbgViewListRowCol object) {
        ArrayList<Object[]> members = new ArrayList<Object[]>();
        Object[] objects = null;
        HashMap<String, Integer> dimIndexMap = new HashMap<String, Integer>();
        List<MbgViewListDimensionInfo> dims = object.getDimensions();
        MbgViewListDimensionInfo dim = null;
        boolean isHasOrgDim = false;
        List orgMember = null;
        for (int i = 0; i < dims.size(); ++i) {
            if (!(dims.get(i) instanceof MbgViewListDimensionInfo)) continue;
            dimIndexMap.put(dims.get(i).getNumber(), i);
        }
        HashMap memberLeafs = new HashMap();
        for (int i = 0; i < dims.size(); ++i) {
            dim = dims.get(i);
            if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) {
                isHasOrgDim = true;
                orgMember = dim.getMember();
                if (orgMember == null || orgMember.isEmpty()) break;
                for (int x = 0; x < orgMember.size(); ++x) {
                    if (!(orgMember.get(x) instanceof BgDimensionMember)) continue;
                    ((BgDimensionMember)orgMember.get(x)).setLevel(0);
                }
                break;
            }
            List dimMembers = dim.getMember();
            if (dimMembers == null || dimMembers.isEmpty()) continue;
            String attri = dim.getAttribute();
            for (int x = 0; x < dimMembers.size(); ++x) {
                if (!(dimMembers.get(x) instanceof BgDimensionMember)) continue;
                BgDimensionMember mem = (BgDimensionMember)dimMembers.get(x);
                if (!memberLeafs.containsKey(attri)) {
                    HashMap leafs = new HashMap();
                    memberLeafs.put(attri, leafs);
                }
                ((Map)memberLeafs.get(attri)).put(mem.getNumber(), mem.isLeaf());
            }
        }
        int dimCount = object.getDimensions().size();
        List<BgDimensionMember> combinMembers = object.getCombinMembers().isEmpty() && !object.getCombinSelectMembers().isEmpty() ? object.getCombinSelectMembers() : object.getCombinMembers();
        for (int i = 0; i < combinMembers.size(); ++i) {
            BgDimensionMember comMember = combinMembers.get(i);
            String[] numbers = DimensionFormulaHelper.splitCombinations(comMember.getNumber());
            String[] srcNumbers = DimensionFormulaHelper.splitCombinations(comMember.getSrcNumber());
            String[] types = DimensionFormulaHelper.splitCombinations(comMember.getType());
            String[] attributes = DimensionFormulaHelper.splitCombinations(comMember.getAttribute());
            String[] names = comMember.getName().split(DimensionConstants.TICK_SEPARATOR);
            objects = new Object[dimCount];
            for (int m = 0; m < types.length; ++m) {
                MbgViewListDimensionMember newMember = !StringUtils.isEmpty((String)numbers[m]) ? new MbgViewListDimensionMember(types[m], attributes[m], names[m], numbers[m]) : new MbgViewListDimensionMember(types[m], attributes[m], null, null);
                if (memberLeafs.containsKey(attributes[m]) && memberLeafs.get(attributes[m]) != null && ((Map)memberLeafs.get(attributes[m])).containsKey(numbers[m])) {
                    newMember.setLeaf((Boolean)((Map)memberLeafs.get(attributes[m])).get(numbers[m]));
                }
                if (srcNumbers != null) {
                    newMember.setSrcNumber(srcNumbers[m]);
                }
                if (!dimIndexMap.containsKey(types[m])) continue;
                objects[((Integer)dimIndexMap.get((Object)types[m])).intValue()] = newMember;
            }
            if (isHasOrgDim && dimIndexMap.containsKey(DimensionConstants.DEF_ORGUNIT_NUMBER) && orgMember != null && !orgMember.isEmpty() && objects[(Integer)dimIndexMap.get(DimensionConstants.DEF_ORGUNIT_NUMBER)] == null) {
                if (orgMember.get(0) instanceof MbgViewListDimensionMember) {
                    objects[((Integer)dimIndexMap.get((Object)DimensionConstants.DEF_ORGUNIT_NUMBER)).intValue()] = orgMember.get(0);
                } else if (orgMember.get(0) instanceof BgDimensionMember) {
                    objects[((Integer)dimIndexMap.get((Object)DimensionConstants.DEF_ORGUNIT_NUMBER)).intValue()] = MbgViewListDimensionMember.getInstance((BgDimensionMember)orgMember.get(0));
                }
            }
            members.add(objects);
        }
        return members;
    }

    public static void dealNotExistsOrg(MbgViewListManager viewManager, String currOrgNumber, Set<String> notExistFormOrg) {
        for (int sheetIndex = 0; sheetIndex < viewManager.getSheetManagers().size(); ++sheetIndex) {
            MbgViewListDimensionManager dimensionManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetIndex)).getDimensionManager();
            boolean isRowColShowbyTemp = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetIndex)).isRowColShowbyTemp();
            boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(dimensionManager);
            if (isorgOnPageOrView) continue;
            boolean isOnCol = MBgTemplateHelper.isOrgOnCol(dimensionManager);
            if (isRowColShowbyTemp) {
                Map oldViewlistObjMap = MbgViewListFormServerHelper.getViewListIndexObjectsByTemp((MbgViewListDimensionManager)dimensionManager, (Boolean)(!isOnCol ? 1 : 0), (String)currOrgNumber);
                for (String orgNum : notExistFormOrg) {
                    if (!oldViewlistObjMap.containsKey(orgNum)) continue;
                    Map tMap = (Map)oldViewlistObjMap.get(orgNum);
                    for (IMbgViewListObject vObject : tMap.values()) {
                        if (!isOnCol) {
                            dimensionManager.getRows().remove(vObject);
                            continue;
                        }
                        dimensionManager.getColumns().remove(vObject);
                    }
                }
            } else {
                Map oldOrgAndRowCols = MbgViewListFormServerHelper.getViewListObjectsByOrg((MbgViewListDimensionManager)dimensionManager, (Boolean)(!isOnCol ? 1 : 0));
                for (String orgNum : notExistFormOrg) {
                    if (oldOrgAndRowCols == null || !oldOrgAndRowCols.containsKey(orgNum)) continue;
                    List list = (List)oldOrgAndRowCols.get(orgNum);
                    for (IMbgViewListObject vObject : list) {
                        if (!isOnCol) {
                            dimensionManager.getRows().remove(vObject);
                            continue;
                        }
                        dimensionManager.getColumns().remove(vObject);
                    }
                }
            }
            DimensionCommonHelper.resetObjectIndex(!isOnCol ? dimensionManager.getRows() : dimensionManager.getColumns());
        }
    }

    public static void resetObjectIndex(List<IMbgViewListObject> list) {
        if (list != null && !list.isEmpty()) {
            for (int index = 0; index < list.size(); ++index) {
                list.get(index).setIndex(index);
            }
        }
    }
}

